/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.client;

import com.elluminate.jinx.ConferenceName;
import com.elluminate.jinx.Connector;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.VCRBufferEvent;
import com.elluminate.jinx.VCRBufferListener;
import com.elluminate.jinx.VCREntry;
import com.elluminate.jinx.VCRException;
import com.elluminate.jinx.VCRFile;
import com.elluminate.jinx.client.PlaybackEvent;
import com.elluminate.jinx.client.PlaybackException;
import com.elluminate.jinx.client.PlaybackListener;
import com.elluminate.jinx.client.StringsProperties;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.PriorityScheduler;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.QueuedProcessorAdapter;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.event.DataProvider;
import com.elluminate.util.event.URLFillErrorListener;
import com.elluminate.util.log.ExTRASupport;
import com.elluminate.util.log.LogSupport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class PlaybackConnector
extends Connector
implements PriorityScheduler,
VCRBufferListener,
ExTRASupport.ExceptionListener {
    public static final long COMPRESS_THRESHOLD = 2000L;
    public static final long BUFFER_MILLIS = 15000L;
    public static final long BUFFER_MSGS = 100L;
    public static final long MIN_MILLIS = 1500L;
    public static final long MIN_MSGS = 10L;
    private static final long MAX_BACKLOG = 100L;
    private static final Runnable NO_OPERATION = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final VCREntry RESET_ENTRY = new VCREntry(0L, 0L, 0L, 0, 0);
    I18n i18n = I18n.create((Object)((Object)this));
    private URL url = null;
    private MTPriorityQueue queue = null;
    private VCRFile vcr = null;
    private volatile long timeBase = 0L;
    private volatile boolean paused = false;
    private volatile long suspendTime = 0L;
    private volatile boolean resetTimeBase = false;
    private float rateScale = 1.0f;
    private volatile boolean linear = false;
    private boolean connected = false;
    private long connectedTime = -1L;
    private short group = 0;
    private long bufferMillis = 15000L;
    private long bufferMsgs = 100L;
    private long totalTime = -1L;
    private long lastTime = -1L;
    private long lastIdx = -1L;
    private long bufferTime = -1L;
    private long bufferIdx = -1L;
    private long msgTime = -1L;
    private volatile boolean complete = false;
    private volatile boolean buffering = false;
    private boolean doRewind = false;
    private volatile boolean compressing = true;
    private Object lock = new Object();
    private List<PlaybackListener> listeners = new ArrayList<PlaybackListener>();

    public void setSource(URL source, URLFillErrorListener ufel) throws PlaybackException {
        this.url = source;
        this.vcr = new VCRFile(this.url);
        this.vcr.addVCRBufferListener((VCRBufferListener)this);
        this.vcr.addURLFillErrorListener(ufel);
        this.lastTime = -1L;
        this.lastIdx = 0L;
        this.bufferMillis = 15000L;
        this.bufferMsgs = 100L;
        this.bufferTime = -1L;
        this.bufferIdx = -1L;
        this.msgTime = -1L;
        this.complete = false;
        try {
            this.vcr.open('r');
        }
        catch (IOException ex) {
            String msg = ex.getLocalizedMessage();
            PlaybackException px = msg == null || msg.trim().length() == 0 ? new PlaybackException(this.url, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYBACKCONNECTOR_CANNOTOPEN), ex) : new PlaybackException(this.url, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYBACKCONNECTOR_CANNOTOPENWITHMSG, new Object[]{msg}), ex);
            LogSupport.message((Object)((Object)this), (String)"setSource", (String)("Aborting playback: " + Debug.getStackTrace((Throwable)px)));
            if (!SwingUtilities.isEventDispatchThread()) {
                throw px;
            }
        }
        catch (VCRException vcr) {
            throw new PlaybackException(this.url, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYBACKCONNECTOR_BADVERSON, new Object[]{VCRFile.getExpectedVersion()}), vcr);
        }
    }

    public ConferenceName getConferenceName() {
        if (this.vcr == null) {
            return null;
        }
        String nm = this.vcr.getAnnotation(" conferenceName ");
        if (nm == null) {
            return null;
        }
        return new ConferenceName(nm);
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setCompression(boolean comp) {
        this.compressing = comp;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRate(float rate) {
        Debug.lockEnter((Object)((Object)this), (String)"setRate", null, (Object)((Object)this));
        PlaybackConnector playbackConnector = this;
        synchronized (playbackConnector) {
            this.rateScale = rate;
            this.linear = this.rateScale == 1.0f;
        }
        Debug.lockLeave((Object)((Object)this), (String)"setRate", null, (Object)((Object)this));
    }

    public float getRate() {
        return this.rateScale;
    }

    public DataProvider getRecordingIndexProvider() {
        if (this.vcr == null) {
            return null;
        }
        return this.vcr.getRecordingIndexProvider();
    }

    public VCRFile.IndexEntry[] getRecordingIndex() {
        if (this.vcr == null) {
            return null;
        }
        return this.vcr.getRecordingIndex();
    }

    public void addURLFillErrorListener(URLFillErrorListener l) {
        if (this.vcr == null) {
            return;
        }
        this.vcr.addURLFillErrorListener(l);
    }

    public void removeURLFillErrorListener(URLFillErrorListener l) {
        if (this.vcr == null) {
            return;
        }
        this.vcr.removeURLFillErrorListener(l);
    }

    public String getAnnotation(String name) {
        if (this.vcr == null) {
            return null;
        }
        return this.vcr.getAnnotation(name);
    }

    public void play() {
        if (this.vcr == null) {
            throw new IllegalStateException("Play with no source defined.");
        }
        if (this.paused) {
            this.paused = false;
            this.resetTimeBase = true;
        } else if (!this.isEnabled()) {
            QueuedProcessorAdapter proc = new QueuedProcessorAdapter(){

                public void process(Object o, Object context) {
                    PlaybackConnector.this.doProcess(o);
                }
            };
            this.queue = new MTPriorityQueue("Playback queue", (QueuedProcessor)proc, (PriorityScheduler)this);
            this.resetTimeBase = true;
            this.msgTime = 0L;
            this.queue.process((Object)new VCREntry(0L, 0L, 0L, 0, -1));
        }
    }

    public void stop() {
        MTPriorityQueue q = this.queue;
        if (q != null) {
            this.queue = null;
            q.clearAndInterrupt();
            q.stop(false, 2000L);
            this.disconnect();
            this.fireConnectionStatusChanged((short)1, " recorder", (byte)4, (byte)2, (byte)0, null);
            this.msgTime = 0L;
            this.paused = false;
            this.suspendTime = 0L;
            this.resetTimeBase = true;
            this.firePlaybackStatus();
        }
    }

    public void pause() {
        this.paused = true;
        this.suspendTime = Platform.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        MTPriorityQueue q = this.queue;
        if (q == null) {
            this.play();
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.doRewind) {
                    return;
                }
                this.doRewind = true;
                q.clear();
                q.process((Object)RESET_ENTRY);
            }
        }
    }

    private void connect(long timestamp) {
        if (!this.connected) {
            this.fireConnectionStatusChanged((short)1, " recorder", (byte)1, (byte)3, (byte)0, null);
            this.fireConnectionStatusChanged((short)1, " recorder", (byte)2, (byte)1, (byte)0, null);
            this.connected = true;
            this.connectedTime = this.timeBase + timestamp;
        }
    }

    public void disconnect() {
        if (this.connected) {
            this.fireConnectionStatusChanged((short)1, " recorder", (byte)3, (byte)2, (byte)0, null);
            this.connected = false;
            this.connectedTime = -1L;
        }
    }

    public short getAddress() {
        if (!this.connected) {
            return -32767;
        }
        return 1;
    }

    public short getGroupID() {
        return this.group;
    }

    public void setGroupID(short grp) {
        this.group = grp;
    }

    public String getName() {
        return " recorder";
    }

    public boolean isEnabled() {
        return this.queue != null;
    }

    public long getConnectedMillis() {
        if (this.connectedTime <= 0L) {
            return 0L;
        }
        if (this.suspendTime > 0L) {
            return this.suspendTime - this.connectedTime;
        }
        return Platform.currentTimeMillis() - this.connectedTime;
    }

    public void onMessage(MessageEvent msg) {
    }

    public void onTransmitStatus(TransmitStatusEvent e) {
        e.setTransmitComplete();
        this.fireOnTranmitStatus(e);
    }

    public void addPlaybackListener(PlaybackListener l) {
        ArrayList<PlaybackListener> newListeners = new ArrayList<PlaybackListener>(this.listeners);
        if (!newListeners.contains(l)) {
            newListeners.add(l);
            this.listeners = newListeners;
            this.firePlaybackStatus();
        }
    }

    public void removePlaybackListener(PlaybackListener l) {
        ArrayList<PlaybackListener> newListeners = new ArrayList<PlaybackListener>(this.listeners);
        newListeners.remove(l);
        this.listeners = newListeners;
    }

    protected void firePlaybackStatus() {
        this.firePlaybackStatus(false);
    }

    protected void firePlaybackStatus(boolean reset) {
        PlaybackEvent e = new PlaybackEvent((Object)this, this.totalTime, this.lastTime, this.msgTime, reset);
        for (PlaybackListener l : this.listeners) {
            try {
                l.playbackStatus(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)((Object)this), (String)"firePlaybackStatus", (Throwable)ex, (boolean)true);
            }
        }
    }

    public long getProcessDelay(int priority, Object obj, long now) {
        VCREntry ve = (VCREntry)obj;
        if (ve == RESET_ENTRY) {
            return 0L;
        }
        if (this.resetTimeBase) {
            long connectDelta = this.connectedTime - this.timeBase;
            this.timeBase = now - ve.getTime();
            if (this.connectedTime >= 0L) {
                this.connectedTime = this.timeBase + connectDelta;
            }
            this.resetTimeBase = false;
            this.suspendTime = 0L;
        } else if (this.buffering || this.paused) {
            return 100L;
        }
        long delay = this.timeBase + ve.getTime() - now;
        if (delay < -100L) {
            this.timeBase = now - ve.getTime();
            delay = 0L;
        }
        if ((this.compressing || !this.linear) && delay > 2000L) {
            this.timeBase -= delay - 2000L;
            this.connectedTime -= delay - 2000L;
            delay = 2000L;
        }
        if (!this.linear && delay > 0L) {
            long delta = delay;
            delay = (long)((float)delay / this.getRate());
            this.timeBase -= (delta -= delay);
            this.connectedTime -= delta;
        }
        return delay;
    }

    public void processingNotify(Object obj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Object data) {
        boolean reset;
        VCREntry ve = (VCREntry)data;
        byte marker = ve.getMarker();
        Object object = this.lock;
        synchronized (object) {
            reset = this.doRewind;
        }
        if (ve.getTime() < 0L) {
            this.msgTime = this.totalTime;
            this.firePlaybackStatus();
            this.stop();
            return;
        }
        if (!reset) {
            this.msgTime = ve.getTime();
            switch (marker) {
                case -1: {
                    try {
                        if (this.vcr != null) {
                            this.vcr.reset();
                        }
                        this.firePlaybackStatus(true);
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)((Object)this), (String)"doProcess", (Throwable)t, (boolean)true, (String)("Resetting VCR file: " + this.vcr));
                    }
                    break;
                }
                case 0: {
                    if (!this.connected) {
                        this.connect(this.msgTime);
                    }
                    MessageEvent msg = ve.getMessage();
                    if (DebugFlags.PLAYBACK.show()) {
                        LogSupport.message((Object)((Object)this), (String)"doProcess", (String)("message - " + msg));
                    }
                    if (msg == null) break;
                    this.fireOnMessage(msg);
                    break;
                }
                case 1: {
                    if (DebugFlags.PLAYBACK.show()) {
                        LogSupport.message((Object)((Object)this), (String)"doProcess", (String)"Disconnect");
                    }
                    this.resetTimeBase = true;
                    this.disconnect();
                    break;
                }
            }
            this.firePlaybackStatus();
        }
        this.queueNext(reset);
        if (reset) {
            try {
                SwingRunnerSupport.invokeAndWait((Runnable)NO_OPERATION);
            }
            catch (InterruptedException intx) {
                Thread.currentThread().interrupt();
            }
            this.disconnect();
            object = this.lock;
            synchronized (object) {
                this.doRewind = false;
            }
            this.firePlaybackStatus(true);
        }
    }

    public void bufferStatus(VCRBufferEvent e) {
        this.totalTime = e.getTotalTime();
        if (e.getCurrentLength() == e.getTotalLength()) {
            this.buffering = false;
            this.complete = true;
            this.bufferTime = -1L;
            this.bufferIdx = -1L;
        }
        if (this.buffering && e.getCurrentTime() > this.bufferTime && e.getLastMessageIndex() > this.bufferIdx) {
            this.bufferTime = -1L;
            this.bufferIdx = -1L;
            this.buffering = false;
            this.resetTimeBase = true;
        }
        this.lastTime = e.getCurrentTime();
        this.lastIdx = e.getLastMessageIndex();
        this.firePlaybackStatus();
    }

    private void queueNext(boolean rewind) {
        if (this.vcr != null && this.vcr.isOpen()) {
            VCREntry entry;
            try {
                if (rewind) {
                    this.vcr.reset();
                }
                long t0 = Platform.currentTimeMillis() - this.timeBase;
                entry = this.vcr.read();
                long t1 = Platform.currentTimeMillis() - this.timeBase;
                if (!(this.buffering || this.complete || this.lastIdx - entry.getIndex() >= 10L && this.lastTime - entry.getTime() >= 1500L)) {
                    this.buffering = true;
                    this.suspendTime = Platform.currentTimeMillis();
                    this.bufferTime = entry.getTime() + this.bufferMillis;
                    this.bufferIdx = entry.getIndex() + this.bufferMsgs;
                    if (this.lastIdx - entry.getIndex() < 10L) {
                        this.bufferMsgs <<= 1;
                    }
                    if (this.lastTime - entry.getTime() < 1500L) {
                        this.bufferMillis <<= 1;
                    }
                } else if (entry.getTime() > t0 && entry.getTime() < t1) {
                    this.resetTimeBase = true;
                } else if (!this.buffering && this.suspendTime > 0L) {
                    this.resetTimeBase = true;
                }
            }
            catch (Throwable t) {
                if (!(t instanceof EOFException || t instanceof InterruptedException || t instanceof InterruptedIOException)) {
                    LogSupport.exception((Object)((Object)this), (String)"queueNext", (Throwable)t, (boolean)true, (String)("Reading " + this.vcr));
                }
                entry = new VCREntry(-1L, -1L, -1L, -1, (MessageEvent)null);
            }
            MTPriorityQueue execQueue = this.queue;
            if (execQueue != null) {
                if (rewind) {
                    execQueue.clear();
                }
                execQueue.process((Object)entry);
            }
        }
    }

    public void exceptionReported(ExTRASupport.ExceptionEvent ev) {
        if (this.vcr != null) {
            Throwable ioErr;
            String dump;
            String status;
            String history = this.vcr.getReaderHistory();
            if (history.length() > 0) {
                ev.getExtraFields().put("vcrhistory", history);
            }
            if ((status = this.vcr.getReaderStatus()).length() > 0) {
                ev.getExtraFields().put("vcrfile", status);
            }
            if ((dump = this.vcr.dumpFileData(0L, 64)) != null) {
                ev.getExtraFields().put("vcrheader", dump);
            }
            if ((dump = this.vcr.dumpReadRegion(16, 1024)) != null) {
                ev.getExtraFields().put("vcrdump", dump);
            }
            if ((ioErr = this.vcr.getReaderError()) != null) {
                ev.getExtraFields().put("vcrDownloadTrace", Debug.getStackTrace((Throwable)ioErr));
            }
        }
    }

    public void dispose() {
        if (this.vcr != null) {
            this.vcr.close();
            this.vcr = null;
        }
    }
}

