/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.client;

import com.elluminate.jinx.AuthResponse;
import com.elluminate.jinx.ConnectionClass;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.JinxAccessDeniedException;
import com.elluminate.jinx.JinxConferenceLockedException;
import com.elluminate.jinx.JinxConferenceNotFoundException;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.JinxNameInUseException;
import com.elluminate.jinx.NetworkTransceiver;
import com.elluminate.jinx.client.CallStatusEvent;
import com.elluminate.jinx.client.CallStatusListener;
import com.elluminate.jinx.client.Caller;
import com.elluminate.jinx.client.ClientAuthenticator;
import com.elluminate.jinx.client.JinxTimeoutException;
import com.elluminate.jinx.client.StringsProperties;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointSecurity;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.URLString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.TooManyListenersException;

public class Dialer {
    public static final int TIMEOUT = 120000;
    private static int SEQUENCE = 1;
    private int uid;
    I18n i18n = I18n.create((Object)this);
    URLString url = null;
    ConnectionClass cls = ConnectionClass.LAN;
    ClientAuthenticator auth = null;
    SSLTargetQuery targetQuery = null;
    Caller caller = null;
    long bestTO = 10000L;
    long anyTO = 60000L;
    InputStream in;
    OutputStream out;
    DataInputStream dataIn;
    DataOutputStream dataOut;
    CallStatusListener listener = null;
    private final Object lock = new Object();
    short jinxAddr = (short)-32767;
    long startGetEndpointTime;
    private long startConnectTime;
    private long endGetEndpointTime;
    private long startProtocolLoopTime;
    private long endGetResponseTime;
    private long startJoinTime;
    private long startUserTime;
    private long startTransceiverConnectTime;
    private long startJinxAddressTime;

    public long getStartConnectTime() {
        return this.startConnectTime;
    }

    public long getEndGetEndpointTime() {
        return this.endGetEndpointTime;
    }

    public long getStartProtocolLoopTime() {
        return this.startProtocolLoopTime;
    }

    public long getEndGetResponseTime() {
        return this.endGetResponseTime;
    }

    public long getStartJoinTime() {
        return this.startJoinTime;
    }

    public long getStartUserTime() {
        return this.startUserTime;
    }

    public long getStartTransceiverConnectTime() {
        return this.startTransceiverConnectTime;
    }

    public long getStartJinxAddressTime() {
        return this.startJinxAddressTime;
    }

    public Dialer() {
        this.uid = SEQUENCE++;
    }

    public void setURL(URLString url) throws MalformedURLException {
        if (url.getHost() == null) {
            throw new MalformedURLException(this.i18n.getString((PropertiesEnum)StringsProperties.DIALER_EMPTYHOST));
        }
        if (url.getPort() <= 0) {
            url.setPort(2187);
        }
        if (url.getName() == null) {
            throw new MalformedURLException(this.i18n.getString((PropertiesEnum)StringsProperties.DIALER_EMPTYPATH));
        }
        this.url = url;
    }

    public URLString getURL() {
        return this.url;
    }

    public void setAuthenticator(ClientAuthenticator auth) {
        this.auth = auth;
    }

    public ClientAuthenticator getAuthenticator() {
        return this.auth;
    }

    public void setConnectionClass(ConnectionClass cls) {
        this.cls = cls;
    }

    public ConnectionClass getConnectionClass() {
        return this.cls;
    }

    public void setTimeouts(long bestTimeout, long anyTimeout) {
        this.bestTO = bestTimeout;
        this.anyTO = anyTimeout;
    }

    public void setTargetQuery(SSLTargetQuery query) {
        this.targetQuery = query;
    }

    public void addCallStatusListener(CallStatusListener lst) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException("Only 1 CallStatusListener allowed per call.");
        }
        this.listener = lst;
    }

    public void removeCallStatusListener(CallStatusListener lst) {
        if (this.listener == lst) {
            this.listener = null;
        }
    }

    private void fireStatusChange(int state, Caller caller) {
        if (this.listener == null) {
            return;
        }
        try {
            this.listener.callStatusChanged(new CallStatusEvent(this, state, caller));
        }
        catch (Throwable th) {
            LogSupport.exception((Object)this, (String)"fireStatusChanged", (Throwable)th, (boolean)true);
        }
    }

    public Caller getCaller() {
        return this.caller;
    }

    public NetworkTransceiver connect(Caller[] callers) throws JinxConnectionException, UnknownHostException, IOException {
        int version = 512;
        String device = Platform.getDeviceCode();
        this.startConnectTime = System.currentTimeMillis();
        if (this.url == null) {
            throw new JinxConnectionException("No URL specified to dial.");
        }
        if (this.auth == null) {
            throw new JinxConnectionException("No authenticator specified for call.");
        }
        String name = this.auth.getName();
        Endpoint endpoint = this.getEndpoint(this.url, callers);
        this.endGetEndpointTime = System.currentTimeMillis();
        endpoint.setSoTimeout(120000);
        endpoint.setTcpNoDelay(false);
        this.in = endpoint.getInputStream();
        this.out = endpoint.getOutputStream();
        this.dataIn = new DataInputStream(this.in);
        this.dataOut = new DataOutputStream(this.out);
        boolean retry = true;
        this.startProtocolLoopTime = System.currentTimeMillis();
        block12: while (retry) {
            retry = false;
            switch (version) {
                case 512: {
                    this.writeLine("protocol 2.0 " + this.caller.getURL().getProtocol() + " " + device);
                    break;
                }
                default: {
                    this.writeLine("protocol " + this.caller.getURL().getProtocol());
                }
            }
            AuthResponse resp = this.readResponse();
            this.endGetResponseTime = System.currentTimeMillis();
            switch (resp.getResponseCode()) {
                case 200: {
                    continue block12;
                }
                case 202: {
                    this.fireStatusChange(3, null);
                    endpoint = EndpointSecurity.secureClient((Endpoint)endpoint, (String)this.caller.getURL().getHost(), (int)this.caller.getURL().getPort());
                    EndpointSecurity.verifyDestination((Endpoint)endpoint, (String)this.caller.getURL().getHost(), (SSLTargetQuery)this.targetQuery);
                    endpoint.setSoTimeout(120000);
                    endpoint.setTcpNoDelay(false);
                    this.in = endpoint.getInputStream();
                    this.out = endpoint.getOutputStream();
                    this.dataIn = new DataInputStream(this.in);
                    this.dataOut = new DataOutputStream(this.out);
                    this.fireStatusChange(4, null);
                    continue block12;
                }
                case 303: {
                    if (version == 512) {
                        version = 256;
                        retry = true;
                        continue block12;
                    }
                    this.processErrorResponse(resp);
                    continue block12;
                }
            }
            this.processErrorResponse(resp);
        }
        this.fireStatusChange(5, null);
        this.startJoinTime = System.currentTimeMillis();
        if (this.jinxAddr != -32767) {
            this.writeLine("rejoin " + this.jinxAddr + "@" + this.url.getName());
        } else {
            this.writeLine("join " + this.url.getName());
        }
        this.readResponse(301);
        this.startUserTime = System.currentTimeMillis();
        this.writeLine("user " + name);
        String challenge = this.readResponse(302);
        this.writeLine("resp " + this.auth.getResponse(version, name, challenge, device));
        String address = this.readResponse(201);
        this.startJinxAddressTime = System.currentTimeMillis();
        try {
            this.jinxAddr = Short.parseShort(address);
        }
        catch (Exception ex) {
            endpoint.closeForce();
            throw new JinxConnectionException("Syntax Error");
        }
        this.fireStatusChange(6, null);
        NetworkTransceiver transceiver = new NetworkTransceiver(null);
        try {
            endpoint.setSendBufferSize(65536);
            endpoint.setRecvBufferSize(65536);
        }
        catch (SocketException se) {
            // empty catch block
        }
        this.startTransceiverConnectTime = System.currentTimeMillis();
        transceiver.connect(endpoint, this.jinxAddr, name, this.cls.getRecvBandwidth(), this.cls.getXmitBandwidth());
        if (DebugFlags.CALLER.show()) {
            LogSupport.message((Object)this, (String)"Dialer", (String)("have transceiver," + endpoint.getLocalPort() + "," + this.jinxAddr));
        }
        return transceiver;
    }

    private AuthResponse readResponse() throws IOException {
        String line = this.readLine();
        return new AuthResponse(line);
    }

    private String readResponse(int expected) throws IOException, JinxConnectionException {
        AuthResponse resp = this.readResponse();
        if (resp.getResponseCode() == expected) {
            return resp.getResponseMessage();
        }
        this.processErrorResponse(resp);
        return null;
    }

    private void processErrorResponse(AuthResponse resp) throws JinxConnectionException {
        switch (resp.getResponseCode()) {
            case 403: 
            case 408: {
                throw new JinxAccessDeniedException(resp.getResponseMessage());
            }
            case 402: {
                throw new JinxNameInUseException(resp.getResponseMessage());
            }
            case 404: {
                throw new JinxConferenceNotFoundException(resp.getResponseMessage());
            }
            case 401: 
            case 406: 
            case 407: 
            case 409: {
                throw new JinxConnectionException(resp.getResponseMessage());
            }
            case 405: {
                throw new JinxTimeoutException(resp.getResponseMessage());
            }
            case 410: {
                throw new JinxConferenceLockedException(resp.getResponseMessage());
            }
        }
        throw new JinxConnectionException(resp.getResponseMessage());
    }

    private String readLine() throws InterruptedIOException, IOException {
        char c;
        StringBuffer buf = new StringBuffer();
        while ((c = this.dataIn.readChar()) != '\n') {
            buf.append(c);
        }
        if (DebugFlags.CONNECTION.show()) {
            LogSupport.message((Object)this, (String)"readLine", (String)("Recv: " + buf.toString()));
        }
        return buf.toString();
    }

    private void writeLine(String line) throws IOException {
        if (DebugFlags.CONNECTION.show()) {
            LogSupport.message((Object)this, (String)"writeLine", (String)("Sent: " + line));
        }
        this.dataOut.writeChars(line);
        this.dataOut.writeChar(10);
        this.dataOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Endpoint getEndpoint(URLString url, Caller[] theCallers) throws IOException {
        this.startGetEndpointTime = System.currentTimeMillis();
        Endpoint endpoint = null;
        if (theCallers == null) {
            theCallers = new Caller[]{Caller.getCaller("")};
        }
        this.caller = null;
        this.fireStatusChange(1, null);
        long connectStartTime = System.currentTimeMillis();
        Debug.lockEnter((Object)this, (String)"getEndpoint", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            int i;
            boolean done = false;
            int best = -1;
            for (i = 0; i < theCallers.length; ++i) {
                theCallers[i].setTargetQuery(this.targetQuery);
                theCallers[i].setTimeout(this.anyTO);
                theCallers[i].start(url, this.lock);
            }
            if (DebugFlags.CALLER.show()) {
                LogSupport.log((String)("," + this.uid + ",Dialer before !done loop," + (System.currentTimeMillis() - connectStartTime)));
            }
            while (!done) {
                int i2;
                block28: {
                    long limit = best < 0 ? this.anyTO : this.bestTO;
                    try {
                        if (limit < 0L) {
                            this.lock.wait();
                        } else if ((limit = this.startGetEndpointTime + limit - System.currentTimeMillis()) > 0L) {
                            this.lock.wait(limit);
                        } else {
                            for (i2 = 0; i2 < theCallers.length; ++i2) {
                                if (theCallers[i2].isDone()) continue;
                                theCallers[i2].abort();
                            }
                        }
                    }
                    catch (InterruptedException ix) {
                        if (!DebugFlags.CALLER.show()) break block28;
                        LogSupport.log((String)("," + this.uid + ",Dialer Connect interrupt," + (System.currentTimeMillis() - connectStartTime)));
                    }
                }
                if (DebugFlags.CALLER.show()) {
                    LogSupport.log((String)("," + this.uid + ",Dialer isDone," + (System.currentTimeMillis() - connectStartTime)));
                }
                done = true;
                for (i2 = 0; i2 < theCallers.length; ++i2) {
                    if (theCallers[i2].isDone()) {
                        if (theCallers[i2].getEndpoint() == null) continue;
                        if (best < 0) {
                            best = i2;
                            for (int j = 0; j < theCallers.length; ++j) {
                                theCallers[j].setTimeout(this.bestTO);
                            }
                            continue;
                        }
                        if (i2 >= best) continue;
                        best = i2;
                        continue;
                    }
                    done = false;
                }
                if (DebugFlags.CALLER.show()) {
                    LogSupport.log((String)("," + this.uid + ",Dialer before abort," + (System.currentTimeMillis() - connectStartTime)));
                }
                if (best != 0 || done) continue;
                for (i2 = 1; i2 < theCallers.length; ++i2) {
                    theCallers[i2].abort();
                }
                done = true;
            }
            if (DebugFlags.CALLER.show()) {
                LogSupport.log((String)("," + this.uid + ",Dialer pick best connection," + (System.currentTimeMillis() - connectStartTime)));
            }
            for (i = 0; i < theCallers.length; ++i) {
                Endpoint ep = theCallers[i].getEndpoint();
                if (ep == null) continue;
                if (endpoint == null) {
                    this.caller = theCallers[i];
                    endpoint = ep;
                    continue;
                }
                ep.closeForce();
            }
        }
        Debug.lockLeave((Object)this, (String)"getEndpoint", (String)"lock", (Object)this.lock);
        if (endpoint == null) {
            StringBuffer msg = new StringBuffer();
            msg.append(this.i18n.getString((PropertiesEnum)StringsProperties.DIALER_CONNECTIONFAILED));
            for (int i = 0; i < theCallers.length; ++i) {
                msg.append("\n     ");
                msg.append(theCallers[i]);
            }
            throw new IOException(msg.toString() + ", getEndpoint Time: " + (System.currentTimeMillis() - connectStartTime));
        }
        this.fireStatusChange(2, this.caller);
        if (this.caller.getURL().getProtocol().equals("ssljinx")) {
            EndpointSecurity.verifyDestination((Endpoint)endpoint, (String)url.getHost(), (SSLTargetQuery)this.targetQuery);
        }
        if (DebugFlags.CALLER.show()) {
            LogSupport.log((String)("," + this.uid + ",Dialer gotEndpoint," + (System.currentTimeMillis() - connectStartTime) + "," + endpoint.getLocalPort()));
        }
        return endpoint;
    }
}

