/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.client;

import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.client.DirectCaller;
import com.elluminate.jinx.client.ProxyCaller;
import com.elluminate.jinx.client.StringsProperties;
import com.elluminate.net.Endpoint;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.util.CPropertyChangeSupport;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.ProxyUtils;
import com.elluminate.util.net.URLString;
import java.beans.PropertyChangeListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class Caller
implements Cloneable {
    public static final int DEFAULT_PORT = 2187;
    public static final String STATE_PROPERTY = "state";
    public static final String STATE_IDLE = "idle";
    public static final String STATE_WORKING = "working";
    public static final String STATE_FAILED = "failed";
    public static final String STATE_CONNECTED = "connected";
    protected URLString url = null;
    protected String host = null;
    protected int port = -1;
    private int portOverride = -1;
    private String protoOverride = null;
    private Endpoint endpoint = null;
    private long timeout = 0L;
    private Object lock = new Object();
    private boolean done = false;
    private String reason = null;
    protected I18n i18n = I18n.create((Object)this);
    protected SSLTargetQuery targetQuery = null;
    private CPropertyChangeSupport cSupport = new CPropertyChangeSupport((Object)this);

    protected Caller() {
    }

    public Object clone() {
        Caller clone = null;
        try {
            clone = (Caller)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        this.cSupport = new CPropertyChangeSupport((Object)this);
        this.done = false;
        this.reason = null;
        this.endpoint = null;
        return clone;
    }

    abstract void startCall();

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.cSupport.addPropertyChangeListener(lst);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener lst) {
        this.cSupport.addPropertyChangeListener(name, lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.cSupport.removePropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener lst) {
        this.cSupport.removePropertyChangeListener(name, lst);
    }

    public void setPortOverride(int port) {
        this.portOverride = port;
    }

    public int getPortOverride() {
        return this.portOverride;
    }

    public void setProtocolOverride(String protocol) {
        this.protoOverride = protocol;
    }

    public String getProtocolOverride() {
        return this.protoOverride;
    }

    public void setTargetQuery(SSLTargetQuery query) {
        this.targetQuery = query;
    }

    public void start(URLString target, Object notify) {
        String proto = this.protoOverride != null ? this.protoOverride : target.getProtocol();
        int n = this.port = this.portOverride > 0 ? this.portOverride : target.getPort();
        if (this.port < 0) {
            this.port = 2187;
        }
        this.lock = notify;
        this.url = new URLString(proto, target.getHost(), this.port, target.getPath());
        this.host = this.url.getHost();
        this.endpoint = null;
        this.done = false;
        this.reason = null;
        if (DebugFlags.CALLER.show()) {
            LogSupport.message((Object)this, (String)"start", (String)("starting call to " + this.getTarget() + "..."));
        }
        this.cSupport.firePropertyChange(STATE_PROPERTY, (Object)STATE_IDLE, (Object)STATE_WORKING);
        this.startCall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(Endpoint result, String errMsg) {
        boolean notify = false;
        Debug.lockEnter((Object)this, (String)"finish", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            if (DebugFlags.CALLER.show()) {
                if (result != null) {
                    LogSupport.message((Object)this, (String)"finish", (String)("Success: " + this.getTarget()));
                } else {
                    LogSupport.message((Object)this, (String)"finish", (String)("Failed:  " + this.getTarget() + " - " + errMsg));
                }
            }
            if (this.done) {
                if (result != null) {
                    result.closeForce();
                }
            } else {
                notify = true;
                this.endpoint = result;
                this.reason = errMsg;
            }
            this.done = true;
            this.lock.notify();
        }
        Debug.lockLeave((Object)this, (String)"finish", (String)"lock", (Object)this.lock);
        if (!notify) {
            this.cSupport.firePropertyChange(STATE_PROPERTY, (Object)STATE_WORKING, (Object)(result == null ? STATE_FAILED : STATE_CONNECTED));
        }
    }

    protected void finish(IOException ex) {
        if (ex instanceof UnknownHostException) {
            this.finish(null, this.i18n.getString((PropertiesEnum)StringsProperties.CALLER_UNKNOWNHOST, new Object[]{ex.getMessage()}));
        } else if (ex instanceof NoRouteToHostException) {
            this.finish(null, this.i18n.getString((PropertiesEnum)StringsProperties.CALLER_NOROUTE, new Object[]{ex.getMessage()}));
        } else if (ex instanceof ConnectException) {
            this.finish(null, ex.getMessage());
        } else {
            this.finish(null, ex.toString());
        }
    }

    protected Object getLock() {
        return this.lock;
    }

    public void abort() {
        this.finish(null, this.i18n.getString((PropertiesEnum)StringsProperties.CALLER_TIMEDOUT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        boolean finished;
        Object object = this.lock;
        synchronized (object) {
            finished = this.done;
        }
        return finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getEndpoint() {
        Endpoint ep;
        Object object = this.lock;
        synchronized (object) {
            ep = this.endpoint;
        }
        return ep;
    }

    public URLString getURL() {
        return this.url;
    }

    public void setTimeout(long to) {
        this.timeout = to;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReason() {
        String msg;
        Object object = this.lock;
        synchronized (object) {
            msg = this.reason;
        }
        return msg;
    }

    public abstract String getTarget();

    protected void sayHello(Endpoint ep) throws IOException {
        String reply;
        this.putLine7(ep, "JINX HELLO\u0000\n\r\n");
        try {
            reply = this.getLine7(ep);
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            if (msg != null) {
                throw new IOException(this.i18n.getString((PropertiesEnum)StringsProperties.CALLER_NOTJINX, new Object[]{msg}));
            }
            throw new IOException(this.i18n.getString((PropertiesEnum)StringsProperties.CALLER_NOTJINX, new Object[]{ex.toString()}));
        }
        if (!reply.equals("200 OK")) {
            throw new IOException(this.i18n.getString((PropertiesEnum)StringsProperties.CALLER_NOTJINX, new Object[]{reply}));
        }
    }

    protected String getLine7(Endpoint ep) throws IOException {
        String line;
        InputStream in = ep.getInputStream();
        byte[] buf = new byte[512];
        int len = 0;
        while (len < buf.length) {
            int chr = in.read();
            if (chr < 0) {
                throw new EOFException();
            }
            if (chr == 10) break;
            if (chr == 13) continue;
            buf[len++] = (byte)chr;
        }
        try {
            line = new String(buf, 0, len, "ASCII7");
        }
        catch (UnsupportedEncodingException ex) {
            line = new String(buf, 0, len);
        }
        return line;
    }

    protected void putLine7(Endpoint ep, String msg) throws IOException {
        byte[] buf;
        OutputStream out = ep.getOutputStream();
        String line = msg + "\r\n";
        try {
            buf = line.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ex) {
            buf = line.getBytes();
        }
        out.write(buf);
        out.flush();
    }

    public static Caller[] getCallers(String specs, Caller[] dft) {
        LinkedList<Caller> list = new LinkedList<Caller>();
        TokenIterator i = new TokenIterator(specs, ',');
        while (i.hasNext()) {
            String spec = i.next();
            if (spec.equals("*")) {
                if (dft == null) {
                    throw new IllegalArgumentException("Caller spec contains * but there is no default caller set defined.");
                }
                for (int x = 0; x < dft.length; ++x) {
                    list.add(dft[x]);
                }
                continue;
            }
            Caller c = Caller.getCaller(spec);
            list.add(c);
        }
        return list.toArray(new Caller[0]);
    }

    public static Caller getCaller(String spec) {
        String proto = null;
        String proxyMethod = ProxyUtils.getCurrentProxyType();
        String proxyOpts = null;
        int port = -1;
        TokenIterator iter = new TokenIterator(spec, '/');
        if (iter.hasNext()) {
            String token = iter.next();
            if (token.length() > 0) {
                try {
                    port = Integer.parseInt(token);
                    if (port < 1 || port > 65535) {
                        throw new IllegalArgumentException("Invalid caller port: " + token + " - not in range 1-65535");
                    }
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Invalid caller port: " + token);
                }
            }
            if (iter.hasNext()) {
                token = iter.next();
                if (token.length() > 0) {
                    if (!((token = token.toLowerCase(Locale.ENGLISH)).equals("jinx") || token.equals("ssljinx") || token.equals("jinxssl"))) {
                        throw new IllegalArgumentException("Invalid protocol in caller spec: " + token);
                    }
                    proto = token;
                }
                if (iter.hasNext()) {
                    token = iter.next();
                    if (token.length() > 0) {
                        StringTokenizer proxyParser = new StringTokenizer(token, ":");
                        proxyMethod = proxyParser.nextToken();
                        while (proxyParser.hasMoreTokens()) {
                            String part = proxyParser.nextToken();
                            if (proxyOpts == null) {
                                proxyOpts = part;
                                continue;
                            }
                            proxyOpts = proxyOpts + "," + part;
                        }
                    }
                    if (iter.hasNext()) {
                        throw new IllegalArgumentException("Too many components in Caller spec: " + spec);
                    }
                }
            }
        }
        DirectCaller c = null;
        c = proxyMethod.equals("direct") ? new DirectCaller() : new ProxyCaller(proxyMethod, proxyOpts);
        if (port > 0) {
            c.setPortOverride(port);
        }
        if (proto != null) {
            c.setProtocolOverride(proto);
        }
        return c;
    }

    static class TokenIterator
    implements Iterator<String> {
        private int cursor = 0;
        private String text = null;
        private char delim;
        private int len;
        private boolean done = false;

        public TokenIterator(String str, char delimiter) {
            this.text = str;
            this.delim = delimiter;
            this.len = this.text.length();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String next() {
            int start = this.cursor;
            while (this.cursor < this.len && this.text.charAt(this.cursor) != this.delim) {
                ++this.cursor;
            }
            String token = this.text.substring(start, this.cursor);
            if (this.cursor < this.len) {
                ++this.cursor;
            } else {
                this.done = true;
            }
            return token;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }
    }
}

