/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.telephony;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.groupware.audio.AudioProtocol;
import com.elluminate.groupware.audio.AudioTuning;
import com.elluminate.groupware.audio.ecelp.ECELPCodec;
import com.elluminate.groupware.audio.resampler.Resampler;
import com.elluminate.groupware.audio.telephony.ReceiveQueue;
import com.elluminate.groupware.audio.telephony.TransmitQueue;
import com.elluminate.groupware.audio.utils.AudioFileLoader;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.Resource;
import com.elluminate.util.SimpleStack;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.TreeMap;

public class TelephonyBridge {
    private static final double GAIN_DEFAULT = 1.0;
    private static final double GAIN_MAX = Math.pow(10.0, 0.8);
    private static final double GAIN_MIN = Math.pow(10.0, -1.2);
    private static final double GAIN_STEP_CNT = AudioTuning.telephonyGainStepCnt.getIntValue();
    private static final double GAIN_STEP_FACTOR = Math.pow(10.0, 2.0 / GAIN_STEP_CNT);
    private static final long MAX_WAIT_MILLIS = 1000L;
    private static final int MEDIUM_BACKLOG_LIMIT = 8000;
    private static final int NULL_TALKER_INDEX = -1;
    private static final int SMALL_BACKLOG_LIMIT = 3000;
    private static final int STATUS_UNKNOWN = -1;
    private static final int TELEPHONY_FRAME_MILLIS = 20;
    private static final int TELEPHONY_SAMP_RATE = 8000;
    private static final int CODEC_FRAME_LEN = 160;
    private static final int CODEC_SAMP_RATE = 8000;
    private static final int MAX_TEL_TALKERS_LIMIT = 2;
    private static final int MAX_VOIP_TALKERS_LIMIT = 32;
    private static final short NULL_ADDRESS = -32767;
    private static final int TELEPHONY_FRAME_LEN = 160;
    private static final int MAX_TALKERS_LIMIT = 34;
    private static final int ANNOUNCEMENT_INDEX = 34;
    private int backlogStatus = -1;
    private Channel channel;
    private boolean channelUp = false;
    private Client client;
    private ClientList clients;
    private LightweightTimer evaluateBacklogStatusTimer = null;
    private boolean evaluateBacklogStatusTimerRunning = false;
    private Object feederLock = new Object();
    private Thread feederThread = null;
    private boolean haveTheFloor = false;
    private short[] mixedBuf = new short[160];
    private int[] mixingBuf = new int[160];
    private volatile int myTalkerIdx = -1;
    private JinxProtocol protocol;
    private ECELPCodec[] recvCodecs;
    private double recvGain = 1.0;
    private ReceiveQueue recvQ = null;
    private LinkedList[] recvQueues = new LinkedList[35];
    private volatile int[] recvQueuesAmt = new int[35];
    private volatile long sendToTeleconfDoneTime = 0L;
    private boolean suppressingELiveAudio = false;
    private boolean suppressingTelephonyAudio = false;
    private short[] talkerAddrs = new short[34];
    private Resampler[] trimResampler = new Resampler[35];
    private Object userAgentAudioCall = null;
    private ECELPCodec xmitCodec;
    private short[] xmitFrameBuf = new short[160];
    private double xmitGain = 1.0;
    private TransmitQueue xmitQ = null;
    private short[] xmitShiftBuf = new short[320];
    private int xmitShiftCnt = 0;
    private int numberAlertsToStartIgnoring = 10;
    private static String announcePath = null;
    private static short[] announcementAudio = null;
    private static long announceModifiedTime = 0L;
    private static Object announcementLock = new Object();
    private SimpleStack txSamplesShortsStack;
    private SimpleStack rxSampleDataStack;
    private byte[] ecelpData = null;
    private static final TreeMap<String, short[]> alertList = new TreeMap();
    private ECELPCodec alertCodec;
    private Object alertCodecLock = new Object();
    private static final String ECELP_EXTENSION = ".ecelp20";
    private Imps imps;

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    public TelephonyBridge(Client client, String announcePathStr, int theNumberAlertsToStartIgnoring) {
        int i;
        this.client = client;
        this.numberAlertsToStartIgnoring = theNumberAlertsToStartIgnoring;
        if (announcePath != null && !announcePath.trim().equals(announcePathStr.trim())) {
            throw new RuntimeException("The new announcement file " + announcePathStr + " does not match the old announcement file " + announcePath);
        }
        announcePath = announcePathStr;
        this.clients = client.getClientList();
        this.protocol = new AudioProtocol();
        try {
            this.channel = client.acquireChannel("audio", (byte)0, null, null);
        }
        catch (JinxChannelException jce) {
            LogSupport.message((Object)this, (String)"TelephonyBridge", (String)("JinxChannelException: " + (Object)((Object)jce)));
            throw new RuntimeException("JinxChannelException: " + (Object)((Object)jce));
        }
        this.xmitCodec = new ECELPCodec();
        this.recvCodecs = new ECELPCodec[34];
        for (i = 0; i < 34; ++i) {
            this.recvCodecs[i] = new ECELPCodec();
            this.talkerAddrs[i] = -32767;
        }
        for (i = 0; i < this.recvQueues.length; ++i) {
            this.recvQueues[i] = new LinkedList();
            this.recvQueuesAmt[i] = 0;
            this.trimResampler[i] = new Resampler(8000, 0);
        }
        this.txSamplesShortsStack = new SimpleStack(200);
        this.rxSampleDataStack = new SimpleStack(300);
    }

    private void addTalker(short talkerAddr, int talkerIdx) {
        ClientInfo ci;
        if (talkerAddr == -32767) {
            throw new IllegalArgumentException("talkerAddr = NULL_ADDRESS");
        }
        if (talkerIdx < 0 || talkerIdx >= this.talkerAddrs.length) {
            throw new IllegalArgumentException("talkerIdx = " + talkerIdx);
        }
        int oldTalkerIdx = this.getTalkerIndex(talkerAddr);
        if (oldTalkerIdx >= 0) {
            ci = this.clients.get(talkerAddr);
            LogSupport.message((Object)this, (String)"addTalker", (String)("Duplicate talkerAddr: " + (ci == null ? "Unknown" : ci.getDisplayName())));
            this.removeTalker(talkerAddr);
        }
        if (this.talkerAddrs[talkerIdx] != -32767) {
            ci = this.clients.get(talkerAddr);
            LogSupport.message((Object)this, (String)"addTalker", (String)("Duplicate talkerIdx: " + (ci == null ? "Unknown" : ci.getDisplayName())));
            this.removeTalker(this.talkerAddrs[talkerIdx]);
        }
        this.talkerAddrs[talkerIdx] = talkerAddr;
        if (this.recvCodecs[talkerIdx].isDecoderOpen()) {
            this.recvCodecs[talkerIdx].resetDecoder();
        } else if (!this.recvCodecs[talkerIdx].openDecoder()) {
            LogSupport.error((Object)this, (String)"addTalker", (String)("Cannot open decoder " + talkerIdx));
        }
        this.trimResampler[talkerIdx].reset(8000, 8);
    }

    private void adjustXmitGain(short requester, int direction) {
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        if (chair.contains(requester) && this.haveTheFloor) {
            this.xmitGain = direction < 0 ? Math.max(GAIN_MIN, this.xmitGain / GAIN_STEP_FACTOR) : Math.min(GAIN_MAX, this.xmitGain * GAIN_STEP_FACTOR);
        }
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)requester, (byte)16);
        this.fireChannelData(cde, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void announce() {
        short[] announcement = this.loadAnnouncement();
        if (announcement == null) {
            announcement = this.createAnnouncement();
        }
        LinkedList linkedList = this.recvQueues[34];
        synchronized (linkedList) {
            if (!this.recvQueues[34].isEmpty()) {
                return;
            }
        }
        SampleData sampleData = (SampleData)this.rxSampleDataStack.pop();
        if (sampleData == null) {
            sampleData = new SampleData(null, 0, 0);
        }
        sampleData.dataBuf = announcement;
        sampleData.dataLen = announcement.length;
        sampleData.dataOff = 0;
        this.queueReceivedAudio(34, sampleData);
    }

    public synchronized void audioData(short[] sampleBuf, int startPos) {
        short[] samples;
        if (sampleBuf == null) {
            throw new IllegalArgumentException("sampleBuf is null");
        }
        if (startPos < 0) {
            throw new IllegalArgumentException("startPos < 0");
        }
        if (startPos + 160 > sampleBuf.length) {
            throw new IllegalArgumentException("sampleBuf too short");
        }
        if (!this.haveTheFloor) {
            return;
        }
        if (!this.channelUp) {
            if (!this.suppressingTelephonyAudio) {
                this.suppressingTelephonyAudio = true;
                LogSupport.message((Object)this, (String)"audioData", (String)"Ignoring telephony audio because eLive channel is down.");
            }
            return;
        }
        if (this.suppressingTelephonyAudio) {
            this.suppressingTelephonyAudio = false;
            LogSupport.message((Object)this, (String)"audioData", (String)"Accepting telephony audio because eLive channel is up.");
        }
        if ((samples = (short[])this.txSamplesShortsStack.pop()) == null) {
            samples = new short[160];
        }
        System.arraycopy(sampleBuf, startPos, samples, 0, 160);
        this.xmitQ.queueSamples(samples);
    }

    public synchronized void channelStateChanged(ChannelEvent event) {
        switch (event.getState()) {
            case 1: {
                if (this.channelUp) break;
                this.channelUp = true;
                try {
                    this.recvQ = new ReceiveQueue();
                    this.recvQ.addReceiveListener(null);
                    this.xmitQ = new TransmitQueue();
                    this.xmitQ.addTransmitListener(null);
                    this.channelUp = true;
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"channelStateChanged", (Throwable)t, (boolean)false);
                    this.recvQ = null;
                    this.xmitQ = null;
                }
                break;
            }
            case 2: {
                if (!this.channelUp) break;
                this.channelUp = false;
                this.recvQ.abort(false);
                this.recvQ = null;
                this.xmitQ.abort(false);
                this.xmitQ = null;
                this.xmitCodec.closeEncoder();
                for (int i = 0; i < this.recvCodecs.length; ++i) {
                    this.recvCodecs[i].closeDecoder();
                }
                break;
            }
            default: {
                String msg = "Invalid channel state: " + event.getState();
                LogSupport.exception((Object)this, (String)"channelStateChanged", (Throwable)new RuntimeException(msg), (boolean)false);
            }
        }
    }

    private short[] createAnnouncement() {
        int MAX_AMP = 16000;
        int NOTE_SUSTAIN_PCT = 67;
        int B4 = 494;
        int A4 = 440;
        int G4 = 392;
        int F4 = 349;
        int E4 = 330;
        int E4_FLAT = 311;
        int D4 = 294;
        int C4 = 262;
        boolean REST = false;
        int WHOLE = 8000;
        int HALF = 4000;
        int QUARTER = 2000;
        int EIGHTH = 1000;
        int[] TUNE = new int[]{392, 2000, 392, 2000, 392, 2000, 330, 8000};
        int sampleCnt = 0;
        for (int i = 1; i < TUNE.length; i += 2) {
            sampleCnt += TUNE[i];
        }
        short[] samples = new short[sampleCnt];
        int sampleIdx = 0;
        for (int i = 0; i < TUNE.length; i += 2) {
            this.createNote(8000, TUNE[i], 67, (short)16000, samples, sampleIdx, TUNE[i + 1]);
            sampleIdx += TUNE[i + 1];
        }
        return samples;
    }

    private void createNote(int sampRate, int noteFreq, int sustainPct, short maxAmp, short[] sampBuf, int sampOff, int sampCnt) {
        for (int i = 0; i < sampCnt; ++i) {
            short samp = (short)((double)maxAmp * Math.sin((double)(i * 2) * Math.PI * (double)noteFreq / (double)sampRate));
            int durationPct = 100 * i / sampCnt;
            if (durationPct > sustainPct) {
                samp = (short)(samp * (100 - durationPct) / 100);
            }
            sampBuf[i + sampOff] = samp;
        }
    }

    private synchronized void evaluateBacklogStatus() {
        int backlogMillis = this.getBacklogMillis();
        if (backlogMillis > 8000) {
            this.sendStatus(4);
        } else if (backlogMillis > 3000) {
            this.sendStatus(2);
        } else if (backlogMillis > 0) {
            this.sendStatus(1);
        } else {
            this.sendStatus(0);
        }
        if (backlogMillis > 0) {
            if (this.evaluateBacklogStatusTimer == null) {
                this.evaluateBacklogStatusTimer = new LightweightTimer(new Runnable(){

                    @Override
                    public void run() {
                        TelephonyBridge.this.evaluateBacklogStatus();
                    }
                });
            }
            if (!this.evaluateBacklogStatusTimerRunning) {
                this.evaluateBacklogStatusTimer.scheduleEvery(500L);
                this.evaluateBacklogStatusTimerRunning = true;
            }
        } else if (this.evaluateBacklogStatusTimer != null) {
            this.evaluateBacklogStatusTimer.cancel();
            this.evaluateBacklogStatusTimerRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feederTask() {
        Thread feederThread = Thread.currentThread();
        try {
            feederThread.setPriority(10);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"feederTask", (String)("Cannot increase thread priority:\n" + t));
        }
        while (!feederThread.isInterrupted()) {
            boolean didFeed;
            long now = Platform.currentTimeMillis();
            boolean canFeed = this.sendToTeleconfDoneTime - now < 20L;
            boolean bl = didFeed = canFeed ? this.feedTeleconference() : false;
            if (canFeed && !didFeed) {
                this.waitForWork();
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        for (int q = 0; q < this.recvQueues.length; ++q) {
            Debug.lockEnter((Object)this, (String)"feederTask", (String)"recvQueues[q]", (Object)this.recvQueues[q]);
            LinkedList linkedList = this.recvQueues[q];
            synchronized (linkedList) {
                this.recvQueues[q].clear();
                this.recvQueuesAmt[q] = 0;
            }
            Debug.lockLeave((Object)this, (String)"feederTask", (String)"recvQueues[q]", (Object)this.recvQueues[q]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean feedTeleconference() {
        if (AudioDebug.SUPPRESS_SPKR_OUTPUT.isEnabled()) {
            return false;
        }
        int firstQ = -1;
        int lastQ = -1;
        for (int q = 0; q < this.recvQueues.length; ++q) {
            Debug.lockEnter((Object)this, (String)"feedTeleconference", (String)"recvQueues[q]", (Object)this.recvQueues[q]);
            LinkedList linkedList = this.recvQueues[q];
            synchronized (linkedList) {
                if (!this.recvQueues[q].isEmpty()) {
                    if (firstQ < 0) {
                        firstQ = q;
                    }
                    lastQ = q;
                }
            }
            Debug.lockLeave((Object)this, (String)"feedTeleconference", (String)"recvQueues[q]", (Object)this.recvQueues[q]);
        }
        if (firstQ < 0) {
            return false;
        }
        if (firstQ != lastQ) {
            for (int i = 0; i < 160; ++i) {
                this.mixingBuf[i] = 0;
            }
        }
        boolean mixingAnnouncement = firstQ < 34 && lastQ >= 34;
        for (int q = firstQ; q <= lastQ; ++q) {
            int sampleCnt = 0;
            Debug.lockEnter((Object)this, (String)"feedTeleconference", (String)"recvQueues[q]", (Object)this.recvQueues[q]);
            LinkedList linkedList = this.recvQueues[q];
            synchronized (linkedList) {
                while (sampleCnt < 160 && this.recvQueues[q].size() > 0) {
                    int needed = 160 - sampleCnt;
                    SampleData sampleData = (SampleData)this.recvQueues[q].getFirst();
                    if (needed < sampleData.dataLen) {
                        System.arraycopy(sampleData.dataBuf, sampleData.dataOff, this.mixedBuf, sampleCnt, needed);
                        sampleData.dataOff += needed;
                        sampleData.dataLen -= needed;
                        sampleCnt += needed;
                        int n = q;
                        this.recvQueuesAmt[n] = this.recvQueuesAmt[n] - needed;
                        continue;
                    }
                    System.arraycopy(sampleData.dataBuf, sampleData.dataOff, this.mixedBuf, sampleCnt, sampleData.dataLen);
                    sampleCnt += sampleData.dataLen;
                    this.recvQueues[q].removeFirst();
                    int n = q;
                    this.recvQueuesAmt[n] = this.recvQueuesAmt[n] - sampleData.dataLen;
                    this.rxSampleDataStack.push((Object)sampleData);
                }
            }
            Debug.lockLeave((Object)this, (String)"feedTeleconference", (String)"recvQueues[q]", (Object)this.recvQueues[q]);
            while (sampleCnt < 160) {
                this.mixedBuf[sampleCnt++] = 0;
            }
            if (mixingAnnouncement && q != 34) {
                int i = 0;
                while (i < 160) {
                    int n = i++;
                    this.mixedBuf[n] = (short)(this.mixedBuf[n] / 6);
                }
            }
            if (firstQ == lastQ) continue;
            for (int i = 0; i < 160; ++i) {
                int n = i;
                this.mixingBuf[n] = this.mixingBuf[n] + this.mixedBuf[i];
            }
        }
        if (firstQ != lastQ) {
            for (int i = 0; i < 160; ++i) {
                int sample = this.mixingBuf[i];
                int clipper = Short.MIN_VALUE - sample;
                sample += clipper & ~(clipper >> 31);
                clipper = Short.MAX_VALUE - sample;
                this.mixedBuf[i] = (short)(sample += clipper & clipper >> 31);
            }
        }
        this.sendToTeleconference(this.mixedBuf, 0, 160);
        return true;
    }

    protected void fireChannelData(byte op) {
        if (!this.channelUp) {
            return;
        }
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)op);
        this.fireChannelData(cde, (byte)0);
    }

    protected void fireChannelData(int streamIdx, byte[] data) {
        if (streamIdx < 0 || 64 + streamIdx > 255) {
            throw new IllegalArgumentException("Invalid streamIdx: " + streamIdx);
        }
        if (!this.channelUp) {
            return;
        }
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)((byte)(64 + streamIdx)), (byte[])data);
        this.fireChannelData(cde, (byte)0);
    }

    private void fireChannelData(ChannelDataEvent cde, byte urgency) {
        try {
            this.channel.onChannelData(cde, urgency);
        }
        catch (IllegalStateException ex) {
            LogSupport.exception((Object)this, (String)"fireChannelData", (Throwable)ex, (boolean)false);
            cde.dispose();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireChanelData", (Throwable)ex, (boolean)true);
        }
    }

    private int getBacklogMillis() {
        int maxQueuedAmt = 0;
        for (int i = 0; i < this.recvQueuesAmt.length; ++i) {
            int queuedAmt = this.recvQueuesAmt[i];
            if (maxQueuedAmt >= queuedAmt) continue;
            maxQueuedAmt = queuedAmt;
        }
        long backlog = 1000L * (long)maxQueuedAmt / 8000L;
        long audioInTransit = this.sendToTeleconfDoneTime - Platform.currentTimeMillis();
        if (audioInTransit > 0L) {
            backlog += audioInTransit;
        }
        return (int)backlog;
    }

    private int getBacklogMillis(int talkerIdx) {
        long backlog = 1000L * (long)this.recvQueuesAmt[talkerIdx] / 8000L;
        long audioInTransit = this.sendToTeleconfDoneTime - Platform.currentTimeMillis();
        if (audioInTransit > 0L) {
            backlog += audioInTransit;
        }
        return (int)backlog;
    }

    private static int getBacklogTrimPct(long backlogMillis) {
        int trimPct = 0;
        if (backlogMillis > 500L) {
            trimPct = backlogMillis > 3000L ? 10 : (backlogMillis > 2500L ? 8 : (backlogMillis > 2000L ? 6 : (backlogMillis > 1500L ? 4 : (backlogMillis > 1000L ? 2 : 1))));
        }
        return trimPct;
    }

    private int getTalkerIndex(short talkerAddr) {
        for (int i = 0; i < this.talkerAddrs.length; ++i) {
            if (this.talkerAddrs[i] != talkerAddr) continue;
            return i;
        }
        return -1;
    }

    private boolean isTelephonyBridge(short clientAddr) {
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        return telephony == null ? false : telephony.isBridge(clientAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short[] loadAnnouncement() {
        if (announcePath == null) {
            return null;
        }
        File announceFile = new File(announcePath);
        if (!announceFile.isFile() || !announceFile.canRead()) {
            LogSupport.message((Object)this, (String)"loadAnnouncement", (String)("Ignoring " + announcePath + " because it is not a readable file"));
            return null;
        }
        long lastModified = announceFile.lastModified();
        Object object = announcementLock;
        synchronized (object) {
            if (announcementAudio == null || lastModified != announceModifiedTime) {
                announcementAudio = AudioFileLoader.loadAudioFile((File)announceFile, (float)8000.0f);
                announceModifiedTime = lastModified;
                LogSupport.message((Object)this, (String)"loadAnnouncement", (String)("loaded announce file " + announceFile));
            }
        }
        return announcementAudio;
    }

    private short loadShortField(byte[] buffer, int fieldOff) {
        return (short)((buffer[fieldOff] << 8) + (buffer[fieldOff + 1] & 0xFF));
    }

    public synchronized void lowerOutboundVolume() {
        this.recvGain = Math.max(GAIN_MIN, this.recvGain / GAIN_STEP_FACTOR);
        if (AudioDebug.TELEPHONY_VOLUME.show()) {
            LogSupport.message((Object)this, (String)"lowerOutboundVolume", (String)("gain=" + this.recvGain));
        }
    }

    public synchronized void onChannelData(ChannelDataEvent cde) {
        int cmd = cde.getCommand() & 0xFF;
        if (cmd >= 64 || cmd == 3 || cmd == 4) {
            this.recvQ.queueEvent(cde);
            return;
        }
        switch (cmd) {
            case 11: {
                this.fireChannelData((byte)10);
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                if (AudioDebug.IGNORE_STATUS_REQ.isEnabled()) {
                    LogSupport.message((Object)this, (String)"onChannelData", (String)"Ignoring STATUS_REQ");
                    break;
                }
                this.backlogStatus = -1;
                this.evaluateBacklogStatus();
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                this.adjustXmitGain(cde.getSourceAddress(), 1);
                break;
            }
            case 18: {
                this.adjustXmitGain(cde.getSourceAddress(), -1);
                break;
            }
            default: {
                LogSupport.error((Object)this, (String)"onChannelData", (String)("Illegal command code: " + cmd));
            }
        }
    }

    public synchronized void onReceive(ChannelDataEvent cde) {
        if (this.recvQ == null) {
            return;
        }
        int cmd = cde.getCommand() & 0xFF;
        if (cmd >= 64) {
            int talkerIdx = cmd - 64;
            if (this.talkerAddrs[talkerIdx] == -32767) {
                if (AudioDebug.GENERAL.isEnabled()) {
                    LogSupport.message((Object)this, (String)"onReceive", (String)"Received samples from an unopen audio stream");
                }
            } else {
                byte[] ecelpData = cde.getContents();
                SampleData sampleData = (SampleData)this.rxSampleDataStack.pop();
                if (sampleData == null) {
                    sampleData = new SampleData(null, 0, 0);
                }
                short[] samples = this.recvCodecs[talkerIdx].decode(ecelpData, sampleData.dataBuf);
                sampleData.dataBuf = samples;
                sampleData.dataLen = samples.length;
                sampleData.dataOff = 0;
                this.queueReceivedAudio(talkerIdx, sampleData);
                this.evaluateBacklogStatus();
            }
        } else if (cmd == 3) {
            byte[] contents = cde.getContents();
            short talkerAddr = this.loadShortField(contents, 0);
            int talkerIdx = contents[2] & 0xFF;
            this.addTalker(talkerAddr, talkerIdx);
            if (talkerAddr == this.clients.getMyAddress()) {
                this.myTalkerIdx = talkerIdx;
                this.haveTheFloor = true;
            }
        } else if (cmd == 4) {
            short talkerAddr = this.loadShortField(cde.getContents(), 0);
            this.removeTalker(talkerAddr);
            if (talkerAddr == this.clients.getMyAddress()) {
                this.myTalkerIdx = -1;
                this.haveTheFloor = false;
            }
        } else {
            LogSupport.error((Object)this, (String)"onReceive", (String)("Invalid ChannelDataCommand code: " + cmd));
        }
    }

    public synchronized void onTransmit(short[] samples) {
        if (this.xmitGain != 1.0) {
            for (int i = 0; i < samples.length; ++i) {
                int scaledSample = (int)Math.round(this.xmitGain * (double)samples[i]);
                int clipper = Short.MIN_VALUE - scaledSample;
                scaledSample += clipper & ~(clipper >> 31);
                clipper = Short.MAX_VALUE - scaledSample;
                samples[i] = (short)(scaledSample += clipper & clipper >> 31);
            }
        }
        System.arraycopy(samples, 0, this.xmitShiftBuf, this.xmitShiftCnt, samples.length);
        this.xmitShiftCnt += samples.length;
        this.txSamplesShortsStack.push((Object)samples);
        while (this.xmitShiftCnt >= 160) {
            System.arraycopy(this.xmitShiftBuf, 0, this.xmitFrameBuf, 0, 160);
            this.xmitShiftCnt -= 160;
            if (this.xmitShiftCnt > 0) {
                System.arraycopy(this.xmitShiftBuf, 160, this.xmitShiftBuf, 0, this.xmitShiftCnt);
            }
            this.ecelpData = this.xmitCodec.encode(this.xmitFrameBuf, this.ecelpData);
            this.fireChannelData(this.myTalkerIdx, this.ecelpData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueReceivedAudio(int talkerIdx, SampleData sampleData) {
        int sampleCnt;
        long backlog = this.getBacklogMillis(talkerIdx);
        int trimPct = TelephonyBridge.getBacklogTrimPct(backlog);
        if (trimPct > 0 && AudioDebug.BACKLOG.isEnabled()) {
            LogSupport.message((String)("talkerIdx #" + talkerIdx + ": backlog = " + backlog + " ms, trimming " + trimPct + "%"));
        }
        short[] samples = sampleData.dataBuf;
        int trimSampRate = (100 - trimPct) * 8000 / 100;
        sampleData.dataLen = sampleCnt = this.trimResampler[talkerIdx].resampleWithoutFiltering(samples, 0, samples.length, trimSampRate, samples, 0);
        Object object = this.recvQueues[talkerIdx];
        synchronized (object) {
            this.recvQueues[talkerIdx].addLast(sampleData);
            int n = talkerIdx;
            this.recvQueuesAmt[n] = this.recvQueuesAmt[n] + sampleCnt;
        }
        object = this.feederLock;
        synchronized (object) {
            this.feederLock.notifyAll();
        }
    }

    public synchronized void raiseOutboundVolume() {
        this.recvGain = Math.min(GAIN_MAX, this.recvGain * GAIN_STEP_FACTOR);
        if (AudioDebug.TELEPHONY_VOLUME.show()) {
            LogSupport.message((Object)this, (String)"raiseOutboundVolume", (String)("gain=" + this.recvGain));
        }
    }

    private void removeTalker(short talkerAddr) {
        if (talkerAddr == -32767) {
            throw new IllegalArgumentException("talkerAddr = NULL_ADDRESS");
        }
        int talkerIdx = this.getTalkerIndex(talkerAddr);
        if (talkerIdx < 0) {
            ClientInfo ci = this.clients.get(talkerAddr);
            LogSupport.message((Object)this, (String)"removeTalker", (String)("Talker not found: " + (ci == null ? "Unknown" : ci.getDisplayName())));
        } else {
            this.talkerAddrs[talkerIdx] = -32767;
        }
    }

    private void sendStatus(int status) {
        if (status == this.backlogStatus) {
            return;
        }
        this.backlogStatus = status;
        try {
            ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)5);
            DataOutputStream ostr = cde.write();
            ostr.writeShort(1);
            ostr.writeShort(this.client.getAddress());
            ostr.writeByte(status);
            ostr.close();
            this.fireChannelData(cde, (byte)0);
            if (AudioDebug.STATUS.show()) {
                LogSupport.message((Object)this, (String)"sendStatus", (String)("Sent " + AudioProtocol.decodeStatus((int)status)));
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"sendStatus", (Throwable)ioe, (boolean)true);
        }
    }

    private void sendToTeleconference(short[] samples, int sampleOff, int sampleCnt) {
        long now;
        if (this.userAgentAudioCall == null) {
            return;
        }
        if (this.recvGain != 1.0) {
            for (int i = 0; i < sampleCnt; ++i) {
                int scaledSample = (int)Math.round(this.recvGain * (double)samples[i + sampleOff]);
                int clipper = Short.MIN_VALUE - scaledSample;
                scaledSample += clipper & ~(clipper >> 31);
                clipper = Short.MAX_VALUE - scaledSample;
                samples[i + sampleOff] = (short)(scaledSample += clipper & clipper >> 31);
            }
        }
        if (this.sendToTeleconfDoneTime < (now = Platform.currentTimeMillis())) {
            this.sendToTeleconfDoneTime = now;
        }
        this.sendToTeleconfDoneTime += (long)((int)(1000L * (long)sampleCnt / 8000L));
    }

    public synchronized void startAudio(Object audioCall) {
        if (audioCall == null) {
            throw new IllegalArgumentException("Null audioCall");
        }
        if (this.userAgentAudioCall != null) {
            throw new IllegalStateException("Audio already started");
        }
        try {
            this.xmitCodec.openEncoder();
            this.xmitShiftCnt = 0;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error: " + t);
        }
        this.userAgentAudioCall = audioCall;
        this.feederThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TelephonyBridge.this.feederTask();
            }
        }, "Teleconference Feeder");
        this.feederThread.setDaemon(true);
        this.feederThread.start();
    }

    public synchronized void stopAudio(Object audioCall) {
        if (audioCall != this.userAgentAudioCall) {
            throw new IllegalArgumentException("Unknown listener");
        }
        if (this.userAgentAudioCall != null) {
            this.userAgentAudioCall = null;
            this.xmitCodec.closeEncoder();
        }
        if (this.feederThread != null) {
            this.feederThread.interrupt();
            this.feederThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForWork() {
        Debug.lockEnter((Object)this, (String)"waitForWork", (String)"feederLock", (Object)this.feederLock);
        Object object = this.feederLock;
        synchronized (object) {
            try {
                this.feederLock.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Debug.lockLeave((Object)this, (String)"waitForWork", (String)"feederLock", (Object)this.feederLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playAlert(String theKey, Object theContext, String thePrimaryAlert, String theBackupAlert) {
        LinkedList linkedList = this.recvQueues[34];
        synchronized (linkedList) {
            if (this.recvQueues[34].size() > this.numberAlertsToStartIgnoring) {
                return;
            }
        }
        short[] alert = this.getAlertSamples(theKey, theContext, thePrimaryAlert, theBackupAlert);
        if (alert != null) {
            if (AudioDebug.TELEPHONY_ALERT_INFO.show()) {
                LogSupport.message((Object)this, (String)"playAlert", (String)("calling playAlert with length " + alert.length));
            }
            this.queueAlert(alert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] getAlertSamples(String theKey, Object theContext, String thePrimaryAlert, String theBackupAlert) {
        short[] alert;
        block15: {
            alert = null;
            if (AudioDebug.TELEPHONY_ALERT_INFO.show()) {
                LogSupport.message((Object)this, (String)"playAlert", (String)("The alert has been requested for key = " + theKey + " and primary alert file = " + thePrimaryAlert + " and backup alert file = " + theBackupAlert));
            }
            TreeMap<String, short[]> treeMap = alertList;
            synchronized (treeMap) {
                alert = alertList.get(theKey);
            }
            if (alert == null) {
                try {
                    Resource r;
                    String alertString = thePrimaryAlert;
                    if (alertString == null) break block15;
                    if (AudioDebug.TELEPHONY_ALERT_INFO.show()) {
                        LogSupport.message((Object)this, (String)"playAlert", (String)"trying primary resource");
                    }
                    if (!(r = new Resource(theContext, alertString)).exists() && theBackupAlert != null) {
                        if (AudioDebug.TELEPHONY_ALERT_INFO.show()) {
                            LogSupport.message((Object)this, (String)"playAlert", (String)"primary resource does not exist");
                        }
                        r = new Resource(theContext, theBackupAlert);
                        alertString = theBackupAlert;
                        if (!r.exists()) {
                            if (AudioDebug.TELEPHONY_ALERT_INFO.show()) {
                                LogSupport.message((Object)this, (String)"playAlert", (String)("The alert could not be found for key = " + theKey + " and primary alert file = " + thePrimaryAlert + " and backup alert file = " + theBackupAlert));
                            }
                            return null;
                        }
                    }
                    if ((alert = this.loadAlert(r.load(), alertString, r)) == null) break block15;
                    TreeMap<String, short[]> treeMap2 = alertList;
                    synchronized (treeMap2) {
                        alertList.put(theKey, alert);
                    }
                }
                catch (Exception t) {
                    LogSupport.exception((Object)this, (String)("playAlert: The alert could not be found for key = " + theKey + " and primary alert file = " + thePrimaryAlert + " and backup alert file = " + theBackupAlert), (Throwable)t, (boolean)true);
                    return null;
                }
            }
        }
        return alert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueAlert(short[] alert) {
        if (this.userAgentAudioCall == null) {
            throw new IllegalStateException("Audio not started");
        }
        SampleData sampleData = (SampleData)this.rxSampleDataStack.pop();
        if (sampleData == null) {
            sampleData = new SampleData(null, 0, 0);
        }
        sampleData.dataBuf = alert;
        sampleData.dataLen = alert.length;
        sampleData.dataOff = 0;
        if (AudioDebug.TELEPHONY_ALERT_INFO.show()) {
            LogSupport.message((Object)this, (String)"playAlert", (String)("queueing sample data with length " + alert.length));
        }
        Object object = this.recvQueues[34];
        synchronized (object) {
            this.recvQueues[34].addLast(sampleData);
            this.recvQueuesAmt[34] = this.recvQueuesAmt[34] + sampleData.dataLen;
        }
        object = this.feederLock;
        synchronized (object) {
            this.feederLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short[] loadAlert(byte[] bytes, String theAlertFileName, Resource resource) {
        short[] samples = null;
        if (theAlertFileName.endsWith(ECELP_EXTENSION)) {
            Object object = this.alertCodecLock;
            synchronized (object) {
                if (this.alertCodec == null) {
                    this.openDecoder();
                } else {
                    this.alertCodec.resetDecoder();
                }
                samples = this.alertCodec.decode(bytes);
            }
            return samples;
        }
        samples = AudioFileLoader.loadAudioFile((URL)resource.find(), (float)8000.0f);
        return samples;
    }

    private void openDecoder() {
        if (this.alertCodec == null) {
            this.alertCodec = new ECELPCodec();
            this.alertCodec.openDecoder();
        }
    }

    private static class SampleData {
        public short[] dataBuf;
        public int dataLen;
        public int dataOff;

        public SampleData(short[] dataBuf, int dataOff, int dataLen) {
            this.dataBuf = dataBuf;
            this.dataOff = dataOff;
            this.dataLen = dataLen;
        }
    }
}

