/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.windows;

import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.module.AudioSupport;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.windows.JIWAudio;
import com.elluminate.groupware.audio.module.windows.JIWMixer;
import com.elluminate.groupware.audio.module.windows.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.swing.CTree;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WaveAudio
implements AudioSupport {
    private static final String DEFAULT = "";
    private static final String DESC_COMP_PREFIX = "[";
    private static final String DESC_COMP_SEPARATOR = "->";
    private static final String DESC_COMP_SUFFIX = "]";
    private static final float LOG_MAX_SCALE_FACTOR = (float)Math.log(20.0);
    private static final float LOG_MIN_SCALE_FACTOR = (float)Math.log(0.05);
    private static final int[] TRIAL_RATES = new int[]{8000, 11025, 16000, 22050, 32000, 44100, 48000};
    private static final int VISTA = 6;
    private static final int BUFFER_MILLIS = 20;
    private static final String DESC_COMP_JOIN = "]->[";
    private static final int WAVEIN_BUFFER_CNT = 200;
    private static final int WAVEOUT_BUFFER_CNT = 200;
    private volatile boolean mikeOpen = false;
    private volatile boolean spkrOpen = false;
    private I18n i18n = I18n.create((Object)this);
    private String inputDeviceName = null;
    private String[] inputDevices = null;
    private String inputSourceName = null;
    private int mikeBoost = -1;
    private float mikeScaleFactor = 1.0f;
    private JIWMixer mixer = new JIWMixer();
    private String outputDeviceName = null;
    private String[] outputDevices = null;
    private Component owner = null;
    private boolean simulateMikeGainControl = false;
    private boolean simulateSpkrVolControl = false;
    private int simulatedMikeGain = 50;
    private int simulatedSpkrVol = 50;
    private float spkrScaleFactor = 1.0f;

    @Override
    public int getLatentOutputSamplesCount() {
        return JIWAudio.getWaveOutBuffered();
    }

    @Override
    public int getLatentInputSamplesCount() {
        return JIWAudio.getWaveInBuffered();
    }

    @Override
    public void closeMike() {
        JIWAudio.closeWaveIn();
        this.mikeOpen = false;
    }

    @Override
    public void closeSpkr() {
        JIWAudio.closeWaveOut();
        this.spkrOpen = false;
    }

    private void connectInputDevice(String devName, String sourceName) {
        if (this.mikeOpen) {
            throw new IllegalStateException("Mike is open");
        }
        if (devName == null || devName.trim().equals(DEFAULT)) {
            devName = DEFAULT;
            sourceName = DEFAULT;
        } else if (sourceName == null || sourceName.trim().equals(DEFAULT)) {
            sourceName = DEFAULT;
        } else if (this.inputDeviceName != null && devName.equals(this.inputDeviceName) && this.inputSourceName != null && sourceName.equals(this.inputSourceName)) {
            return;
        }
        this.mixer.closeRecordingMixer();
        JIWAudio.setWaveInDevName(devName);
        this.inputDeviceName = JIWAudio.getWaveInDevName();
        this.inputSourceName = null;
        if (this.inputDeviceName == null) {
            LogSupport.message((Object)this, (String)"connectInputDevice", (String)"No audio input device found.");
            this.simulateMikeGainControl = false;
        } else {
            LogSupport.message((Object)this, (String)"connectInputDevice", (String)("Input device name = " + this.inputDeviceName));
            if (this.mixer.openRecordingMixer(this.inputDeviceName, sourceName)) {
                LogSupport.message((Object)this, (String)"connectInputDevice", (String)"Recording mixer found.");
                this.simulateMikeGainControl = false;
                this.inputSourceName = this.mixer.getSelectedRecordingLineName();
                LogSupport.message((Object)this, (String)"connectInputDevice", (String)("Input source name = " + this.inputSourceName));
                this.mixer.setControlValue(0, 10000);
                this.mixer.setControlValue(6, 0);
                if (this.mikeBoost >= 0) {
                    this.mixer.setControlValue(8, this.mikeBoost);
                }
            } else if (AudioDebug.NO_GAIN_CTRL_SIMULATION.isEnabled()) {
                LogSupport.message((Object)this, (String)"connectInputDevice", (String)"No recording mixer found: Disabling gain control.");
                this.simulateMikeGainControl = false;
            } else {
                LogSupport.message((Object)this, (String)"connectInputDevice", (String)"No recording mixer found: Simulating gain control.");
                this.simulateMikeGainControl = true;
            }
        }
        AudioEngine.controlChanged(1);
    }

    private void connectOutputDevice(String devName) {
        if (this.spkrOpen) {
            throw new IllegalStateException("Spkr is open");
        }
        if (devName == null || devName.trim().equals(DEFAULT)) {
            devName = DEFAULT;
        } else if (this.outputDeviceName != null && devName.equals(this.outputDeviceName)) {
            return;
        }
        if (this.outputDeviceName != null && devName.equals(this.outputDeviceName)) {
            return;
        }
        boolean mustSimulateSpkrVolControl = Platform.getVersion() < 6 && Platform.usingScreenReader() == 1;
        this.mixer.closePlaybackMixer();
        JIWAudio.setWaveOutDevName(devName);
        this.outputDeviceName = JIWAudio.getWaveOutDevName();
        if (this.outputDeviceName == null) {
            LogSupport.message((Object)this, (String)"connectOutputDevice", (String)"No audio output device found.");
            this.simulateSpkrVolControl = mustSimulateSpkrVolControl;
        } else if (mustSimulateSpkrVolControl) {
            this.simulateSpkrVolControl = true;
            LogSupport.message((Object)this, (String)"connectOutputDevice", (String)"Simulating speaker volume control due to screen reader");
        } else if (this.mixer.openPlaybackMixer(this.outputDeviceName)) {
            LogSupport.message((Object)this, (String)"connectOutputDevice", (String)("Output device name = " + this.outputDeviceName));
            LogSupport.message((Object)this, (String)"connectOutputDevice", (String)"Playback mixer found.");
            this.simulateSpkrVolControl = false;
            this.mixer.setControlValue(1, 0);
            this.mixer.setControlValue(0, 10000);
            this.mixer.setControlValue(3, 0);
        } else {
            LogSupport.message((Object)this, (String)"connectOutputDevice", (String)("Output device name = " + this.outputDeviceName));
            if (JIWAudio.getWaveOutVolume() >= 0) {
                LogSupport.message((Object)this, (String)"connectOutputDevice", (String)"No playback mixer found: Using waveOut volume control.");
                this.simulateSpkrVolControl = false;
            } else if (AudioDebug.NO_VOL_CTRL_SIMULATION.isEnabled()) {
                LogSupport.message((Object)this, (String)"connectOutputDevice", (String)"No playback mixer found: Disabling volume control.");
                this.simulateSpkrVolControl = false;
            } else {
                LogSupport.message((Object)this, (String)"connectOutputDevice", (String)"No playback mixer found: Simulating volume control.");
                this.simulateSpkrVolControl = true;
            }
        }
        AudioEngine.controlChanged(2);
    }

    private JPanel createTextPanel(String textI18nTag) {
        MultilineLabel label = new MultilineLabel(this.i18n.getStringLegacy(textI18nTag));
        if (Platform.usingScreenReader() == 1 || Platform.usingScreenReader() == -1) {
            label.setFocusable(true);
        }
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new FlowLayout(1, 0, 0));
        innerPanel.add((Component)label);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        outerPanel.add(Box.createGlue());
        outerPanel.add(innerPanel);
        outerPanel.add(Box.createGlue());
        return outerPanel;
    }

    @Override
    public void flushMike() {
        JIWAudio.flushWaveIn();
    }

    @Override
    public void flushSpkr() {
        JIWAudio.flushWaveOut();
    }

    @Override
    public String getInputDevice() {
        String deviceDesc = this.inputDeviceName == null || this.inputDeviceName.equals(DEFAULT) ? null : (this.inputSourceName == null || this.inputSourceName.equals(DEFAULT) ? DESC_COMP_PREFIX + this.inputDeviceName + DESC_COMP_SUFFIX : DESC_COMP_PREFIX + this.inputDeviceName + DESC_COMP_JOIN + this.inputSourceName + DESC_COMP_SUFFIX);
        return deviceDesc;
    }

    @Override
    public String[] getInputDeviceList() {
        String[] deviceDescriptions = new String[]{DEFAULT};
        if (this.inputDeviceName == null || this.inputDeviceName.equals(DEFAULT)) {
            return deviceDescriptions;
        }
        deviceDescriptions[0] = this.inputSourceName == null || this.inputSourceName.equals(DEFAULT) ? DESC_COMP_PREFIX + this.inputDeviceName + DESC_COMP_SUFFIX : DESC_COMP_PREFIX + this.inputDeviceName + DESC_COMP_JOIN + this.inputSourceName + DESC_COMP_SUFFIX;
        return deviceDescriptions;
    }

    @Override
    public String getInputDeviceDisplayName(String deviceHnd) {
        return this.inputDeviceName;
    }

    @Override
    public DeviceSelectionPanel getInputDeviceSelectionPanel(JButton okBtn, ActionListener selectionAL) {
        DeviceSelectionPanel panel = new DeviceSelectionPanel(okBtn, selectionAL){
            private DefaultTreeModel treeModel;
            private CTree treeViewer;
            private JButton okBtn;
            private String deviceName;
            private String sourceName;
            private JButton refreshBtn;
            private boolean supressDuringRefresh;
            {
                this.supressDuringRefresh = true;
            }

            @Override
            public void setup(final JButton okBtn, final ActionListener selectionAL) {
                this.okBtn = okBtn;
                final DefaultMutableTreeNode treeData = new DefaultMutableTreeNode("Audio Output Devices");
                TreePath currentPath = WaveAudio.this.populateInputDeviceDataTree(treeData);
                this.treeModel = new DefaultTreeModel(treeData);
                this.treeViewer = new CTree((TreeModel)this.treeModel);
                this.treeViewer.setRootVisible(false);
                this.treeViewer.setVisibleRowCount(15);
                this.treeViewer.setShowsRootHandles(true);
                this.treeViewer.getSelectionModel().setSelectionMode(1);
                this.treeViewer.setExpandsSelectedPaths(true);
                this.treeViewer.expandAll();
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setLeafIcon(null);
                renderer.setClosedIcon(null);
                renderer.setOpenIcon(null);
                this.treeViewer.setCellRenderer((TreeCellRenderer)renderer);
                if (currentPath != null) {
                    this.treeViewer.getSelectionModel().setSelectionPath(currentPath);
                    okBtn.setEnabled(true);
                } else {
                    okBtn.setEnabled(false);
                }
                this.treeViewer.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent me) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeViewer.getLastSelectedPathComponent();
                        if (node == null) {
                            return;
                        }
                        if (me.getClickCount() == 2 && node.isLeaf()) {
                            okBtn.setEnabled(true);
                            okBtn.doClick();
                        }
                    }
                });
                this.treeViewer.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeViewer.getLastSelectedPathComponent();
                        if (node == null) {
                            return;
                        }
                        okBtn.setEnabled(node.isLeaf());
                        if (!supressDuringRefresh) {
                            selectionAL.actionPerformed(null);
                        }
                    }
                });
                JScrollPane scrollPane = new JScrollPane((Component)this.treeViewer, 20, 30);
                this.refreshBtn = new JButton(WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_REFRESH_BTN_NAME));
                this.refreshBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        supressDuringRefresh = true;
                        TreePath currentPath = WaveAudio.this.populateInputDeviceDataTree(treeData);
                        treeModel.nodeStructureChanged(treeData);
                        treeViewer.expandAll();
                        okBtn.setEnabled(false);
                        selectionAL.actionPerformed(null);
                        if (currentPath != null) {
                            treeViewer.getSelectionModel().setSelectionPath(currentPath);
                            okBtn.setEnabled(true);
                        } else {
                            okBtn.setEnabled(false);
                        }
                        treeViewer.requestFocus();
                        supressDuringRefresh = false;
                    }
                });
                JPanel refreshPanel = new JPanel(new FlowLayout(1, 12, 12));
                refreshPanel.add(this.refreshBtn);
                this.selectionPanel.setLayout(new BorderLayout());
                this.selectionPanel.add((Component)WaveAudio.this.createTextPanel("WinAudio.inputSelectionText"), "North");
                this.selectionPanel.add((Component)refreshPanel, "Center");
                this.selectionPanel.add((Component)scrollPane, "South");
                this.selectionPanel.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        treeViewer.requestFocus();
                    }
                });
                this.selectionPanel.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent he) {
                        long flags = he.getChangeFlags();
                        if ((flags & 4L) != 0L && selectionPanel.isShowing()) {
                            refreshBtn.doClick();
                        }
                    }
                });
            }

            @Override
            public void apply() {
                if (!this.parseSelection()) {
                    return;
                }
                try {
                    WaveAudio.this.connectInputDevice(this.deviceName, this.sourceName);
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"inputDeviceSelectionOkBtn", (String)("Cant connect to selected audio device: " + t));
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this.okBtn, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_CANT_CONNECT_AUDIO_DEVICE), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_ERROR_TITLE), (int)0);
                }
            }

            private boolean parseSelection() {
                String deviceDisplayName;
                TreePath selectionPath = this.treeViewer.getSelectionPath();
                if (selectionPath == null) {
                    return false;
                }
                int componentCnt = selectionPath.getPathCount();
                DefaultMutableTreeNode component1 = componentCnt <= 1 ? null : (DefaultMutableTreeNode)selectionPath.getPathComponent(1);
                DefaultMutableTreeNode component2 = componentCnt <= 2 ? null : (DefaultMutableTreeNode)selectionPath.getPathComponent(2);
                this.deviceName = deviceDisplayName = component1 == null ? WaveAudio.DEFAULT : component1.toString();
                this.sourceName = component2 == null ? WaveAudio.DEFAULT : component2.toString();
                for (int i = 0; i < WaveAudio.this.inputDevices.length; ++i) {
                    if (!deviceDisplayName.equals(JIWAudio.getInputDeviceDisplayName(WaveAudio.this.inputDevices[i]))) continue;
                    this.deviceName = WaveAudio.this.inputDevices[i];
                    break;
                }
                return true;
            }
        };
        return panel;
    }

    @Override
    public int getMikeBoost() {
        int mikeBoost = this.mixer.getControlValue(8);
        return mikeBoost < 0 ? -1 : (100 * mikeBoost + 5000) / 10000;
    }

    @Override
    public int getMikeGain() {
        if (this.simulateMikeGainControl) {
            return this.simulatedMikeGain;
        }
        if (this.mixer.getControlValue(7) == 0) {
            return -1;
        }
        int mikeGain = this.mixer.getControlValue(5);
        return mikeGain < 0 ? -1 : (100 * mikeGain + 5000) / 10000;
    }

    @Override
    public String getOutputDevice() {
        String deviceDesc = this.outputDeviceName == null || this.outputDeviceName.trim().equals(DEFAULT) ? null : DESC_COMP_PREFIX + this.outputDeviceName + DESC_COMP_SUFFIX;
        return deviceDesc;
    }

    @Override
    public String[] getOutputDeviceList() {
        String[] deviceDescriptions = new String[]{DEFAULT};
        if (this.outputDeviceName == null || this.outputDeviceName.trim().equals(DEFAULT)) {
            return deviceDescriptions;
        }
        deviceDescriptions[0] = DESC_COMP_PREFIX + this.outputDeviceName + DESC_COMP_SUFFIX;
        return deviceDescriptions;
    }

    @Override
    public String getOutputDeviceDisplayName(String deviceHnd) {
        return this.outputDeviceName;
    }

    @Override
    public DeviceSelectionPanel getOutputDeviceSelectionPanel(JButton okBtn, ActionListener selectionAL) {
        DeviceSelectionPanel panel = new DeviceSelectionPanel(okBtn, selectionAL){
            private DefaultTreeModel treeModel;
            private CTree treeViewer;
            private JButton okBtn;
            private String deviceName;
            private JButton refreshBtn;
            private boolean supressDuringRefresh;
            {
                this.supressDuringRefresh = true;
            }

            @Override
            public void setup(final JButton okBtn, final ActionListener selectionAL) {
                this.okBtn = okBtn;
                final DefaultMutableTreeNode treeData = new DefaultMutableTreeNode("Audio Output Devices");
                TreePath currentPath = WaveAudio.this.populateOutputDeviceDataTree(treeData);
                this.treeModel = new DefaultTreeModel(treeData);
                this.treeViewer = new CTree((TreeModel)this.treeModel);
                this.treeViewer.setRootVisible(false);
                this.treeViewer.setVisibleRowCount(15);
                this.treeViewer.setShowsRootHandles(true);
                this.treeViewer.getSelectionModel().setSelectionMode(1);
                this.treeViewer.setExpandsSelectedPaths(true);
                this.treeViewer.expandAll();
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setLeafIcon(null);
                renderer.setClosedIcon(null);
                renderer.setOpenIcon(null);
                this.treeViewer.setCellRenderer((TreeCellRenderer)renderer);
                if (currentPath != null) {
                    this.treeViewer.getSelectionModel().setSelectionPath(currentPath);
                    okBtn.setEnabled(true);
                } else {
                    okBtn.setEnabled(false);
                }
                this.treeViewer.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent me) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeViewer.getLastSelectedPathComponent();
                        if (node == null) {
                            return;
                        }
                        if (me.getClickCount() == 2 && node.isLeaf()) {
                            okBtn.setEnabled(true);
                            okBtn.doClick();
                        }
                    }
                });
                this.treeViewer.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeViewer.getLastSelectedPathComponent();
                        if (node == null) {
                            return;
                        }
                        okBtn.setEnabled(node.isLeaf());
                        if (!supressDuringRefresh) {
                            selectionAL.actionPerformed(null);
                        }
                    }
                });
                JScrollPane scrollPane = new JScrollPane((Component)this.treeViewer, 20, 30);
                this.refreshBtn = new JButton(WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_REFRESH_BTN_NAME));
                this.refreshBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        supressDuringRefresh = true;
                        TreePath currentPath = WaveAudio.this.populateOutputDeviceDataTree(treeData);
                        treeModel.nodeStructureChanged(treeData);
                        treeViewer.expandAll();
                        okBtn.setEnabled(false);
                        selectionAL.actionPerformed(null);
                        if (currentPath != null) {
                            treeViewer.getSelectionModel().setSelectionPath(currentPath);
                            okBtn.setEnabled(true);
                        } else {
                            okBtn.setEnabled(false);
                        }
                        treeViewer.requestFocus();
                        supressDuringRefresh = true;
                    }
                });
                JPanel refreshPanel = new JPanel(new FlowLayout(1, 12, 12));
                refreshPanel.add(this.refreshBtn);
                this.selectionPanel.setLayout(new BorderLayout());
                this.selectionPanel.add((Component)WaveAudio.this.createTextPanel("WinAudio.outputSelectionText"), "North");
                this.selectionPanel.add((Component)refreshPanel, "Center");
                this.selectionPanel.add((Component)scrollPane, "South");
                this.selectionPanel.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        treeViewer.requestFocus();
                    }
                });
                this.selectionPanel.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent he) {
                        long flags = he.getChangeFlags();
                        if ((flags & 4L) != 0L && selectionPanel.isShowing()) {
                            refreshBtn.doClick();
                        }
                    }
                });
            }

            public String getSelectedDeviceName() {
                if (this.parseSelection()) {
                    return this.deviceName;
                }
                return WaveAudio.DEFAULT;
            }

            public String getSelectedSourceName() {
                return WaveAudio.DEFAULT;
            }

            @Override
            public void apply() {
                if (!this.parseSelection()) {
                    return;
                }
                try {
                    WaveAudio.this.connectOutputDevice(this.deviceName);
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"outputDeviceSelectionOkBtn", (String)("Cant connect to selected audio device: " + t));
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this.okBtn, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_CANT_CONNECT_AUDIO_DEVICE), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_ERROR_TITLE), (int)0);
                }
            }

            private boolean parseSelection() {
                String deviceDisplayName;
                TreePath selectionPath = this.treeViewer.getSelectionPath();
                if (selectionPath == null) {
                    return false;
                }
                int componentCnt = selectionPath.getPathCount();
                DefaultMutableTreeNode component1 = componentCnt <= 1 ? null : (DefaultMutableTreeNode)selectionPath.getPathComponent(1);
                this.deviceName = deviceDisplayName = component1 == null ? WaveAudio.DEFAULT : component1.toString();
                for (int i = 0; i < WaveAudio.this.outputDevices.length; ++i) {
                    if (!deviceDisplayName.equals(JIWAudio.getOutputDeviceDisplayName(WaveAudio.this.outputDevices[i]))) continue;
                    this.deviceName = WaveAudio.this.outputDevices[i];
                    break;
                }
                return true;
            }
        };
        return panel;
    }

    @Override
    public int getSpkrVolume() {
        if (this.simulateSpkrVolControl) {
            return this.simulatedSpkrVol;
        }
        int masterVol = Platform.getVersion() >= 6 ? -1 : this.mixer.getControlValue(2);
        int waveVol = this.mixer.getControlValue(4);
        int spkrVol = masterVol < 0 ? waveVol : (waveVol < 0 ? masterVol : (masterVol * waveVol + 5000) / 10000);
        if (spkrVol >= 0) {
            return (100 * spkrVol + 5000) / 10000;
        }
        int waveOutVol = JIWAudio.getWaveOutVolume();
        return waveOutVol < 0 ? -1 : (100 * waveOutVol + Short.MAX_VALUE) / 65535;
    }

    @Override
    public void initialize() {
        this.mixer.addChangeListener(new JIWMixer.ChangeListener(){

            @Override
            public void stateChanged(JIWMixer.ChangeEvent event) {
                switch (event.CONTROL_IDX) {
                    case 1: {
                        if (WaveAudio.this.mixer.getControlValue(1) != 10000 || 0 != ModalDialog.showConfirmDialog((Component)WaveAudio.this.owner, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_MASTER_MUTE_QUERY), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2)) break;
                        WaveAudio.this.mixer.setControlValue(1, 0);
                        break;
                    }
                    case 2: 
                    case 4: {
                        AudioEngine.controlChanged(2);
                        break;
                    }
                    case 0: {
                        if (WaveAudio.this.mixer.getControlValue(0) != 0 || 0 != ModalDialog.showConfirmDialog((Component)WaveAudio.this.owner, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_MIC_ECHO_QUERY), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2)) break;
                        WaveAudio.this.mixer.setControlValue(0, 10000);
                        break;
                    }
                    case 3: {
                        if (WaveAudio.this.mixer.getControlValue(3) == 0 || 0 != ModalDialog.showConfirmDialog((Component)WaveAudio.this.owner, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_SPKR_MUTE_QUERY), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2)) break;
                        WaveAudio.this.mixer.setControlValue(3, 0);
                        break;
                    }
                    case 8: {
                        if (WaveAudio.this.mixer.getControlValue(8) != 0) {
                            if (0 != ModalDialog.showConfirmDialog((Component)WaveAudio.this.owner, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_MIKE_BOOST_ENABLED_QUERY), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2)) break;
                            WaveAudio.this.mixer.setControlValue(8, 0);
                            break;
                        }
                        if (0 != ModalDialog.showConfirmDialog((Component)WaveAudio.this.owner, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_MIKE_BOOST_DISABLED_QUERY), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2)) break;
                        WaveAudio.this.mixer.setControlValue(8, 10000);
                        break;
                    }
                    case 5: {
                        if (WaveAudio.this.mixer.getControlValue(7) == 0) break;
                        AudioEngine.controlChanged(1);
                        break;
                    }
                    case 6: {
                        if (WaveAudio.this.mixer.getControlValue(7) == 0 || WaveAudio.this.mixer.getControlValue(6) != 10000 || 0 != ModalDialog.showConfirmDialog((Component)WaveAudio.this.owner, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_MIC_MUTE_QUERY), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2)) break;
                        WaveAudio.this.mixer.setControlValue(6, 0);
                        break;
                    }
                    case 7: {
                        if (WaveAudio.this.mixer.getControlValue(7) == 0) {
                            boolean disallow;
                            boolean bl = disallow = 0 == ModalDialog.showConfirmDialog((Component)WaveAudio.this.owner, (Object)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_MIC_SELECT_QUERY), (String)WaveAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2);
                            if (disallow) {
                                WaveAudio.this.mixer.setControlValue(7, 10000);
                                break;
                            }
                            AudioEngine.controlChanged(1);
                            break;
                        }
                        AudioEngine.controlChanged(1);
                    }
                }
            }
        });
    }

    @Override
    public boolean isInputDeviceSelectionSupported() {
        return true;
    }

    @Override
    public boolean isOutputDeviceSelectionSupported() {
        return true;
    }

    @Override
    public int openMike(int desiredRate) {
        int actualRate;
        block11: {
            actualRate = 0;
            try {
                JIWAudio.openWaveIn(desiredRate, 200, (desiredRate * 20 + 999) / 1000);
                actualRate = desiredRate;
                this.mikeOpen = true;
            }
            catch (RuntimeException x) {
                for (int i = 0; i < 2 * TRIAL_RATES.length; ++i) {
                    int trialRate;
                    if (i < TRIAL_RATES.length ? (trialRate = TRIAL_RATES[i]) <= desiredRate : (trialRate = TRIAL_RATES[2 * TRIAL_RATES.length - i - 1]) >= desiredRate) continue;
                    try {
                        JIWAudio.openWaveIn(trialRate, 200, (trialRate * 20 + 999) / 1000);
                        actualRate = trialRate;
                        this.mikeOpen = true;
                        break;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (actualRate != 0) break block11;
                throw x;
            }
        }
        if (this.inputDeviceName == null) {
            this.inputDeviceName = JIWAudio.getWaveInDevName();
            this.inputSourceName = null;
            if (this.inputDeviceName == null) {
                this.inputDeviceName = DEFAULT;
                LogSupport.message((Object)this, (String)"openMike", (String)"Input device name unknown.");
                this.simulateMikeGainControl = true;
            } else if (this.mixer.openRecordingMixer(this.inputDeviceName, DEFAULT)) {
                LogSupport.message((Object)this, (String)"openMike", (String)("Input device name = " + this.inputDeviceName));
                LogSupport.message((Object)this, (String)"openMike", (String)"Recording mixer found.");
                this.simulateMikeGainControl = false;
                this.inputSourceName = this.mixer.getSelectedRecordingLineName();
                LogSupport.message((Object)this, (String)"openMike", (String)("Input source name = " + this.inputSourceName));
                this.mixer.setControlValue(0, 10000);
                this.mixer.setControlValue(6, 0);
                if (this.mikeBoost >= 0) {
                    this.mixer.setControlValue(8, this.mikeBoost);
                }
            } else {
                LogSupport.message((Object)this, (String)"openMike", (String)("Input device name = " + this.inputDeviceName));
                LogSupport.message((Object)this, (String)"openMike", (String)"No recording mixer found: Simulating gain control.");
                this.simulateMikeGainControl = true;
            }
            AudioEngine.controlChanged(1);
        }
        return actualRate;
    }

    @Override
    public int openSpkr(int desiredRate) {
        int actualRate;
        block12: {
            actualRate = 0;
            try {
                JIWAudio.openWaveOut(desiredRate, 200, (desiredRate * 20 + 999) / 1000);
                actualRate = desiredRate;
                this.spkrOpen = true;
            }
            catch (RuntimeException x) {
                for (int i = 0; i < 2 * TRIAL_RATES.length; ++i) {
                    int trialRate;
                    if (i < TRIAL_RATES.length ? (trialRate = TRIAL_RATES[i]) <= desiredRate : (trialRate = TRIAL_RATES[2 * TRIAL_RATES.length - i - 1]) >= desiredRate) continue;
                    try {
                        JIWAudio.openWaveOut(trialRate, 200, (trialRate * 20 + 999) / 1000);
                        actualRate = trialRate;
                        this.spkrOpen = true;
                        break;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (actualRate != 0) break block12;
                throw x;
            }
        }
        if (this.outputDeviceName == null) {
            this.outputDeviceName = JIWAudio.getWaveOutDevName();
            if (this.outputDeviceName == null) {
                this.outputDeviceName = DEFAULT;
                LogSupport.message((Object)this, (String)"openSpkr", (String)"Output device name unknown");
                this.simulateSpkrVolControl = false;
            } else if (this.mixer.openPlaybackMixer(this.outputDeviceName)) {
                LogSupport.message((Object)this, (String)"openSpkr", (String)("Output device name = " + this.outputDeviceName));
                LogSupport.message((Object)this, (String)"openSpkr", (String)"Playback mixer found.");
                this.simulateSpkrVolControl = false;
                this.mixer.setControlValue(1, 0);
                this.mixer.setControlValue(0, 10000);
                this.mixer.setControlValue(3, 0);
            } else {
                LogSupport.message((Object)this, (String)"openSpkr", (String)("Output device name = " + this.outputDeviceName));
                if (JIWAudio.getWaveOutVolume() >= 0) {
                    LogSupport.message((Object)this, (String)"openSpkr", (String)"No playback mixer found: Using waveOut volume control.");
                    this.simulateSpkrVolControl = false;
                } else {
                    LogSupport.message((Object)this, (String)"openSpkr", (String)"No playback mixer found: Simulating volume control.");
                    this.simulateSpkrVolControl = true;
                }
            }
            AudioEngine.controlChanged(2);
        }
        return actualRate;
    }

    private TreePath populateInputDeviceDataTree(DefaultMutableTreeNode treeData) {
        TreePath currentPath = null;
        treeData.removeAllChildren();
        this.inputDevices = JIWAudio.enumerateInputDevices();
        for (int i = 0; i < this.inputDevices.length; ++i) {
            boolean isCurrentDevice;
            DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(JIWAudio.getInputDeviceDisplayName(this.inputDevices[i]));
            treeData.add(deviceNode);
            boolean bl = isCurrentDevice = this.inputDeviceName != null && this.inputDeviceName.equals(this.inputDevices[i]);
            if (isCurrentDevice && (this.inputSourceName == null || this.inputSourceName.equals(DEFAULT))) {
                currentPath = new TreePath(deviceNode.getPath());
            }
            String[] sourceLines = JIWMixer.enumerateWaveInSourceLines(this.inputDevices[i]);
            for (int j = 0; j < sourceLines.length; ++j) {
                DefaultMutableTreeNode sourceNode = new DefaultMutableTreeNode(sourceLines[j]);
                deviceNode.add(sourceNode);
                if (!isCurrentDevice || this.inputSourceName == null || !this.inputSourceName.equals(sourceLines[j])) continue;
                currentPath = new TreePath(sourceNode.getPath());
            }
        }
        return currentPath;
    }

    private TreePath populateOutputDeviceDataTree(DefaultMutableTreeNode treeData) {
        TreePath currentPath = null;
        treeData.removeAllChildren();
        this.outputDevices = JIWAudio.enumerateOutputDevices();
        for (int i = 0; i < this.outputDevices.length; ++i) {
            DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(JIWAudio.getOutputDeviceDisplayName(this.outputDevices[i]));
            treeData.add(deviceNode);
            if (this.outputDeviceName == null || !this.outputDeviceName.equals(this.outputDevices[i])) continue;
            currentPath = new TreePath(deviceNode.getPath());
        }
        return currentPath;
    }

    @Override
    public void readMike(short[] samples, int samplesOff, int samplesCnt) {
        JIWAudio.readWaveIn(samples, samplesOff, samplesCnt);
        if (this.simulateMikeGainControl) {
            for (int i = 0; i < samplesCnt; ++i) {
                int sampIdx = samplesOff + i;
                int newSamp = (int)(this.mikeScaleFactor * (float)samples[sampIdx]);
                if (newSamp < Short.MIN_VALUE) {
                    newSamp = Short.MIN_VALUE;
                } else if (newSamp > Short.MAX_VALUE) {
                    newSamp = Short.MAX_VALUE;
                }
                samples[sampIdx] = (short)newSamp;
            }
        }
    }

    @Override
    public void setInputDevice(String deviceDesc) {
        String sourceName;
        String deviceName;
        if (deviceDesc == null || deviceDesc.trim().equals(DEFAULT)) {
            this.connectInputDevice(DEFAULT, DEFAULT);
            return;
        }
        int prefixLen = DESC_COMP_PREFIX.length();
        String prefix = deviceDesc.substring(0, prefixLen);
        if (!prefix.equals(DESC_COMP_PREFIX)) {
            LogSupport.message((Object)this, (String)"setInputDevice", (String)("Invalid prefix in device descriptor: \"" + deviceDesc + "\""));
            return;
        }
        int suffixLen = DESC_COMP_SUFFIX.length();
        String suffix = deviceDesc.substring(deviceDesc.length() - suffixLen);
        if (!suffix.equals(DESC_COMP_SUFFIX)) {
            LogSupport.message((Object)this, (String)"setInputDevice", (String)("Invalid suffix in input device descriptor: \"" + deviceDesc + "\""));
            return;
        }
        int joinIdx = deviceDesc.indexOf(DESC_COMP_JOIN);
        if (joinIdx < 0) {
            deviceName = deviceDesc.substring(prefixLen, deviceDesc.length() - suffixLen);
            sourceName = DEFAULT;
        } else {
            int joinLen = DESC_COMP_JOIN.length();
            deviceName = deviceDesc.substring(prefixLen, joinIdx);
            sourceName = deviceDesc.substring(joinIdx + joinLen, deviceDesc.length() - suffixLen);
        }
        this.connectInputDevice(deviceName, sourceName);
    }

    @Override
    public void setMikeBoost(int percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException();
        }
        this.mikeBoost = (percent * 10000 + 50) / 100;
        this.mixer.setControlValue(8, this.mikeBoost);
    }

    @Override
    public void setMikeGain(int percent) {
        int MAX_GAIN = 100;
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException();
        }
        if (this.simulateMikeGainControl) {
            this.simulatedMikeGain = percent;
            this.mikeScaleFactor = (float)Math.exp((float)percent * (LOG_MAX_SCALE_FACTOR - LOG_MIN_SCALE_FACTOR) / 100.0f + LOG_MIN_SCALE_FACTOR);
            return;
        }
        if (this.mixer.getControlValue(7) != 0) {
            int mikeGain = (percent * 10000 + 50) / 100;
            this.mixer.setControlValue(5, mikeGain);
        }
    }

    @Override
    public void setOwner(Component who) {
        this.owner = who;
    }

    @Override
    public void setOutputDevice(String deviceDesc) {
        if (deviceDesc == null || deviceDesc.trim().equals(DEFAULT)) {
            this.connectOutputDevice(DEFAULT);
            return;
        }
        int prefixLen = DESC_COMP_PREFIX.length();
        String prefix = deviceDesc.substring(0, prefixLen);
        if (!prefix.equals(DESC_COMP_PREFIX)) {
            LogSupport.message((Object)this, (String)"setOutputDevice", (String)("Invalid prefix in device descriptor: \"" + deviceDesc + "\""));
            return;
        }
        int suffixLen = DESC_COMP_SUFFIX.length();
        String suffix = deviceDesc.substring(deviceDesc.length() - suffixLen);
        if (!suffix.equals(DESC_COMP_SUFFIX)) {
            LogSupport.message((Object)this, (String)"setOutputDevice", (String)("Invalid suffix in output device descriptor: \"" + deviceDesc + "\""));
            return;
        }
        String deviceName = deviceDesc.substring(prefixLen, deviceDesc.length() - suffixLen);
        this.connectOutputDevice(deviceName);
    }

    @Override
    public void setSpkrVolume(int percent) {
        int MAX_VOL = 100;
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException();
        }
        if (this.simulateSpkrVolControl) {
            this.simulatedSpkrVol = percent;
            this.spkrScaleFactor = (float)Math.exp((float)percent * (LOG_MAX_SCALE_FACTOR - LOG_MIN_SCALE_FACTOR) / 100.0f + LOG_MIN_SCALE_FACTOR);
            return;
        }
        int masterVol = Platform.getVersion() >= 6 ? -1 : this.mixer.getControlValue(2);
        int waveVol = this.mixer.getControlValue(4);
        if (masterVol < 0 && waveVol < 0) {
            int newVol = (percent * 65535 + 50) / 100;
            JIWAudio.setWaveOutVolume(newVol);
        } else if (masterVol < 0) {
            int newVol = (percent * 10000 + 50) / 100;
            this.mixer.setControlValue(4, newVol);
        } else if (waveVol < 0) {
            int newVol = (percent * 10000 + 50) / 100;
            this.mixer.setControlValue(2, newVol);
        } else {
            int newVol = (percent * 10000 + 50) / 100;
            if (newVol == 0) {
                this.mixer.setControlValue(4, 0);
            } else if (newVol > masterVol) {
                this.mixer.setControlValue(2, newVol);
                this.mixer.setControlValue(4, 10000);
            } else {
                this.mixer.setControlValue(4, (10000 * newVol + masterVol / 2) / masterVol);
            }
        }
    }

    @Override
    public boolean supportsFullDuplex() {
        return true;
    }

    @Override
    public void terminate() {
        this.mixer.terminate();
    }

    @Override
    public void writeSpkr(short[] samples, int samplesOff, int samplesCnt) {
        if (this.simulateSpkrVolControl) {
            for (int i = 0; i < samplesCnt; ++i) {
                int sampIdx = samplesOff + i;
                int newSamp = (int)(this.spkrScaleFactor * (float)samples[sampIdx]);
                if (newSamp < Short.MIN_VALUE) {
                    newSamp = Short.MIN_VALUE;
                } else if (newSamp > Short.MAX_VALUE) {
                    newSamp = Short.MAX_VALUE;
                }
                samples[sampIdx] = (short)newSamp;
            }
        }
        JIWAudio.writeWaveOut(samples, samplesOff, samplesCnt);
    }
}

