/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.windows;

import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;

public class JIWMixer
implements Runnable {
    public static final int MAX = 10000;
    public static final int OFF = 0;
    public static final int ON = 10000;
    public static final int PLAY_INPUT_MUTE = 0;
    public static final int PLAY_MASTER_MUTE = 1;
    public static final int PLAY_MASTER_VOLUME = 2;
    public static final int PLAY_WAVE_MUTE = 3;
    public static final int PLAY_WAVE_VOLUME = 4;
    public static final int REC_INPUT_GAIN = 5;
    public static final int REC_INPUT_MUTE = 6;
    public static final int REC_INPUT_SELECT = 7;
    public static final int REC_MIKE_BOOST = 8;
    private static final int CLOSED_HND = 0;
    private static final String LIB_NAME = "JIWMixer";
    private Object listenerLock = new Object();
    private ArrayList listenerVec = new ArrayList();
    private long mixerMgrHnd = JIWMixer.nativeCreateMixerManager();
    private Thread monitorThread = null;
    private int playbackMixerIdx = -1;
    private int recordingMixerIdx = -1;
    private boolean stopMonitoring = false;
    private String wavePlaybackDevName = null;
    private String waveRecordingDevName = null;

    private static native void nativeClosePlaybackMixer(long var0);

    private static native void nativeCloseRecordingMixer(long var0);

    private static native long nativeCreateMixerManager();

    private static native void nativeDestroyMixerManager(long var0);

    private static native String[] nativeEnumerateWaveInSourceLines(String var0);

    private static native int nativeGetControlValue(long var0, int var2);

    private static native int nativeGetMixerCount();

    private static native String nativeGetSelectedRecordingLineName(long var0);

    private static native String nativeGetVersion();

    private static native boolean nativeOpenPlaybackMixer(long var0, String var2);

    private static native boolean nativeOpenRecordingMixer(long var0, String var2, String var3);

    private static native boolean nativeSetControlValue(long var0, int var2, int var3);

    private native void nativeMonitorControls(long var1);

    public static int getMixerCount() {
        return JIWMixer.nativeGetMixerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        if (Platform.getVersion() > 5) {
            return;
        }
        if (this.mixerMgrHnd == 0L) {
            throw new IllegalStateException("Mixer not open");
        }
        Debug.lockEnter((Object)this, (String)"addChangeListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.listenerVec.contains(listener)) {
                ArrayList newList = (ArrayList)this.listenerVec.clone();
                newList.add(listener);
                this.listenerVec = newList;
                if (this.listenerVec.size() == 1) {
                    this.monitorThread = new WorkerThread((Runnable)this, "JIWMixerMonitor");
                    this.monitorThread.setDaemon(true);
                    this.monitorThread.start();
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"addChangeListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    public void closePlaybackMixer() {
        JIWMixer.nativeClosePlaybackMixer(this.mixerMgrHnd);
    }

    public void closeRecordingMixer() {
        JIWMixer.nativeCloseRecordingMixer(this.mixerMgrHnd);
    }

    protected void controlChanged(int ctrlIdx) {
        final ChangeEvent event = new ChangeEvent(this, ctrlIdx);
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ChangeListener cl : JIWMixer.this.listenerVec) {
                    try {
                        cl.stateChanged(event);
                    }
                    catch (Exception ex) {
                        LogSupport.exception((Object)this, (String)"controlChanged", (Throwable)ex, (boolean)true);
                    }
                }
            }
        });
    }

    public void createMixerManager() {
        if (this.mixerMgrHnd != 0L) {
            throw new IllegalStateException("Mixer manager already exists");
        }
        this.mixerMgrHnd = JIWMixer.nativeCreateMixerManager();
    }

    public static String[] enumerateWaveInSourceLines(String devName) {
        return JIWMixer.nativeEnumerateWaveInSourceLines(devName);
    }

    public int getControlValue(int controlIdx) {
        return JIWMixer.nativeGetControlValue(this.mixerMgrHnd, controlIdx);
    }

    public String getSelectedRecordingLineName() {
        return JIWMixer.nativeGetSelectedRecordingLineName(this.mixerMgrHnd);
    }

    public boolean openPlaybackMixer(String deviceName) {
        return JIWMixer.nativeOpenPlaybackMixer(this.mixerMgrHnd, deviceName);
    }

    public boolean openRecordingMixer(String deviceName, String sourceName) {
        return JIWMixer.nativeOpenRecordingMixer(this.mixerMgrHnd, deviceName, sourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        if (this.mixerMgrHnd == 0L) {
            throw new IllegalStateException("Mixer not open");
        }
        Debug.lockEnter((Object)this, (String)"removeChangeListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listenerVec.contains(listener)) {
                ArrayList newList = (ArrayList)this.listenerVec.clone();
                newList.remove(listener);
                this.listenerVec = newList;
                if (this.listenerVec.size() == 0) {
                    this.stopMonitoring = true;
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"removeChangeListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    @Override
    public void run() {
        this.stopMonitoring = false;
        this.nativeMonitorControls(this.mixerMgrHnd);
    }

    public void setControlValue(int controlIdx, int newValue) {
        JIWMixer.nativeSetControlValue(this.mixerMgrHnd, controlIdx, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.mixerMgrHnd != 0L) {
            this.closePlaybackMixer();
            this.closeRecordingMixer();
            Debug.lockEnter((Object)this, (String)"terminate", (String)"listenerLock", (Object)this.listenerLock);
            Object object = this.listenerLock;
            synchronized (object) {
                ArrayList newList;
                this.listenerVec = newList = new ArrayList();
                while (this.monitorThread != null && this.monitorThread.isAlive()) {
                    this.stopMonitoring = true;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                this.monitorThread = null;
            }
            Debug.lockLeave((Object)this, (String)"terminate", (String)"listenerLock", (Object)this.listenerLock);
            JIWMixer.nativeDestroyMixerManager(this.mixerMgrHnd);
            this.mixerMgrHnd = 0L;
        }
    }

    static {
        System.loadLibrary(LIB_NAME);
        LogSupport.message((String)("Loaded native library JIWMixer, version " + JIWMixer.nativeGetVersion()));
    }

    public static class ChangeEvent
    extends EventObject {
        public final int CONTROL_IDX;

        public ChangeEvent(JIWMixer mixer, int controlIdx) {
            super(mixer);
            this.CONTROL_IDX = controlIdx;
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }
}

