/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.macosx;

import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.Collection;

public class CoreAudioDevice {
    public static final int DEV_TYPE_UNKNOWN = 0;
    public static final int DEV_TYPE_BUILTIN = 1;
    public static final int DEV_TYPE_PCI = 2;
    public static final int DEV_TYPE_USB = 3;
    public static final int DEV_TYPE_FIREWIRE = 4;
    public static final int DEV_TYPE_WIRELESS = 5;
    public static final int DEV_TYPE_LAST = 5;
    private int devID;
    private String devUID;
    private int devType;
    private float devRate;
    private String desc;
    private static final String[] DEV_TYPE_NAME;

    CoreAudioDevice(int id, String uid, int type, float rate, String info) {
        this.devID = id;
        this.devUID = uid;
        if (type < 0 || type >= 5) {
            type = 0;
        }
        this.devType = type;
        this.devRate = rate;
        this.desc = info;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof CoreAudioDevice) {
            return this.devID == ((CoreAudioDevice)obj).devID;
        }
        return false;
    }

    public int hashCode() {
        return this.devID;
    }

    public String toString() {
        return this.desc;
    }

    public String getPersistentUID() {
        return this.devUID;
    }

    public int getDeviceType() {
        return this.devType;
    }

    float getNominalRate() {
        return this.devRate;
    }

    public int getDeviceID() {
        return this.devID;
    }

    boolean isCurrentlyValid(boolean forInput) {
        return CoreAudioDevice.isDeviceValidNative(this.devID, forInput);
    }

    public static CoreAudioDevice[] enumerateInputDevices() {
        ArrayList list = new ArrayList();
        int nDevices = CoreAudioDevice.enumerateInputDevicesNative(list);
        if (nDevices < 0) {
            LogSupport.message(CoreAudioDevice.class, (String)"enumerateInputDevices", (String)("enumerate return count is " + nDevices));
            return new CoreAudioDevice[0];
        }
        if (AudioDebug.GENERAL.show()) {
            LogSupport.message(CoreAudioDevice.class, (String)"enumerateInputDevices", (String)list.toString());
        }
        return list.toArray(new CoreAudioDevice[nDevices]);
    }

    public static CoreAudioDevice getDefaultInputDevice() {
        int dftID = CoreAudioDevice.getDefaultInputDeviceNative();
        ArrayList list = new ArrayList();
        int nDevices = CoreAudioDevice.enumerateInputDevicesNative(list);
        if (nDevices < 0) {
            LogSupport.message(CoreAudioDevice.class, (String)"getDefaultInputDevice", (String)("enumerate return count is " + nDevices));
            return null;
        }
        for (CoreAudioDevice dev : list) {
            if (dev.getDeviceID() != dftID) continue;
            return dev;
        }
        return null;
    }

    public static CoreAudioDevice getPersistentInputDevice(String persistentUID) {
        if (persistentUID == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        int nDevices = CoreAudioDevice.enumerateInputDevicesNative(list);
        if (nDevices < 0) {
            LogSupport.message(CoreAudioDevice.class, (String)"getPersistentInputDevice", (String)("enumerate return count is " + nDevices));
            return null;
        }
        for (CoreAudioDevice dev : list) {
            if (AudioDebug.GENERAL.show()) {
                LogSupport.message(CoreAudioDevice.class, (String)"", (String)("Checking " + dev + " vs. " + persistentUID));
            }
            if (!persistentUID.equals(dev.getPersistentUID())) continue;
            return dev;
        }
        return null;
    }

    static int getDefaultInputDeviceID() {
        return CoreAudioDevice.getDefaultInputDeviceNative();
    }

    static String getDeviceTypeName(int type) {
        if (type >= 0 && type < DEV_TYPE_NAME.length) {
            return DEV_TYPE_NAME[type];
        }
        return DEV_TYPE_NAME[0];
    }

    private static void addDevice(Collection list, int id, String uid, int type, float rate, String info) {
        CoreAudioDevice dev = new CoreAudioDevice(id, uid, type, rate, info.trim());
        list.add(dev);
    }

    private static native int enumerateInputDevicesNative(Collection var0);

    private static native int getDefaultInputDeviceNative();

    private static native boolean isDeviceValidNative(int var0, boolean var1);

    public static void main(String[] args) {
        int dftDev = CoreAudioDevice.getDefaultInputDeviceID();
        CoreAudioDevice[] devList = CoreAudioDevice.enumerateInputDevices();
        System.err.println(devList.length + " devices found, default=" + Integer.toHexString(dftDev) + ":");
        for (int ix = 0; ix < devList.length; ++ix) {
            System.err.println((devList[ix].devID == dftDev ? (char)'*' : ' ') + Integer.toHexString(devList[ix].devID) + "\t" + devList[ix].devUID + "\t" + devList[ix].devRate + "\t" + CoreAudioDevice.getDeviceTypeName(devList[ix].getDeviceType()) + "\t" + devList[ix]);
        }
    }

    static {
        System.loadLibrary("vcCoreAudio");
        DEV_TYPE_NAME = new String[]{"Unknown", "Builtin", "PCI", "USB", "FireWire", "BlueTooth"};
    }
}

