/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.javasound;

import com.elluminate.groupware.audio.module.AudioSupport;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.javasound.StringsProperties;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.swing.CTree;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JavaSoundAudioSupport
implements AudioSupport {
    private static final String DEFAULT = "";
    private static final String DESC_COMP_PREFIX = "[";
    private static final String DESC_COMP_SUFFIX = "]";
    private static final float LOG_MAX_SCALE_FACTOR = (float)Math.log(20.0);
    private static final float LOG_MIN_SCALE_FACTOR = (float)Math.log(0.05);
    private static final float MIKE_BUFFER_SECS = 4.0f;
    private static final float SOLARIS_MIKE_BUFFER_SECS = 0.1f;
    private static final float SPKR_BUFFER_SECS = 4.0f;
    private static final boolean[] STD_AUDIO_BYTE_ORDER = new boolean[]{false, true};
    private static final int[] STD_AUDIO_CHNLS = new int[]{1, 2};
    private static final float[] STD_AUDIO_RATES = new float[]{8000.0f, 11025.0f, 16000.0f, 22050.0f, 32000.0f, 44100.0f, 48000.0f};
    private I18n i18n = I18n.create((Object)this);
    private String inputDeviceName = "";
    private TargetDataLine mike = null;
    private Object mikeLock = new Object();
    private AudioFormat mikeFmt = null;
    private int mikeGain = 50;
    private String outputDeviceName = "";
    private boolean simulateMikeGainControl = false;
    private boolean simulateSpkrVolControl = false;
    private float simulatedMikeGainScaleFactor = 1.0f;
    private float simulatedSpkrVolScaleFactor = 1.0f;
    private SourceDataLine spkr = null;
    private AudioFormat spkrFmt = null;
    private Object spkrLock = new Object();
    private int spkrVolume = 50;

    @Override
    public int getLatentInputSamplesCount() {
        return -1;
    }

    @Override
    public int getLatentOutputSamplesCount() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeMike() {
        Debug.lockEnter((Object)this, (String)"closeMike", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            if (this.mike != null) {
                this.mike.stop();
                this.mike.flush();
                this.mike.close();
                this.mike = null;
            }
        }
        Debug.lockLeave((Object)this, (String)"closeMike", (String)"mikeLock", (Object)this.mikeLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSpkr() {
        Debug.lockEnter((Object)this, (String)"closeSpkr", (String)"spkrLock", (Object)this.spkrLock);
        Object object = this.spkrLock;
        synchronized (object) {
            if (this.spkr != null) {
                this.spkr.drain();
                this.spkr.stop();
                this.spkr.close();
                this.spkr = null;
                this.spkrFmt = null;
            }
        }
        Debug.lockLeave((Object)this, (String)"closeSpkr", (String)"spkrLock", (Object)this.spkrLock);
    }

    private JPanel createTextPanel(StringsProperties textI18nTag) {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new FlowLayout(1, 0, 0));
        innerPanel.add((Component)this.getLabel(textI18nTag));
        return innerPanel;
    }

    private MultilineLabel getLabel(StringsProperties textI18nTag) {
        MultilineLabel label = new MultilineLabel(this.i18n.getString((PropertiesEnum)textI18nTag));
        if (Platform.usingScreenReader() == 1 || Platform.usingScreenReader() == -1) {
            label.setFocusable(true);
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushMike() {
        Debug.lockEnter((Object)this, (String)"flushMike", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            if (this.mike != null) {
                this.mike.flush();
            }
        }
        Debug.lockLeave((Object)this, (String)"flushMike", (String)"mikeLock", (Object)this.mikeLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushSpkr() {
        Debug.lockEnter((Object)this, (String)"flushSpkr", (String)"spkrLock", (Object)this.spkrLock);
        Object object = this.spkrLock;
        synchronized (object) {
            if (this.spkr != null) {
                this.spkr.flush();
            }
        }
        Debug.lockLeave((Object)this, (String)"flushSpkr", (String)"spkrLock", (Object)this.spkrLock);
    }

    private DeviceSelectionPanel getDeviceSelectionPanel(JButton okBtn, final char deviceType, ActionListener selectionAL) {
        DeviceSelectionPanel panel = new DeviceSelectionPanel(okBtn, selectionAL){
            private DefaultTreeModel treeModel;
            private CTree treeViewer;
            private ActionListener inputRefreshBtnAL;
            private boolean supressDuringRefresh;
            {
                super(x0, x1);
                this.supressDuringRefresh = true;
            }

            @Override
            public void apply() {
                String deviceDisplayName;
                TreePath selectionPath = this.treeViewer.getSelectionPath();
                if (selectionPath == null) {
                    return;
                }
                int componentCnt = selectionPath.getPathCount();
                DefaultMutableTreeNode component1 = componentCnt <= 1 ? null : (DefaultMutableTreeNode)selectionPath.getPathComponent(1);
                String string = deviceDisplayName = component1 == null ? JavaSoundAudioSupport.DEFAULT : component1.toString();
                if (deviceType == 'I') {
                    JavaSoundAudioSupport.this.inputDeviceName = deviceDisplayName;
                } else {
                    JavaSoundAudioSupport.this.outputDeviceName = deviceDisplayName;
                }
            }

            @Override
            public void setup(final JButton okBtn, final ActionListener selectionAL) {
                if (deviceType != 'I' && deviceType != 'O') {
                    throw new IllegalArgumentException("deviceType invalid: " + deviceType);
                }
                final DefaultMutableTreeNode treeData = new DefaultMutableTreeNode(deviceType == 'I' ? "Audio Input Devices" : "Audio Output Devices");
                TreePath currentPath = JavaSoundAudioSupport.this.populateDeviceDataTree(treeData, deviceType);
                this.treeModel = new DefaultTreeModel(treeData);
                this.treeViewer = new CTree((TreeModel)this.treeModel);
                this.treeViewer.setRootVisible(false);
                this.treeViewer.setVisibleRowCount(15);
                this.treeViewer.setShowsRootHandles(true);
                this.treeViewer.getSelectionModel().setSelectionMode(1);
                this.treeViewer.setExpandsSelectedPaths(true);
                this.treeViewer.expandAll();
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setLeafIcon(null);
                renderer.setClosedIcon(null);
                renderer.setOpenIcon(null);
                this.treeViewer.setCellRenderer((TreeCellRenderer)renderer);
                if (currentPath != null) {
                    this.treeViewer.getSelectionModel().setSelectionPath(currentPath);
                    okBtn.setEnabled(true);
                } else {
                    okBtn.setEnabled(false);
                }
                this.treeViewer.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent me) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeViewer.getLastSelectedPathComponent();
                        if (node == null) {
                            return;
                        }
                        if (me.getClickCount() == 2 && node.isLeaf()) {
                            okBtn.setEnabled(true);
                            okBtn.doClick();
                        }
                    }
                });
                this.treeViewer.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeViewer.getLastSelectedPathComponent();
                        if (node == null) {
                            return;
                        }
                        okBtn.setEnabled(node.isLeaf());
                        if (!supressDuringRefresh) {
                            selectionAL.actionPerformed(null);
                        }
                    }
                });
                JScrollPane scrollPane = new JScrollPane((Component)this.treeViewer, 20, 30);
                JButton refreshBtn = new JButton(JavaSoundAudioSupport.this.i18n.getString((PropertiesEnum)StringsProperties.JSA_REFRESH_BTN_NAME));
                this.inputRefreshBtnAL = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        supressDuringRefresh = true;
                        TreePath currentPath = JavaSoundAudioSupport.this.populateDeviceDataTree(treeData, deviceType);
                        treeModel.nodeStructureChanged(treeData);
                        treeViewer.expandAll();
                        okBtn.setEnabled(false);
                        selectionAL.actionPerformed(null);
                        if (currentPath != null) {
                            treeViewer.getSelectionModel().setSelectionPath(currentPath);
                            okBtn.setEnabled(true);
                        } else {
                            okBtn.setEnabled(false);
                        }
                        treeViewer.requestFocus();
                        supressDuringRefresh = false;
                    }
                };
                refreshBtn.addActionListener(this.inputRefreshBtnAL);
                this.selectionPanel.setLayout(new GridBagLayout());
                this.selectionPanel.add((Component)JavaSoundAudioSupport.this.createTextPanel(deviceType == 'I' ? StringsProperties.JSA_INPUT_SELECTION_TEXT : StringsProperties.JSA_OUTPUT_SELECTION_TEXT), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.selectionPanel.add((Component)refreshBtn, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 0, new Insets(4, 0, 4, 0), 0, 0));
                this.selectionPanel.add((Component)scrollPane, new GridBagConstraints(0, 2, 3, 1, 0.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.selectionPanel.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        treeViewer.requestFocus();
                    }
                });
                this.selectionPanel.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent he) {
                        long flags = he.getChangeFlags();
                        if ((flags & 4L) != 0L && selectionPanel.isShowing()) {
                            inputRefreshBtnAL.actionPerformed(null);
                        }
                    }
                });
            }
        };
        return panel;
    }

    @Override
    public String getInputDevice() {
        String deviceDesc = this.inputDeviceName == null || this.inputDeviceName.equals(DEFAULT) ? null : DESC_COMP_PREFIX + this.inputDeviceName + DESC_COMP_SUFFIX;
        return deviceDesc;
    }

    @Override
    public String[] getInputDeviceList() {
        String[] deviceDesc = new String[]{DEFAULT};
        if (this.inputDeviceName != null && !this.inputDeviceName.equals(DEFAULT)) {
            deviceDesc[0] = DESC_COMP_PREFIX + this.inputDeviceName + DESC_COMP_SUFFIX;
        }
        return deviceDesc;
    }

    @Override
    public String getInputDeviceDisplayName(String deviceHnd) {
        return this.inputDeviceName;
    }

    @Override
    public DeviceSelectionPanel getInputDeviceSelectionPanel(JButton okBtn, ActionListener selectionAL) {
        return this.getDeviceSelectionPanel(okBtn, 'I', selectionAL);
    }

    @Override
    public int getMikeBoost() {
        return -1;
    }

    @Override
    public int getMikeGain() {
        if (this.mike != null) {
            try {
                FloatControl ctrl = (FloatControl)this.mike.getControl(FloatControl.Type.MASTER_GAIN);
                this.mikeGain = (int)((double)(100.0f * (ctrl.getValue() - ctrl.getMinimum()) / (ctrl.getMaximum() - ctrl.getMinimum())) + 0.5);
                this.simulatedMikeGainScaleFactor = (float)Math.exp((float)this.mikeGain * (LOG_MAX_SCALE_FACTOR - LOG_MIN_SCALE_FACTOR) / 100.0f + LOG_MIN_SCALE_FACTOR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.mikeGain;
    }

    private String getMixerDisplayName(Mixer.Info mixerInfo) {
        String mixerName = mixerInfo.getName();
        String mixerDesc = mixerInfo.getDescription();
        String mixerDisplayName = mixerDesc == null ? mixerName : (mixerName == null ? mixerDesc : mixerName + " (" + mixerDesc + ")");
        return mixerDisplayName;
    }

    private Mixer.Info getMixerInfo(String displayName, char lineType) {
        if (lineType != 'S' && lineType != 'T') {
            throw new IllegalArgumentException("Invalid lineType: " + lineType);
        }
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfos.length; ++i) {
            if (mixerInfos[i].getName() == null && mixerInfos[i].getDescription() == null || !displayName.equals(DEFAULT) && !displayName.equals(this.getMixerDisplayName(mixerInfos[i]))) continue;
            Mixer mixer = AudioSystem.getMixer(mixerInfos[i]);
            Line.Info[] lineInfos = lineType == 'S' ? mixer.getSourceLineInfo() : mixer.getTargetLineInfo();
            for (int j = 0; j < lineInfos.length; ++j) {
                if (!(lineInfos[j] instanceof DataLine.Info)) continue;
                return mixerInfos[i];
            }
        }
        return null;
    }

    @Override
    public String getOutputDevice() {
        String deviceDesc = this.outputDeviceName == null || this.outputDeviceName.trim().equals(DEFAULT) ? null : DESC_COMP_PREFIX + this.outputDeviceName + DESC_COMP_SUFFIX;
        return deviceDesc;
    }

    @Override
    public String[] getOutputDeviceList() {
        String[] deviceDesc = new String[]{DEFAULT};
        if (this.outputDeviceName != null && !this.outputDeviceName.trim().equals(DEFAULT)) {
            deviceDesc[0] = DESC_COMP_PREFIX + this.outputDeviceName + DESC_COMP_SUFFIX;
        }
        return deviceDesc;
    }

    @Override
    public String getOutputDeviceDisplayName(String deviceHnd) {
        return this.outputDeviceName;
    }

    @Override
    public DeviceSelectionPanel getOutputDeviceSelectionPanel(JButton okBtn, ActionListener selectionAL) {
        return this.getDeviceSelectionPanel(okBtn, 'O', selectionAL);
    }

    @Override
    public int getSpkrVolume() {
        if (this.spkr != null) {
            try {
                FloatControl ctrl = (FloatControl)this.spkr.getControl(FloatControl.Type.MASTER_GAIN);
                this.spkrVolume = (int)((double)(100.0f * (ctrl.getValue() - ctrl.getMinimum()) / (ctrl.getMaximum() - ctrl.getMinimum())) + 0.5);
                this.simulatedSpkrVolScaleFactor = (float)Math.exp((float)this.spkrVolume * (LOG_MAX_SCALE_FACTOR - LOG_MIN_SCALE_FACTOR) / 100.0f + LOG_MIN_SCALE_FACTOR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.spkrVolume;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isInputDeviceSelectionSupported() {
        return true;
    }

    @Override
    public boolean isOutputDeviceSelectionSupported() {
        return true;
    }

    private DataLine openDataLine(char lineType, Mixer.Info mixerInfo, int desiredRate, float bufferSecs) {
        int c;
        int r;
        int BitsPerSamp = 16;
        boolean SampsSigned = true;
        if (lineType != 'S' && lineType != 'T') {
            throw new IllegalArgumentException("Invalid lineType: " + lineType);
        }
        if (mixerInfo == null) {
            throw new IllegalArgumentException("null mixerInfo");
        }
        for (int c2 = 0; c2 < STD_AUDIO_CHNLS.length; ++c2) {
            for (int b = 0; b < STD_AUDIO_BYTE_ORDER.length; ++b) {
                AudioFormat fmt = new AudioFormat(desiredRate, 16, STD_AUDIO_CHNLS[c2], true, STD_AUDIO_BYTE_ORDER[b]);
                int bufferSize = (int)(bufferSecs * (float)desiredRate * (float)fmt.getFrameSize() + 0.5f);
                try {
                    if (lineType == 'S') {
                        SourceDataLine sourceDataLine = AudioSystem.getSourceDataLine(fmt, mixerInfo);
                        sourceDataLine.open(fmt, bufferSize);
                        return sourceDataLine;
                    }
                    TargetDataLine targetDataLine = AudioSystem.getTargetDataLine(fmt, mixerInfo);
                    targetDataLine.open(fmt, bufferSize);
                    return targetDataLine;
                }
                catch (Throwable t) {
                    continue;
                }
            }
        }
        for (r = 0; r < STD_AUDIO_RATES.length; ++r) {
            if (STD_AUDIO_RATES[r] <= (float)desiredRate) continue;
            for (c = 0; c < STD_AUDIO_CHNLS.length; ++c) {
                for (int b = 0; b < STD_AUDIO_BYTE_ORDER.length; ++b) {
                    AudioFormat fmt = new AudioFormat(STD_AUDIO_RATES[r], 16, STD_AUDIO_CHNLS[c], true, STD_AUDIO_BYTE_ORDER[b]);
                    int bufferSize = (int)(bufferSecs * (float)desiredRate * (float)fmt.getFrameSize() + 0.5f);
                    try {
                        if (lineType == 'S') {
                            SourceDataLine sourceDataLine = AudioSystem.getSourceDataLine(fmt, mixerInfo);
                            sourceDataLine.open(fmt, bufferSize);
                            return sourceDataLine;
                        }
                        TargetDataLine targetDataLine = AudioSystem.getTargetDataLine(fmt, mixerInfo);
                        targetDataLine.open(fmt, bufferSize);
                        return targetDataLine;
                    }
                    catch (Throwable t) {
                        continue;
                    }
                }
            }
        }
        for (r = STD_AUDIO_RATES.length - 1; r >= 0; --r) {
            if (STD_AUDIO_RATES[r] >= (float)desiredRate) continue;
            for (c = 0; c < STD_AUDIO_CHNLS.length; ++c) {
                for (int b = 0; b < STD_AUDIO_BYTE_ORDER.length; ++b) {
                    AudioFormat fmt = new AudioFormat(STD_AUDIO_RATES[r], 16, STD_AUDIO_CHNLS[c], true, STD_AUDIO_BYTE_ORDER[b]);
                    int bufferSize = (int)(bufferSecs * (float)desiredRate * (float)fmt.getFrameSize() + 0.5f);
                    try {
                        if (lineType == 'S') {
                            SourceDataLine sourceDataLine = AudioSystem.getSourceDataLine(fmt, mixerInfo);
                            sourceDataLine.open(fmt, bufferSize);
                            return sourceDataLine;
                        }
                        TargetDataLine targetDataLine = AudioSystem.getTargetDataLine(fmt, mixerInfo);
                        targetDataLine.open(fmt, bufferSize);
                        return targetDataLine;
                    }
                    catch (Throwable t) {
                        continue;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Cannot find suitable data line");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int openMike(int desiredRate) {
        int actualRate;
        Debug.lockEnter((Object)this, (String)"openMike", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            float bufferSecs = Platform.getOS() == 250 ? 0.1f : 4.0f;
            Mixer.Info mixerInfo = null;
            if (!this.inputDeviceName.equals(DEFAULT)) {
                mixerInfo = this.getMixerInfo(this.inputDeviceName, 'T');
            }
            if (mixerInfo == null) {
                mixerInfo = this.getMixerInfo(DEFAULT, 'T');
            }
            if (mixerInfo == null) {
                throw new RuntimeException("Cannot find a suitable mixer");
            }
            try {
                this.mike = (TargetDataLine)this.openDataLine('T', mixerInfo, desiredRate, bufferSecs);
                this.mike.start();
                this.setMikeGain(this.mikeGain);
            }
            catch (Throwable t) {
                throw new RuntimeException(this.i18n.getString((PropertiesEnum)StringsProperties.JSA_CANT_OPEN_MIC, new Object[]{t.toString()}));
            }
            this.mikeFmt = this.mike.getFormat();
            actualRate = (int)this.mikeFmt.getSampleRate();
            this.inputDeviceName = this.getMixerDisplayName(mixerInfo);
        }
        Debug.lockLeave((Object)this, (String)"openMike", (String)"mikeLock", (Object)this.mikeLock);
        return actualRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int openSpkr(int desiredRate) {
        int actualRate;
        Debug.lockEnter((Object)this, (String)"openSpkr", (String)"spkrLock", (Object)this.spkrLock);
        Object object = this.spkrLock;
        synchronized (object) {
            Mixer.Info mixerInfo = null;
            if (!this.outputDeviceName.equals(DEFAULT)) {
                mixerInfo = this.getMixerInfo(this.outputDeviceName, 'S');
            }
            if (mixerInfo == null) {
                mixerInfo = this.getMixerInfo(DEFAULT, 'S');
            }
            if (mixerInfo == null) {
                throw new RuntimeException("Cannot find a suitable mixer");
            }
            try {
                this.spkr = (SourceDataLine)this.openDataLine('S', mixerInfo, desiredRate, 4.0f);
                this.spkr.start();
                this.setSpkrVolume(this.spkrVolume);
            }
            catch (Throwable t) {
                throw new RuntimeException(this.i18n.getString((PropertiesEnum)StringsProperties.JSA_CANT_OPEN_SPKR, new Object[]{t.toString()}));
            }
            this.spkrFmt = this.spkr.getFormat();
            actualRate = (int)this.spkrFmt.getSampleRate();
            this.outputDeviceName = this.getMixerDisplayName(mixerInfo);
        }
        Debug.lockLeave((Object)this, (String)"openSpkr", (String)"spkrLock", (Object)this.spkrLock);
        return actualRate;
    }

    private TreePath populateDeviceDataTree(DefaultMutableTreeNode treeData, char deviceType) {
        int i;
        TreePath currentPath = null;
        if (deviceType != 'I' && deviceType != 'O') {
            throw new IllegalArgumentException("deviceType invalid: " + deviceType);
        }
        treeData.removeAllChildren();
        ArrayList<Mixer.Info> suitableMixerInfos = new ArrayList<Mixer.Info>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        block0: for (i = 0; i < mixerInfos.length; ++i) {
            if (mixerInfos[i].getName() == null && mixerInfos[i].getDescription() == null) continue;
            Mixer mixer = AudioSystem.getMixer(mixerInfos[i]);
            Line.Info[] lineInfos = deviceType == 'I' ? mixer.getTargetLineInfo() : mixer.getSourceLineInfo();
            for (int j = 0; j < lineInfos.length; ++j) {
                if (!(lineInfos[j] instanceof DataLine.Info)) continue;
                suitableMixerInfos.add(mixerInfos[i]);
                continue block0;
            }
        }
        for (i = 0; i < suitableMixerInfos.size(); ++i) {
            boolean isCurrentDevice;
            Mixer.Info mixerInfo = (Mixer.Info)suitableMixerInfos.get(i);
            String mixerDisplayName = this.getMixerDisplayName(mixerInfo);
            DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(mixerDisplayName);
            treeData.add(deviceNode);
            if (deviceType == 'I') {
                isCurrentDevice = this.inputDeviceName != null && this.inputDeviceName.equals(mixerDisplayName);
            } else {
                boolean bl = isCurrentDevice = this.outputDeviceName != null && this.outputDeviceName.equals(mixerDisplayName);
            }
            if (!isCurrentDevice) continue;
            currentPath = new TreePath(deviceNode.getPath());
        }
        return currentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMike(short[] samples, int offset, int length) {
        Debug.lockEnter((Object)this, (String)"readMike", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            if (this.mike == null) {
                return;
            }
            if (samples == null || offset < 0 || offset + length > samples.length) {
                throw new IllegalArgumentException();
            }
            byte[] buffer = new byte[length * this.mikeFmt.getFrameSize()];
            try {
                for (int readCnt = 0; readCnt < buffer.length && this.mike.available() > 0; readCnt += this.mike.read(buffer, readCnt, buffer.length - readCnt)) {
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
            int channelCnt = this.mikeFmt.getChannels();
            int i = 0;
            boolean isBigEndian = this.mikeFmt.isBigEndian();
            for (int o = offset; o < offset + length; ++o) {
                float value = 0.0f;
                for (int c = 0; c < channelCnt; ++c) {
                    if (isBigEndian) {
                        value += (float)(buffer[i + 1] & 0xFF | buffer[i] << 8);
                        i += 2;
                        continue;
                    }
                    value += (float)(buffer[i] & 0xFF | buffer[i + 1] << 8);
                    i += 2;
                }
                if (channelCnt > 1) {
                    value /= (float)channelCnt;
                }
                if (this.simulateMikeGainControl) {
                    value *= this.simulatedMikeGainScaleFactor;
                }
                samples[o] = value < -32768.0f ? Short.MIN_VALUE : (value > 32767.0f ? Short.MAX_VALUE : (short)value);
            }
        }
        Debug.lockLeave((Object)this, (String)"readMike", (String)"mikeLock", (Object)this.mikeLock);
    }

    @Override
    public void setInputDevice(String deviceDesc) {
        if (deviceDesc == null || deviceDesc.trim().equals(DEFAULT)) {
            this.inputDeviceName = DEFAULT;
            return;
        }
        int prefixLen = DESC_COMP_PREFIX.length();
        String prefix = deviceDesc.substring(0, prefixLen);
        if (!prefix.equals(DESC_COMP_PREFIX)) {
            LogSupport.message((Object)this, (String)"setInputDevice", (String)("Invalid prefix in device descriptor: \"" + deviceDesc + "\""));
            return;
        }
        int suffixLen = DESC_COMP_SUFFIX.length();
        String suffix = deviceDesc.substring(deviceDesc.length() - suffixLen);
        if (!suffix.equals(DESC_COMP_SUFFIX)) {
            LogSupport.message((Object)this, (String)"setInputDevice", (String)("Invalid suffix in input device descriptor: \"" + deviceDesc + "\""));
            return;
        }
        this.inputDeviceName = deviceDesc.substring(prefixLen, deviceDesc.length() - suffixLen);
    }

    @Override
    public void setMikeBoost(int percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setMikeGain(int percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("percent invalid: " + percent);
        }
        this.mikeGain = percent;
        this.simulatedMikeGainScaleFactor = (float)Math.exp((float)percent * (LOG_MAX_SCALE_FACTOR - LOG_MIN_SCALE_FACTOR) / 100.0f + LOG_MIN_SCALE_FACTOR);
        if (this.mike != null) {
            try {
                FloatControl ctrl = (FloatControl)this.mike.getControl(FloatControl.Type.MASTER_GAIN);
                ctrl.setValue((float)percent * (ctrl.getMaximum() - ctrl.getMinimum()) / 100.0f + ctrl.getMinimum());
                this.simulateMikeGainControl = false;
            }
            catch (Throwable t) {
                this.simulateMikeGainControl = true;
            }
        }
    }

    @Override
    public void setOutputDevice(String deviceDesc) {
        if (deviceDesc == null || deviceDesc.trim().equals(DEFAULT)) {
            this.outputDeviceName = DEFAULT;
            return;
        }
        int prefixLen = DESC_COMP_PREFIX.length();
        String prefix = deviceDesc.substring(0, prefixLen);
        if (!prefix.equals(DESC_COMP_PREFIX)) {
            LogSupport.message((Object)this, (String)"setOutputDevice", (String)("Invalid prefix in device descriptor: \"" + deviceDesc + "\""));
            return;
        }
        int suffixLen = DESC_COMP_SUFFIX.length();
        String suffix = deviceDesc.substring(deviceDesc.length() - suffixLen);
        if (!suffix.equals(DESC_COMP_SUFFIX)) {
            LogSupport.message((Object)this, (String)"setOutputDevice", (String)("Invalid suffix in output device descriptor: \"" + deviceDesc + "\""));
            return;
        }
        this.outputDeviceName = deviceDesc.substring(prefixLen, deviceDesc.length() - suffixLen);
    }

    @Override
    public void setOwner(Component owner) {
    }

    @Override
    public void setSpkrVolume(int percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("percent invalid: " + percent);
        }
        this.spkrVolume = percent;
        this.simulatedSpkrVolScaleFactor = (float)Math.exp((float)percent * (LOG_MAX_SCALE_FACTOR - LOG_MIN_SCALE_FACTOR) / 100.0f + LOG_MIN_SCALE_FACTOR);
        if (this.spkr != null) {
            try {
                FloatControl ctrl = (FloatControl)this.spkr.getControl(FloatControl.Type.MASTER_GAIN);
                ctrl.setValue((float)percent * (ctrl.getMaximum() - ctrl.getMinimum()) / 100.0f + ctrl.getMinimum());
                this.simulateSpkrVolControl = false;
            }
            catch (Throwable t) {
                this.simulateSpkrVolControl = true;
            }
        }
    }

    @Override
    public boolean supportsFullDuplex() {
        return Platform.checkJavaVersion((String)"1.5+");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Debug.lockEnter((Object)this, (String)"terminate", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            if (this.mike != null) {
                this.closeMike();
            }
        }
        Debug.lockLeave((Object)this, (String)"terminate", (String)"mikeLock", (Object)this.mikeLock);
        Debug.lockEnter((Object)this, (String)"terminate", (String)"spkrLock", (Object)this.spkrLock);
        object = this.spkrLock;
        synchronized (object) {
            if (this.spkr != null) {
                this.closeSpkr();
            }
        }
        Debug.lockLeave((Object)this, (String)"terminate", (String)"spkrLock", (Object)this.spkrLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSpkr(short[] samples, int offset, int length) {
        Debug.lockEnter((Object)this, (String)"writeSpkr", (String)"spkrLock", (Object)this.spkrLock);
        Object object = this.spkrLock;
        synchronized (object) {
            if (this.spkr == null) {
                return;
            }
            byte[] buffer = new byte[length * this.spkrFmt.getFrameSize()];
            int channelCnt = this.spkrFmt.getChannels();
            boolean isBigEndian = this.spkrFmt.isBigEndian();
            int o = 0;
            if (samples == null || offset < 0 || offset + length > samples.length) {
                throw new IllegalArgumentException();
            }
            for (int i = offset; i < offset + length; ++i) {
                int sample = samples[i];
                if (this.simulateSpkrVolControl) {
                    float scaledSample = (float)sample * this.simulatedSpkrVolScaleFactor;
                    sample = scaledSample < -32768.0f ? Short.MIN_VALUE : (scaledSample > 32767.0f ? Short.MAX_VALUE : (int)((short)scaledSample));
                }
                for (int c = 0; c < channelCnt; ++c) {
                    if (isBigEndian) {
                        buffer[o++] = (byte)(sample >> 8 & 0xFF);
                        buffer[o++] = (byte)(sample & 0xFF);
                        continue;
                    }
                    buffer[o++] = (byte)(sample & 0xFF);
                    buffer[o++] = (byte)(sample >> 8 & 0xFF);
                }
            }
            this.spkr.write(buffer, 0, buffer.length);
        }
        Debug.lockLeave((Object)this, (String)"writeSpkr", (String)"spkrLock", (Object)this.spkrLock);
    }
}

