/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.platform.Platform;
import com.elluminate.util.SwingRunnerSupport;

public class VUFeature {
    NumericFeature<Integer> feature;
    long lastUpdateTime = 0L;
    static final long MIN_UPDATE_DELTA = 100L;

    VUFeature(NumericFeature<Integer> inFeature) {
        this.feature = inFeature;
    }

    public void setPeakAudioLevel(int newValue) {
        int VU;
        long now = Platform.currentTimeMillis();
        if (now - this.lastUpdateTime < 100L) {
            return;
        }
        if (newValue == 0) {
            newValue = 1;
        }
        if ((VU = (int)((Math.log10(newValue) / Math.log10(65536.0) - 0.5) * 2.0 * 32767.0)) < 0) {
            VU = 0;
        }
        this.setVU(VU);
    }

    private void setVU(final int VU) {
        long now = Platform.currentTimeMillis();
        if ((Integer)this.feature.getValue() == VU) {
            return;
        }
        this.lastUpdateTime = now;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VUFeature.this.feature != null && VUFeature.this.feature.isEnabled() && VUFeature.this.feature.isMutable()) {
                    VUFeature.this.feature.setValue((Object)VU);
                }
            }
        });
    }
}

