/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.groupware.audio.module.InputEvent;
import com.elluminate.groupware.audio.module.TransmitListener;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.QueuedProcessorAdapter;
import com.elluminate.util.log.LogSupport;
import java.util.TooManyListenersException;

public class TransmitQueue {
    private TransmitListener listener = null;
    private MTPriorityQueue queue = new MTPriorityQueue("Audio transmit queue", (QueuedProcessor)new QueuedProcessorAdapter(){

        public void process(Object object, Object context) {
            TransmitQueue.this.doProcess(object);
        }
    });

    public TransmitQueue() {
        this.queue.setThreadPriority(10);
    }

    public void abort() {
        this.queue.stop(true);
    }

    public void addTransmitListener(TransmitListener l) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException("Too many transmit queue listeners.");
        }
        this.listener = l;
    }

    private void doProcess(Object event) {
        try {
            InputEvent ie = (InputEvent)event;
            if (this.listener != null) {
                try {
                    this.listener.onTransmit(ie);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"doProcess", (Throwable)t, (boolean)true);
                }
            } else {
                LogSupport.error((Object)this, (String)"doProcess", (String)"No listener.");
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doProcess", (Throwable)t, (boolean)true);
        }
    }

    public void queueEvent(InputEvent event) {
        this.queue.process((Object)event);
    }

    public void removeTransmitListener(TransmitListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }
}

