/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.groupware.audio.module.ReceiveListener;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.Debug;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.QueuedProcessorAdapter;
import com.elluminate.util.log.LogSupport;
import java.util.Comparator;
import java.util.TooManyListenersException;
import java.util.TreeMap;

public class ReceiveQueue {
    private ReceiveListener listener = null;
    private MTPriorityQueue queue = null;
    private TreeMap streamCntMap = new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            int iv1 = (Integer)o1;
            int iv2 = (Integer)o2;
            return iv1 - iv2;
        }
    });

    public ReceiveQueue() {
        this.queue = new MTPriorityQueue("Audio receive queue", (QueuedProcessor)new QueuedProcessorAdapter(){

            public void process(Object object, Object context) {
                ReceiveQueue.this.doProcess(object);
            }
        });
        this.queue.setThreadPriority(10);
    }

    public void abort(boolean drain) {
        this.queue.stop(drain);
    }

    public void addReceiveListener(ReceiveListener l) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException("Too many receive queue listeners.");
        }
        this.listener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Object event) {
        try {
            ChannelDataEvent cde = (ChannelDataEvent)event;
            int cmd = cde.getCommand() & 0xFF;
            if (cmd >= 64) {
                Debug.lockEnter((Object)this, (String)"doProcess", (String)"streamCntMap", (Object)this.streamCntMap);
                TreeMap treeMap = this.streamCntMap;
                synchronized (treeMap) {
                    Integer key = new Integer(cmd - 64);
                    Integer value = (Integer)this.streamCntMap.get(key);
                    if (value == null) {
                        LogSupport.error((Object)this, (String)"doProcess", (String)("Unknown stream: " + key));
                    } else {
                        byte[] ecelpData = cde.getContents();
                        int count = value - ecelpData.length;
                        if (count > 0) {
                            this.streamCntMap.put(key, new Integer(count));
                        } else {
                            this.streamCntMap.remove(key);
                        }
                    }
                }
                Debug.lockLeave((Object)this, (String)"doProcess", (String)"streamCntMap", (Object)this.streamCntMap);
            }
            if (this.listener == null) {
                LogSupport.error((Object)this, (String)"doProcess", (String)"No listener.");
            } else {
                try {
                    this.listener.onReceive(cde);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"doProcess", (Throwable)t, (boolean)true);
                }
            }
            cde.dispose();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doProcess", (Throwable)t, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLongestStreamSize() {
        int longestStreamCnt = 0;
        Debug.lockEnter((Object)this, (String)"queueEvent", (String)"streamCntMap", (Object)this.streamCntMap);
        TreeMap treeMap = this.streamCntMap;
        synchronized (treeMap) {
            for (Integer value : this.streamCntMap.values()) {
                int count = value;
                if (longestStreamCnt >= count) continue;
                longestStreamCnt = count;
            }
        }
        Debug.lockLeave((Object)this, (String)"queueEvent", (String)"streamCntMap", (Object)this.streamCntMap);
        return longestStreamCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(ChannelDataEvent cde) {
        int cmd = cde.getCommand() & 0xFF;
        if (cmd >= 64) {
            Debug.lockEnter((Object)this, (String)"queueEvent", (String)"streamCntMap", (Object)this.streamCntMap);
            TreeMap treeMap = this.streamCntMap;
            synchronized (treeMap) {
                Integer key = new Integer(cmd - 64);
                Integer value = (Integer)this.streamCntMap.get(key);
                if (value == null) {
                    this.streamCntMap.put(key, new Integer(1));
                } else {
                    byte[] ecelpData = cde.getContents();
                    int count = value + ecelpData.length;
                    this.streamCntMap.put(key, new Integer(count));
                }
            }
            Debug.lockLeave((Object)this, (String)"queueEvent", (String)"streamCntMap", (Object)this.streamCntMap);
        }
        this.queue.process(cde.clone());
    }

    public void removeReceiveListener(ReceiveListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }
}

