/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.classroom.client.AudioVideoPrefsOwner;
import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.groupware.audio.module.AudioBean;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.module.AudioModule;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.InvalidPreferenceSettingException;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

@Singleton
public class MicrophoneSettingsPrefsPanel
extends AbstractPreferencesPanel {
    static final int MOD_KEYS_MASK = 15;
    private I18n i18n;
    private AudioModule module;
    private JPanel webrtcPanel;
    private JPanel legacyPanel;
    private JCheckBox gainControlBox;
    private JCheckBox peakLimiterBox;
    private JRadioButton narrowRangeButton;
    private JRadioButton wideRangeButton;
    private JCheckBox transmitSilenceBox;
    private JCheckBox boostBox;
    private JComboBox sampleRatePopup;
    private JCheckBox webrtcEchoCancellation;
    private JCheckBox webrtcGainControlBox;
    private AudioEngine engine;
    private DeviceSelectionPanel selectionPanel = null;
    private boolean inputDeviceSelected = false;
    private JButton inputOkButton;
    private boolean inputSelectionSupported = false;

    @Inject
    public MicrophoneSettingsPrefsPanel(AudioVideoPrefsOwner owner, I18n i18n, DialogParentProvider parentProv, AudioModule module) {
        super((PreferencesPanelOwner)owner, i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_TITLE));
        this.i18n = i18n;
        this.module = module;
        this.engine = AudioEngine.getInstance(parentProv.getDialogParent());
        this.boostBox = new JCheckBox();
        this.boostBox.setVisible(false);
    }

    protected void createContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        JButton refreshBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_REFRESH_BTN_NAME));
        refreshBtn.setSize(70, 25);
        this.inputSelectionSupported = this.engine.isInputDeviceSelectionSupported();
        if (this.inputSelectionSupported) {
            this.inputOkButton = new JButton("Ok");
            this.inputOkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicrophoneSettingsPrefsPanel.this.setModified(true);
                    MicrophoneSettingsPrefsPanel.this.inputDeviceSelected = true;
                }
            });
            this.selectionPanel = this.engine.getInputDeviceSelectionPanel(this.inputOkButton, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicrophoneSettingsPrefsPanel.this.inputDeviceSelected = MicrophoneSettingsPrefsPanel.this.inputOkButton.isEnabled();
                    MicrophoneSettingsPrefsPanel.this.setModified(MicrophoneSettingsPrefsPanel.this.inputDeviceSelected);
                }
            });
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add(this.selectionPanel.getSelectionPanel(), gbc);
            gbc.fill = 0;
            gbc.weighty = 0.0;
            ++gbc.gridy;
        }
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 5;
        gbc.insets.left = 0;
        this.webrtcPanel = this.setupWebrtcPanel();
        this.legacyPanel = this.setupLegacyPanel();
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        this.add(this.webrtcPanel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        this.add(this.legacyPanel, gbc);
        this.registerLegacyOverrideListener();
        this.updateMicPanels();
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        this.transmitSilenceBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_TRANSMITSILENCEBOX));
        this.transmitSilenceBox.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_TRANSMITSILENCETEXT));
        this.transmitSilenceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.transmitSilenceBox, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 0;
        gbc.insets.left = 26;
        gbc.fill = 2;
        MultilineLabel text = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_TRANSMITSILENCETEXT));
        Font f = text.getFont();
        text.setFont(f.deriveFont((float)(f.getSize() * 11 / 12)));
        this.add((Component)text, gbc);
        gbc.fill = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 12;
        gbc.insets.left = 0;
        this.boostBox.setText(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_BOOSTBOX));
        this.boostBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.boostBox, gbc);
        String[] rates = new String[AudioBean.SAMP_RATES.length];
        for (int i = 0; i < AudioBean.SAMP_RATES.length; ++i) {
            rates[i] = AudioBean.SAMP_RATES[i] + " Hz";
        }
        ++gbc.gridy;
        gbc.insets.top = 12;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        JLabel l = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_SAMPLERATELABEL));
        this.add(l, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 6;
        this.sampleRatePopup = new JComboBox<String>(rates);
        this.sampleRatePopup.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_SAMPLERATETEXT));
        this.sampleRatePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
            }
        });
        l.setLabelFor(this.sampleRatePopup);
        this.add(this.sampleRatePopup, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 4;
        gbc.insets.left = 0;
        gbc.fill = 2;
        text = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_SAMPLERATETEXT));
        f = text.getFont();
        text.setFont(f.deriveFont((float)(f.getSize() * 11 / 12)));
        this.add((Component)text, gbc);
        gbc.fill = 0;
    }

    private void updateMicPanels() {
        boolean legacy = this.engine == null ? false : this.engine.useLegacy();
        this.webrtcPanel.setVisible(!legacy);
        this.legacyPanel.setVisible(legacy);
        this.invalidate();
    }

    private void registerLegacyOverrideListener() {
        AudioDebug.LEGACYOVERRIDE.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                MicrophoneSettingsPrefsPanel.this.updateMicPanels();
            }
        });
    }

    private JPanel setupWebrtcPanel() {
        JPanel webrtcPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.insets.top = 0;
        constraints.insets.left = 0;
        this.webrtcEchoCancellation = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_ECHOCANCELLATIONBOX));
        this.webrtcEchoCancellation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
            }
        });
        webrtcPanel.add((Component)this.webrtcEchoCancellation, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.insets.top = 0;
        constraints.insets.left = 0;
        this.webrtcGainControlBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_WEBRTCGAINCONTROLBOX));
        this.webrtcGainControlBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
            }
        });
        webrtcPanel.add((Component)this.webrtcGainControlBox, constraints);
        return webrtcPanel;
    }

    private JPanel setupLegacyPanel() {
        JPanel legacyPnl = new JPanel(new GridBagLayout());
        GridBagConstraints contraints = new GridBagConstraints();
        contraints.anchor = 17;
        contraints.weightx = 1.0;
        contraints.gridx = 0;
        contraints.gridy = 0;
        contraints.gridwidth = 2;
        contraints.insets.top = 0;
        contraints.insets.left = 0;
        ++contraints.gridy;
        contraints.gridx = 0;
        contraints.gridwidth = 2;
        contraints.insets.top = 0;
        contraints.insets.left = 0;
        this.gainControlBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_GAINCONTROLBOX));
        this.gainControlBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
            }
        });
        legacyPnl.add((Component)this.gainControlBox, contraints);
        ++contraints.gridy;
        contraints.gridx = 0;
        contraints.gridwidth = 2;
        contraints.insets.top = 0;
        contraints.insets.left = 0;
        this.peakLimiterBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_PEAKLIMITERBOX));
        this.peakLimiterBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
                boolean en = MicrophoneSettingsPrefsPanel.this.peakLimiterBox.isSelected();
                MicrophoneSettingsPrefsPanel.this.narrowRangeButton.setEnabled(en);
                MicrophoneSettingsPrefsPanel.this.wideRangeButton.setEnabled(en);
            }
        });
        legacyPnl.add((Component)this.peakLimiterBox, contraints);
        ButtonGroup grp = new ButtonGroup();
        ++contraints.gridy;
        contraints.gridx = 0;
        contraints.gridwidth = 2;
        contraints.insets.top = 0;
        contraints.insets.left = 20;
        this.narrowRangeButton = new JRadioButton(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_NARROWRANGEBUTTON));
        this.narrowRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
            }
        });
        grp.add(this.narrowRangeButton);
        legacyPnl.add((Component)this.narrowRangeButton, contraints);
        ++contraints.gridy;
        contraints.gridx = 0;
        contraints.gridwidth = 2;
        contraints.insets.top = 0;
        contraints.insets.left = 20;
        this.wideRangeButton = new JRadioButton(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_WIDERANGEBUTTON));
        this.wideRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicrophoneSettingsPrefsPanel.this.setModified(true);
            }
        });
        grp.add(this.wideRangeButton);
        legacyPnl.add((Component)this.wideRangeButton, contraints);
        return legacyPnl;
    }

    public void setMicrophoneBoostSettingVisible(boolean visible) {
        this.boostBox.setVisible(visible);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.module.getPrefix();
        this.webrtcEchoCancellation.setSelected(AudioBean.getPreferredWebrtcAEC(prefix, preferences));
        this.webrtcGainControlBox.setSelected(AudioBean.getPreferredWebrtcAGC(prefix, preferences));
        boolean en = AudioBean.getPreferredPeakLimiter(prefix, preferences);
        this.gainControlBox.setSelected(en);
        this.peakLimiterBox.setSelected(en);
        this.narrowRangeButton.setEnabled(en);
        this.wideRangeButton.setEnabled(en);
        if (AudioBean.getPreferredGainBoost(prefix, preferences)) {
            this.wideRangeButton.setSelected(true);
        } else {
            this.narrowRangeButton.setSelected(true);
        }
        this.transmitSilenceBox.setSelected(!AudioBean.getPreferredSilenceSuppression(prefix, preferences));
        if (this.boostBox.isVisible()) {
            this.boostBox.setSelected(AudioBean.getPreferredMikeBoost(prefix, preferences));
        }
        int rate = AudioBean.getPreferredMikeSampleRate(prefix, preferences);
        this.sampleRatePopup.setSelectedItem(rate + " Hz");
        this.inputDeviceSelected = false;
    }

    protected void apply(Preferences preferences) throws InvalidPreferenceSettingException {
        String prefix = this.module.getPrefix();
        AudioBean.setPreferredWebrtcAEC(prefix, preferences, this.webrtcEchoCancellation.isSelected());
        AudioBean.setPreferredAGC(prefix, preferences, this.gainControlBox.isSelected());
        AudioBean.setPreferredWebrtcAGC(prefix, preferences, this.webrtcGainControlBox.isSelected());
        AudioBean.setPreferredPeakLimiter(prefix, preferences, this.peakLimiterBox.isSelected());
        AudioBean.setPreferredGainBoost(prefix, preferences, this.wideRangeButton.isSelected());
        AudioBean.setPreferredSilenceSuppression(prefix, preferences, !this.transmitSilenceBox.isSelected());
        if (this.boostBox.isVisible()) {
            AudioBean.setPreferredMikeBoost(prefix, preferences, this.boostBox.isSelected());
        }
        int rate = 44100;
        String item = (String)this.sampleRatePopup.getSelectedItem();
        if (item != null) {
            try {
                rate = Integer.parseInt(item.substring(0, item.length() - " Hz".length()));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        AudioBean.setPreferredMikeSampleRate(prefix, preferences, rate);
        if (this.inputSelectionSupported && this.selectionPanel != null && this.inputDeviceSelected) {
            boolean mikeOpen = this.engine.isMikeOpen();
            if (mikeOpen) {
                this.engine.forceStopInput();
                this.engine.waitForMicrophoneStop();
            }
            this.selectionPanel.apply();
            this.engine.startEavesdrop();
        }
    }

    protected void reset(Preferences preferences) {
        String prefix = this.module.getPrefix();
        AudioBean.setPreferredAGC(prefix, preferences, true);
        AudioBean.setPreferredWebrtcAGC(prefix, preferences, true);
        AudioBean.setPreferredWebrtcAEC(prefix, preferences, true);
        AudioBean.setPreferredPeakLimiter(prefix, preferences, true);
        AudioBean.setPreferredGainBoost(prefix, preferences, true);
        AudioBean.setPreferredSilenceSuppression(prefix, preferences, true);
        if (this.boostBox.isVisible()) {
            AudioBean.setPreferredMikeBoost(prefix, preferences, false);
        }
        AudioBean.setPreferredMikeSampleRate(prefix, preferences, 44100);
        this.inputDeviceSelected = false;
    }
}

