/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.extra.ExTRA;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.GroupwareDebug;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.groupware.audio.AudioProtocol;
import com.elluminate.groupware.audio.ecelp.ECELPCodec;
import com.elluminate.groupware.audio.module.ApplicationBean_Audio;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.module.AudioModule;
import com.elluminate.groupware.audio.module.AudioPermissionDelegate;
import com.elluminate.groupware.audio.module.AudioPublisher;
import com.elluminate.groupware.audio.module.AudioSetupWizard;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.FollowTheSpeakerAPIImpl;
import com.elluminate.groupware.audio.module.InputEvent;
import com.elluminate.groupware.audio.module.InputListener;
import com.elluminate.groupware.audio.module.ReceiveListener;
import com.elluminate.groupware.audio.module.ReceiveQueue;
import com.elluminate.groupware.audio.module.RemoteMikeAdjustMenu;
import com.elluminate.groupware.audio.module.RollingAverage;
import com.elluminate.groupware.audio.module.SpkrVUMeter;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.groupware.audio.module.TransmitListener;
import com.elluminate.groupware.audio.module.TransmitQueue;
import com.elluminate.groupware.audio.module.VUFeature;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.SteppedAwayAPI;
import com.elluminate.groupware.imps.StreamingMediaAPI;
import com.elluminate.groupware.imps.StreamingMediaListener;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AccessibleTextSlider;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.RollOverButton;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.JinxServerProps;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.Resource;
import com.elluminate.util.ShortList;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

@Singleton
public class AudioBean
extends ApplicationBean_Audio
implements ChannelDataListener,
ChannelListener,
InputListener,
ItemListener,
PropertyChangeListener,
ReceiveListener,
StreamingMediaAPI,
TransmitListener {
    private static final long serialVersionUID = 1L;
    private static final int EV_INVALID = 0;
    private static final int EV_BUTTON_PRESSED = 1;
    private static final int EV_BUTTON_RELEASED = 2;
    private static final int EV_CHANNEL_DOWN = 3;
    private static final int EV_CHANNEL_UP = 4;
    private static final int EV_FLOOR_GRANTED_ME = 5;
    private static final int EV_FLOOR_GRANTED_OTHER = 6;
    private static final int EV_FLOOR_REVOKED_ME = 7;
    private static final int EV_FLOOR_REVOKED_OTHER = 8;
    private static final int EV_MIKE_MUTED = 9;
    private static final int EV_MIKE_SAMPLES = 10;
    private static final int EV_MIKE_STARTED = 11;
    private static final int EV_MIKE_STOPPED = 12;
    private static final int EV_MIKE_UNMUTED = 13;
    private static final int EV_PHONE_MODE_ENTERED = 14;
    private static final int EV_PHONE_MODE_EXITED = 15;
    private static final int EV_SPKR_SAMPLES = 16;
    private static final int EV_TALKING_ALLOWED = 17;
    private static final int EV_TALKING_BANNED = 18;
    private static final int EV_TIMEOUT = 19;
    private static final String[] DECODE_EVENT = new String[]{"EV_INVALID", "EV_BUTTON_PRESSED", "EV_BUTTON_RELEASED", "EV_CHANNEL_DOWN", "EV_CHANNEL_UP", "EV_FLOOR_GRANTED_ME", "EV_FLOOR_GRANTED_OTHER", "EV_FLOOR_REVOKED_ME", "EV_FLOOR_REVOKED_OTHER", "EV_MIKE_MUTED", "EV_MIKE_SAMPLES", "EV_MIKE_STARTED", "EV_MIKE_STOPPED", "EV_MIKE_UNMUTED", "EV_PHONE_MODE_ENTERED", "EV_PHONE_MODE_EXITED", "EV_SPKR_SAMPLES", "EV_TALKING_ALLOWED", "EV_TALKING_BANNED", "EV_TIMEOUT"};
    private static final int ST_INVALID = 0;
    private static final int ST_AWAITING_FLOOR = 1;
    private static final int ST_AWAITING_MIKE = 2;
    private static final int ST_CONNECTED = 3;
    private static final int ST_CONVERSING = 4;
    private static final int ST_CONVERSING_MUTED = 5;
    private static final int ST_DISCONNECTED = 6;
    private static final int ST_LISTENING = 7;
    private static final int ST_RELEASING_FLOOR = 8;
    private static final int ST_RELEASING_MIKE = 9;
    private static final int ST_TALKING = 10;
    private static final int ST_TALKING_MUTED = 11;
    private static final int ST_TELEPHONE = 12;
    private static final int ST_DISCONNECTED_TELEPHONE = 13;
    private static final String[] DECODE_STATE = new String[]{"ST_INVALID", "ST_AWAITING_FLOOR", "ST_AWAITING_MIKE", "ST_CONNECTED", "ST_CONVERSING", "ST_CONVERSING_MUTED", "ST_DISCONNECTED", "ST_LISTENING", "ST_RELEASING_FLOOR", "ST_RELEASING_MIKE", "ST_TALKING", "ST_TALKING_MUTED", "ST_TELEPHONE", "ST_DISCONNECTED_TELEPHONE"};
    static final boolean AGC_DEFAULT = true;
    private static final String AGC_PREF = ".agc";
    static final boolean AGC_WEBRTC_DEFAULT = true;
    private static final String AGC_WEBRTC_PREF = ".webrtc.agc";
    static final boolean AEC_DEFAULT = true;
    private static final String AEC_PREF = ".webrtc.aec";
    private static final String ENABLE_BOOST_RESTORE_PREF = ".enableboostRestore";
    private static final String MIKE_SAMP_RATE_PREF = ".mikeSampRate";
    private static final String SPKR_SAMP_RATE_PREF = ".spkrSampRate";
    private static final String MIKE_BOOST_PREF = ".mikeBoost";
    private static final String DEFAULT_INPUT_DEVICE = ".defInputDevice";
    private static final String USE_DEFAULT_INPUT_DEVICE = ".useDefInputDevice";
    private static final String DEFAULT_OUTPUT_DEVICE = ".defOutputDevice";
    static final boolean MIKE_BOOST_DEFAULT = false;
    static final boolean PEAK_LIMIT_DEFAULT = true;
    private static final String PEAK_LIMIT_PREF = ".peakLimit";
    private static final String SPKR_MUTE_PREF = ".muteWhenTalking";
    static final boolean SPKR_MUTE_DEFAULT = false;
    private static final String SUPPRESS_SILENCE_PREF = ".suppressSilence";
    static final boolean SUPPRESS_SILENCE_DEFAULT = true;
    static final int DEFAULT_GAIN_PERCENT = 10;
    private static final double ATTACK_SLOPE;
    private static final double ATTACK_TIME = 0.25;
    public static final boolean BEEP_ON_MUTE_CHANGE = true;
    private static final double BOOST_THRESHOLD_GAIN = 4.0;
    private static final double DECAY_SLOPE;
    private static final double DECAY_TIME = 3.0;
    private static final int DEFAULT_MAX_VOIP_TALKERS = 1;
    private static final int DEFAULT_MAX_VOIP_TALKERS_LIMIT = 6;
    private static final int NULL_TALKER_INDEX = -1;
    private static final int TALK_WIDTH = 46;
    private static final int TALK_HEIGHT = 46;
    private static final int EVENT_HIST_LEN = 100;
    private static final boolean EXCLUDE_SELF = true;
    private static final boolean EXCLUDE_TELEPHONY = true;
    private static final String HTML_FACE_NAME = "Dialog";
    private static final boolean INCLUDE_SELF = false;
    private static final boolean INCLUDE_TELEPHONY = false;
    private static final long LOAD_TIME;
    private static final int MAX_MILLIS_PER_PACKET = 240;
    private static final int MAX_TALKERS_LIMIT = 34;
    private static final int MAX_TEL_TALKERS_LIMIT = 2;
    private static final int MAX_VOIP_TALKERS_LIMIT = 32;
    private final int MEDIUM_BACKLOG_LIMIT = 8000;
    private static final float MIKE_DEC_FACTOR = 0.9f;
    private static final float MIKE_INC_FACTOR = 1.1f;
    private static final int MIN_PEAK_SAMPLES = 5;
    private static final int MIN_SILENCE_MILLIS_BEFORE_SUPPRESSION = 960;
    private static final short NULL_ADDRESS = -32767;
    private static final String NULL_LABEL;
    private static final byte NULL_OPTIMIZATION_MODE = 0;
    private static final String NULL_TIP;
    static final int SAMP_RATE_DEFAULT_FOR_MIKE = 44100;
    static final int SAMP_RATE_DEFAULT_FOR_SPKR;
    static final int[] SAMP_RATES;
    private static final int SAMPS_PER_MILLI = 8;
    private static final double SAMPLE_RANGE = 31128.649999999998;
    private static final boolean SET_HTML_TYPE_FACE;
    private final int SMALL_BACKLOG_LIMIT = 3000;
    private static final int STATUS_UNKNOWN = -1;
    private static final boolean SUPPORTS_HTML_BTN_LABELS = false;
    private static final boolean TALK_ENABLED = true;
    private static final boolean TALK_PRESSED = true;
    private static final boolean TEL_MODE_BTN_ENABLED = true;
    private static final int TRY_AGAIN_OPTION = 0;
    private static final int WATCHDOG_DELAY = 5000;
    private static final int DEFAULT_VOL_LEVEL = 0;
    private static final int DEFAULT_MIC_LEVEL = 0;
    private static I18n i18n;
    private final ImageIcon DEC_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_DECICON);
    private final String GET_FLOOR_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_GETFLR);
    private final ImageIcon INC_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_INCICON);
    private final ImageIcon MIKE_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_MIKEICON);
    private final ImageIcon MIKE_LIVE_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_ONTHEAIRICON);
    private final ImageIcon MIKE_MUTED_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_MUTEDICON);
    private final String RELEASE_FLOOR_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_GETFLR);
    private final ImageIcon SPKR_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_SPEAKERICON);
    private final String START_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_START);
    private final String STOP_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_STOP);
    private final ImageIcon TALK_ICON = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKICON).equals("null") ? null : i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKICON);
    private final String TALK_TIP = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKTIP);
    private final String TALKING_TIP = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKINGTIP);
    private final ImageIcon TEL_MODE_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_TELEPHONEMODEICON);
    private final ImageIcon USING_PHONE_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_TELEPHONEICON);
    private final String USING_PHONE_TIP = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TELEPHONETALKINGTIP);
    private final ImageIcon VOIP_MODE_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_VOIPMODEICON);
    private final ImageIcon VOIP_MODE_WARN_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOBEAN_VOIPMODEWARNICON);
    private final String ACCESSIBLE_TALK = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_ACCESSIBLE_TALK);
    private final String ACCESSIBLE_MIKE_LEVEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_ACCESSIBLE_MIKE_LEVEL);
    private final String ACCESSIBLE_SPKR_LEVEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_ACCESSIBLE_SPKR_LEVEL);
    private static final String MIC_OPENED = "/audio/notice/micOpened";
    private static final String MIC_CLOSED = "/audio/notice/micClosed";
    private static final int MAX_TEXT_WIDTH = 400;
    private static final int MAX_WIDTH = 500;
    private static int volCount;
    private volatile boolean awaitingFloorRelease = false;
    private volatile int buttonUpdatesPending = 0;
    private volatile boolean connected = false;
    private volatile int ignoreMikeLevelChanges = 0;
    private volatile int mikeFeatureSetting = -1;
    private volatile int ignoreSpkrLevelChanges = 0;
    private volatile int spkrFeatureSetting = -1;
    private volatile int maxVoIPTalkers = 1;
    private volatile int maxVoIPTalkersLimit = 6;
    private volatile int minMillisPerPacket = 20;
    private volatile boolean moveFocusToTalkBtn = false;
    private volatile int msgNumber = 1;
    private volatile boolean muteWhenTalking = false;
    private volatile short myAddr = (short)-32767;
    private volatile int myTalkerIdx = -1;
    private volatile byte optimizationMode = 0;
    private volatile boolean nowRecording = false;
    private volatile int state = 6;
    private volatile boolean timedOutReleasingMike = false;
    private volatile boolean timedOutRequestingMike = false;
    private boolean acceptLateMikeSamples = false;
    private ContentCapture contentCapture;
    private ContentCaptureProvider contentCaptureProvider;
    private LinkedList<short[]> audioPacketQueue = new LinkedList();
    private int audioPacketQueuedMillis = 0;
    private AudioSetupWizard audioSetupWizard = null;
    private JMenu audioSubmenu = new JMenu();
    private JSeparator audioSubmenuSeparator = new JSeparator();
    private int boostPeakRestorePercentLimit = 50;
    private ArrayList changeListeners = new ArrayList();
    private int consecutiveSilenceMillis = 0;
    private boolean enableAGC = true;
    private boolean enableWebrtcAGC = true;
    private boolean enableBoostRestore = true;
    private boolean enablePeakLimit = true;
    private AudioEngine engine = null;
    private LightweightTimer evaluateSpkrStatusTimer = null;
    private boolean evaluateSpkrStatusTimerRunning = false;
    private int eventHistCnt = 0;
    private int[] eventHistEvents = new int[100];
    private int[] eventHistStates = new int[100];
    private long[] eventHistTimes = new long[100];
    private boolean first = false;
    private boolean haveTheFloor = false;
    private boolean ignoreTimeOut = false;
    private int millisSinceLastNonsilence = 0;
    private int lastPeakLimit = 100;
    private LinkedList loadTestAudio = null;
    private LinkedList loadTestAudioQueue = new LinkedList();
    private boolean loadTestAudioStarted = false;
    private LightweightTimer loadTestTimer = null;
    private long loadTestTimerDesiredStart = 0L;
    private short[] microphoneSamples = null;
    private boolean mikeSliderMousePressed = false;
    private JPanel mikePanel = new JPanel();
    private ECELPCodec mikeCodec = new ECELPCodec();
    private AudioModule module = null;
    private boolean mute = false;
    private boolean muteForSetup = false;
    private JLabel mikeLabel = new JLabel();
    private int millisBetweenBoosts = 200;
    private int muteThreshold = 10;
    private LinkedList<NoiseInfo> noiseFloorQueue = new LinkedList();
    private int noiseFloorSamplePeriod = 500;
    private int noisePeak = 0;
    private int noiseQueueMillis = 0;
    private int nonsilenceGainBoostThreshold = 1000;
    private int nonsilenceThreshold = 2000;
    private BufferedOutputStream outgoingSaveStrm = null;
    private HashMap participantStatus = new HashMap();
    private float peakedSampleRunCount = 0.0f;
    private InputEvent pending = null;
    private AudioProtocol protocol = new AudioProtocol();
    private ReceiveQueue recvQ = null;
    private JMenuItem remoteMuteWhenTalkingMenuItem = new JMenuItem();
    private ClientInfo remoteMuteWhenTalkingClient = null;
    private JMenuItem remoteModeChangeMenuItem = new JMenuItem();
    private ClientInfo remoteModeChangeClient = null;
    private short[] remoteTalkerAddrs = new short[34];
    private int remoteTalkerCnt = 0;
    private JButton remoteTalkerDecBtn = new RollOverButton();
    private JButton remoteTalkerIncBtn = new RollOverButton();
    private String[] remoteTalkerNames = new String[34];
    private SpkrVUMeter[] remoteTalkerVUMeters = new SpkrVUMeter[34];
    private JMenuItem remoteUnmuteWhenTalkingMenuItem = new JMenuItem();
    private int retainedSilenceLimit = 20;
    private double runningGain = 1.0;
    private ParticipantSelectorAPI selector = null;
    private boolean settingButtonState = false;
    private int silenceSustainLimit = 1500;
    private ECELPCodec[] spkrCodecs = new ECELPCodec[34];
    private JLabel spkrLabel = new JLabel();
    private JPanel spkrPanel = new JPanel();
    private int spkrStatus = -1;
    private Object stateLock = new Object();
    private LinkedList streamingMediaListeners = new LinkedList();
    private JToggleButton talkBtn = new JToggleButton();
    private int talkerSilenceLimit = 2;
    private Font[] talkFonts = new Font[]{this.talkBtn.getFont(), null, null, null, null};
    private short[] talkerAddrs = new short[34];
    private String talkerDesc = null;
    private int[] talkerPktSizes = new int[34];
    private boolean talkingAllowed = false;
    private long timeOfLastBoostRestore = 0L;
    private short volAckPending = (short)-32767;
    private JPanel volPanel = new JPanel();
    private JMenuItem waitForListenersMenuItem = new JMenuItem();
    private ActionListener waitForListenersListener;
    private boolean waitForSelected = false;
    private JMenuItem waitForSelectedListenersMenuItem = new JMenuItem();
    private LightweightTimer watchdogTimer = null;
    private int webrtcTargetLevel = 6;
    private int webrtcCompressionGain = 5;
    private int webrtcLatencyOverrideMilliSecs = 0;
    private int webrtcNoiseSuppressionLevel = 0;
    private int webrtcEchoCancellationLevel = 2;
    private int digitalGainLimit = 6;
    private float digitalGainMin = 1.5f;
    private LightweightTimer mikeVUTimer = null;
    private TransmitQueue xmitQ = null;
    private LightweightTimer xmitSpeedMonitor = null;
    private int xmitSpeedMonitorPrevSpeed = 0;
    private AudioPublisher msgPublisher;
    private PropertyChangeListener preferenceChangeListener;
    private JLabel boostPeakRestorePercentLimitLabel = new JLabel();
    private SpinnerNumberModel boostPeakRestorePercentLimitModel;
    private JSpinner boostPeakRestorePercentLimitSpinner;
    private JLabel millisBetweenBoostsLabel = new JLabel();
    private SpinnerNumberModel millisBetweenBoostsModel;
    private JSpinner millisBetweenBoostsSpinner;
    private JLabel muteThresholdLabel = new JLabel();
    private SpinnerNumberModel muteThresholdModel;
    private JSpinner muteThresholdSpinner;
    private JLabel noiseFloorSamplePeriodLabel = new JLabel();
    private SpinnerNumberModel noiseFloorSamplePeriodModel;
    private JSpinner noiseFloorSamplePeriodSpinner;
    private JLabel nonsilenceGainBoostThresholdLabel = new JLabel();
    private SpinnerNumberModel nonsilenceGainBoostThresholdModel;
    private JSpinner nonsilenceGainBoostThresholdSpinner;
    private JLabel nonsilenceThresholdLabel = new JLabel();
    private SpinnerNumberModel nonsilenceThresholdModel;
    private JSpinner nonsilenceThresholdSpinner;
    private CDialog parametersDlg = null;
    private JLabel retainedSilenceLimitLabel = new JLabel();
    private SpinnerNumberModel retainedSilenceLimitModel;
    private JSpinner retainedSilenceLimitSpinner;
    private JLabel silenceSustainLimitLabel = new JLabel();
    private SpinnerNumberModel silenceSustainLimitModel;
    private JSpinner silenceSustainLimitSpinner;
    private JLabel talkerSilenceLimitLabel = new JLabel();
    private SpinnerNumberModel talkerSilenceLimitModel;
    private JSpinner talkerSilenceLimitSpinner;
    private JLabel webrtcTargetLevelLabel = new JLabel();
    private SpinnerNumberModel webrtcTargetLevelModel;
    private JSpinner webrtcTargetLevelSpinner;
    private JLabel webrtcCompressionGainLabel = new JLabel();
    private SpinnerNumberModel webrtcCompressionGainModel;
    private JSpinner webrtcCompressionGainSpinner;
    private JLabel webrtcLatencyOverrideLabel = new JLabel();
    private SpinnerNumberModel webrtcLatencyOverrideModel;
    private JSpinner webrtcLatencyOverrideSpinner;
    private JLabel webrtcNoiseSuppressionLevelLabel = new JLabel();
    private SpinnerNumberModel webrtcNoiseSuppressionLevelModel;
    private JSpinner webrtcNoiseSuppressionLevelSpinner;
    private JLabel webrtcEchoCancellationLevelLabel = new JLabel();
    private SpinnerNumberModel webrtcEchoCancellationLevelModel;
    private JSpinner webrtcEchoCancellationLevelSpinner;
    private JLabel digitalGainLimitLabel = new JLabel();
    private SpinnerNumberModel digitalGainLimitModel;
    private JSpinner digitalGainLimitSpinner;
    private JLabel digitalGainMinLabel = new JLabel();
    private SpinnerNumberModel digitalGainMinModel;
    private JSpinner digitalGainMinSpinner;
    private JLabel staticPlayLabel = new JLabel();
    private JButton staticPlayBtn;
    private JLabel recordLabel = new JLabel();
    private JButton recordBtn;
    private JLabel playbackLabel = new JLabel();
    private JButton playbackBtn;
    private boolean talkFeatureEnabled = true;
    private Imps imps;
    private ImpsAPI impsApi;
    private AudioPermissionDelegate audioPermissionDelegate;
    private CRSession session;
    private BorderLayout beanLayout = new BorderLayout();
    private JPanel northPanel = new JPanel();
    private BorderLayout northLayout = new BorderLayout();
    private JPanel centrePanel = new JPanel();
    private BoxLayout centreLayout = new BoxLayout(this.centrePanel, 1);
    private JPanel buttonPanel = new JPanel();
    private BoxLayout buttonLayout = new BoxLayout(this.buttonPanel, 1);
    private JPanel vuPanel = new JPanel();
    private JPanel talkPanel = new JPanel();
    private FeatureBroker broker;
    private BooleanFeature talkFeature;
    private StringFeature teleconfIndicatorFeature;
    private ActionFeature audioVoipFeature = null;
    private ActionFeature audioPhoneFeature = null;
    private ActionFeature audioVoip2Feature = null;
    private ActionFeature audioPhone2Feature = null;
    private ActionFeature remoteTalkerIncFeature;
    private ActionFeature remoteTalkerDecFeature;
    private NumericFeature<Integer> micLevelSliderFeature;
    private NumericFeature<Integer> micLevelIndicatorFeature;
    private VUFeature micLevelVUFeature;
    private NumericFeature<Integer> volumeLevelSliderFeature;
    private NumericFeature<Integer> volumeLevelIndicatorFeature;
    private VUFeature volumeLevelVUFeature;
    private boolean talkFeatureInitEnabled = false;
    private boolean talkFeatureInitValue = false;
    private FollowTheSpeakerAPIImpl followTheSpeakerAPIImpl;
    private RollingAverage shortAverage;
    private RollingAverage longAverage;
    private int packetSizeInMillis = -1;
    private int audioSetUpSpkrSetting = 0;
    private int audioSetUpMicSetting = 0;
    TelephonyAPI telephony;
    boolean isAutomatic;
    private long lastSpeakingEvent = 0L;
    private long TIME_BETWEENSPEAKING_EVENTS = 500L;
    private DeviceSelectionPanel inputSelectionPanel;
    private DeviceSelectionPanel outputSelectionPanel;
    private boolean switchedOK;

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void intiFollowTheSpeakerAPI(FollowTheSpeakerAPIImpl ftsAPI) {
        this.followTheSpeakerAPIImpl = ftsAPI;
    }

    @Inject
    public void initAudioPublisher(AudioPublisher pub) {
        this.msgPublisher = pub;
    }

    @Override
    @Inject
    public void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initAudioPermissionDelegate(AudioPermissionDelegate audioPermissionDelegate) {
        this.audioPermissionDelegate = audioPermissionDelegate;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    public AudioBean(ContentCaptureProvider contentCaptureProvider) {
        this.contentCaptureProvider = contentCaptureProvider;
        AudioEngine.initContentCaptureProvider(contentCaptureProvider);
        this.setAudioSetupAwayProperty(false);
        this.mikeVUTimer = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                AudioBean.this.setMikeLevel(0);
            }
        });
    }

    protected void volumeInc(short clientId) {
        if (clientId > 0) {
            this.sendVolumeAdjustment((byte)17, clientId);
        }
    }

    protected void volumeDec(short clientId) {
        if (clientId > 0) {
            this.sendVolumeAdjustment((byte)18, clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener lst) {
        Debug.lockEnter((Object)this, (String)"addChangeListener", (String)"changeListeners", (Object)this.changeListeners);
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            if (!this.changeListeners.contains(lst)) {
                this.changeListeners.add(lst);
            }
        }
        Debug.lockLeave((Object)this, (String)"addChangeListener", (String)"changeListeners", (Object)this.changeListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamingMediaListener(StreamingMediaListener l) {
        LinkedList linkedList = this.streamingMediaListeners;
        synchronized (linkedList) {
            if (!this.streamingMediaListeners.contains(l)) {
                this.streamingMediaListeners.add(l);
            }
        }
    }

    private void addTalker(short talkerAddr, int talkerIdx) {
        ClientInfo ci;
        if (talkerAddr == -32767) {
            throw new IllegalArgumentException("talkerAddr = NULL_ADDRESS");
        }
        if (talkerIdx < 0 || talkerIdx >= this.talkerAddrs.length) {
            throw new IllegalArgumentException("talkerIdx = " + talkerIdx);
        }
        int oldTalkerIdx = this.getTalkerIndex(talkerAddr);
        if (oldTalkerIdx >= 0) {
            ci = this.clients.get(talkerAddr);
            LogSupport.message((Object)this, (String)"addTalker", (String)("Duplicate talkerAddr: " + (ci == null ? "Unknown" : ci.getDisplayName())));
            this.removeTalker(talkerAddr);
        }
        if (this.talkerAddrs[talkerIdx] != -32767) {
            ci = this.clients.get(talkerAddr);
            LogSupport.message((Object)this, (String)"addTalker", (String)("Duplicate talkerIdx: " + (ci == null ? "Unknown" : ci.getDisplayName())));
            this.removeTalker(this.talkerAddrs[talkerIdx]);
        }
        this.talkerAddrs[talkerIdx] = talkerAddr;
        this.talkerPktSizes[talkerIdx] = 0;
        if (this.spkrCodecs[talkerIdx].isDecoderOpen()) {
            this.spkrCodecs[talkerIdx].resetDecoder();
        } else if (!this.spkrCodecs[talkerIdx].openDecoder()) {
            LogSupport.error((Object)this, (String)"addTalker", (String)("Cannot open decoder " + talkerIdx));
        }
        if (this.engine != null) {
            this.engine.resetSpkrChannel(talkerIdx);
        }
        this.updateTalkerDesc();
    }

    private void adjustMikePeak(short[] samples) {
        if (!this.enablePeakLimit) {
            return;
        }
        int peakedCount = 0;
        short peakLimit = 32112;
        for (int i = 0; i < samples.length; ++i) {
            if (samples[i] < 0) {
                if (-samples[i] <= peakLimit) continue;
                ++peakedCount;
                continue;
            }
            if (-samples[i] <= peakLimit) continue;
            ++peakedCount;
        }
        if (peakedCount > 5) {
            this.peakedSampleRunCount += 1.0f;
            float adjust = 1.0f - this.peakedSampleRunCount / 50.0f;
            this.adjustLocalMikeGain(adjust, true, false);
        } else {
            this.peakedSampleRunCount = 0.0f;
        }
    }

    private void setWebrtcTargetLevel(int level) {
        if (this.engine != null) {
            this.engine.setWebrtcTargetLevel(level);
        }
    }

    private void setWebrtcCompressionGain(int gain) {
        if (this.engine != null) {
            this.engine.setWebrtcCompressionGain(gain);
        }
    }

    private void setWebrtcLatencyOverrideMilliSecs(int ms) {
        if (this.engine != null) {
            this.engine.setWebrtcLatencyOverrideMilliSecs(ms);
        }
    }

    private void setWebrtcNoiseSuppressionLevel(int ms) {
        if (this.engine != null) {
            this.engine.setWebrtcNoiseSuppressionLevel(ms);
        }
    }

    private void setWebrtcEchoCancellationLevel(int ms) {
        if (this.engine != null) {
            this.engine.setWebrtcEchoCancellationLevel(ms);
        }
    }

    private void setDigitalGainLimit(int limit) {
        if (this.engine != null) {
            this.engine.setDigitalGainLimit(limit);
        }
    }

    private void setDigitalGainMin(float min) {
        if (this.engine != null) {
            this.engine.setDigitalGainMin(min);
        }
    }

    private boolean useLegacy() {
        if (this.engine != null) {
            return this.engine.useLegacy();
        }
        return false;
    }

    protected void adjustLocalMikeGain(float mult, boolean setPeakLimit, boolean setBoostRestore) {
        int adjGain;
        if (this.micLevelSliderFeature == null || !this.micLevelSliderFeature.isEnabled()) {
            return;
        }
        int delta = 0;
        int gain = (Integer)this.micLevelSliderFeature.getValue();
        if ((double)mult < 1.0) {
            delta = (int)Math.floor((mult - 1.0f) * (float)gain);
            if (delta > -2) {
                delta = -2;
            }
        } else {
            delta = (int)Math.ceil((mult - 1.0f) * (float)gain);
            if (delta < 2) {
                delta = 2;
            }
        }
        if ((adjGain = Math.min(Math.max(gain + delta, 1), 100)) <= 1) {
            this.module.disableAdjustMicLevelDownMenuItem();
            this.module.enableAdjustMicLevelUpMenuItem();
        } else if (adjGain >= 99) {
            this.module.disableAdjustMicLevelUpMenuItem();
            this.module.enableAdjustMicLevelDownMenuItem();
        } else {
            this.module.enableAdjustMicLevelDownMenuItem();
            this.module.enableAdjustMicLevelUpMenuItem();
        }
        int restoreGainLimit = 0;
        if (this.useLegacy()) {
            restoreGainLimit = this.lastPeakLimit < 50 ? this.lastPeakLimit : (100 - this.lastPeakLimit) * this.boostPeakRestorePercentLimit / 100;
            restoreGainLimit += this.lastPeakLimit;
        }
        if (adjGain != gain) {
            if (this.useLegacy()) {
                this.timeOfLastBoostRestore = System.currentTimeMillis();
            }
            if (!this.useLegacy() || !setBoostRestore || setBoostRestore && restoreGainLimit >= adjGain) {
                if (this.useLegacy() && setPeakLimit) {
                    this.lastPeakLimit = adjGain;
                }
                if (AudioDebug.GAIN.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)("Setting mike slider to " + adjGain));
                }
                this.micLevelSliderFeature.setValue((Object)adjGain);
                this.engine.setMikeGain(adjGain);
            }
        }
    }

    private void adjustLocalMikeGain(short src, float mult) {
        if (this.micLevelSliderFeature == null) {
            return;
        }
        boolean isTalking = this.state == 4 || this.state == 5 || this.state == 10 || this.state == 11;
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        if (chair.contains(src) && isTalking) {
            if (AudioDebug.GAIN.show()) {
                LogSupport.message((Object)this, (String)"adjustLocalMikeGain", (String)("src=" + src + ", mult=" + mult + ", gain=" + this.micLevelSliderFeature.getValue()));
            }
            this.adjustLocalMikeGain(mult, false, false);
        }
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)src, (byte)16);
        this.fireChannelData(e);
    }

    protected void adjustLocalSpkrVolume(float mult) {
        int adjVol;
        int volume = (Integer)this.volumeLevelSliderFeature.getValue();
        int delta = 0;
        if ((double)mult < 1.0) {
            delta = (int)Math.floor((mult - 1.0f) * (float)volume);
            if (delta > -2) {
                delta = -2;
            }
        } else {
            delta = (int)Math.ceil((mult - 1.0f) * (float)volume);
            if (delta < 2) {
                delta = 2;
            }
        }
        if ((adjVol = Math.min(Math.max(volume + delta, 0), 100)) != volume) {
            LogSupport.message((Object)this, (String)"adjustLocalSpkrVolume", (String)("Adjusting volume by " + mult));
            this.setSpkrFeatureValue(adjVol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustRemoteMikeGain(final byte op) {
        int i;
        this.remoteTalkerCnt = 0;
        Debug.lockEnter((Object)this, (String)"adjustRemoteMikeGain", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            for (i = 0; i < 34; ++i) {
                String talkerName;
                short talkerAddr = this.talkerAddrs[i];
                if (talkerAddr == -32767 || talkerAddr == this.myAddr) continue;
                ClientInfo ci = this.clients.get(talkerAddr);
                String string = talkerName = ci == null ? null : ci.getDisplayName();
                if (talkerName == null) continue;
                for (int j = this.remoteTalkerCnt; j > 0 && talkerName.compareTo(this.remoteTalkerNames[j - 1]) < 0; --j) {
                    this.remoteTalkerAddrs[j] = this.remoteTalkerAddrs[j - 1];
                    this.remoteTalkerNames[j] = this.remoteTalkerNames[j - 1];
                }
                this.remoteTalkerAddrs[j] = talkerAddr;
                this.remoteTalkerNames[j] = talkerName;
                ++this.remoteTalkerCnt;
            }
        }
        Debug.lockLeave((Object)this, (String)"adjustRemoteMikeGain", (String)"stateLock", (Object)this.stateLock);
        if (this.remoteTalkerCnt < 1) {
            return;
        }
        if (this.remoteTalkerCnt == 1) {
            this.sendVolumeAdjustment(op, this.remoteTalkerAddrs[0]);
            return;
        }
        RemoteMikeAdjustMenu menu = new RemoteMikeAdjustMenu(this.getAppFrame());
        for (i = 0; i < this.remoteTalkerCnt; ++i) {
            menu.add(this.remoteTalkerNames[i], this.remoteTalkerVUMeters[i]);
        }
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int idx = ae.getID();
                AudioBean.this.sendVolumeAdjustment(op, AudioBean.this.remoteTalkerAddrs[idx]);
            }
        });
        menu.show(op == 17 ? this.remoteTalkerIncBtn : this.remoteTalkerDecBtn);
    }

    private short[] automaticGainControl(short[] samples) {
        if (!this.enableAGC) {
            return samples;
        }
        short[] newSamples = new short[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            double effectivePeak = 31128.649999999998 / this.runningGain;
            short absSample = samples[i] >= 0 ? samples[i] : -samples[i];
            double gainDelta = 0.0;
            if ((double)absSample > effectivePeak) {
                gainDelta = ATTACK_SLOPE / 31128.649999999998;
            } else if ((double)absSample < effectivePeak) {
                gainDelta = DECAY_SLOPE / 31128.649999999998;
            }
            this.runningGain += gainDelta;
            if (this.runningGain > 4.0) {
                this.runningGain = 4.0;
            } else if (this.runningGain < 0.25) {
                this.runningGain = 0.25;
            }
            double newSample = this.runningGain * (double)absSample;
            if (newSample > 31128.649999999998) {
                this.runningGain = 31128.649999999998 / (double)absSample;
            }
            newSamples[i] = (short)(this.runningGain * (double)samples[i]);
        }
        return newSamples;
    }

    private void audioInit() {
        if (this.contentCaptureProvider.get().isCapturingData()) {
            this.contentCapture = this.contentCaptureProvider.get().registerAudioModule("Audio", "Audio#2.0", i18n.getIcon("BrowserAudioSupport.thinClientIcon"), (byte)1, (byte)10);
            this.contentCapture.setTitle("");
            this.contentCapture.setFeedVisible(false);
        }
        this.engine = AudioEngine.getInstance(this.getAppFrame());
        if (this.engine == null) {
            if (ModalDialog.showConfirmDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_NOAUDIOMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_ERRORTITLE), (int)0, (int)0) != 0) {
                ExTRA.exit((int)2);
            }
            if (this.talkFeature != null) {
                this.talkFeature.setEnabled(false);
            }
            if (this.micLevelSliderFeature != null) {
                this.micLevelSliderFeature.setEnabled(false);
                this.setMikeFeatureValue(0);
            }
            this.volumeLevelSliderFeature.setEnabled(false);
            this.setSpkrFeatureValue(0);
            return;
        }
        this.setState(6);
        try {
            this.engine.addInputListener(this);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"audioInit", (Throwable)ex, (boolean)true);
            return;
        }
        this.engine.addChangeListener(new AudioEngine.ChangeListener(){

            @Override
            public void stateChanged(AudioEngine.ChangeEvent event) {
                switch ((Integer)event.getSource()) {
                    case 1: 
                    case 3: {
                        AudioBean.this.updateMikeLevelSlider();
                        break;
                    }
                    case 2: {
                        AudioBean.this.updateSpkrLevelSlider();
                        break;
                    }
                }
            }
        });
        this.audioSetupWizard = new AudioSetupWizard(this.getAppFrame());
    }

    private void awaitFloorRelease() {
        if (!this.awaitingFloorRelease) {
            this.awaitingFloorRelease = true;
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.getAppFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SERVICENOTRESPONDING), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_WARNINGTITLE), (int)2);
        }
    }

    public void channelStateChanged(ChannelEvent event) {
        if (this.micLevelSliderFeature == null) {
            return;
        }
        this.moveFocusToTalkBtn = false;
        switch (event.getState()) {
            case 1: {
                this.updateState(4, null);
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean playback = AudioBean.this.isPlayback();
                        AudioBean.this.micLevelSliderFeature.setEnabled(!playback && AudioBean.this.engine != null && AudioBean.this.engine.getMikeGain() >= 0);
                    }
                });
                break;
            }
            case 2: {
                this.updateState(3, null);
                this.micLevelSliderFeature.setEnabled(this.engine != null && this.engine.getMikeGain() >= 0);
                this.ignoreMikeLevelChanges = 0;
                this.mikeFeatureSetting = -1;
                this.ignoreSpkrLevelChanges = 0;
                this.spkrFeatureSetting = -1;
                break;
            }
            default: {
                String msg = "Invalid channel state: " + event.getState();
                LogSupport.exception((Object)this, (String)"channelStateChanged", (Throwable)new RuntimeException(msg), (boolean)false);
            }
        }
    }

    private void clearAllTalkers() {
        for (int i = 0; i < this.talkerAddrs.length; ++i) {
            this.talkerAddrs[i] = -32767;
        }
        this.updateTalkerDesc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueuedECELP() {
        LinkedList<short[]> linkedList = this.audioPacketQueue;
        synchronized (linkedList) {
            this.timeOfLastBoostRestore = 0L;
            this.audioPacketQueuedMillis = 0;
            this.audioPacketQueue.clear();
        }
    }

    private void clearStatusIndicators() {
        for (ClientInfo ci : this.clients) {
            if (ci == null) continue;
            ci.setProperty("audioYellowStatus", false);
            ci.setProperty("audioRedStatus", false);
        }
        this.participantStatus.clear();
    }

    public void close() {
        if (this.engine != null) {
            this.engine.close();
        }
        this.setModule(null);
    }

    private void closeOutgoingSaveFile() {
        if (this.outgoingSaveStrm != null) {
            try {
                this.outgoingSaveStrm.close();
            }
            catch (Throwable t) {
                LogSupport.error((Object)this, (String)"closeOutgoingSaveFile", (String)("Cannot close outgoing audio file:\n" + t));
            }
            this.outgoingSaveStrm = null;
        }
    }

    private int countTalkers(boolean excludeSelf, boolean excludeTelephony) {
        int talkerCnt = 0;
        int talkerLim = excludeTelephony ? 32 : this.talkerAddrs.length;
        for (int i = 0; i < talkerLim; ++i) {
            if (this.talkerAddrs[i] == this.myAddr) {
                if (excludeSelf) continue;
                ++talkerCnt;
                continue;
            }
            if (this.talkerAddrs[i] == -32767) continue;
            ++talkerCnt;
        }
        return talkerCnt;
    }

    private void createParametersDialog() {
        if (this.talkerSilenceLimit < 0 || this.talkerSilenceLimit > 6) {
            this.talkerSilenceLimit = 2;
        }
        this.talkerSilenceLimitModel = new SpinnerNumberModel(this.talkerSilenceLimit, 0, 6, 1);
        this.talkerSilenceLimitSpinner = new JSpinner(this.talkerSilenceLimitModel);
        this.talkerSilenceLimitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.talkerSilenceLimit = AudioBean.this.talkerSilenceLimitModel.getNumber().intValue();
                LogSupport.message((String)("audio.talkerSilenceLimit = " + AudioBean.this.talkerSilenceLimit));
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.silenceSustainLimit < 0 || this.silenceSustainLimit > 5000) {
            this.silenceSustainLimit = 1500;
        }
        this.silenceSustainLimitModel = new SpinnerNumberModel(this.silenceSustainLimit, 0, 5000, 100);
        this.silenceSustainLimitSpinner = new JSpinner(this.silenceSustainLimitModel);
        this.silenceSustainLimitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.silenceSustainLimit = AudioBean.this.silenceSustainLimitModel.getNumber().intValue();
                LogSupport.message((String)("audio.silenceSustainLimit = " + AudioBean.this.silenceSustainLimit));
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.retainedSilenceLimit < 0 || this.retainedSilenceLimit > 1000) {
            this.retainedSilenceLimit = 20;
        }
        this.retainedSilenceLimitModel = new SpinnerNumberModel(this.retainedSilenceLimit, 0, 1000, 20);
        this.retainedSilenceLimitSpinner = new JSpinner(this.retainedSilenceLimitModel);
        this.retainedSilenceLimitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.retainedSilenceLimit = AudioBean.this.retainedSilenceLimitModel.getNumber().intValue();
                LogSupport.message((String)("audio.retainedSilenceLimit = " + AudioBean.this.retainedSilenceLimit));
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.nonsilenceThreshold < 0 || this.nonsilenceThreshold > 5000) {
            this.nonsilenceThreshold = 2000;
        }
        this.nonsilenceThresholdModel = new SpinnerNumberModel(this.nonsilenceThreshold, 0, 5000, 100);
        this.nonsilenceThresholdSpinner = new JSpinner(this.nonsilenceThresholdModel);
        this.nonsilenceThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.nonsilenceThreshold = AudioBean.this.nonsilenceThresholdModel.getNumber().intValue();
                LogSupport.message((String)("audio.nonsilenceThreshold = " + AudioBean.this.nonsilenceThreshold));
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.noiseFloorSamplePeriod < 50 || (long)this.noiseFloorSamplePeriod > 5000L) {
            this.noiseFloorSamplePeriod = 500;
        }
        this.noiseFloorSamplePeriodModel = new SpinnerNumberModel((double)this.noiseFloorSamplePeriod, 50.0, 5000.0, 50.0);
        this.noiseFloorSamplePeriodSpinner = new JSpinner(this.noiseFloorSamplePeriodModel);
        this.noiseFloorSamplePeriodSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.noiseFloorSamplePeriod = AudioBean.this.noiseFloorSamplePeriodModel.getNumber().intValue();
                LogSupport.message((String)("audio.noiseFloorSamplePeriod = " + AudioBean.this.noiseFloorSamplePeriod));
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.nonsilenceGainBoostThreshold < 0 || this.nonsilenceGainBoostThreshold > 5000) {
            this.nonsilenceGainBoostThreshold = 1000;
        }
        this.nonsilenceGainBoostThresholdModel = new SpinnerNumberModel(this.nonsilenceGainBoostThreshold, 0, 5000, 50);
        this.nonsilenceGainBoostThresholdSpinner = new JSpinner(this.nonsilenceGainBoostThresholdModel);
        this.nonsilenceGainBoostThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.nonsilenceGainBoostThreshold = AudioBean.this.nonsilenceGainBoostThresholdModel.getNumber().intValue();
                LogSupport.message((String)("audio.nonsilenceGainBoost = " + AudioBean.this.nonsilenceGainBoostThreshold));
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.muteThreshold < 0 || this.muteThreshold > 200) {
            this.muteThreshold = 10;
        }
        this.muteThresholdModel = new SpinnerNumberModel(this.muteThreshold, 0, 200, 5);
        this.muteThresholdSpinner = new JSpinner(this.muteThresholdModel);
        this.muteThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.muteThreshold = AudioBean.this.muteThresholdModel.getNumber().intValue();
                LogSupport.message((String)("audio.muteThreshold = " + AudioBean.this.muteThreshold));
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.boostPeakRestorePercentLimit < 0 || this.boostPeakRestorePercentLimit > 100) {
            this.boostPeakRestorePercentLimit = 50;
        }
        this.boostPeakRestorePercentLimitModel = new SpinnerNumberModel(this.boostPeakRestorePercentLimit, 0, 100, 5);
        this.boostPeakRestorePercentLimitSpinner = new JSpinner(this.boostPeakRestorePercentLimitModel);
        this.boostPeakRestorePercentLimitSpinner.setPreferredSize(new Dimension(60, 21));
        this.boostPeakRestorePercentLimitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.boostPeakRestorePercentLimit = AudioBean.this.boostPeakRestorePercentLimitModel.getNumber().intValue();
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.webrtcCompressionGain < 0 || this.webrtcCompressionGain > 90) {
            this.webrtcCompressionGain = 5;
        }
        this.webrtcCompressionGainModel = new SpinnerNumberModel(this.webrtcCompressionGain, 0, 90, 1);
        this.webrtcCompressionGainSpinner = new JSpinner(this.webrtcCompressionGainModel);
        this.webrtcCompressionGainSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.webrtcCompressionGain = AudioBean.this.webrtcCompressionGainModel.getNumber().intValue();
                LogSupport.message((String)("audio.webrtcCompressionGain = " + AudioBean.this.webrtcCompressionGain));
                AudioBean.this.setWebrtcCompressionGain(AudioBean.this.webrtcCompressionGain);
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.webrtcTargetLevel < 0 || this.webrtcTargetLevel > 31) {
            this.webrtcTargetLevel = 6;
        }
        this.webrtcTargetLevelModel = new SpinnerNumberModel(this.webrtcTargetLevel, 0, 31, 1);
        this.webrtcTargetLevelSpinner = new JSpinner(this.webrtcTargetLevelModel);
        this.webrtcTargetLevelSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.webrtcTargetLevel = AudioBean.this.webrtcTargetLevelModel.getNumber().intValue();
                LogSupport.message((String)("audio.webrtcTargetLevel = " + AudioBean.this.webrtcTargetLevel));
                AudioBean.this.setWebrtcTargetLevel(AudioBean.this.webrtcTargetLevel);
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.webrtcLatencyOverrideMilliSecs < 0 || this.webrtcLatencyOverrideMilliSecs > 500) {
            this.webrtcLatencyOverrideMilliSecs = 0;
        }
        this.webrtcLatencyOverrideModel = new SpinnerNumberModel(this.webrtcLatencyOverrideMilliSecs, 0, 500, 10);
        this.webrtcLatencyOverrideSpinner = new JSpinner(this.webrtcLatencyOverrideModel);
        this.webrtcLatencyOverrideSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.webrtcLatencyOverrideMilliSecs = AudioBean.this.webrtcLatencyOverrideModel.getNumber().intValue();
                LogSupport.message((String)("audio.webrtcLatencyOverrideMilliSecs = " + AudioBean.this.webrtcLatencyOverrideMilliSecs));
                AudioBean.this.setWebrtcLatencyOverrideMilliSecs(AudioBean.this.webrtcLatencyOverrideMilliSecs);
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.webrtcNoiseSuppressionLevel < 0 || this.webrtcNoiseSuppressionLevel > 3) {
            this.webrtcNoiseSuppressionLevel = 0;
        }
        this.webrtcNoiseSuppressionLevelModel = new SpinnerNumberModel(this.webrtcNoiseSuppressionLevel, 0, 3, 1);
        this.webrtcNoiseSuppressionLevelSpinner = new JSpinner(this.webrtcNoiseSuppressionLevelModel);
        this.webrtcNoiseSuppressionLevelSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.webrtcNoiseSuppressionLevel = AudioBean.this.webrtcNoiseSuppressionLevelModel.getNumber().intValue();
                LogSupport.message((String)("audio.webrtcNoiseSuppressionLevel = " + AudioBean.this.webrtcNoiseSuppressionLevel));
                AudioBean.this.setWebrtcNoiseSuppressionLevel(AudioBean.this.webrtcNoiseSuppressionLevel);
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.digitalGainLimit < 2 || this.digitalGainLimit > 32) {
            this.digitalGainLimit = 6;
        }
        this.digitalGainLimitModel = new SpinnerNumberModel(this.digitalGainLimit, 2, 32, 1);
        this.digitalGainLimitSpinner = new JSpinner(this.digitalGainLimitModel);
        this.digitalGainLimitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.digitalGainLimit = AudioBean.this.digitalGainLimitModel.getNumber().intValue();
                LogSupport.message((String)("audio.digitalGainLimit = " + AudioBean.this.digitalGainLimit));
                AudioBean.this.setDigitalGainLimit(AudioBean.this.digitalGainLimit);
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.digitalGainMin < 1.0f || this.digitalGainMin > 1.9f) {
            this.digitalGainMin = 1.5f;
        }
        this.digitalGainMinModel = new SpinnerNumberModel(this.digitalGainMin, 1.0, 1.9f, 0.1f);
        this.digitalGainMinSpinner = new JSpinner(this.digitalGainMinModel);
        this.digitalGainMinSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.digitalGainMin = AudioBean.this.digitalGainMinModel.getNumber().floatValue();
                LogSupport.message((String)("audio.digitalGainMin = " + AudioBean.this.digitalGainMin));
                AudioBean.this.setDigitalGainMin(AudioBean.this.digitalGainMin);
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        this.staticPlayBtn = new JButton("Play Test Message");
        this.staticPlayBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioBean.this.playAudio(true);
            }
        });
        this.recordBtn = new JButton("Record Audio");
        this.recordBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioBean.this.recordAudio();
            }
        });
        this.playbackBtn = new JButton("Playback Recording");
        this.playbackBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioBean.this.playAudio(false);
            }
        });
        if (this.webrtcEchoCancellationLevel < 0 || this.webrtcEchoCancellationLevel > 2) {
            this.webrtcEchoCancellationLevel = 2;
        }
        this.webrtcEchoCancellationLevelModel = new SpinnerNumberModel(this.webrtcEchoCancellationLevel, 0, 2, 1);
        this.webrtcEchoCancellationLevelSpinner = new JSpinner(this.webrtcEchoCancellationLevelModel);
        this.webrtcEchoCancellationLevelSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.webrtcEchoCancellationLevel = AudioBean.this.webrtcEchoCancellationLevelModel.getNumber().intValue();
                LogSupport.message((String)("audio.webrtcEchoCancellationLevel = " + AudioBean.this.webrtcEchoCancellationLevel));
                AudioBean.this.setWebrtcEchoCancellationLevel(AudioBean.this.webrtcEchoCancellationLevel);
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        if (this.millisBetweenBoosts < 0 || this.millisBetweenBoosts > 2000) {
            this.millisBetweenBoosts = 200;
        }
        this.millisBetweenBoostsModel = new SpinnerNumberModel(this.millisBetweenBoosts, 0, 2000, 50);
        this.millisBetweenBoostsSpinner = new JSpinner(this.millisBetweenBoostsModel);
        this.millisBetweenBoostsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioBean.this.millisBetweenBoosts = AudioBean.this.millisBetweenBoostsModel.getNumber().intValue();
                LogSupport.message((String)("audio.millisBetweenBoosts = " + AudioBean.this.millisBetweenBoosts));
                AudioBean.this.updateAudioParametersLabels();
            }
        });
        Box parametersBox = Box.createVerticalBox();
        parametersBox.add(Box.createHorizontalStrut(400));
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel talkerSilenceLimitLbl = new JPanel(new BorderLayout());
        talkerSilenceLimitLbl.add((Component)this.talkerSilenceLimitLabel, "West");
        talkerSilenceLimitLbl.add((Component)this.talkerSilenceLimitSpinner, "East");
        parametersBox.add(talkerSilenceLimitLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel silenceSustainLimitLbl = new JPanel(new BorderLayout());
        silenceSustainLimitLbl.add((Component)this.silenceSustainLimitLabel, "West");
        silenceSustainLimitLbl.add((Component)this.silenceSustainLimitSpinner, "East");
        parametersBox.add(silenceSustainLimitLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel retainedSilenceLimitLbl = new JPanel(new BorderLayout());
        retainedSilenceLimitLbl.add((Component)this.retainedSilenceLimitLabel, "West");
        retainedSilenceLimitLbl.add((Component)this.retainedSilenceLimitSpinner, "East");
        parametersBox.add(retainedSilenceLimitLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel nonsilenceThresholdLbl = new JPanel(new BorderLayout());
        nonsilenceThresholdLbl.add((Component)this.nonsilenceThresholdLabel, "West");
        nonsilenceThresholdLbl.add((Component)this.nonsilenceThresholdSpinner, "East");
        parametersBox.add(nonsilenceThresholdLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel noiseFloorSamplePeriodLbl = new JPanel(new BorderLayout());
        noiseFloorSamplePeriodLbl.add((Component)this.noiseFloorSamplePeriodLabel, "West");
        noiseFloorSamplePeriodLbl.add((Component)this.noiseFloorSamplePeriodSpinner, "East");
        parametersBox.add(noiseFloorSamplePeriodLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel nonsilenceGainBoostThresholdLbl = new JPanel(new BorderLayout());
        nonsilenceGainBoostThresholdLbl.add((Component)this.nonsilenceGainBoostThresholdLabel, "West");
        nonsilenceGainBoostThresholdLbl.add((Component)this.nonsilenceGainBoostThresholdSpinner, "East");
        parametersBox.add(nonsilenceGainBoostThresholdLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel muteThresholdLbl = new JPanel(new BorderLayout());
        muteThresholdLbl.add((Component)this.muteThresholdLabel, "West");
        muteThresholdLbl.add((Component)this.muteThresholdSpinner, "East");
        parametersBox.add(muteThresholdLbl);
        parametersBox.add(Box.createVerticalStrut(10));
        JPanel boostPeakRestoreRatioLbl = new JPanel(new BorderLayout());
        boostPeakRestoreRatioLbl.add((Component)this.boostPeakRestorePercentLimitLabel, "West");
        boostPeakRestoreRatioLbl.add((Component)this.boostPeakRestorePercentLimitSpinner, "East");
        parametersBox.add(boostPeakRestoreRatioLbl);
        parametersBox.add(Box.createVerticalStrut(10));
        JPanel millisBetweenBoostsLbl = new JPanel(new BorderLayout());
        millisBetweenBoostsLbl.add((Component)this.millisBetweenBoostsLabel, "West");
        millisBetweenBoostsLbl.add((Component)this.millisBetweenBoostsSpinner, "East");
        parametersBox.add(millisBetweenBoostsLbl);
        parametersBox.add(Box.createVerticalStrut(15));
        JPanel webrtcCompressionGainLbl = new JPanel(new BorderLayout());
        webrtcCompressionGainLbl.add((Component)this.webrtcCompressionGainLabel, "West");
        webrtcCompressionGainLbl.add((Component)this.webrtcCompressionGainSpinner, "East");
        parametersBox.add(webrtcCompressionGainLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel webrtcTargetLevelLbl = new JPanel(new BorderLayout());
        webrtcTargetLevelLbl.add((Component)this.webrtcTargetLevelLabel, "West");
        webrtcTargetLevelLbl.add((Component)this.webrtcTargetLevelSpinner, "East");
        parametersBox.add(webrtcTargetLevelLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel webrtcLatencyOverrideLbl = new JPanel(new BorderLayout());
        webrtcLatencyOverrideLbl.add((Component)this.webrtcLatencyOverrideLabel, "West");
        webrtcLatencyOverrideLbl.add((Component)this.webrtcLatencyOverrideSpinner, "East");
        parametersBox.add(webrtcLatencyOverrideLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel webrtcNoiseSuppressionLevelLbl = new JPanel(new BorderLayout());
        webrtcNoiseSuppressionLevelLbl.add((Component)this.webrtcNoiseSuppressionLevelLabel, "West");
        webrtcNoiseSuppressionLevelLbl.add((Component)this.webrtcNoiseSuppressionLevelSpinner, "East");
        parametersBox.add(webrtcNoiseSuppressionLevelLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel webrtcEchoCancellationLevelLbl = new JPanel(new BorderLayout());
        webrtcEchoCancellationLevelLbl.add((Component)this.webrtcEchoCancellationLevelLabel, "West");
        webrtcEchoCancellationLevelLbl.add((Component)this.webrtcEchoCancellationLevelSpinner, "East");
        parametersBox.add(webrtcEchoCancellationLevelLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel digitalGainLimitLbl = new JPanel(new BorderLayout());
        digitalGainLimitLbl.add((Component)this.digitalGainLimitLabel, "West");
        digitalGainLimitLbl.add((Component)this.digitalGainLimitSpinner, "East");
        parametersBox.add(digitalGainLimitLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel digitalGainMinLbl = new JPanel(new BorderLayout());
        digitalGainMinLbl.add((Component)this.digitalGainMinLabel, "West");
        digitalGainMinLbl.add((Component)this.digitalGainMinSpinner, "East");
        parametersBox.add(digitalGainMinLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel staticPlayLbl = new JPanel(new BorderLayout());
        staticPlayLbl.add((Component)this.staticPlayLabel, "West");
        staticPlayLbl.add((Component)this.staticPlayBtn, "East");
        parametersBox.add(staticPlayLbl);
        parametersBox.add(Box.createVerticalStrut(6));
        JPanel recordLbl = new JPanel(new BorderLayout());
        recordLbl.add((Component)this.recordLabel, "West");
        recordLbl.add((Component)this.recordBtn, "Center");
        recordLbl.add((Component)this.playbackBtn, "East");
        parametersBox.add(recordLbl);
        this.updateAudioParametersLabels();
        this.parametersDlg = new CDialog(this.getAppFrame(), "Audio Parameters");
        this.parametersDlg.getContentPane().add(parametersBox);
        this.parametersDlg.pack();
        this.parametersDlg.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AudioDebug.PARAMETERS.setEnabled(false);
            }
        });
    }

    private void updateAudioParametersLabels() {
        this.talkerSilenceLimitLabel.setText("talkerSilenceLimit (talkers): " + this.talkerSilenceLimit);
        this.silenceSustainLimitLabel.setText("silenceSustainLimit (millis): " + this.silenceSustainLimit);
        this.retainedSilenceLimitLabel.setText("retainedSilenceLimit (millis): " + this.retainedSilenceLimit);
        this.nonsilenceThresholdLabel.setText("nonsilenceThreshold (vol level): " + this.nonsilenceThreshold);
        this.noiseFloorSamplePeriodLabel.setText("noiseFloorSamplePeriod (millis): " + this.noiseFloorSamplePeriod);
        this.nonsilenceGainBoostThresholdLabel.setText("nonsilenceGainBoostThreshold (vol level): " + this.nonsilenceGainBoostThreshold);
        this.muteThresholdLabel.setText("muteThreshold (vol Level): " + this.muteThreshold);
        this.boostPeakRestorePercentLimitLabel.setText("boostPeakRestorePercentLimit: " + this.boostPeakRestorePercentLimit);
        this.millisBetweenBoostsLabel.setText("millisBetweenBoosts (ms): " + this.millisBetweenBoosts);
        this.webrtcCompressionGainLabel.setText("webrtcCompressionGain (dB compression applied above target): " + this.webrtcCompressionGain);
        this.webrtcTargetLevelLabel.setText("webrtcTargetLevel (dB below full-scale): " + this.webrtcTargetLevel);
        this.webrtcLatencyOverrideLabel.setText("webrtcLatencyOverride (ms): " + this.webrtcLatencyOverrideMilliSecs + " (activate w/audio.webrtc.overrideLatency)");
        this.webrtcNoiseSuppressionLevelLabel.setText("webrtcNoiseSuppressionLevel (0:low - 3:hi): " + this.webrtcNoiseSuppressionLevel);
        this.webrtcEchoCancellationLevelLabel.setText("webrtcEchoCancellationLevel (0:low - 2:hi): " + this.webrtcEchoCancellationLevel);
        this.digitalGainLimitLabel.setText("digitalGainLimit (2 - 32): " + this.digitalGainLimit);
        this.digitalGainMinLabel.setText("digitalGainMin (1.0 - 1.9): " + this.digitalGainMin);
        this.staticPlayLabel.setText("Play a pre-recorded (fixed) audio message.");
        this.recordLabel.setText("Record/Play webrtc-processed audio.");
    }

    private synchronized void evaluateSpkrStatus() {
        int backlogMillis;
        int n = backlogMillis = this.engine == null ? 0 : this.engine.getSpkrBacklogMillis();
        if (this.recvQ != null) {
            backlogMillis += this.recvQ.getLongestStreamSize() / 18 * 20;
        }
        if (backlogMillis > 8000) {
            this.sendStatus(4);
        } else if (backlogMillis > 3000) {
            this.sendStatus(2);
        } else if (backlogMillis > 0) {
            this.sendStatus(1);
        } else {
            this.sendStatus(0);
        }
        if (backlogMillis > 0) {
            if (this.evaluateSpkrStatusTimer == null) {
                this.evaluateSpkrStatusTimer = new LightweightTimer(new Runnable(){

                    @Override
                    public void run() {
                        AudioBean.this.evaluateSpkrStatus();
                    }
                });
            }
            if (!this.evaluateSpkrStatusTimerRunning) {
                this.evaluateSpkrStatusTimer.scheduleEvery(500L);
                this.evaluateSpkrStatusTimerRunning = true;
            }
        } else {
            if (this.evaluateSpkrStatusTimer != null) {
                this.evaluateSpkrStatusTimer.cancel();
                this.evaluateSpkrStatusTimerRunning = false;
            }
            this.setSpkrLevel(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent() {
        Debug.lockEnter((Object)this, (String)"fireChangeEvent", (String)"changeListeners", (Object)this.changeListeners);
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            Iterator i = this.changeListeners.iterator();
            ChangeEvent e = new ChangeEvent(this);
            while (i.hasNext()) {
                ChangeListener cl = (ChangeListener)i.next();
                try {
                    cl.stateChanged(e);
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"fireChangeEvent", (Throwable)ex, (boolean)true);
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"fireChangeEvent", (String)"changeListeners", (Object)this.changeListeners);
    }

    @Override
    public void fireChannelData(ChannelDataEvent e) {
        super.fireChannelData(e);
    }

    protected void fireChannelData(int streamIdx, byte[] data) {
        if (streamIdx < 0 || 64 + streamIdx > 255) {
            throw new IllegalArgumentException("Invalid streamIdx: " + streamIdx);
        }
        if (!this.connected) {
            return;
        }
        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)((byte)(64 + streamIdx)), (byte[])data);
        this.fireChannelData(event);
        if (AudioDebug.ECHO.isEnabled()) {
            event = ChannelDataEvent.getInstance((Object)this, (short)this.myAddr, (byte)((byte)(64 + streamIdx)), (byte[])data);
            this.fireChannelData(event);
        }
    }

    protected void fireChannelData(byte op) {
        if (!this.connected) {
            return;
        }
        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)op);
        if (AudioDebug.FLOOR.show() && (op == 1 || op == 2)) {
            LogSupport.message((Object)this, (String)"fireChannelData", (String)("Sent " + this.protocol.commandToString(op)));
        }
        this.fireChannelData(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSpeakingEvent(short signalStrength) {
        if (!this.connected) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastSpeakingEvent < this.TIME_BETWEENSPEAKING_EVENTS) {
            return;
        }
        this.lastSpeakingEvent = time;
        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)12);
        DataOutputStream out = null;
        try {
            out = event.write();
            out.writeShort(signalStrength);
            out.flush();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"fireSpeakingEvent", (Throwable)ex, (boolean)true);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        if (AudioDebug.SPEAKING.show()) {
            System.out.println("... SPEAKING ...");
        }
        this.fireChannelData(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStreamingMedia(ChannelDataEvent cde) {
        short talkerAddress;
        if (this.streamingMediaListeners == null) {
            return;
        }
        boolean grant = cde.getCommand() == 3;
        boolean revoke = cde.getCommand() == 4;
        byte[] ecelpData = cde.getContents();
        if (grant || revoke) {
            talkerAddress = this.loadShortField(ecelpData, 0);
            ecelpData = null;
        } else {
            talkerAddress = cde.getSourceAddress();
        }
        LinkedList linkedList = this.streamingMediaListeners;
        synchronized (linkedList) {
            for (StreamingMediaListener listener : this.streamingMediaListeners) {
                try {
                    if (grant || revoke) {
                        listener.audioGrant(talkerAddress, grant, 0L);
                        continue;
                    }
                    listener.audioData(ecelpData, talkerAddress, 0L);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"fireStreamingMedia", (Throwable)t, (boolean)true);
                }
            }
        }
    }

    private boolean floorIsFull() {
        int maxTalkers;
        int lastSlot;
        int firstSlot;
        short clientAddr;
        ClientInfo ci = this.clients.getMyClient();
        short s = clientAddr = ci == null ? (short)-32767 : (short)ci.getAddress();
        if (this.isTelephonyBridge(clientAddr)) {
            firstSlot = 32;
            lastSlot = firstSlot + 2 - 1;
            maxTalkers = 2;
        } else {
            firstSlot = 0;
            lastSlot = 31;
            maxTalkers = this.maxVoIPTalkers;
        }
        int talkerCnt = 0;
        for (int i = firstSlot; i <= lastSlot; ++i) {
            if (this.talkerAddrs[i] == -32767) continue;
            ++talkerCnt;
        }
        return talkerCnt >= maxTalkers;
    }

    private String formatEventHistory() {
        String msg = "Recent Event History:\n";
        int oldestIdx = 0;
        long prevTime = 0L;
        int retainedCnt = this.eventHistCnt;
        if (retainedCnt > 100) {
            oldestIdx = this.eventHistCnt % 100;
            retainedCnt = 100;
        }
        int histIdx = oldestIdx;
        for (int retainedIdx = 0; retainedIdx < retainedCnt; ++retainedIdx) {
            msg = msg + "  ";
            msg = retainedIdx == 0 ? msg + (this.eventHistTimes[histIdx] - LOAD_TIME) : msg + "+" + (this.eventHistTimes[histIdx] - prevTime);
            msg = msg + ": " + this.getEventName(this.eventHistEvents[histIdx]) + " in " + this.getStateName(this.eventHistStates[histIdx]) + "\n";
            prevTime = this.eventHistTimes[histIdx];
            histIdx = (histIdx + 1) % 100;
        }
        return msg;
    }

    private boolean getEnableAGC() {
        return this.enableAGC;
    }

    private boolean getEnableWebrtcAGC() {
        return this.enableWebrtcAGC;
    }

    boolean getEnableBoostRestore() {
        return this.enableBoostRestore;
    }

    void setEnableBoostRestore(boolean enable) {
        AudioBean.setPreferredGainBoost(this.module.getPrefix(), this.module.getPreferences(), enable);
    }

    protected boolean getEnablePeakLimiter() {
        return this.enablePeakLimit;
    }

    private String getEventName(int event) {
        return event >= 0 && event < DECODE_EVENT.length ? DECODE_EVENT[event] : "Event #" + event;
    }

    private int getMaxXmitSpeed() {
        Client client = this.getClient();
        int xmitSpeed = 0;
        if (client != null && (xmitSpeed = client.getMaxXmitSpeed()) < 0) {
            xmitSpeed = 10000000;
        }
        return xmitSpeed;
    }

    public int getMediaType() {
        return 0;
    }

    protected boolean getMikeBoost() {
        if (this.engine == null) {
            return false;
        }
        return this.engine.getMikeBoost() > 0;
    }

    private static String getPhoneString(String phone, String pin, boolean html) {
        phone = phone == null ? "" : phone.trim();
        String string = pin = pin == null ? "" : pin.trim();
        if (phone.equals("")) {
            return "";
        }
        String info = html ? ("".equals(pin) ? i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_HTMLPHONENOPIN, new Object[]{phone}) : i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_HTMLPHONEWITHPIN, new Object[]{phone, pin})) : ("".equals(pin) ? i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_PHONENOPIN, new Object[]{phone}) : i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_PHONEWITHPIN, new Object[]{phone, pin}));
        return info;
    }

    protected static boolean getPreferredWebrtcAEC(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + AEC_PREF, true);
    }

    protected static boolean getPreferredWebrtcAGC(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + AGC_WEBRTC_PREF, true);
    }

    protected static boolean getPreferredGainBoost(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + ENABLE_BOOST_RESTORE_PREF, true);
    }

    protected static boolean getPreferredMikeBoost(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + MIKE_BOOST_PREF, false);
    }

    protected static int getPreferredMikeSampleRate(String prefix, Preferences preferences) {
        int sampRate = preferences.getIntegerSetting(prefix + MIKE_SAMP_RATE_PREF, 44100);
        try {
            for (int i = 0; i < SAMP_RATES.length; ++i) {
                if (sampRate != SAMP_RATES[i]) continue;
                return sampRate;
            }
        }
        catch (Throwable t) {
            LogSupport.message(AudioBean.class, (String)"getPreferredMikeSampleRate", (String)("Cannot get mike sample rate: " + t));
        }
        return 44100;
    }

    protected static boolean getPreferredPeakLimiter(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + PEAK_LIMIT_PREF, true);
    }

    protected static boolean getPreferredSilenceSuppression(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + SUPPRESS_SILENCE_PREF, true);
    }

    protected static boolean getPreferredSpeakerMute(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + SPKR_MUTE_PREF, false);
    }

    protected static int getPreferredSpeakerSampleRate(String prefix, Preferences preferences) {
        int sampRate = preferences.getIntegerSetting(prefix + SPKR_SAMP_RATE_PREF, SAMP_RATE_DEFAULT_FOR_SPKR);
        try {
            for (int i = 0; i < SAMP_RATES.length; ++i) {
                if (sampRate != SAMP_RATES[i]) continue;
                return sampRate;
            }
        }
        catch (Throwable t) {
            LogSupport.message(AudioBean.class, (String)"getPreferredSpeakerSampleRate", (String)("Cannot get speaker sample rate: " + t));
        }
        return SAMP_RATE_DEFAULT_FOR_SPKR;
    }

    protected static String getPreferredInputDevice(String prefix, Preferences preferences) {
        return preferences.getSetting(prefix + DEFAULT_INPUT_DEVICE);
    }

    protected static boolean getPreferredDefaultInputDevice(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + USE_DEFAULT_INPUT_DEVICE, true);
    }

    protected static String getPreferredOutputDevice(String prefix, Preferences preferences) {
        return preferences.getSetting(prefix + DEFAULT_OUTPUT_DEVICE);
    }

    public String getProvider() {
        return "Audio";
    }

    public String getSourceName() {
        return "Audio";
    }

    private String getStateName(int state) {
        return state >= 0 && state < DECODE_STATE.length ? DECODE_STATE[state] : "State #" + state;
    }

    private int getTalkerIndex(short talkerAddr) {
        for (int i = 0; i < this.talkerAddrs.length; ++i) {
            if (this.talkerAddrs[i] != talkerAddr) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTransmitAudioCmd() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.muteForSetup) {
                return false;
            }
            switch (this.state) {
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 13: {
                    if (this.floorIsFull()) {
                        return false;
                    }
                    this.updateState(1, null);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAudioCmd() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.muteForSetup) {
                return false;
            }
            switch (this.state) {
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    this.updateState(2, null);
                    return true;
                }
            }
            return false;
        }
    }

    private String getTalkLabel(boolean talkEnabled) {
        String talkLabel = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKPLAIN);
        return talkLabel;
    }

    public byte getTier() {
        this.impsApi = this.imps.findBest(ImpsAPI.class);
        return 32;
    }

    public String getTrackName() {
        return "";
    }

    private boolean groupListenersNotQuiesced() {
        LinkedList<ClientInfo> groupClientList = new LinkedList<ClientInfo>();
        ClientInfo ci = this.clients.getMyClient();
        short group = ci.getGroupID();
        for (ClientInfo thisClient : this.clients) {
            if (thisClient.getGroupID() != group || thisClient.getAddress() < 2) continue;
            groupClientList.add(thisClient);
        }
        return this.waitForClients(groupClientList);
    }

    protected boolean hasMikeBoost() {
        if (this.engine == null) {
            return false;
        }
        return this.engine.getMikeBoost() >= 0;
    }

    public boolean isInputDeviceSelectionSupported() {
        if (this.engine == null) {
            return false;
        }
        return this.engine.isInputDeviceSelectionSupported();
    }

    public boolean isMuted() {
        return this.mute;
    }

    public boolean isOutputDeviceSelectionSupported() {
        if (this.engine == null) {
            return false;
        }
        return this.engine.isOutputDeviceSelectionSupported();
    }

    private boolean isTelephonyBridge(short clientAddr) {
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        return telephony == null ? false : telephony.isBridge(clientAddr);
    }

    private boolean isSessionTeleconferenced() {
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        return telephony == null ? false : telephony.isConnected();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item = e.getItem();
        if (item == this.talkBtn) {
            this.processTalkPushed(this.talkBtn.isSelected());
        }
    }

    private void jbInit() throws Exception {
        this.mikeLabel.setIcon(this.MIKE_ICON);
        this.spkrLabel.setIcon(this.SPKR_ICON);
        if (Platform.getLAF() == 502) {
            this.talkBtn.putClientProperty("JButton.buttonType", "icon");
        }
        Insets mrgn = this.talkBtn.getMargin();
        int val = Math.min(mrgn.top, mrgn.left);
        Dimension talkDim = new Dimension(46 + 2 * val, 46 + 2 * val);
        this.talkBtn.setMargin(new Insets(val, val, val, val));
        this.talkBtn.setPreferredSize(talkDim);
        this.talkBtn.setEnabled(false);
        this.talkBtn.setHorizontalTextPosition(0);
        this.talkBtn.setVerticalTextPosition(3);
        this.talkBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKTIP));
        AccessibilityUtils.setAccessibleName((Object)this.talkBtn, (String)this.ACCESSIBLE_TALK);
        this.talkBtn.addItemListener(this);
        this.talkBtn.setIconTextGap(0);
        AccessibilityUtils.initComponent((JComponent)this.talkBtn);
        this.remoteTalkerDecBtn.setIcon(this.DEC_ICON);
        this.remoteTalkerDecBtn.setMaximumSize(new Dimension(14, 14));
        this.remoteTalkerDecBtn.setPreferredSize(new Dimension(14, 14));
        this.remoteTalkerDecBtn.setMinimumSize(new Dimension(14, 14));
        this.remoteTalkerDecBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_DECTIP));
        this.remoteTalkerDecBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AudioBean.this.adjustRemoteMikeGain((byte)18);
            }
        });
        this.remoteTalkerIncBtn.setIcon(this.INC_ICON);
        this.remoteTalkerIncBtn.setMaximumSize(new Dimension(14, 14));
        this.remoteTalkerIncBtn.setPreferredSize(new Dimension(14, 14));
        this.remoteTalkerIncBtn.setMinimumSize(new Dimension(14, 14));
        this.remoteTalkerIncBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_INCTIP));
        this.remoteTalkerIncBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AudioBean.this.adjustRemoteMikeGain((byte)17);
            }
        });
        for (int i = 0; i < 34; ++i) {
            this.remoteTalkerVUMeters[i] = new SpkrVUMeter(1);
            this.remoteTalkerVUMeters[i].setRange(32768);
            Dimension preferredSize = this.remoteTalkerIncBtn.getPreferredSize();
            preferredSize.width = 7 * preferredSize.height / 2;
            this.remoteTalkerVUMeters[i].setPreferredSize(preferredSize);
        }
        this.setLayout(this.beanLayout);
        this.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        this.northPanel.setLayout(this.northLayout);
        this.add((Component)this.northPanel, "North");
        this.buttonPanel.setLayout(this.buttonLayout);
        this.northPanel.add((Component)this.buttonPanel, "West");
        this.buttonPanel.add(Box.createVerticalGlue());
        this.talkPanel.setLayout(new BorderLayout(4, 0));
        this.talkPanel.add((Component)this.talkBtn, "Center");
        this.buttonPanel.add(this.talkPanel);
        this.buttonPanel.add(Box.createVerticalGlue());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.volPanel.setLayout(new BoxLayout(this.volPanel, 1));
        this.volPanel.add(Box.createVerticalGlue());
        this.volPanel.add(this.remoteTalkerIncBtn);
        this.volPanel.add(Box.createVerticalGlue());
        this.volPanel.add(this.remoteTalkerDecBtn);
        this.volPanel.add(Box.createVerticalGlue());
        this.volPanel.setVisible(true);
        this.talkPanel.add((Component)this.volPanel, "East");
        this.talkPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.talkPanel.getPreferredSize().height));
        this.northPanel.add((Component)this.centrePanel, "Center");
        this.centrePanel.setLayout(this.centreLayout);
        this.centrePanel.add((Component)this.vuPanel, null);
        BoxLayout vuLayout = new BoxLayout(this.vuPanel, 1);
        this.vuPanel.setLayout(vuLayout);
        this.vuPanel.add(Box.createVerticalGlue());
        this.vuPanel.add((Component)this.mikePanel, null);
        this.vuPanel.add(Box.createVerticalGlue());
        this.vuPanel.add((Component)this.spkrPanel, null);
        this.vuPanel.add(Box.createVerticalGlue());
        int h = this.centrePanel.getPreferredSize().height;
        if (h > this.buttonPanel.getPreferredSize().height) {
            this.northPanel.add(Box.createVerticalStrut(h), "East");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLoadTestAudioQueue() {
        if (this.loadTestAudio == null) {
            this.loadTestAudio = new LinkedList();
            try {
                byte[] audio = new Resource((Object)this, i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_SETUPAUDIO)).load();
                if (audio == null) {
                    audio = new Resource((Object)this, i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_SETUPAUDIOBACKUP)).load();
                }
                if (audio == null) {
                    throw new RuntimeException("Cannot find load-test prerecorded audio");
                }
                int MaxPieceSize = 18;
                for (int i = 0; i < audio.length; i += 18) {
                    int pieceSize = audio.length - i;
                    if (pieceSize > 18) {
                        pieceSize = 18;
                    }
                    byte[] piece = new byte[pieceSize];
                    System.arraycopy(audio, i, piece, 0, pieceSize);
                    this.loadTestAudio.addLast(piece);
                }
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"loadLoadTestAudioQueue", (Throwable)t, (boolean)false);
            }
        }
        Debug.lockEnter((Object)this, (String)"loadLoadTestAudioQueue", (String)"loadTestAudioQueue", (Object)this.loadTestAudioQueue);
        LinkedList linkedList = this.loadTestAudioQueue;
        synchronized (linkedList) {
            this.loadTestAudioQueue.clear();
            Iterator iterator = this.loadTestAudio.iterator();
            while (iterator.hasNext()) {
                this.loadTestAudioQueue.addLast(iterator.next());
            }
        }
        Debug.lockLeave((Object)this, (String)"loadLoadTestAudioQueue", (String)"loadTestAudioQueue", (Object)this.loadTestAudioQueue);
    }

    public void loadPreferences(String prefix, Preferences preferences) {
        String device;
        if (preferences.getBooleanSetting(prefix + ".loadTest", false)) {
            AudioDebug.LOAD_TEST.setEnabled(true);
        }
        if (preferences.getBooleanSetting(prefix + ".native", false)) {
            AudioDebug.NATIVE.setEnabled(true);
        }
        if (preferences.getBooleanSetting(prefix + ".useWaveAudio", false)) {
            AudioDebug.USE_WAVE_AUDIO.setEnabled(true);
        }
        this.audioInit();
        if (this.engine == null) {
            return;
        }
        String lastVer = preferences.getSetting("vclass.lastVersion", null);
        if (Platform.getPlatform() == 2 && lastVer != null && lastVer.compareTo("8.0") < 0) {
            preferences.clearSetting(prefix + SPKR_SAMP_RATE_PREF);
        }
        try {
            device = preferences.getSetting(prefix + DEFAULT_INPUT_DEVICE);
            LogSupport.message((Object)this, (String)"loadPreferences", (String)("audio.inputDevice = " + (device == null ? "null" : device)));
            this.engine.setInputDevice(device);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"loadPreferences", (String)("Cannot set audio input device: " + t));
        }
        try {
            device = preferences.getSetting(prefix + DEFAULT_OUTPUT_DEVICE);
            LogSupport.message((Object)this, (String)"loadPreferences", (String)("audio.outputDevice = " + (device == null ? "null" : device)));
            this.engine.setOutputDevice(device);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"loadPreferences", (String)("Cannot set audio output device: " + t));
        }
        if (this.hasMikeBoost()) {
            try {
                boolean boost = AudioBean.getPreferredMikeBoost(prefix, preferences);
                this.setMikeBoost(boost);
            }
            catch (Throwable t) {
                LogSupport.message((Object)this, (String)"loadPreferences", (String)("Cannot set mike boost: " + t));
            }
        }
        if (this.micLevelSliderFeature != null && this.micLevelSliderFeature.isEnabled()) {
            try {
                int mikeGain = preferences.getIntegerSetting(prefix + ".mikeLevel", 50);
                mikeGain = Math.max(mikeGain, 10);
                this.engine.setMikeGain(mikeGain);
                this.setMikeFeatureValue(mikeGain);
            }
            catch (Throwable t) {
                LogSupport.message((Object)this, (String)"loadPreferences", (String)("Cannot set mike gain: " + t));
            }
        }
        try {
            this.muteWhenTalking = AudioBean.getPreferredSpeakerMute(prefix, preferences);
            this.engine.setMuteWhenTalking(this.muteWhenTalking);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"loadPreferences", (String)("Cannot set muteWhenTalking: " + t));
        }
        try {
            int rate = AudioBean.getPreferredMikeSampleRate(prefix, preferences);
            this.engine.setMikeSampRate(rate);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"loadPreferences", (String)("Cannot set mike sample rate: " + t));
        }
        try {
            int rate = AudioBean.getPreferredSpeakerSampleRate(prefix, preferences);
            this.engine.setSpkrSampRate(rate);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"loadPreferences", (String)("Cannot set speaker sample rate: " + t));
        }
        if (this.volumeLevelSliderFeature.isEnabled()) {
            try {
                int spkrVol = preferences.getIntegerSetting(prefix + ".spkrLevel", 50);
                spkrVol = Math.max(spkrVol, 10);
                this.engine.setSpkrVolume(spkrVol);
                this.setSpkrFeatureValue(spkrVol);
            }
            catch (Throwable t) {
                LogSupport.message((Object)this, (String)"loadPreferences", (String)("Cannot set speaker volume: " + t));
            }
        }
        this.enableAGC = preferences.getBooleanSetting(prefix + AGC_PREF, true);
        this.enableBoostRestore = preferences.getBooleanSetting(prefix + ENABLE_BOOST_RESTORE_PREF, true);
        this.enablePeakLimit = preferences.getBooleanSetting(prefix + PEAK_LIMIT_PREF, true);
        this.engine.startEavesdrop();
    }

    private short loadShortField(byte[] buffer, int fieldOff) {
        return (short)((buffer[fieldOff] << 8) + (buffer[fieldOff + 1] & 0xFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTestTimerTask() {
        Debug.lockEnter((Object)this, (String)"loadTestTimerTask", (String)"loadTestAudioQueue", (Object)this.loadTestAudioQueue);
        LinkedList linkedList = this.loadTestAudioQueue;
        synchronized (linkedList) {
            if (this.loadTestAudioQueue.isEmpty()) {
                this.ignoreTimeOut = false;
                this.updateState(12, null);
                this.loadTestAudioStarted = false;
            } else {
                if (!this.loadTestAudioStarted) {
                    this.updateState(11, null);
                    this.loadTestAudioStarted = true;
                }
                int frameCnt = this.optimizationMode == 9 ? 12 : this.minMillisPerPacket / 20;
                int packetLen = frameCnt * 18;
                byte[] packet = new byte[packetLen];
                for (int packetOff = 0; packetOff < packetLen; packetOff += 18) {
                    byte[] ecelpData = (byte[])this.loadTestAudioQueue.removeFirst();
                    this.loadTestAudioQueue.addLast(ecelpData);
                    System.arraycopy(ecelpData, 0, packet, packetOff, 18);
                }
                if (this.myTalkerIdx != -1) {
                    this.fireChannelData(this.myTalkerIdx, packet);
                }
                this.loadTestTimerDesiredStart += (long)(frameCnt * 20);
                if (this.loadTestTimerDesiredStart <= Platform.currentTimeMillis()) {
                    this.loadTestTimer.scheduleIn(1L);
                } else {
                    this.loadTestTimer.scheduleAt(this.loadTestTimerDesiredStart);
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"loadTestTimerTask", (String)"loadTestAudioQueue", (Object)this.loadTestAudioQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mikeLevelChanged() {
        AudioBean audioBean = this;
        synchronized (audioBean) {
            if (this.ignoreMikeLevelChanges-- > 0 || this.micLevelSliderFeature == null || this.mikeFeatureSetting == (Integer)this.micLevelSliderFeature.getValue()) {
                return;
            }
            this.ignoreMikeLevelChanges = 0;
            this.mikeFeatureSetting = -1;
        }
        if (AudioDebug.GAIN.show()) {
            LogSupport.message((Object)this, (String)"mikeLevel_stateChanged", (String)("Mike slider set to: " + this.micLevelSliderFeature.getValue() + "%"));
        }
        if (this.engine != null) {
            int percent = (Integer)this.micLevelSliderFeature.getValue();
            if (percent <= 1) {
                this.module.disableAdjustMicLevelDownMenuItem();
                this.module.enableAdjustMicLevelUpMenuItem();
            } else if (percent >= 99) {
                this.module.disableAdjustMicLevelUpMenuItem();
                this.module.enableAdjustMicLevelDownMenuItem();
            } else {
                this.module.enableAdjustMicLevelDownMenuItem();
                this.module.enableAdjustMicLevelUpMenuItem();
            }
            this.engine.setMikeGain((Integer)this.micLevelSliderFeature.getValue());
        }
    }

    void moduleInstalled(AudioModule mod) {
        if (this.module != mod) {
            this.setModule(mod);
        }
        this.preferenceChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AudioBean.this.preferenceChange(e);
            }
        };
        Preferences prefs = mod.getPreferences();
        String prefix = mod.getPrefix();
        prefs.addSettingChangeListener(prefix + MIKE_SAMP_RATE_PREF, this.preferenceChangeListener);
        prefs.addSettingChangeListener(prefix + SPKR_SAMP_RATE_PREF, this.preferenceChangeListener);
        prefs.addSettingChangeListener(prefix + SPKR_MUTE_PREF, this.preferenceChangeListener);
        if (this.hasMikeBoost()) {
            prefs.addSettingChangeListener(prefix + MIKE_BOOST_PREF, this.preferenceChangeListener);
        }
        prefs.addSettingChangeListener(prefix + AGC_PREF, this.preferenceChangeListener);
        prefs.addSettingChangeListener(prefix + AGC_WEBRTC_PREF, this.preferenceChangeListener);
        prefs.addSettingChangeListener(prefix + PEAK_LIMIT_PREF, this.preferenceChangeListener);
        prefs.addSettingChangeListener(prefix + ENABLE_BOOST_RESTORE_PREF, this.preferenceChangeListener);
        if (this.engine != null) {
            this.module.exposeMikeBoostUI(this.hasMikeBoost());
            this.updateMikeLevelSlider();
            this.updateSpkrLevelSlider();
        }
    }

    protected void moduleUninstalled(AudioModule mod) {
        Preferences prefs = mod.getPreferences();
        String prefix = mod.getPrefix();
        prefs.removeSettingChangeListener(prefix + MIKE_SAMP_RATE_PREF, this.preferenceChangeListener);
        prefs.removeSettingChangeListener(prefix + SPKR_SAMP_RATE_PREF, this.preferenceChangeListener);
        prefs.removeSettingChangeListener(prefix + SPKR_MUTE_PREF, this.preferenceChangeListener);
        if (this.hasMikeBoost()) {
            prefs.removeSettingChangeListener(prefix + MIKE_BOOST_PREF, this.preferenceChangeListener);
        }
        prefs.removeSettingChangeListener(prefix + AGC_PREF, this.preferenceChangeListener);
        prefs.removeSettingChangeListener(prefix + AGC_WEBRTC_PREF, this.preferenceChangeListener);
        prefs.removeSettingChangeListener(prefix + PEAK_LIMIT_PREF, this.preferenceChangeListener);
        prefs.removeSettingChangeListener(prefix + ENABLE_BOOST_RESTORE_PREF, this.preferenceChangeListener);
    }

    @Override
    public void onAddClient(ClientEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelData(ChannelDataEvent cde) {
        int cmd = cde.getCommand() & 0xFF;
        if (cmd >= 64 || cmd == 3 || cmd == 4 || cmd == 13) {
            if (cmd < 64) {
                short address = this.loadShortField(cde.getContents(), 0);
                if (AudioDebug.FLOOR.show()) {
                    ClientInfo ci = this.clients.get(address);
                    LogSupport.message((Object)this, (String)"onChannelData", (String)("Received " + this.protocol.commandToString(cde.getCommand()) + " for " + (ci == null ? "#" + address : ci.getDisplayName())));
                }
                if (this.contentCaptureProvider.get().isCapturingData()) {
                    this.contentCapture.sendAudioGrant(address, cde.getCommand() == 3);
                }
            }
            if (this.recvQ == null) {
                LogSupport.error((Object)this, (String)"onChannelData", (String)"No receive queue");
            } else if (!this.mute || cde.getCommand() < 64) {
                this.recvQ.queueEvent(cde);
            }
            this.fireStreamingMedia(cde);
            return;
        }
        switch (cmd) {
            case 8: {
                if (cde.size() != 1) {
                    LogSupport.error((Object)this, (String)"onChannelData", (String)("Invalid ChangeAudioMode message recieved, " + cde.size() + " bytes recieved, 1 expected."));
                    break;
                }
                final byte mode = cde.getContents()[0];
                if (mode != 2 && mode != 1) {
                    LogSupport.error((Object)this, (String)"onChannelData", (String)("Invalid ChangeAudioMode request, mode=" + Integer.toHexString(mode & 0xFF)));
                }
                Runnable switcher = new Runnable(){

                    @Override
                    public void run() {
                        if (mode == 2) {
                            AudioBean.this.switchedOK = AudioBean.this.switchModeToTelephone(false);
                            AudioBean.this.updateState(14, Boolean.FALSE);
                        } else {
                            AudioBean.this.switchedOK = AudioBean.this.switchModeToVoIP(false);
                            AudioBean.this.updateState(15, Boolean.FALSE);
                        }
                        AudioBean.this.switchedOK = false;
                    }
                };
                SwingRunnerSupport.invokeLater((Runnable)switcher);
                break;
            }
            case 11: {
                Object object = this.stateLock;
                synchronized (object) {
                    this.optimizationMode = 0;
                    this.updateOptimizationMode();
                    break;
                }
            }
            case 5: {
                this.processStatusChanged(cde);
                break;
            }
            case 7: {
                if (this.spkrStatus != -1 && AudioDebug.IGNORE_STATUS_REQ.isEnabled()) {
                    LogSupport.message((Object)this, (String)"onChannelData", (String)"Ignoring STATUS_REQ");
                    break;
                }
                this.spkrStatus = -1;
                this.evaluateSpkrStatus();
                break;
            }
            case 16: {
                this.processVolAck(cde.getSourceAddress());
                break;
            }
            case 18: {
                if (this.micLevelSliderFeature == null) break;
                int oldDecValue = (Integer)this.micLevelSliderFeature.getValue();
                this.adjustLocalMikeGain(cde.getSourceAddress(), 0.9f);
                if (!this.useLegacy() || (Integer)this.micLevelSliderFeature.getValue() >= this.lastPeakLimit) break;
                this.lastPeakLimit -= oldDecValue - (Integer)this.micLevelSliderFeature.getValue();
                break;
            }
            case 17: {
                if (this.micLevelSliderFeature == null) break;
                int oldIncValue = (Integer)this.micLevelSliderFeature.getValue();
                this.adjustLocalMikeGain(cde.getSourceAddress(), 1.1f);
                if (!this.useLegacy() || (Integer)this.micLevelSliderFeature.getValue() <= this.lastPeakLimit) break;
                this.lastPeakLimit += (Integer)this.micLevelSliderFeature.getValue() - oldIncValue;
                break;
            }
            default: {
                LogSupport.error((Object)this, (String)"onChannelData", (String)("Illegal AudioProtocol command code: " + cmd));
            }
        }
    }

    public void recordingComplete() {
        this.nowRecording = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInput(InputEvent ie) {
        if (this.nowRecording) {
            this.audioSetupWizard.onInput(ie);
        }
        try {
            Debug.lockEnter((Object)this, (String)"onInput", (String)"stateLock", (Object)this.stateLock);
            Object object = this.stateLock;
            synchronized (object) {
                block14: {
                    if (this.xmitQ == null) break block14;
                    this.xmitQ.queueEvent(ie);
                    return;
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"onInput", (String)"stateLock", (Object)this.stateLock);
        }
        switch (ie.getKind()) {
            case 4: {
                this.runningGain = 1.0;
                this.updateState(11, null);
                break;
            }
            case 5: {
                this.updateState(12, null);
                break;
            }
            case 3: {
                this.updateState(10, ie);
                break;
            }
            default: {
                String msg = "Invalid input event code: " + ie.getKind();
                LogSupport.exception((Object)this, (String)"onInput", (Throwable)new RuntimeException(msg), (boolean)false);
            }
        }
    }

    @Override
    public void onReceive(ChannelDataEvent cde) {
        int cmd;
        if (this.recvQ == null) {
            return;
        }
        if (AudioDebug.GENERAL.show()) {
            LogSupport.message((Object)this, (String)"onReceive", (String)cde.toString());
        }
        if ((cmd = cde.getCommand() & 0xFF) >= 64) {
            this.updateState(16, cde);
        } else if (cmd == 3 || cmd == 4) {
            byte[] contents = cde.getContents();
            short who = this.loadShortField(contents, 0);
            if (who == this.myAddr) {
                if (cmd == 3) {
                    this.updateState(5, contents);
                } else {
                    this.updateState(7, contents);
                }
            } else if (cmd == 3) {
                this.updateState(6, contents);
            } else {
                this.updateState(8, contents);
            }
        } else if (cmd == 13) {
            byte[] contents = cde.getContents();
            short who = this.loadShortField(contents, 0);
            if (who != 1 && who != 0) {
                this.announceSpeaker(cde);
            }
        } else {
            LogSupport.error((Object)this, (String)"onReceive", (String)("Invalid ChannelDataCommand code: " + cmd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceSpeaker(ChannelDataEvent cde) {
        DataInputStream in = null;
        try {
            in = cde.read();
            Short speaker = in.readShort();
            this.followTheSpeakerAPIImpl.fireSpeakerChanged(speaker);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"announceSpeaker", (Throwable)ex, (boolean)true);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void onRemoveClient(ClientEvent event) {
        ClientInfo ci;
        short clientAddr = event.getAddress();
        if (clientAddr == this.volAckPending) {
            this.processVolAck(clientAddr);
        }
        if (event.isMe()) {
            this.clearStatusIndicators();
        }
        if ((ci = this.clients.get(clientAddr)) != null) {
            this.participantStatus.remove(ci);
        }
    }

    @Override
    public void onTransmit(InputEvent ie) {
        if (this.pending != null) {
            InputEvent temp = this.pending;
            this.pending = null;
            this.onTransmit(temp);
        }
        switch (ie.getKind()) {
            case 4: {
                this.first = true;
                this.updateState(11, ie);
                break;
            }
            case 5: {
                this.updateState(12, ie);
                break;
            }
            case 3: {
                if (this.first && this.maxVoIPTalkers < 2) {
                    this.pending = ie;
                    this.first = false;
                    break;
                }
                this.updateState(10, ie);
                break;
            }
            default: {
                LogSupport.error((Object)this, (String)"onTransmit", (String)("Unsupported ChannelDataEvent operation - " + ie.getKind()));
            }
        }
    }

    private void openOutgoingSaveFile() {
        if (this.outgoingSaveStrm == null && AudioDebug.SAVE_OUTGOING.isEnabled()) {
            try {
                String tempDir = System.getProperty("java.io.tmpdir");
                File outgoingSaveFile = null;
                for (int i = 1; i < 1000 && (outgoingSaveFile = new File(tempDir, "outgoing." + i)).exists(); ++i) {
                }
                this.outgoingSaveStrm = new BufferedOutputStream(new FileOutputStream(outgoingSaveFile));
                LogSupport.message((String)("ECELP audio file written to: " + outgoingSaveFile.getAbsolutePath()));
            }
            catch (Throwable t) {
                LogSupport.error((Object)this, (String)"openOutgoingSaveFile", (String)("Cannot create outgoing save file:\n" + t));
                this.outgoingSaveStrm = null;
            }
        }
    }

    private boolean populateAudioSubmenu() {
        boolean isModerator;
        boolean isPopulated = false;
        this.audioSubmenu.remove(this.audioSubmenuSeparator);
        this.audioSubmenu.remove(this.remoteMuteWhenTalkingMenuItem);
        this.audioSubmenu.remove(this.remoteUnmuteWhenTalkingMenuItem);
        this.audioSubmenu.remove(this.waitForListenersMenuItem);
        this.audioSubmenu.remove(this.waitForSelectedListenersMenuItem);
        this.audioSubmenu.remove(this.remoteModeChangeMenuItem);
        boolean groupVoIPMembersSelected = false;
        this.remoteMuteWhenTalkingClient = null;
        this.remoteModeChangeClient = null;
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        boolean bl = isModerator = chair != null && chair.isMe();
        if (this.selector != null && this.clients.getMyClient() != null) {
            short group = this.clients.getMyClient().getGroupID();
            List selectedClients = this.selector.getSelectedParticipants();
            for (CRParticipant part : selectedClients) {
                if (part.getRoom().getID() != group || part.getID() < 2) continue;
                short clientAddr = part.getID();
                int clientMode = 0;
                if (this.module != null) {
                    clientMode = this.module.getAudioMode(clientAddr);
                }
                if (clientMode == 2) continue;
                groupVoIPMembersSelected = true;
                break;
            }
            if (isModerator && selectedClients.size() == 1) {
                short clientAddr = ((CRParticipant)selectedClients.get(0)).getID();
                ClientInfo ci = this.clients.get(clientAddr);
                int clientMode = 0;
                if (this.module != null) {
                    clientMode = this.module.getAudioMode(clientAddr);
                }
                if (!this.module.isTelephonyEnabled() || clientMode == 1) {
                    this.remoteMuteWhenTalkingClient = ci;
                }
                if (clientMode == 1 || clientMode == 2) {
                    this.remoteModeChangeClient = ci;
                }
            }
        }
        if (this.haveTheFloor && !this.muteForSetup) {
            this.audioSubmenu.add(this.waitForListenersMenuItem);
            isPopulated = true;
            if (groupVoIPMembersSelected) {
                this.audioSubmenu.add(this.waitForSelectedListenersMenuItem);
            }
        }
        if (isModerator) {
            if (this.remoteMuteWhenTalkingClient != null) {
                boolean isMuted;
                if (isPopulated) {
                    this.audioSubmenu.add(this.audioSubmenuSeparator);
                }
                this.audioSubmenu.add((isMuted = this.remoteMuteWhenTalkingClient.getProperty("audioMuteWhenTalking", false)) ? this.remoteUnmuteWhenTalkingMenuItem : this.remoteMuteWhenTalkingMenuItem);
                isPopulated = true;
            }
            if (this.module.isTelephonyEnabled() && this.remoteModeChangeClient != null) {
                String itemText = null;
                short addr = this.remoteModeChangeClient.getAddress();
                int clientMode = 0;
                if (this.module != null) {
                    clientMode = this.module.getAudioMode(addr);
                }
                if (clientMode == 2) {
                    itemText = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_REMOTEMODECHANGEVOIP);
                } else if (clientMode == 1) {
                    itemText = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_REMOTEMODECHANGETELEPHONE);
                }
                if (itemText != null) {
                    if (isPopulated && this.remoteMuteWhenTalkingClient == null) {
                        this.audioSubmenu.add(this.audioSubmenuSeparator);
                    }
                    this.remoteModeChangeMenuItem.setEnabled(this.getTalkerIndex(addr) < 0);
                    this.remoteModeChangeMenuItem.setText(itemText);
                    this.audioSubmenu.add(this.remoteModeChangeMenuItem);
                    isPopulated = true;
                }
            }
        }
        return isPopulated;
    }

    private void preferenceChange(PropertyChangeEvent e) {
        if (this.engine == null) {
            return;
        }
        String prop = e.getPropertyName();
        if (prop.endsWith(MIKE_SAMP_RATE_PREF)) {
            this.engine.setMikeSampRate(Preferences.integerValue((Object)e.getNewValue(), (int)44100));
        } else if (prop.endsWith(SPKR_SAMP_RATE_PREF)) {
            this.engine.setSpkrSampRate(Preferences.integerValue((Object)e.getNewValue(), (int)SAMP_RATE_DEFAULT_FOR_SPKR));
        } else if (prop.endsWith(MIKE_BOOST_PREF)) {
            this.setMikeBoost(Preferences.booleanValue((Object)e.getNewValue(), (boolean)false));
        } else if (prop.endsWith(SPKR_MUTE_PREF)) {
            this.muteWhenTalking = Preferences.booleanValue((Object)e.getNewValue(), (boolean)false);
            this.engine.setMuteWhenTalking(this.muteWhenTalking);
            ClientInfo me = this.clients.getMyClient();
            if (me != null) {
                me.setProperty("audioMuteWhenTalking", this.muteWhenTalking);
            }
        } else if (prop.endsWith(AGC_WEBRTC_PREF)) {
            this.enableWebrtcAGC = Preferences.booleanValue((Object)e.getNewValue(), (boolean)true);
        } else if (prop.endsWith(AGC_PREF)) {
            this.enableAGC = Preferences.booleanValue((Object)e.getNewValue(), (boolean)true);
        } else if (prop.endsWith(ENABLE_BOOST_RESTORE_PREF)) {
            this.enableBoostRestore = Preferences.booleanValue((Object)e.getNewValue(), (boolean)true);
        } else if (prop.endsWith(PEAK_LIMIT_PREF)) {
            this.enablePeakLimit = Preferences.booleanValue((Object)e.getNewValue(), (boolean)true);
            this.runningGain = 1.0;
        }
    }

    private void processStatusChanged(ChannelDataEvent cde) {
        try {
            DataInputStream str = cde.read();
            short count = str.readShort();
            for (short i = 0; i < count; i = (short)(i + 1)) {
                short address = str.readShort();
                byte status = str.readByte();
                ClientInfo ci = this.clients.get(address);
                if (ci != null && AudioDebug.STATUS.show()) {
                    LogSupport.message((Object)this, (String)"processStatusChanged", (String)(AudioProtocol.decodeStatus((int)status) + " received for " + ci.getDisplayName()));
                }
                if (ci == null || ci == this.clients.getMyClient()) continue;
                this.showStatus(ci, status);
            }
            str.close();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"processStatusChanged", (Throwable)t, (boolean)true, (String)"Processing STATUS_CHANGED");
        }
    }

    private void processTalkPushed(boolean pressed) {
        if (!this.settingButtonState) {
            if (this.muteForSetup) {
                return;
            }
            if (this.buttonUpdatesPending < 1) {
                if (pressed) {
                    this.updateState(1, null);
                } else {
                    this.updateState(2, null);
                    this.audioVoipFeature.setEnabled(true);
                    this.audioVoip2Feature.setEnabled(true);
                }
            } else {
                this.settingButtonState = true;
                if (this.talkFeature != null) {
                    this.talkFeature.setValue((Object)(!pressed ? 1 : 0));
                }
                this.settingButtonState = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVolAck(short who) {
        Debug.lockEnter((Object)this, (String)"processVolAck", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            if (who == this.volAckPending) {
                this.volAckPending = (short)-32767;
                this.refreshButtonState();
            }
        }
        Debug.lockLeave((Object)this, (String)"processVolAck", (String)"stateLock", (Object)this.stateLock);
    }

    public boolean setMaximumTalkersCmd(int maxTalkersParameter) {
        boolean isModerator;
        if (maxTalkersParameter < 1 || maxTalkersParameter > 6) {
            return false;
        }
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        boolean bl = isModerator = chair != null && chair.isMe();
        if (!isModerator) {
            return false;
        }
        if (maxTalkersParameter != this.maxVoIPTalkers) {
            this.clients.setProperty("audioMaxVOIPTalkers", new Integer(maxTalkersParameter).intValue());
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        short addr = this.clients.getPropertyOwner(event.getSource());
        String pName = event.getPropertyName();
        if (GroupwareDebug.EVENTS.show()) {
            LogSupport.message((Object)this, (String)"propertyChange", (String)(event.toString() + ": " + event.getPropertyName() + "(" + event.getOldValue() + "->" + event.getNewValue() + ")"));
        }
        if (pName.equals("audioFloor") && addr == this.clients.getMyAddress()) {
            ClientInfo me = this.clients.getMyClient();
            if (me.getProperty("audioFloor", false)) {
                this.updateState(17, null);
            } else {
                this.updateState(18, null);
            }
        } else {
            if (pName.equals("audioMaxVOIPTalkers")) {
                this.maxVoIPTalkers = this.clients.getProperty("audioMaxVOIPTalkers", 1);
                this.updateOptimizationMode();
                this.refreshButtonState();
                return;
            }
            if (pName.equals("audioMaxVOIPTalkersLimit")) {
                this.maxVoIPTalkersLimit = this.clients.getProperty("audioMaxVOIPTalkersLimit", 6);
                if (this.maxVoIPTalkers > this.maxVoIPTalkersLimit) {
                    this.maxVoIPTalkers = this.maxVoIPTalkersLimit;
                    this.updateOptimizationMode();
                }
                this.refreshButtonState();
                return;
            }
            if (pName.equals("audioMinMillisPerPacket")) {
                this.minMillisPerPacket = this.clients.getProperty("audioMinMillisPerPacket", 20);
                this.minMillisPerPacket = this.minMillisPerPacket <= 20 ? 20 : (this.minMillisPerPacket >= 240 ? 240 : (this.minMillisPerPacket + 20 - 1) / 20 * 20);
                if (this.optimizationMode == 10 && this.engine != null) {
                    this.engine.setMikeMillisPerPacket(this.minMillisPerPacket);
                }
            } else if (pName.equals("audioMuteWhenTalking") && addr == this.clients.getMyAddress()) {
                ClientInfo me = this.clients.getMyClient();
                if (this.muteWhenTalking != me.getProperty("audioMuteWhenTalking", false) && this.connected) {
                    this.muteWhenTalking = !this.muteWhenTalking;
                    Preferences prefs = this.module.getPreferences();
                    prefs.setSetting(this.module.getPrefix() + SPKR_MUTE_PREF, this.muteWhenTalking);
                    ModalDialog.showMessageDialogAsync((int)10, (Component)this.getAppFrame(), (Object)i18n.getString((PropertiesEnum)(this.muteWhenTalking ? StringsProperties.AUDIOBEAN_SPKRSMUTEDBYCHAIR : StringsProperties.AUDIOBEAN_SPKRSUNMUTEDBYCHAIR), new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_WARNINGTITLE), (int)2);
                }
            } else if (pName.equals("chair")) {
                int i;
                boolean wasOldChair = false;
                boolean isNewChair = false;
                short[] newChairs = (short[])event.getNewValue();
                short[] oldChairs = (short[])event.getOldValue();
                if (oldChairs != null) {
                    for (i = 0; i < oldChairs.length; ++i) {
                        if (this.myAddr != oldChairs[i]) continue;
                        wasOldChair = true;
                        break;
                    }
                }
                if (wasOldChair) {
                    if (newChairs != null) {
                        for (i = 0; i < newChairs.length; ++i) {
                            if (this.myAddr != newChairs[i]) continue;
                            isNewChair = true;
                            break;
                        }
                    }
                    if (!isNewChair && !this.haveTheFloor) {
                        this.clearStatusIndicators();
                    }
                }
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Chair chair = ChairProtocol.getChair((ClientList)AudioBean.this.clients);
                        AudioBean.this.volPanel.setVisible(chair.isMe());
                        AudioBean.this.updateTelephonyUI();
                    }
                });
            } else if (pName.equals("audioWebrtcCompressionGain")) {
                this.webrtcCompressionGain = this.clients.getProperty("audioWebrtcCompressionGain", 5);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.webrtcCompressionGainSpinner.setValue(new Integer(AudioBean.this.webrtcCompressionGain));
                        }
                    });
                }
            } else if (pName.equals("audioWebrtcTargetLevel")) {
                this.webrtcTargetLevel = this.clients.getProperty("audioWebrtcTargetLevel", 6);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.webrtcTargetLevelSpinner.setValue(new Integer(AudioBean.this.webrtcTargetLevel));
                        }
                    });
                }
            } else if (pName.equals("audioMillisBetweenBoosts")) {
                this.millisBetweenBoosts = this.clients.getProperty("audioMillisBetweenBoosts", 200);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.millisBetweenBoostsSpinner.setValue(new Integer(AudioBean.this.millisBetweenBoosts));
                        }
                    });
                }
            } else if (pName.equals("audioNonsilenceGainBoostThreshold")) {
                this.nonsilenceGainBoostThreshold = this.clients.getProperty("audioNonsilenceGainBoostThreshold", 1000);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.nonsilenceGainBoostThresholdSpinner.setValue(new Integer(AudioBean.this.nonsilenceGainBoostThreshold));
                        }
                    });
                }
            } else if (pName.equals("audioNonsilenceThreshold")) {
                this.nonsilenceThreshold = this.clients.getProperty("audioNonsilenceThreshold", 2000);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.nonsilenceThresholdSpinner.setValue(new Integer(AudioBean.this.nonsilenceThreshold));
                        }
                    });
                }
            } else if (pName.equals("audioRetainedSilenceLimit")) {
                this.retainedSilenceLimit = this.clients.getProperty("audioRetainedSilenceLimit", 20);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.retainedSilenceLimitSpinner.setValue(new Integer(AudioBean.this.retainedSilenceLimit));
                        }
                    });
                }
            } else if (pName.equals("audioSilenceSustainLimit")) {
                this.silenceSustainLimit = this.clients.getProperty("audioSilenceSustainLimit", 1500);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.silenceSustainLimitSpinner.setValue(new Integer(AudioBean.this.silenceSustainLimit));
                        }
                    });
                }
            } else if (pName.equals("audioTalkerSilenceLimit")) {
                this.talkerSilenceLimit = this.clients.getProperty("audioTalkerSilenceLimit", 2);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.talkerSilenceLimitSpinner.setValue(new Integer(AudioBean.this.talkerSilenceLimit));
                        }
                    });
                }
            } else if (pName.equals("audioMuteThreshold")) {
                this.muteThreshold = this.clients.getProperty("audioMuteThreshold", 10);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.muteThresholdSpinner.setValue(new Integer(AudioBean.this.muteThreshold));
                        }
                    });
                }
            } else if (pName.equals("audioNoiseFloorSamplePeriod")) {
                this.noiseFloorSamplePeriod = this.clients.getProperty("audioNoiseFloorSamplePeriod", 500);
                if (this.parametersDlg != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AudioBean.this.noiseFloorSamplePeriodSpinner.setValue(new Integer(AudioBean.this.noiseFloorSamplePeriod));
                        }
                    });
                }
            } else if (pName.equals("audioBoostPeakRestorePercent")) {
                this.boostPeakRestorePercentLimit = this.clients.getProperty("audioBoostPeakRestorePercent", 50);
                try {
                    if (this.parametersDlg != null) {
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AudioBean.this.boostPeakRestorePercentLimitSpinner.setValue(AudioBean.this.boostPeakRestorePercentLimit);
                            }
                        });
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    private void quenchWatchdog() {
        this.ignoreTimeOut = true;
        if (this.watchdogTimer.cancel()) {
            this.stateMessage("Watchdog timer quenched");
        } else {
            this.stateMessage("Unable to quench watchdog timer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshButtonState() {
        Debug.lockEnter((Object)this, (String)"refreshButtonState", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            this.setState(this.state);
        }
        Debug.lockLeave((Object)this, (String)"refreshButtonState", (String)"stateLock", (Object)this.stateLock);
    }

    private void releaseFloor() {
        if (AudioDebug.SUPPRESS_FLOOR_RELEASE.isEnabled()) {
            this.startWatchdog(5000);
            this.stateMessage("Suppressing AudioProtocol.FLOOR_RELEASE");
        } else if (AudioDebug.STALL_FLOOR_RELEASE.isEnabled()) {
            this.startWatchdog(5000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Firing AudioProtocol.FLOOR_RELEASE");
                    AudioBean.this.fireChannelData((byte)2);
                }
            }).scheduleIn(15000L);
        } else if (AudioDebug.DELAY_FLOOR_RELEASE.isEnabled()) {
            this.startWatchdog(10000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Firing AudioProtocol.FLOOR_RELEASE");
                    AudioBean.this.fireChannelData((byte)2);
                }
            }).scheduleIn(5000L);
        } else {
            this.startWatchdog(5000);
            this.stateMessage("Firing AudioProtocol.FLOOR_RELEASE");
            this.fireChannelData((byte)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseMike() {
        this.timedOutReleasingMike = false;
        this.clearQueuedECELP();
        if (AudioDebug.LOAD_TEST.isEnabled()) {
            Debug.lockEnter((Object)this, (String)"releaseMike", (String)"loadTestAudioQueue", (Object)this.loadTestAudioQueue);
            LinkedList linkedList = this.loadTestAudioQueue;
            synchronized (linkedList) {
                this.loadTestAudioQueue.clear();
            }
            Debug.lockLeave((Object)this, (String)"releaseMike", (String)"loadTestAudioQueue", (Object)this.loadTestAudioQueue);
        } else if (AudioDebug.SUPPRESS_MIKE_RELEASE.isEnabled()) {
            this.startWatchdog(5000);
            this.stateMessage("Suppressing engine.stopInput()");
        } else if (AudioDebug.STALL_MIKE_RELEASE.isEnabled()) {
            this.startWatchdog(5000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Calling engine.stopInput()");
                    AudioBean.this.engine.stopInput();
                }
            }).scheduleIn(5100L);
        } else if (AudioDebug.DELAY_MIKE_RELEASE.isEnabled()) {
            this.startWatchdog(10000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Calling engine.stopInput()");
                    AudioBean.this.engine.stopInput();
                }
            }).scheduleIn(5000L);
        } else {
            this.startWatchdog(5000);
            this.stateMessage("Calling engine.stopInput()");
            this.engine.stopInput();
        }
        if (this.outgoingSaveStrm != null) {
            this.closeOutgoingSaveFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener lst) {
        Debug.lockEnter((Object)this, (String)"removeChangeListener", (String)"changeListeners", (Object)this.changeListeners);
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            this.changeListeners.remove(lst);
        }
        Debug.lockLeave((Object)this, (String)"removeChangeListener", (String)"changeListeners", (Object)this.changeListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreamingMediaListener(StreamingMediaListener l) {
        LinkedList linkedList = this.streamingMediaListeners;
        synchronized (linkedList) {
            this.streamingMediaListeners.remove(l);
        }
    }

    private void removeTalker(short talkerAddr) {
        if (talkerAddr == -32767) {
            throw new IllegalArgumentException("talkerAddr = NULL_ADDRESS");
        }
        int talkerIdx = this.getTalkerIndex(talkerAddr);
        if (talkerIdx < 0) {
            ClientInfo ci = this.clients.get(talkerAddr);
            LogSupport.message((Object)this, (String)"removeTalker", (String)("Talker not found: " + (ci == null ? "Unknown" : ci.getDisplayName())));
        } else {
            this.talkerAddrs[talkerIdx] = -32767;
            this.updateTalkerDesc();
        }
    }

    private void requestFloor() {
        if (AudioDebug.SUPPRESS_FLOOR_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
            this.stateMessage("Suppressing AudioProtocol.FLOOR_REQUEST");
        } else if (AudioDebug.DENY_FLOOR_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Faking floor request denial");
                    AudioBean.this.updateState(7, null);
                }
            }).scheduleIn(2500L);
        } else if (AudioDebug.STALL_FLOOR_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
        } else if (AudioDebug.DELAY_FLOOR_REQUEST.isEnabled()) {
            this.startWatchdog(10000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Firing AudioProtocol.FLOOR_REQUEST");
                    AudioBean.this.fireChannelData((byte)1);
                }
            }).scheduleIn(5000L);
        } else {
            this.startWatchdog(5000);
            this.stateMessage("Firing AudioProtocol.FLOOR_REQUEST");
            this.fireChannelData((byte)1);
        }
    }

    private void requestMike() {
        this.timedOutRequestingMike = false;
        this.clearQueuedECELP();
        if (AudioDebug.LOAD_TEST.isEnabled()) {
            this.loadLoadTestAudioQueue();
            if (this.loadTestTimer == null) {
                this.loadTestTimer = new LightweightTimer(new Runnable(){

                    @Override
                    public void run() {
                        AudioBean.this.loadTestTimerTask();
                    }
                });
            }
            this.loadTestTimerDesiredStart = Platform.currentTimeMillis() + 1L;
            this.loadTestTimer.scheduleAt(this.loadTestTimerDesiredStart);
        } else if (AudioDebug.SUPPRESS_MIKE_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
            this.stateMessage("Suppressing engine.startInput()");
        } else if (AudioDebug.DENY_MIKE_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Faking mike request denial");
                    AudioBean.this.updateState(12, null);
                }
            }).scheduleIn(2500L);
        } else if (AudioDebug.STALL_MIKE_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Calling engine.startInput()");
                    AudioBean.this.engine.startInput();
                }
            }).scheduleIn(5100L);
        } else if (AudioDebug.DELAY_MIKE_REQUEST.isEnabled()) {
            this.startWatchdog(10000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioBean.this.stateMessage("Calling engine.startInput()");
                    AudioBean.this.engine.startInput();
                }
            }).scheduleIn(5000L);
        } else {
            this.startWatchdog(5000);
            this.stateMessage("Calling engine.startInput()");
            this.engine.startInput();
        }
    }

    public void savePreferences(String prefix, Preferences preferences) {
        String device;
        if (this.engine == null) {
            return;
        }
        if (this.micLevelSliderFeature != null && this.micLevelSliderFeature.isEnabled()) {
            preferences.setSetting(prefix + ".mikeLevel", ((Integer)this.micLevelSliderFeature.getValue()).intValue());
        }
        try {
            if (this.engine.isInputDeviceSelectionSupported()) {
                device = this.engine.getInputDevice();
                if (device != null) {
                    preferences.setSetting(prefix + DEFAULT_INPUT_DEVICE, device);
                } else {
                    preferences.clearSetting(prefix + DEFAULT_INPUT_DEVICE);
                }
            }
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"savePreferences", (String)("Cannot save audio input device: " + t));
        }
        try {
            if (this.engine.isOutputDeviceSelectionSupported()) {
                device = this.engine.getOutputDevice();
                if (device != null) {
                    preferences.setSetting(prefix + DEFAULT_OUTPUT_DEVICE, device);
                } else {
                    preferences.clearSetting(prefix + DEFAULT_OUTPUT_DEVICE);
                }
            }
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"savePreferences", (String)("Cannot save audio output device: " + t));
        }
        if (this.volumeLevelSliderFeature.isEnabled()) {
            preferences.setSetting(prefix + ".spkrLevel", ((Integer)this.volumeLevelSliderFeature.getValue()).intValue());
        }
        preferences.setSetting(prefix + AGC_PREF, this.enableAGC);
        preferences.setSetting(prefix + AGC_WEBRTC_PREF, this.enableWebrtcAGC);
        preferences.setSetting(prefix + ENABLE_BOOST_RESTORE_PREF, this.enableBoostRestore);
        preferences.setSetting(prefix + PEAK_LIMIT_PREF, this.enablePeakLimit);
        preferences.setSetting(prefix + ".loadTest", AudioDebug.LOAD_TEST.isEnabled());
        preferences.setSetting(prefix + ".native", AudioDebug.NATIVE.isEnabled());
        preferences.setSetting(prefix + ".useWaveAudio", AudioDebug.USE_WAVE_AUDIO.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAudioInput() {
        if (this.engine == null) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    ModalDialog.showMessageDialogAsync((int)10, (Component)this.getAppFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_INPUTSELECTIONWHILETALKINGMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_AUDIOSETUPERRORCAP), (int)0);
                    return;
                }
            }
        }
        String title = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_INPUTSELECTIONDLGTITLE);
        EasyDialog d = new EasyDialog((Component)this.getAppFrame(), title);
        JButton okBtn = d.makeButton(1);
        okBtn.setEnabled(false);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AudioBean.this.inputSelectionPanel.apply();
                AudioBean.this.module.exposeMikeBoostUI(AudioBean.this.hasMikeBoost());
                AudioBean.this.updateMikeLevelSlider();
            }
        });
        this.inputSelectionPanel = this.engine.getInputDeviceSelectionPanel(okBtn, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        d.setContent((Component)this.inputSelectionPanel.getSelectionPanel());
        d.addActionButton(okBtn, true);
        d.addCancelButton(d.makeButton(0));
        d.setInitialFocus((Component)this.inputSelectionPanel.getSelectionPanel());
        d.show();
    }

    public void selectAudioOutput() {
        if (this.engine == null) {
            return;
        }
        String title = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_OUTPUTSELECTIONDLGTITLE);
        EasyDialog d = new EasyDialog((Component)this.getAppFrame(), title);
        JButton okBtn = d.makeButton(1);
        okBtn.setEnabled(false);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AudioBean.this.outputSelectionPanel.apply();
                AudioBean.this.updateSpkrLevelSlider();
            }
        });
        this.outputSelectionPanel = this.engine.getOutputDeviceSelectionPanel(okBtn, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        d.setContent((Component)this.outputSelectionPanel.getSelectionPanel());
        d.addActionButton(okBtn, true);
        d.addCancelButton(d.makeButton(0));
        d.setInitialFocus((Component)this.outputSelectionPanel.getSelectionPanel());
        this.engine.suspendSpkr();
        d.show();
        this.engine.resumeSpkr();
    }

    private boolean selectedListenersNotQuiesced() {
        List who = null;
        if (this.selector == null) {
            return false;
        }
        who = this.selector.getSelectedClients();
        return this.waitForClients(who);
    }

    private void sendECELPData(short[] samples) {
        byte[] ecelpData = this.mikeCodec.encode(samples);
        this.fireChannelData(this.myTalkerIdx, ecelpData);
        if (this.outgoingSaveStrm != null) {
            this.writeOutgoingSaveFile(ecelpData);
        }
    }

    private void sendStatus(int status) {
        if (status == this.spkrStatus) {
            return;
        }
        this.spkrStatus = status;
        this.showStatus(this.clients.getMyClient(), status);
        try {
            ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)5);
            DataOutputStream ostr = cde.write();
            ostr.writeShort(1);
            ostr.writeShort(this.client.getAddress());
            ostr.writeByte(status);
            ostr.close();
            this.fireChannelData(cde);
            if (AudioDebug.STATUS.show()) {
                LogSupport.message((Object)this, (String)"sendStatus", (String)("Sent " + AudioProtocol.decodeStatus((int)status)));
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"sendStatus", (Throwable)ioe, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVolumeAdjustment(byte op, short who) {
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        if (!chair.isMe()) {
            return;
        }
        Debug.lockEnter((Object)this, (String)"sendVolumeAdjustment", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            if (who != -32767) {
                ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)who, (byte)op);
                this.fireChannelData(cde);
                this.volAckPending = who;
                this.refreshButtonState();
            }
        }
        Debug.lockLeave((Object)this, (String)"sendVolumeAdjustment", (String)"stateLock", (Object)this.stateLock);
    }

    private void setButtonState(final String context, final boolean talkEnabled, final boolean talkSelected, final ImageIcon talkIcon, final String talkText, final String talkTip, final boolean volAdjEnabled, final boolean telModeBtnEnabled) {
        ++this.buttonUpdatesPending;
        final int deferredFrom = this.stateMessage(context + " InvokeLater");
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AudioBean.this.updateButton(context, talkEnabled, talkSelected, talkIcon, talkText, talkTip, volAdjEnabled, telModeBtnEnabled, deferredFrom);
            }
        });
    }

    private void setButtonState(String context, boolean talkEnabled, boolean talkSelected, String talkText, String talkTip, boolean volAdjEnabled, boolean telModeBtnEnabled) {
        this.setButtonState(context, talkEnabled, talkSelected, null, talkText, talkTip, volAdjEnabled, telModeBtnEnabled);
    }

    public void setClient(Client theClient) {
        this.setClient(theClient, (JinxProtocol)new AudioProtocol(false), this, this, this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener(this.audioPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.audioPermissionDelegate));
        this.clients.addDefaultPropertyChangeListener(this.audioPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.audioPermissionDelegate));
        this.clients.addPropertyChangeListener((byte)0, (PropertyChangeListener)new AudioAnnotationProvider());
        this.remoteMuteWhenTalkingMenuItem.setText(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MUTESELECTEDTALKERSSPKRS));
        this.remoteMuteWhenTalkingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (AudioBean.this.remoteMuteWhenTalkingClient == null) {
                    return;
                }
                if (ModalDialog.showConfirmDialog((Component)AudioBean.this.getAppFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_CONFIRMSPKRMUTE, new Object[]{AudioBean.this.remoteMuteWhenTalkingClient.getDisplayName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_QUERYTITLE), (int)0, (int)3) == 0) {
                    AudioBean.this.remoteMuteWhenTalkingClient.setProperty("audioMuteWhenTalking", true);
                }
            }
        });
        this.remoteUnmuteWhenTalkingMenuItem.setText(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_UNMUTESELECTEDTALKERSSPKRS));
        this.remoteUnmuteWhenTalkingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (AudioBean.this.remoteMuteWhenTalkingClient == null) {
                    return;
                }
                if (ModalDialog.showConfirmDialog((Component)AudioBean.this.getAppFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_CONFIRMSPKRUNMUTE, new Object[]{AudioBean.this.remoteMuteWhenTalkingClient.getDisplayName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_QUERYTITLE), (int)0, (int)3) == 0) {
                    AudioBean.this.remoteMuteWhenTalkingClient.setProperty("audioMuteWhenTalking", false);
                }
            }
        });
        this.waitForListenersMenuItem.setText(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_WAITFORLISTENERS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participants")}));
        this.waitForListenersListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AudioBean.this.haveTheFloor) {
                    boolean beginMuting;
                    AudioBean.this.waitForSelected = e.getSource() == AudioBean.this.waitForSelectedListenersMenuItem;
                    boolean bl = beginMuting = AudioBean.this.waitForSelected ? AudioBean.this.selectedListenersNotQuiesced() : AudioBean.this.groupListenersNotQuiesced();
                    if (beginMuting) {
                        AudioBean.this.updateState(9, null);
                    }
                }
            }
        };
        this.waitForListenersMenuItem.addActionListener(this.waitForListenersListener);
        this.waitForSelectedListenersMenuItem.setText(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_WAITFORSELECTEDLISTENERS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participants")}));
        this.waitForSelectedListenersMenuItem.addActionListener(this.waitForListenersListener);
        ActionListener remoteModeChangeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AudioBean.this.remoteModeChangeClient == null) {
                    return;
                }
                short addr = AudioBean.this.remoteModeChangeClient.getAddress();
                int clientMode = 0;
                if (AudioBean.this.module != null) {
                    clientMode = AudioBean.this.module.getAudioMode(addr);
                }
                if (clientMode == 2) {
                    this.fireModeChange(addr, (byte)1);
                } else if (clientMode == 1) {
                    this.fireModeChange(addr, (byte)2);
                }
            }

            private void fireModeChange(short target, byte mode) {
                byte op = 8;
                byte[] data = new byte[]{mode};
                ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)target, (byte)op, (byte[])data);
                AudioBean.this.fireChannelData(event);
            }
        };
        this.remoteModeChangeMenuItem.addActionListener(remoteModeChangeListener);
        this.audioSubmenu.setText(i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_MENUTEXT));
        this.audioSubmenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent me) {
            }

            @Override
            public void menuDeselected(MenuEvent me) {
            }

            @Override
            public void menuSelected(MenuEvent me) {
                AudioBean.this.populateAudioSubmenu();
            }
        });
    }

    public void start() {
        this.selector = (ParticipantSelectorAPI)this.imps.findBest(ParticipantSelectorAPI.class);
        for (int i = 0; i < 34; ++i) {
            this.spkrCodecs[i] = new ECELPCodec();
            this.talkerAddrs[i] = -32767;
        }
        this.watchdogTimer = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                AudioBean.this.updateState(19, null);
            }
        });
        if (!this.isPlayback()) {
            this.xmitSpeedMonitor = new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    int curSpeed = AudioBean.this.getMaxXmitSpeed();
                    if (curSpeed != AudioBean.this.xmitSpeedMonitorPrevSpeed) {
                        AudioBean.this.xmitSpeedMonitorPrevSpeed = curSpeed;
                        AudioBean.this.updateOptimizationMode();
                    }
                    AudioBean.this.xmitSpeedMonitor.scheduleIn(1000L);
                }
            });
        }
        this.createFeatures();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"AudioBean", (Throwable)ex, (boolean)true);
        }
        this.imps.provideAPI(StreamingMediaAPI.class, (ImpsAPI)this);
        AudioDebug.PARAMETERS.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AudioBean.this.parametersDlg == null) {
                    AudioBean.this.createParametersDialog();
                }
                if (AudioDebug.PARAMETERS.isEnabled()) {
                    AudioBean.this.millisBetweenBoostsSpinner.setValue(new Integer(AudioBean.this.millisBetweenBoosts));
                    AudioBean.this.nonsilenceGainBoostThresholdSpinner.setValue(new Integer(AudioBean.this.nonsilenceGainBoostThreshold));
                    AudioBean.this.nonsilenceThresholdSpinner.setValue(new Integer(AudioBean.this.nonsilenceThreshold));
                    AudioBean.this.retainedSilenceLimitSpinner.setValue(new Integer(AudioBean.this.retainedSilenceLimit));
                    AudioBean.this.silenceSustainLimitSpinner.setValue(new Integer(AudioBean.this.silenceSustainLimit));
                    AudioBean.this.talkerSilenceLimitSpinner.setValue(new Integer(AudioBean.this.talkerSilenceLimit));
                    AudioBean.this.muteThresholdSpinner.setValue(new Integer(AudioBean.this.muteThreshold));
                    AudioBean.this.noiseFloorSamplePeriodSpinner.setValue(new Integer(AudioBean.this.noiseFloorSamplePeriod));
                    AudioBean.this.parametersDlg.setVisible(true);
                } else {
                    AudioBean.this.parametersDlg.setVisible(false);
                }
            }
        });
    }

    private void setHaveTheFloor(boolean haveTheFloor) {
        boolean changed = haveTheFloor != this.haveTheFloor;
        this.haveTheFloor = haveTheFloor;
        if (changed) {
            if (haveTheFloor) {
                this.fireNotification(MIC_OPENED, "mike opened");
            } else {
                this.fireNotification(MIC_CLOSED, "mike closed");
            }
        }
    }

    public void setMikeBoost(boolean boost) {
        if (this.engine == null) {
            return;
        }
        this.engine.setMikeBoost(boost ? 100 : 0);
        this.fireChangeEvent();
    }

    private void setMikeLevel(int level) {
        if (this.micLevelVUFeature != null) {
            this.micLevelVUFeature.setPeakAudioLevel(level);
            if (level > 0) {
                this.mikeVUTimer.scheduleIn(500L);
            }
        }
    }

    private void setSpkrLevel(int level) {
        if (this.volumeLevelVUFeature != null) {
            this.volumeLevelVUFeature.setPeakAudioLevel(level);
        }
    }

    protected void setModule(AudioModule module) {
        if (this.module == module) {
            return;
        }
        this.module = module;
    }

    public void setMuted(boolean muted) {
        this.mute = muted;
        if (muted) {
            this.setSpkrLevel(0);
        }
    }

    protected static void setPreferredWebrtcAEC(String prefix, Preferences preferences, boolean setting) {
        preferences.setSetting(prefix + AEC_PREF, setting);
    }

    protected static void setPreferredAGC(String prefix, Preferences preferences, boolean setting) {
        preferences.setSetting(prefix + AGC_PREF, setting);
    }

    protected static void setPreferredWebrtcAGC(String prefix, Preferences preferences, boolean setting) {
        preferences.setSetting(prefix + AGC_WEBRTC_PREF, setting);
    }

    protected static void setPreferredGainBoost(String prefix, Preferences preferences, boolean setting) {
        preferences.setSetting(prefix + ENABLE_BOOST_RESTORE_PREF, setting);
    }

    protected static void setPreferredMikeBoost(String prefix, Preferences preferences, boolean boost) {
        preferences.setSetting(prefix + MIKE_BOOST_PREF, boost);
    }

    protected static void setPreferredMikeSampleRate(String prefix, Preferences preferences, int rate) {
        preferences.setSetting(prefix + MIKE_SAMP_RATE_PREF, rate);
    }

    protected static void setPreferredPeakLimiter(String prefix, Preferences preferences, boolean setting) {
        preferences.setSetting(prefix + PEAK_LIMIT_PREF, setting);
    }

    protected static void setPreferredSilenceSuppression(String prefix, Preferences preferences, boolean mute) {
        preferences.setSetting(prefix + SUPPRESS_SILENCE_PREF, mute);
    }

    protected static void setPreferredSpeakerMute(String prefix, Preferences preferences, boolean mute) {
        preferences.setSetting(prefix + SPKR_MUTE_PREF, mute);
    }

    protected static void setPreferredSpeakerSampleRate(String prefix, Preferences preferences, int rate) {
        preferences.setSetting(prefix + SPKR_SAMP_RATE_PREF, rate);
    }

    public static void setPreferredInputDevice(String prefix, Preferences preferences, String inputDeviceHnd) {
        preferences.setSetting(prefix + DEFAULT_INPUT_DEVICE, inputDeviceHnd);
    }

    public static void setPreferredInputDevice_MAC_OSX(String prefix, Preferences preferences, int macDeviceID) {
        preferences.setSetting(prefix + DEFAULT_INPUT_DEVICE, macDeviceID);
    }

    public static void setPreferredDefaultInputDevice(String prefix, Preferences preferences, boolean useDefault) {
        preferences.setSetting(prefix + USE_DEFAULT_INPUT_DEVICE, useDefault);
    }

    public static void setPreferredOutputDevice(String prefix, Preferences preferences, String outputDeviceHnd) {
        preferences.setSetting(prefix + DEFAULT_OUTPUT_DEVICE, outputDeviceHnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) {
        Debug.lockEnter((Object)this, (String)"setState", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateMessage(this.getStateName(this.state) + " -> " + this.getStateName(newState));
            this.state = newState;
            boolean remoteMikeAdjustAllowed = this.volAckPending == -32767 && this.countTalkers(true, false) > 0;
            switch (this.state) {
                case 1: {
                    this.setButtonState("ST_AWAITING_FLOOR", false, true, this.GET_FLOOR_LABEL, NULL_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 2: {
                    this.setButtonState("ST_AWAITING_MIKE", false, true, this.START_LABEL, NULL_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 3: 
                case 7: {
                    boolean talkEnabled = this.talkingAllowed && !this.awaitingFloorRelease && !this.floorIsFull();
                    String talkLabel = this.getTalkLabel(talkEnabled);
                    if (this.state == 3) {
                        this.setButtonState("ST_CONNECTED", talkEnabled, false, this.TALK_ICON, talkLabel, this.TALK_TIP, remoteMikeAdjustAllowed, true);
                    } else {
                        String talkTip = this.talkerDesc == null ? null : i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_OTHERTALKINGTIP, new Object[]{this.talkerDesc});
                        this.setButtonState("ST_LISTENING", talkEnabled, false, this.TALK_ICON, talkLabel, talkTip, remoteMikeAdjustAllowed, true);
                    }
                    this.setMikeLevel(0);
                    this.setSpkrLevel(0);
                    break;
                }
                case 4: {
                    String talkLabel = this.getTalkLabel(true);
                    this.setButtonState("ST_CONVERSING", true, true, this.MIKE_LIVE_ICON, talkLabel, this.TALKING_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 5: {
                    this.setButtonState("ST_CONVERSING_MUTED", true, false, this.MIKE_MUTED_ICON, NULL_LABEL, NULL_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 6: 
                case 13: {
                    boolean talkEnabled = !this.isPlayback();
                    String talkLabel = this.getTalkLabel(false);
                    this.setButtonState("ST_DISCONNECTED", false, false, this.TALK_ICON, talkLabel, this.TALK_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 8: {
                    this.setButtonState("ST_RELEASING_FLOOR", false, false, this.RELEASE_FLOOR_LABEL, NULL_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 9: {
                    this.setButtonState("ST_RELEASING_MIKE", false, false, this.STOP_LABEL, NULL_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 10: {
                    String talkLabel = this.getTalkLabel(true);
                    this.setButtonState("ST_TALKING", true, true, this.MIKE_LIVE_ICON, talkLabel, this.TALKING_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 11: {
                    this.setButtonState("ST_TALKING_MUTED", true, false, this.MIKE_MUTED_ICON, NULL_LABEL, NULL_TIP, remoteMikeAdjustAllowed, false);
                    break;
                }
                case 12: {
                    this.setButtonState("ST_TELEPHONE", false, false, this.USING_PHONE_ICON, NULL_LABEL, this.USING_PHONE_TIP, remoteMikeAdjustAllowed, true);
                    break;
                }
                default: {
                    String msg = "No code for state " + this.state;
                    LogSupport.exception((Object)this, (String)"setState", (Throwable)new RuntimeException(msg), (boolean)false);
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"setState", (String)"stateLock", (Object)this.stateLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpAudio() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    ModalDialog.showMessageDialogAsync((int)10, (Component)this.getAppFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SETUPWHILETALKINGMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_AUDIOSETUPERRORCAP), (int)0);
                    return;
                }
            }
            this.muteForSetup = true;
        }
        SteppedAwayAPI awayAPI = (SteppedAwayAPI)this.imps.findBest(SteppedAwayAPI.class);
        try {
            if (awayAPI != null) {
                awayAPI.setSettingUpAudio(true);
            }
            if (this.engine == null) {
                LogSupport.error((String)"engine is NULL");
            }
            this.engine.removeInputListener(this);
            this.audioSetUpMicSetting = (Integer)this.micLevelSliderFeature.getValue();
            this.audioSetUpSpkrSetting = (Integer)this.volumeLevelSliderFeature.getValue();
            this.engine.forceStopInput();
            this.audioSetupWizard.run(this.engine, this);
            this.engine.addInputListener(this);
            this.engine.startEavesdrop();
            this.setMikeFeatureValue(this.audioSetUpMicSetting);
            this.setSpkrFeatureValue(this.audioSetUpSpkrSetting);
            this.refreshButtonState();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"setUpAudio", (Throwable)t, (boolean)true);
        }
        finally {
            if (awayAPI != null) {
                awayAPI.setSettingUpAudio(false);
            }
        }
        this.muteForSetup = false;
    }

    private void playAudio(boolean useCannedAudio) {
        try {
            if (this.engine == null) {
                LogSupport.error((Object)this, (String)"playAudio", (String)"engine is NULL");
            } else {
                this.audioSetupWizard.playAudio(this.engine, this, useCannedAudio);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"playAudio", (Throwable)t, (boolean)true);
        }
    }

    private void recordAudio() {
        try {
            if (this.engine == null) {
                LogSupport.error((Object)this, (String)"recordAudio", (String)"engine is NULL");
            } else if (!this.nowRecording) {
                this.nowRecording = this.audioSetupWizard.recordAudio(this.engine, this);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"recordAudio", (Throwable)t, (boolean)true);
        }
    }

    protected void setAudioSetupSpkrLevel(int level) {
        this.audioSetUpSpkrSetting = level;
    }

    protected void setAudioSetupMicLevel(int level) {
        this.audioSetUpMicSetting = level;
    }

    public void showMaxTalkersDialog() {
        int newMaxTalkers;
        if (this.engine == null || this.module == null) {
            return;
        }
        String insertText = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MAXTALKERSECHOONMSG);
        if (!this.engine.useLegacy() && !AudioBean.getPreferredWebrtcAEC(this.module.getPrefix(), this.module.getPreferences())) {
            insertText = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MAXTALKERSECHOOFFMSG);
        }
        JEditorPane blurb = new JEditorPane("text/html", i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MAXTALKERSMSG, new Object[]{insertText}));
        blurb.setEditable(false);
        blurb.setFocusable(false);
        blurb.setOpaque(false);
        blurb.setBackground(UIManager.getColor("Label.background"));
        blurb.setSize(new Dimension(400, Integer.MAX_VALUE));
        AccessibleTextSlider slider = new AccessibleTextSlider(1, Math.max(this.maxVoIPTalkersLimit, this.maxVoIPTalkers), this.maxVoIPTalkers);
        slider.setMajorTickSpacing((this.maxVoIPTalkersLimit - 1) / 8 + 1);
        slider.setMinorTickSpacing(1);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setSnapToTicks(true);
        slider.getAccessibleContext().setAccessibleDescription(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MAXTALKERS_ACCESSIBLE_DESC));
        Frame parent = this.getAppFrame();
        String title = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MAXTALKERSTITLE);
        JPanel content = new JPanel(new BorderLayout(0, 6));
        content.add((Component)blurb, "North");
        content.add((Component)slider, "Center");
        EasyDialog d = new EasyDialog(parent, title){

            public Dimension getPreferredSize() {
                Dimension prefSize = super.getPreferredSize();
                if (prefSize.getWidth() > 500.0) {
                    prefSize = new Dimension(500, prefSize.height);
                }
                return prefSize;
            }
        };
        d.setContent((Component)content);
        d.addActionButton(d.makeButton(1), true);
        d.addCancelButton(d.makeButton(0));
        d.setInitialFocus((Component)slider);
        d.show();
        if (!d.wasCanceled() && this.maxVoIPTalkers != (newMaxTalkers = slider.getValue())) {
            this.clients.setProperty("audioMaxVOIPTalkers", new Integer(newMaxTalkers).intValue());
        }
    }

    private void showStatus(ClientInfo ci, int status) {
        try {
            ci.setProperty("audioYellowStatus", status == 2 || status == 4);
            ci.setProperty("audioRedStatus", status == 4 || status == 3);
            this.participantStatus.put(ci, ShortList.get((short)((short)status)));
            if (this.state == 5 || this.state == 11) {
                boolean keepMuting;
                boolean bl = keepMuting = this.waitForSelected ? this.selectedListenersNotQuiesced() : this.groupListenersNotQuiesced();
                if (!keepMuting) {
                    this.updateState(13, null);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spkrLevelChanged() {
        AudioBean audioBean = this;
        synchronized (audioBean) {
            if (this.ignoreSpkrLevelChanges-- > 0 || this.spkrFeatureSetting == (Integer)this.volumeLevelSliderFeature.getValue()) {
                return;
            }
            this.ignoreSpkrLevelChanges = 0;
            this.spkrFeatureSetting = -1;
        }
        if (AudioDebug.GAIN.show()) {
            LogSupport.message((Object)this, (String)"spkrLevel_stateChanged", (String)("Speaker slider set to: " + this.volumeLevelSliderFeature.getValue() + "%"));
        }
        if (this.engine != null) {
            int percent = (Integer)this.volumeLevelSliderFeature.getValue();
            if (percent <= 1) {
                this.module.disableAdjustSpeakerLevelDownMenuItem();
                this.module.enableAdjustSpeakerLevelUpMenuItem();
            } else if (percent >= 99) {
                this.module.disableAdjustSpeakerLevelUpMenuItem();
                this.module.enableAdjustSpeakerLevelDownMenuItem();
            } else {
                this.module.enableAdjustSpeakerLevelDownMenuItem();
                this.module.enableAdjustSpeakerLevelUpMenuItem();
            }
            this.engine.setSpkrVolume((Integer)this.volumeLevelSliderFeature.getValue());
        }
    }

    private void startWatchdog(int delay) {
        if (delay <= 0 || this.watchdogTimer.isScheduled()) {
            return;
        }
        this.ignoreTimeOut = false;
        this.watchdogTimer.scheduleIn((long)delay);
        this.stateMessage("Watchdog timer set at " + delay);
    }

    private int stateMessage(String msg) {
        int msgNum = 0;
        if (AudioDebug.STATE.show()) {
            msgNum = this.msgNumber++;
            LogSupport.message((String)(msgNum + ": " + msg));
        }
        return msgNum;
    }

    private boolean switchModeToTelephone(boolean interactive) {
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        if (telephony == null) {
            this.updateMenuForVoip(true);
            return false;
        }
        if (interactive) {
            Chair chair;
            ImageIcon telIcon = i18n.getIcon("AudioBean.dialogTelephoneIcon");
            String title = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOTELECONFERENCETITLE);
            String tel = telephony == null ? "" : telephony.getParticipantTelephone();
            String pin = telephony == null ? "" : telephony.getParticipantPIN();
            String telChair = telephony == null ? "" : telephony.getModeratorTelephone();
            String pinChair = telephony == null ? "" : telephony.getModeratorPIN();
            String partInfo = AudioBean.getPhoneString(tel, pin, false);
            String modInfo = AudioBean.getPhoneString(telChair, pinChair, false);
            String content = null;
            Chair chair2 = chair = this.clients == null ? null : ChairProtocol.getChair((ClientList)this.clients);
            if (chair != null && chair.isMe() && !modInfo.equals(partInfo) && !"".equals(telChair)) {
                String modStr = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator");
                String partStr = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant");
                content = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOTELECONFERENCECHAIRMSG, new Object[]{partInfo, modInfo, modStr, partStr});
            } else if ("".equals(tel)) {
                URL confUrl = i18n.getImageUrl((PropertiesEnum)StringsProperties.AUDIOBEAN_VOIPMODEICON);
                URL unconfUrl = i18n.getImageUrl((PropertiesEnum)StringsProperties.AUDIOBEAN_VOIPMODEWARNICON);
                String confStr = confUrl.toString();
                String unconfStr = unconfUrl.toString();
                if (AudioDebug.TELEPHONY_NO_INFO.show()) {
                    LogSupport.message((Object)this, (String)"switchModeToTelephone", (String)(" voipModeIcon = " + confStr + " warnIcon = " + unconfStr));
                }
                String modStr = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator");
                content = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOTELECONFERENCENOINFOMSG, new Object[]{confStr, unconfStr, modStr});
            } else {
                content = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOTELECONFERENCEPARTICIPANTMSG, new Object[]{partInfo});
            }
            JTextPane contentPane = new JTextPane();
            contentPane.setContentType("text/html");
            contentPane.setText(content);
            contentPane.setEditable(false);
            contentPane.setBackground(UIManager.getColor("Label.background"));
            contentPane.setBorder(BorderFactory.createEmptyBorder(12, 6, 12, 64));
            Frame parent = this.getAppFrame();
            int which = ModalDialog.showOptionDialog((Component)parent, (Object)contentPane, (String)title, (int)2, (int)-1, (Icon)telIcon, null, null);
            if (which != 0) {
                this.updateMenuForVoip(true);
                return false;
            }
        }
        if (telephony != null) {
            telephony.setAudioMode(2);
        }
        this.updateMenuForVoip(false);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void updateMenuForVoip(boolean voip) {
        this.broker.setFeaturePublished((Feature)this.audioPhoneFeature, voip == false);
        this.broker.setFeaturePublished((Feature)this.audioPhone2Feature, voip == false);
        sessionTeleconferenced = this.isSessionTeleconferenced();
        this.telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        if (this.telephony == null) ** GOTO lbl-1000
        if (this.telephony.getTelephonyMode() == 2) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.isAutomatic = v0;
        this.broker.setFeaturePublished((Feature)this.audioVoipFeature, voip != false && (sessionTeleconferenced != false || this.isAutomatic != false));
        this.broker.setFeaturePublished((Feature)this.audioVoip2Feature, voip != false && (sessionTeleconferenced != false || this.isAutomatic != false));
        this.audioVoipFeature.setEnabled(voip != false && (sessionTeleconferenced != false || this.isAutomatic != false));
        this.audioVoip2Feature.setEnabled(voip != false && (sessionTeleconferenced != false || this.isAutomatic != false));
    }

    private boolean switchModeToVoIP(boolean interactive) {
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        if (telephony == null) {
            this.updateMenuForVoip(true);
            return true;
        }
        if (interactive) {
            Chair chair;
            ImageIcon telIcon = i18n.getIcon("AudioBean.dialogTelephoneIcon");
            String title = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOVOIPTITLE);
            String tel = telephony == null ? "" : telephony.getParticipantTelephone();
            String pin = telephony == null ? "" : telephony.getParticipantPIN();
            String telChair = telephony == null ? "" : telephony.getModeratorTelephone();
            String pinChair = telephony == null ? "" : telephony.getModeratorPIN();
            String partInfo = AudioBean.getPhoneString(tel, pin, false);
            String modInfo = AudioBean.getPhoneString(telChair, pinChair, false);
            String content = null;
            Chair chair2 = chair = this.clients == null ? null : ChairProtocol.getChair((ClientList)this.clients);
            if ("".equals(telChair) && "".equals(tel)) {
                content = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOVOIPNOPHONEMSG);
            } else if (chair != null && chair.isMe() && !modInfo.equals(partInfo) && !"".equals(telChair)) {
                String modStr = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator");
                String partStr = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant");
                content = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOVOIPCHAIRMSG, new Object[]{partInfo, modInfo, modStr, partStr});
            } else {
                content = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOVOIPPARTICIPANTMSG, new Object[]{partInfo});
            }
            JTextPane contentPane = new JTextPane();
            contentPane.setContentType("text/html");
            contentPane.setText(content);
            contentPane.setEditable(false);
            contentPane.setBackground(UIManager.getColor("Label.background"));
            contentPane.setBorder(BorderFactory.createEmptyBorder(12, 6, 12, 64));
            Frame parent = this.getAppFrame();
            String okBtnTxt = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOVOIPOKBTNTXT);
            String cancelBtnTxt = i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SWITCHTOVOIPCANCELBTNTXT);
            Object[] possibleValues = new Object[]{okBtnTxt, cancelBtnTxt};
            int selectedValue = JOptionPane.showOptionDialog(parent, contentPane, title, -1, 1, telIcon, possibleValues, possibleValues[0]);
            if (selectedValue != 0) {
                this.updateMenuForVoip(false);
                return false;
            }
        }
        telephony.setAudioMode(1);
        this.updateMenuForVoip(true);
        return true;
    }

    public void talkHotKey() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AudioBean.this.talkBtn.doClick();
            }
        });
    }

    protected void toggleAudioMode() {
        boolean isTelephoneMode;
        boolean enabled = this.module == null ? false : this.module.isTelephonyEnabled();
        boolean bl = isTelephoneMode = this.module == null ? false : this.module.isTelephoneMode();
        if (!enabled) {
            return;
        }
        if (!isTelephoneMode) {
            this.switchedOK = this.switchModeToTelephone(true);
            if (this.switchedOK) {
                this.updateState(14, Boolean.TRUE);
            }
        } else {
            this.switchedOK = this.switchModeToVoIP(true);
            if (this.switchedOK) {
                this.updateState(15, Boolean.TRUE);
            }
        }
    }

    private void updateMikeLevelSlider() {
        if (this.micLevelSliderFeature == null) {
            return;
        }
        try {
            int mikeGain;
            int n = mikeGain = this.engine == null ? -1 : this.engine.getMikeGain();
            if (mikeGain < 0) {
                this.setMikeFeatureValue(0);
                this.micLevelSliderFeature.setEnabled(false);
            } else {
                this.setMikeFeatureValue(mikeGain);
                this.micLevelSliderFeature.setEnabled(true);
            }
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"updateMikeLevelSlider", (String)("Unable to set mike level: " + t));
        }
    }

    private void updateMikeVUMeter(short[] samples) {
        if (this.micLevelVUFeature != null) {
            this.setMikeLevel(AudioBean.volumeLevel(samples));
        }
    }

    private void updateSpkrLevelSlider() {
        try {
            int spkrVolume;
            int n = spkrVolume = this.engine == null ? -1 : this.engine.getSpkrVolume();
            if (spkrVolume < 0) {
                this.setSpkrFeatureValue(0);
                this.volumeLevelSliderFeature.setEnabled(false);
            } else {
                this.volumeLevelSliderFeature.setEnabled(true);
                this.setSpkrFeatureValue(this.engine.getSpkrVolume());
            }
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"updateSpkrLevelSlider", (String)("Unable to set speaker level: " + t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMikeFeatureValue(int level) {
        AudioBean audioBean = this;
        synchronized (audioBean) {
            ++this.ignoreMikeLevelChanges;
            this.mikeFeatureSetting = level;
        }
        this.micLevelSliderFeature.setValue((Object)level);
        if (level <= 1) {
            this.module.disableAdjustMicLevelDownMenuItem();
            this.module.enableAdjustMicLevelUpMenuItem();
        } else if (level >= 99) {
            this.module.disableAdjustMicLevelUpMenuItem();
            this.module.enableAdjustMicLevelDownMenuItem();
        } else {
            this.module.enableAdjustMicLevelUpMenuItem();
            this.module.enableAdjustMicLevelDownMenuItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSpkrFeatureValue(int level) {
        AudioBean audioBean = this;
        synchronized (audioBean) {
            ++this.ignoreSpkrLevelChanges;
            this.spkrFeatureSetting = level;
        }
        this.volumeLevelSliderFeature.setValue((Object)level);
        if (level <= 1) {
            this.module.disableAdjustSpeakerLevelDownMenuItem();
            this.module.enableAdjustSpeakerLevelUpMenuItem();
            this.engine.setSpkrVolume(0);
        } else if (level >= 99) {
            this.module.disableAdjustSpeakerLevelUpMenuItem();
            this.module.enableAdjustSpeakerLevelDownMenuItem();
            this.engine.setSpkrVolume(100);
        } else {
            this.module.enableAdjustSpeakerLevelDownMenuItem();
            this.module.enableAdjustSpeakerLevelUpMenuItem();
            this.engine.setSpkrVolume((Integer)this.volumeLevelSliderFeature.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(int eventCode, Object eventData) {
        Debug.lockEnter((Object)this, (String)"updateState", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            String operation = "Got " + this.getEventName(eventCode) + " in " + this.getStateName(this.state);
            this.stateMessage(operation);
            int histIdx = this.eventHistCnt++ % 100;
            this.eventHistEvents[histIdx] = eventCode;
            this.eventHistStates[histIdx] = this.state;
            this.eventHistTimes[histIdx] = System.currentTimeMillis();
            block7 : switch (eventCode) {
                case 1: {
                    switch (this.state) {
                        case 6: 
                        case 13: {
                            this.setUpAudio();
                            break block7;
                        }
                        case 3: 
                        case 7: {
                            this.moveFocusToTalkBtn = this.talkBtn.hasFocus();
                            this.setState(1);
                            this.requestFloor();
                            break block7;
                        }
                        case 5: {
                            this.setState(4);
                            break block7;
                        }
                        case 11: {
                            this.setState(10);
                            break block7;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: {
                            String diagnostic = "Button pressed in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 2: {
                    switch (this.state) {
                        case 4: 
                        case 5: 
                        case 10: 
                        case 11: {
                            this.acceptLateMikeSamples = true;
                            this.moveFocusToTalkBtn = this.talkBtn.hasFocus();
                            this.setState(9);
                            this.releaseMike();
                            break block7;
                        }
                        case 6: 
                        case 8: 
                        case 9: 
                        case 13: {
                            break block7;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 7: 
                        case 12: {
                            String diagnostic = "Button released in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 3: {
                    if (!this.connected) break;
                    if (this.xmitSpeedMonitor != null) {
                        this.xmitSpeedMonitor.cancel();
                    }
                    this.myAddr = (short)-32767;
                    this.connected = false;
                    this.awaitingFloorRelease = false;
                    this.talkingAllowed = false;
                    this.haveTheFloor = false;
                    this.clearAllTalkers();
                    this.spkrStatus = -1;
                    this.recvQ.abort(false);
                    this.recvQ = null;
                    this.xmitQ.abort();
                    this.xmitQ = null;
                    this.mikeCodec.closeEncoder();
                    for (int i = 0; i < this.spkrCodecs.length; ++i) {
                        this.spkrCodecs[i].closeDecoder();
                    }
                    switch (this.state) {
                        case 6: 
                        case 13: {
                            String diagnostic = "Channel already disconnected in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block7;
                        }
                        case 2: 
                        case 9: {
                            break block7;
                        }
                        case 4: 
                        case 5: 
                        case 10: 
                        case 11: {
                            this.setState(9);
                            this.releaseMike();
                            break block7;
                        }
                        case 1: 
                        case 8: {
                            this.quenchWatchdog();
                        }
                        case 3: 
                        case 7: {
                            this.setState(6);
                            break block7;
                        }
                        case 12: {
                            this.setState(13);
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 4: {
                    if (this.connected) break;
                    try {
                        this.recvQ = new ReceiveQueue();
                        this.recvQ.addReceiveListener(this);
                        this.xmitQ = new TransmitQueue();
                        this.xmitQ.addTransmitListener(this);
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"updateState", (Throwable)t, (boolean)false);
                        this.recvQ = null;
                        this.xmitQ = null;
                        break;
                    }
                    ClientInfo me = this.clients.getMyClient();
                    me.setProperty("audioMuteWhenTalking", this.muteWhenTalking);
                    if (this.engine != null) {
                        AudioEngine.setSpkrBacklogMaxTrimPct(this.isPlayback() ? 3 : 100);
                    }
                    this.myAddr = this.clients.getMyAddress();
                    this.connected = true;
                    if (this.xmitSpeedMonitor != null) {
                        this.xmitSpeedMonitorPrevSpeed = 0;
                        this.xmitSpeedMonitor.scheduleIn(1000L);
                    }
                    switch (this.state) {
                        case 6: {
                            this.setState(3);
                            break;
                        }
                        case 13: {
                            this.setState(12);
                            TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
                            if (telephony == null) break block7;
                            telephony.setAudioMode(2);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 9: {
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 12: {
                            String diagnostic = "Channel already connected in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    if (AudioDebug.IGNORE_FLOOR_GRANT.isEnabled()) {
                        this.stateMessage("Ignoring EV_FLOOR_GRANTED_ME");
                        break;
                    }
                    if (this.awaitingFloorRelease) break;
                    byte[] floorData = (byte[])eventData;
                    this.myTalkerIdx = floorData.length < 3 ? 0 : floorData[2] & 0xFF;
                    this.addTalker(this.myAddr, this.myTalkerIdx);
                    this.setHaveTheFloor(true);
                    this.updateTalkerDesc();
                    switch (this.state) {
                        case 6: 
                        case 13: {
                            break block7;
                        }
                        case 1: {
                            this.quenchWatchdog();
                            this.setState(2);
                            this.requestMike();
                            break block7;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            String diagnostic = "Floor granted in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 6: {
                    byte[] floorData = (byte[])eventData;
                    short talkerAddr = this.loadShortField(floorData, 0);
                    int talkerIdx = floorData.length < 3 ? 0 : floorData[2] & 0xFF;
                    this.addTalker(talkerAddr, talkerIdx);
                    switch (this.state) {
                        case 6: 
                        case 13: {
                            break block7;
                        }
                        case 3: 
                        case 7: {
                            this.setState(7);
                            break block7;
                        }
                        case 10: {
                            this.setState(4);
                            break block7;
                        }
                        case 11: {
                            this.setState(5);
                            break block7;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 12: {
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 7: {
                    if (AudioDebug.IGNORE_FLOOR_REVOKE.isEnabled()) {
                        this.stateMessage("Ignoring EV_FLOOR_REVOKED_ME");
                        break;
                    }
                    if (!ChairProtocol.getChair((ClientList)this.clients).isMe()) {
                        this.clearStatusIndicators();
                    }
                    this.myTalkerIdx = -1;
                    short talkerAddr = this.myAddr;
                    if (this.getTalkerIndex(talkerAddr) >= 0) {
                        this.removeTalker(talkerAddr);
                    }
                    if (this.haveTheFloor) {
                        this.setHaveTheFloor(false);
                    }
                    if (this.awaitingFloorRelease) {
                        this.awaitingFloorRelease = false;
                        this.refreshButtonState();
                    }
                    switch (this.state) {
                        case 6: 
                        case 13: {
                            break block7;
                        }
                        case 2: 
                        case 9: {
                            break block7;
                        }
                        case 4: 
                        case 5: 
                        case 10: 
                        case 11: {
                            this.setState(9);
                            this.releaseMike();
                            break block7;
                        }
                        case 1: 
                        case 8: {
                            this.quenchWatchdog();
                            this.setState(!this.connected ? 6 : (this.countTalkers(true, false) < 1 ? 3 : 7));
                            break block7;
                        }
                        case 3: 
                        case 7: {
                            break block7;
                        }
                        case 12: {
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 8: {
                    byte[] floorData = (byte[])eventData;
                    short talkerAddr = this.loadShortField(floorData, 0);
                    this.removeTalker(talkerAddr);
                    if (talkerAddr == this.volAckPending) {
                        this.processVolAck(talkerAddr);
                    }
                    switch (this.state) {
                        case 6: 
                        case 13: {
                            break block7;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            break block7;
                        }
                        case 4: {
                            this.setState(this.countTalkers(true, false) > 0 ? 4 : 10);
                            break block7;
                        }
                        case 5: {
                            this.setState(this.countTalkers(true, false) > 0 ? 5 : 11);
                            break block7;
                        }
                        case 7: {
                            this.setState(this.countTalkers(true, false) > 0 ? 7 : 3);
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 9: {
                    switch (this.state) {
                        case 4: {
                            AudioEngine.beep();
                            this.setState(5);
                            break block7;
                        }
                        case 10: {
                            AudioEngine.beep();
                            this.setState(11);
                            break block7;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: {
                            String diagnostic = "Got MIKE_MUTED in " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 10: {
                    switch (this.state) {
                        case 9: {
                            if (!this.acceptLateMikeSamples) break;
                            this.acceptLateMikeSamples = false;
                        }
                        case 4: 
                        case 10: {
                            if (this.haveTheFloor) {
                                LinkedList<short[]> linkedList;
                                boolean suppressSilence;
                                InputEvent ie = (InputEvent)eventData;
                                short[] samples = ie.getData();
                                if (this.useLegacy()) {
                                    this.adjustMikePeak(samples);
                                }
                                this.microphoneSamples = this.useLegacy() ? this.automaticGainControl(samples) : samples;
                                this.updateMikeVUMeter(this.microphoneSamples);
                                int microphoneRawLevel = AudioBean.volumeLevel(samples);
                                int packetMillis = 1000 * this.microphoneSamples.length / 8000;
                                if (this.useLegacy()) {
                                    this.noiseFloorQueue.addFirst(new NoiseInfo(microphoneRawLevel, packetMillis));
                                    this.noiseQueueMillis += packetMillis;
                                }
                                this.trackForAudioActivityDetection(microphoneRawLevel, packetMillis);
                                if (this.useLegacy() && microphoneRawLevel > this.noisePeak) {
                                    this.noisePeak = microphoneRawLevel;
                                }
                                while (this.useLegacy() && !this.noiseFloorQueue.isEmpty() && this.noiseQueueMillis > this.noiseFloorSamplePeriod) {
                                    NoiseInfo infoPacket = this.noiseFloorQueue.removeLast();
                                    this.noiseQueueMillis -= infoPacket.getMillis();
                                    if (infoPacket.getLevel() < this.noisePeak) continue;
                                    this.noiseQueueMillis = 0;
                                    this.noisePeak = 0;
                                    for (NoiseInfo info : this.noiseFloorQueue) {
                                        this.noiseQueueMillis += info.getMillis();
                                        if (info.getLevel() <= this.noisePeak) continue;
                                        this.noisePeak = info.getLevel();
                                    }
                                }
                                int microphoneVolumeLevel = this.useLegacy() && this.enableAGC ? (int)((double)microphoneRawLevel * this.runningGain) : (this.useLegacy() ? (int)((double)microphoneRawLevel * 4.0) : microphoneRawLevel);
                                boolean suppressedSilence = false;
                                if (this.useLegacy() && this.enableBoostRestore && (double)this.noisePeak < (double)this.nonsilenceGainBoostThreshold / 4.0 && this.timeOfLastBoostRestore + (long)this.millisBetweenBoosts < System.currentTimeMillis() && microphoneRawLevel > this.muteThreshold && this.enablePeakLimit) {
                                    this.adjustLocalMikeGain(1.02f, false, true);
                                }
                                if ((suppressSilence = AudioBean.getPreferredSilenceSuppression(this.module.getPrefix(), this.module.getPreferences())) && microphoneVolumeLevel < this.nonsilenceThreshold && this.outgoingSaveStrm == null && this.countTalkers(true, false) >= this.talkerSilenceLimit) {
                                    if (this.millisSinceLastNonsilence > this.silenceSustainLimit) {
                                        if (AudioDebug.SILENCE_SUPPRESSION.show() && this.consecutiveSilenceMillis == 0) {
                                            LogSupport.message((String)"begin silence suppression");
                                        }
                                        this.consecutiveSilenceMillis += packetMillis;
                                        if (this.retainedSilenceLimit > 0) {
                                            linkedList = this.audioPacketQueue;
                                            synchronized (linkedList) {
                                                while (!this.audioPacketQueue.isEmpty() && this.audioPacketQueuedMillis + packetMillis > this.retainedSilenceLimit) {
                                                    short[] droppedData = this.audioPacketQueue.removeFirst();
                                                    int droppedMillis = 1000 * droppedData.length / 8000;
                                                    this.audioPacketQueuedMillis -= droppedMillis;
                                                }
                                                if (this.audioPacketQueue.isEmpty()) {
                                                    this.audioPacketQueuedMillis = 0;
                                                }
                                                this.audioPacketQueue.addLast(this.microphoneSamples);
                                                this.audioPacketQueuedMillis += packetMillis;
                                            }
                                        }
                                        suppressedSilence = true;
                                    }
                                    this.millisSinceLastNonsilence += packetMillis;
                                } else {
                                    this.millisSinceLastNonsilence = 0;
                                }
                                if (suppressedSilence) break block7;
                                linkedList = this.audioPacketQueue;
                                synchronized (linkedList) {
                                    if (this.audioPacketQueue.size() > 0) {
                                        long preservedSilenceMillis = 0L;
                                        do {
                                            short[] preservedSilence = this.audioPacketQueue.removeFirst();
                                            preservedSilenceMillis += (long)(1000 * preservedSilence.length / 8000);
                                            this.sendECELPData(preservedSilence);
                                        } while (this.audioPacketQueue.size() > 0);
                                        if (AudioDebug.SILENCE_SUPPRESSION.show()) {
                                            LogSupport.message((String)("end silence suppression of " + this.consecutiveSilenceMillis + " ms with " + preservedSilenceMillis + " ms of preserved silence"));
                                        }
                                        this.audioPacketQueuedMillis = 0;
                                    }
                                    this.sendECELPData(this.microphoneSamples);
                                }
                                this.consecutiveSilenceMillis = 0;
                                break;
                            }
                            this.setState(9);
                            this.releaseMike();
                            break;
                        }
                        case 5: 
                        case 11: {
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 12: 
                        case 13: {
                            this.engine.stopInput();
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 11: {
                    if (this.timedOutRequestingMike) {
                        this.stateMessage("Ignoring AUDIO_BEGIN due to mike request timeout");
                        break;
                    }
                    if (AudioDebug.IGNORE_MIKE_GRANT.isEnabled()) {
                        this.stateMessage("Ignoring EV_MIKE_STARTED");
                        break;
                    }
                    this.msgPublisher.sendMicOnMessage(i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_MIC_ON), true);
                    switch (this.state) {
                        case 2: {
                            this.quenchWatchdog();
                            if (this.haveTheFloor) {
                                this.setState(this.countTalkers(true, false) > 0 ? 4 : 10);
                                if (this.mikeCodec.isEncoderOpen()) {
                                    this.mikeCodec.resetEncoder();
                                } else if (!this.mikeCodec.openEncoder()) {
                                    LogSupport.error((Object)this, (String)"updateState", (String)"Cannot open encoder");
                                }
                                if (!AudioDebug.SAVE_OUTGOING.isEnabled()) break block7;
                                this.openOutgoingSaveFile();
                                break;
                            }
                            this.setState(9);
                            this.releaseMike();
                            break;
                        }
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 12: 
                        case 13: {
                            this.engine.stopInput();
                            break;
                        }
                        case 1: 
                        case 4: 
                        case 5: 
                        case 10: 
                        case 11: {
                            this.engine.stopInput();
                            String diagnostic = "Got AUDIO_BEGIN in " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 12: {
                    if (this.timedOutReleasingMike) {
                        this.stateMessage("Ignoring AUDIO_END due to mike release timeout");
                        break;
                    }
                    if (AudioDebug.IGNORE_MIKE_REVOKE.isEnabled()) {
                        this.stateMessage("Ignoring EV_MIKE_STOPPED");
                        break;
                    }
                    this.setMikeLevel(0);
                    this.msgPublisher.sendMicOffMessage(i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_MIC_OFF), true);
                    switch (this.state) {
                        case 2: 
                        case 9: {
                            this.quenchWatchdog();
                        }
                        case 4: 
                        case 5: 
                        case 10: 
                        case 11: {
                            if (this.haveTheFloor) {
                                this.setState(8);
                                this.releaseFloor();
                                break block7;
                            }
                            this.setState(!this.connected ? 6 : (this.state == 4 ? 7 : 3));
                            break block7;
                        }
                        case 1: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 12: 
                        case 13: {
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 13: {
                    switch (this.state) {
                        case 5: {
                            AudioEngine.beep();
                            this.setState(4);
                            break block7;
                        }
                        case 11: {
                            AudioEngine.beep();
                            this.setState(10);
                            break block7;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: {
                            String diagnostic = "Got MIKE_UNMUTED in " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 14: {
                    boolean interactive = (Boolean)eventData;
                    switch (this.state) {
                        case 4: 
                        case 10: {
                            if (this.switchedOK) {
                                this.fireChannelData((byte)2);
                            }
                        }
                        case 3: 
                        case 7: {
                            if (!this.switchedOK) {
                                this.setState(!this.connected ? 6 : (this.countTalkers(true, false) < 1 ? 3 : 7));
                                break;
                            }
                            this.setState(12);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: {
                            if (!this.isAutomatic) break block7;
                            this.setState(12);
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 15: {
                    boolean interactive = (Boolean)eventData;
                    switch (this.state) {
                        case 12: {
                            if (!this.switchedOK) break block7;
                            this.setState(!this.connected ? 6 : (this.countTalkers(true, false) < 1 ? 3 : 7));
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 13: {
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 16: {
                    int pktSize;
                    ChannelDataEvent cde = (ChannelDataEvent)eventData;
                    int cmd = cde.getCommand() & 0xFF;
                    int talkerIdx = cmd - 64;
                    short talkerAddr = this.talkerAddrs[talkerIdx];
                    if (talkerAddr == -32767) {
                        if (!AudioDebug.GENERAL.isEnabled()) break;
                        LogSupport.message((Object)this, (String)"onReceive", (String)"Received samples from an unopen audio stream");
                        break;
                    }
                    byte[] ecelpData = cde.getContents();
                    if (AudioDebug.TALKER_PACKET_SIZES.isEnabled() && this.talkerPktSizes[talkerIdx] != (pktSize = ecelpData.length * 20 / 18)) {
                        ClientInfo ci = this.clients.get(talkerAddr);
                        String talkerName = ci == null ? "?" : ci.getDisplayName();
                        LogSupport.message((String)("Receiving " + pktSize + " ms packets from " + talkerName));
                        this.talkerPktSizes[talkerIdx] = pktSize;
                    }
                    if (this.contentCaptureProvider.get().isCapturingData()) {
                        this.contentCapture.sendAudio(talkerAddr, ecelpData);
                    }
                    if (this.engine == null || !this.contentCaptureProvider.get().isEchoingData()) break;
                    short[] samples = this.spkrCodecs[talkerIdx].decode(ecelpData);
                    if (this.mute || this.muteForSetup) break;
                    if (this.volumeLevelVUFeature != null) {
                        int level = AudioBean.volumeLevel(samples);
                        this.setSpkrLevel(level);
                    }
                    if (ChairProtocol.getChair((ClientList)this.clients).isMe()) {
                        for (int i = 0; i < this.remoteTalkerCnt; ++i) {
                            if (talkerAddr != this.remoteTalkerAddrs[i]) continue;
                            this.remoteTalkerVUMeters[i].processSamples(0, samples);
                        }
                    }
                    if (this.state != 12 && !AudioDebug.LOAD_TEST.isEnabled()) {
                        this.engine.write(talkerIdx, samples);
                    }
                    this.evaluateSpkrStatus();
                    break;
                }
                case 17: {
                    this.talkingAllowed = true;
                    switch (this.state) {
                        case 3: 
                        case 7: {
                            this.refreshButtonState();
                            break block7;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 18: {
                    if (this.haveTheFloor) {
                        this.removeTalker(this.clients.getMyClient().getAddress());
                        this.setHaveTheFloor(false);
                    }
                    this.talkingAllowed = false;
                    switch (this.state) {
                        case 1: 
                        case 2: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 12: 
                        case 13: {
                            break block7;
                        }
                        case 3: 
                        case 7: {
                            this.refreshButtonState();
                            break block7;
                        }
                        case 4: 
                        case 5: 
                        case 10: 
                        case 11: {
                            this.setState(9);
                            this.releaseMike();
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 19: {
                    if (this.ignoreTimeOut) {
                        this.stateMessage("Ignoring false time-out");
                        break;
                    }
                    switch (this.state) {
                        case 1: {
                            this.setState(8);
                            if (AudioDebug.STALL_FLOOR_REQUEST.isEnabled()) {
                                new LightweightTimer(new Runnable(){

                                    @Override
                                    public void run() {
                                        AudioBean.this.stateMessage("Firing stalled AudioProtocol.FLOOR_REQUEST");
                                        AudioBean.this.fireChannelData((byte)1);
                                        AudioBean.this.stateMessage("Firing AudioProtocol.FLOOR_RELEASE");
                                        AudioBean.this.fireChannelData((byte)2);
                                    }
                                }).scheduleIn(10000L);
                            } else {
                                this.stateMessage("Firing AudioProtocol.FLOOR_RELEASE");
                                this.fireChannelData((byte)2);
                            }
                            this.awaitFloorRelease();
                            this.setState(this.connected ? 3 : 6);
                            break block7;
                        }
                        case 2: {
                            this.timedOutRequestingMike = true;
                            this.setState(9);
                            this.releaseMike();
                            break block7;
                        }
                        case 9: {
                            this.timedOutReleasingMike = true;
                            if (this.haveTheFloor) {
                                this.setState(8);
                                this.releaseFloor();
                                break block7;
                            }
                            this.setState(!this.connected ? 6 : (this.countTalkers(true, false) < 1 ? 3 : 7));
                            break block7;
                        }
                        case 8: {
                            this.awaitFloorRelease();
                            this.setHaveTheFloor(false);
                            this.removeTalker(this.clients.getMyClient().getAddress());
                            this.setState(this.connected ? 3 : 6);
                            break block7;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            String diagnostic = "Watchdog timeout in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block7;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                default: {
                    String diagnostic = "Invalid event index: " + eventCode;
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalArgumentException(diagnostic), (boolean)false, (String)this.formatEventHistory());
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"updateState", (String)"stateLock", (Object)this.stateLock);
    }

    private void trackForAudioActivityDetection(int microphoneRawLevel, int packetMillis) {
        if (packetMillis != this.packetSizeInMillis) {
            this.packetSizeInMillis = packetMillis;
            int averageWindow = this.calcAverageWindow(this.packetSizeInMillis);
            this.shortAverage = new RollingAverage(averageWindow);
            this.longAverage = new RollingAverage(averageWindow * 7);
        }
        this.shortAverage.add(microphoneRawLevel);
        this.longAverage.add(microphoneRawLevel);
        if (this.shortAverage.getAverage() > this.longAverage.getAverage() * 2) {
            this.fireSpeakingEvent((short)(this.shortAverage.getAverage() - this.longAverage.getAverage()));
        }
    }

    private int calcAverageWindow(int packetMillis) {
        int window = 200 / packetMillis;
        if (window == 0) {
            return 2;
        }
        return window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOptimizationMode() {
        Object object = this.stateLock;
        synchronized (object) {
            byte desiredMode = this.getMaxXmitSpeed() < 300000 ? (byte)9 : 10;
            if (desiredMode != this.optimizationMode) {
                this.fireChannelData(desiredMode);
                this.optimizationMode = desiredMode;
            }
            if (this.engine != null) {
                this.engine.setMikeMillisPerPacket(desiredMode == 9 ? 240 : this.minMillisPerPacket);
            }
        }
    }

    private void updateTalkerDesc() {
        String firstTalkerName = null;
        int talkerCnt = 0;
        for (int i = 0; i < this.talkerAddrs.length; ++i) {
            ClientInfo ci;
            if (this.talkerAddrs[i] == -32767 || this.talkerAddrs[i] == this.myAddr || (ci = this.clients.get(this.talkerAddrs[i])) == null) continue;
            if (talkerCnt < 1) {
                firstTalkerName = ci.getDisplayName();
            }
            ++talkerCnt;
        }
        this.talkerDesc = talkerCnt < 1 ? null : (talkerCnt == 1 ? firstTalkerName : i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MULTIPLETALKERSDESC));
        if (this.contentCaptureProvider.get().isCapturingData()) {
            this.contentCapture.setTitle(this.talkerDesc);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void updateTelephonyUI() {
        block12: {
            block11: {
                if (this.isPlayback()) {
                    return;
                }
                v0 = enabled = this.module == null ? false : this.module.isTelephonyEnabled();
                if (!enabled) {
                    this.teleconfIndicatorFeature.setValue((Object)"");
                    return;
                }
                telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
                usingTelephoneForAudio = false;
                if (telephony != null && this.clients != null && (myClient = this.clients.getMyClient()) != null) {
                    myId = myClient.getAddress();
                    mode = telephony.getAudioMode(myId);
                    v1 = usingTelephoneForAudio = mode == 2;
                }
                if (!this.isSessionTeleconferenced()) break block11;
                this.broker.setFeaturePublished((Feature)this.audioVoipFeature, usingTelephoneForAudio == false);
                this.broker.setFeaturePublished((Feature)this.audioVoip2Feature, usingTelephoneForAudio == false);
                this.audioVoipFeature.setEnabled(usingTelephoneForAudio == false);
                this.audioVoip2Feature.setEnabled(usingTelephoneForAudio == false);
                break block12;
            }
            telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
            if (usingTelephoneForAudio) ** GOTO lbl-1000
            if (telephony.getTelephonyMode() == 2) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            this.isAutomatic = v2;
            this.broker.setFeaturePublished((Feature)this.audioVoipFeature, this.isAutomatic);
            this.broker.setFeaturePublished((Feature)this.audioVoip2Feature, this.isAutomatic);
            this.audioVoipFeature.setEnabled(this.isAutomatic);
            this.audioVoip2Feature.setEnabled(this.isAutomatic);
        }
        v3 = isTelephoneMode = this.module == null ? false : this.module.isTelephoneMode();
        if (isTelephoneMode) {
            chair = this.clients == null ? null : ChairProtocol.getChair((ClientList)this.clients);
            tel = null;
            pin = null;
            if (chair != null && chair.isMe()) {
                tel = telephony == null ? null : telephony.getModeratorTelephone();
                v4 = pin = telephony == null ? null : telephony.getModeratorPIN();
            }
            if (tel == null || tel.trim().length() == 0) {
                tel = telephony == null ? null : telephony.getParticipantTelephone();
                v5 = pin = telephony == null ? null : telephony.getParticipantPIN();
            }
            if (tel == null) {
                tel = "";
            }
            if (pin == null) {
                pin = "";
            }
            tel = tel.trim();
            pin = pin.trim();
            this.teleconfIndicatorFeature.setValue((Object)AudioBean.i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TELECONFERENCINGMSG));
        } else {
            this.teleconfIndicatorFeature.setValue((Object)"");
        }
    }

    public static int volumeLevel(short[] samples) {
        short maxSamp = samples[0];
        short minSamp = samples[0];
        for (int i = 1; i < samples.length; ++i) {
            short samp = samples[i];
            if (maxSamp < samp) {
                maxSamp = samp;
            }
            if (minSamp <= samp) continue;
            minSamp = samp;
        }
        if (AudioDebug.VOLUME.show() && volCount++ % 10 == 0) {
            System.out.println("VOLUME LEVEL: " + (maxSamp - minSamp) / 2);
        }
        return (maxSamp - minSamp) / 2;
    }

    private boolean waitForClients(List<ClientInfo> who) {
        boolean continueToMute = false;
        ClientInfo clientInfo = this.clients.getMyClient();
        short group = clientInfo.getGroupID();
        for (ClientInfo ci : who) {
            Short status = (Short)this.participantStatus.get(ci);
            if (ci.getGroupID() != group || status == null || status == 0) continue;
            continueToMute = true;
            break;
        }
        return continueToMute;
    }

    private void writeOutgoingSaveFile(byte[] compressedSamples) {
        if (this.outgoingSaveStrm != null) {
            try {
                this.outgoingSaveStrm.write(compressedSamples);
            }
            catch (Throwable t) {
                LogSupport.error((Object)this, (String)"onTransmit", (String)("Cannot write to outgoing audio file:\n" + t));
                try {
                    this.outgoingSaveStrm.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.outgoingSaveStrm = null;
            }
        }
    }

    private void updateButton(String context, boolean talkEnabled, boolean talkSelected, ImageIcon talkIcon, String talkText, String talkTip, boolean volAdjEnabled, boolean telModeBtnEnabled, int deferredFrom) {
        boolean shouldBeEnabled;
        if (this.audioVoipFeature != null) {
            this.stateMessage("setButtonState: " + context + " deferred from " + deferredFrom + "\ntalkEnabled: " + this.talkBtn.isEnabled() + " -> " + talkEnabled + "\ntalkIcon: " + this.talkBtn.getIcon() + " -> " + talkIcon + "\ntalkSelected: " + this.talkBtn.isSelected() + " -> " + talkSelected + "\ntalkText: " + this.talkBtn.getText() + " -> " + talkText + "\nvolAdjEnabled: " + this.remoteTalkerIncBtn.isEnabled() + " -> " + volAdjEnabled + "\ntelModeBtnEnabled: " + this.audioVoipFeature.isPublished() + " -> " + telModeBtnEnabled);
        }
        this.settingButtonState = true;
        boolean bl = shouldBeEnabled = talkEnabled && !this.isPlayback() && this.engine != null;
        if (this.talkFeature != null) {
            if (this.talkFeature.isEnabled() != shouldBeEnabled) {
                if (this.contentCaptureProvider.get().isCapturingData()) {
                    this.stateMessage("Ignore browser server talkEnabled = " + shouldBeEnabled);
                } else {
                    this.stateMessage("Set talkEnabled = " + shouldBeEnabled);
                    this.talkFeature.setEnabled(shouldBeEnabled);
                    if (shouldBeEnabled && this.audioVoip2Feature != null) {
                        this.audioVoip2Feature.setEnabled(true);
                    }
                    if (shouldBeEnabled && this.moveFocusToTalkBtn) {
                        this.moveFocusToTalkBtn = false;
                        this.talkBtn.requestFocus();
                    }
                }
            }
            if ((Boolean)this.talkFeature.getValue() != talkSelected) {
                this.talkFeature.setValue((Object)talkSelected);
                this.stateMessage("Set talkSelected = " + talkSelected);
            }
        } else {
            this.talkFeatureInitEnabled = shouldBeEnabled;
            this.talkFeatureInitValue = talkSelected;
        }
        if (this.talkBtn.getIcon() != talkIcon) {
            this.talkBtn.setDisabledIcon(null);
            this.talkBtn.setIcon(talkIcon);
            this.stateMessage("Set talkIcon = " + talkIcon);
        }
        if (talkText == null) {
            if (this.talkBtn.getText() != null) {
                this.talkBtn.setText(null);
                this.stateMessage("Set talkText = null");
            }
        } else if (!talkText.equals(this.talkBtn.getText())) {
            Insets ins = new Insets(0, 0, 0, 0);
            Border brdr = this.talkBtn.getBorder();
            if (brdr != null) {
                ins = brdr.getBorderInsets(this.talkBtn);
            }
            Insets marg = this.talkBtn.getMargin();
            int maxTextWidth = this.talkBtn.getSize().width - ins.left - ins.right - marg.left - marg.right;
            Font base = this.talkFonts[0];
            for (int i = 0; i < this.talkFonts.length; ++i) {
                if (this.talkFonts[i] == null) {
                    this.talkFonts[i] = new Font(base.getName(), base.getStyle(), base.getSize() - i);
                }
                if (i == this.talkFonts.length - 1) {
                    this.talkBtn.setFont(this.talkFonts[i]);
                    break;
                }
                FontMetrics metrics = this.getFontMetrics(this.talkFonts[i]);
                int len = metrics.stringWidth(talkText);
                if (len > maxTextWidth) continue;
                this.talkBtn.setFont(this.talkFonts[i]);
                break;
            }
            this.talkBtn.setText(talkText);
            this.stateMessage("Set talkText = " + talkText);
            AccessibilityUtils.setAccessibleName((Object)this.talkBtn, (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_ACCESSIBLE_TALK, new Object[]{""}));
        }
        String tt = this.talkBtn.getToolTipText();
        if (talkTip == null) {
            if (tt != null) {
                this.talkBtn.setToolTipText(null);
                this.stateMessage("Set talkTip = null");
            }
        } else if (!talkTip.equals(tt)) {
            this.talkBtn.setToolTipText(talkTip);
            this.stateMessage("Set talkTip = " + talkTip);
        }
        if (this.remoteTalkerIncBtn.isEnabled() != volAdjEnabled) {
            this.remoteTalkerIncBtn.setEnabled(volAdjEnabled);
            this.remoteTalkerDecBtn.setEnabled(volAdjEnabled);
            this.stateMessage("Set volAdjEnabled = " + volAdjEnabled);
        }
        if (this.audioVoipFeature != null && this.audioPhoneFeature.isPublished() != telModeBtnEnabled) {
            this.updateMenuForVoip(telModeBtnEnabled);
            this.stateMessage("Set telModeBtnEnabled = " + telModeBtnEnabled);
        }
        this.settingButtonState = false;
        --this.buttonUpdatesPending;
    }

    public void registerProvider() {
        this.audioPermissionDelegate.setClientProvider(this.clientProvider);
        this.audioPermissionDelegate.setSession(this.session);
        CRPermissionFactory permissionFactory = new CRPermissionFactory("AudioPermission", "AudioPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.audioPermissionDelegate);
        this.session.registerPermission(permissionFactory);
    }

    private void createFeatures() {
        this.talkFeature = this.broker.createBooleanFeature((Object)this, "/audio/talk", true, false, i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKPLAIN), i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKTIP));
        this.talkFeature.setTrueIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOBEAN_TALKICON));
        this.talkFeature.setValue((Object)this.talkFeatureInitValue);
        this.talkFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                AudioBean.this.processTalkPushed((Boolean)ev.getNewValue());
            }
        });
        String sessionLabel = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.session");
        this.audioPhoneFeature = this.broker.createActionFeature((Object)this, "/audio/phoneAudioMode", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_AUDIOMODETELEPHONEMENUITEM), "");
        this.audioPhoneFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                AudioBean.this.toggleAudioMode();
            }
        });
        this.audioPhone2Feature = this.broker.createActionFeature((Object)this, "/audio/phoneAudioMode2", "", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_AUDIOMODETELEPHONEBUTTONTIP, new Object[]{sessionLabel}));
        this.audioPhone2Feature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                AudioBean.this.toggleAudioMode();
            }
        });
        this.audioPhone2Feature.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_PHONEMODE_ICON));
        this.audioPhone2Feature.setPressedIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_PHONEMODE_PRESSED_ICON));
        this.audioPhone2Feature.setRolloverIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_PHONEMODE_ROLLOVER_ICON));
        this.audioVoipFeature = this.broker.createActionFeature((Object)this, "/audio/voipAudioMode", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_AUDIOMODEVOIPMENUITEM), "");
        this.audioVoipFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                AudioBean.this.toggleAudioMode();
            }
        });
        this.audioVoip2Feature = this.broker.createActionFeature((Object)this, "/audio/voipAudioMode2", "", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_AUDIOMODEVOIPBUTTONTIP, new Object[]{sessionLabel}));
        this.audioVoip2Feature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                AudioBean.this.toggleAudioMode();
            }
        });
        this.audioVoip2Feature.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_VOIPMODE_ICON));
        this.audioVoip2Feature.setPressedIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_VOIPMODE_PRESSED_ICON));
        this.audioVoip2Feature.setRolloverIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_VOIPMODE_ROLLOVER_ICON));
        this.teleconfIndicatorFeature = this.broker.createStringFeature((Object)this, "/audio/teleconfIndicator", true, "", "", null);
        this.remoteTalkerIncFeature = this.broker.createActionFeature((Object)this, "/audio/remoteTalkerInc", i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_INCICON_ACCESSIBLENAME), i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_INCTIP));
        this.remoteTalkerIncFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                LogSupport.message((String)"audioBean: remoteTalkerIncFeature invoked -> needs implementation");
            }
        });
        this.remoteTalkerDecFeature = this.broker.createActionFeature((Object)this, "/audio/remoteTalkerDec", i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_DECICON_ACCESSIBLENAME), i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_DECTIP));
        this.remoteTalkerDecFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                LogSupport.message((String)"audioBean: remoteTalkerDecFeature invoked -> needs implementation");
            }
        });
        this.micLevelSliderFeature = this.broker.createNumericFeature((Object)this, "/audio/micLevelSlider", true, 0, i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MIKEVOLUME), i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_ACCESSIBLE_MIKE_LEVEL));
        this.micLevelSliderFeature.setMaximumValue((Comparable)Integer.valueOf(100));
        this.micLevelSliderFeature.setMinimumValue((Comparable)Integer.valueOf(0));
        this.micLevelSliderFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                AudioBean.this.mikeLevelChanged();
            }
        });
        this.micLevelIndicatorFeature = this.broker.createNumericFeature((Object)this, "/audio/micLevelIndicator", true, 0, i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MIKEVOLUME), i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_ACCESSIBLE_MIKE_LEVEL));
        this.micLevelIndicatorFeature.setMaximumValue((Comparable)Integer.valueOf(Short.MAX_VALUE));
        this.micLevelIndicatorFeature.setMinimumValue((Comparable)Integer.valueOf(0));
        this.micLevelIndicatorFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
            }
        });
        this.micLevelVUFeature = new VUFeature(this.micLevelIndicatorFeature);
        this.volumeLevelSliderFeature = this.broker.createNumericFeature((Object)this, "/audio/volLevelSlider", true, 0, i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SPEAKERVOLUME), i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_ACCESSIBLE_SPKR_LEVEL));
        this.volumeLevelSliderFeature.setMaximumValue((Comparable)Integer.valueOf(100));
        this.volumeLevelSliderFeature.setMinimumValue((Comparable)Integer.valueOf(0));
        this.volumeLevelSliderFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                AudioBean.this.spkrLevelChanged();
            }
        });
        this.volumeLevelIndicatorFeature = this.broker.createNumericFeature((Object)this, "/audio/volLevelIndicator", true, 0, i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SPEAKERVOLUME), i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_ACCESSIBLE_SPKR_LEVEL));
        this.volumeLevelIndicatorFeature.setMaximumValue((Comparable)Integer.valueOf(Short.MAX_VALUE));
        this.volumeLevelIndicatorFeature.setMinimumValue((Comparable)Integer.valueOf(0));
        this.volumeLevelIndicatorFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
            }
        });
        this.volumeLevelVUFeature = new VUFeature(this.volumeLevelIndicatorFeature);
        this.talkFeature.setEnabled(this.talkFeatureInitEnabled);
        this.remoteTalkerIncFeature.setEnabled(true);
        this.remoteTalkerDecFeature.setEnabled(true);
        this.micLevelSliderFeature.setEnabled(true);
        this.micLevelIndicatorFeature.setEnabled(true);
        this.volumeLevelSliderFeature.setEnabled(true);
        this.volumeLevelIndicatorFeature.setEnabled(true);
        this.audioVoipFeature.setEnabled(true);
        this.audioVoip2Feature.setEnabled(true);
        this.audioPhoneFeature.setEnabled(true);
        this.audioPhone2Feature.setEnabled(true);
        this.teleconfIndicatorFeature.setEnabled(true);
        this.broker.addFeature((Feature)this.remoteTalkerIncFeature);
        this.broker.addFeature((Feature)this.remoteTalkerDecFeature);
        this.broker.addFeature(this.micLevelSliderFeature);
        this.broker.addFeature(this.micLevelIndicatorFeature);
        this.broker.addFeature(this.volumeLevelSliderFeature);
        this.broker.addFeature(this.volumeLevelIndicatorFeature);
        this.broker.setFeaturePublished((Feature)this.audioPhoneFeature, false);
        this.broker.setFeaturePublished((Feature)this.audioPhone2Feature, false);
        this.broker.setFeaturePublished((Feature)this.teleconfIndicatorFeature, true);
        this.broker.announceNotification((Object)this, MIC_OPENED);
        this.broker.announceNotification((Object)this, MIC_CLOSED);
    }

    private void fireNotification(String path, String msg) {
        long ts = this.client.getSessionTime();
        this.broker.sendNotification((Object)this, path, msg, ts);
    }

    public void publishTalkButton(boolean publish) {
        if (this.broker != null && this.talkFeature != null) {
            this.broker.setFeaturePublished((Feature)this.talkFeature, publish);
        }
    }

    void setAudioSetupAwayProperty(boolean active) {
        if (this.clients != null && !this.isPlayback() && this.connected) {
            ClientInfo ci = this.clients.getMyClient();
            ci.setProperty("audioSettingUpAudio", active);
        }
    }

    CRSession getSession() {
        return this.session;
    }

    static {
        LOAD_TIME = System.currentTimeMillis();
        NULL_LABEL = null;
        NULL_TIP = null;
        SAMP_RATE_DEFAULT_FOR_SPKR = Platform.getPlatform() == 2 ? 8000 : 44100;
        SAMP_RATES = new int[]{8000, 11025, 16000, 22050, 32000, 44100, 48000};
        SET_HTML_TYPE_FACE = Platform.getOS() == 202 && Platform.checkJavaVersion((String)"1.3*");
        i18n = I18n.create(AudioBean.class);
        volCount = 0;
        ATTACK_SLOPE = -0.17646626984126984;
        DECAY_SLOPE = 2.117595238095238;
    }

    private class AudioAnnotationProvider
    implements PropertyChangeListener {
        private TelephonyAPI telephony;

        private AudioAnnotationProvider() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (AudioBean.this.clients == null) {
                return;
            }
            String propertyName = evt.getPropertyName();
            short ownerId = AudioBean.this.clients.getPropertyOwner(evt.getSource());
            ClientInfo ci = AudioBean.this.clients.get(ownerId);
            if (ci == null) {
                return;
            }
            boolean activeProp = propertyName.equals("audioActive");
            boolean yellowProp = propertyName.equals("audioYellowStatus");
            boolean redProp = propertyName.equals("audioRedStatus");
            boolean usingTelephony = false;
            boolean isBridge = false;
            if (activeProp || yellowProp || redProp) {
                if (this.telephony == null) {
                    this.telephony = (TelephonyAPI)AudioBean.this.imps.findBest(TelephonyAPI.class);
                }
                if (this.telephony != null) {
                    int mode = this.telephony.getAudioMode(ownerId);
                    usingTelephony = mode == 2 || mode == 3;
                    isBridge = this.telephony.isBridge(ownerId);
                }
            }
            if (activeProp) {
                if (!usingTelephony) {
                    boolean active = ci.getProperty("audioActive", false);
                    if (active) {
                        AudioBean.this.session.setAnnotationValue(ownerId, "AudioActivityAnnotation", (Object)1);
                    } else {
                        AudioBean.this.session.setAnnotationValue(ownerId, "AudioActivityAnnotation", (Object)0);
                    }
                } else {
                    AudioBean.this.session.setAnnotationValue(ownerId, "AudioActivityAnnotation", (Object)0);
                }
            } else if ((yellowProp || redProp) && !usingTelephony && !isBridge) {
                boolean status_low = ci.getProperty("audioYellowStatus", false);
                boolean status_high = ci.getProperty("audioRedStatus", false);
                if (status_high) {
                    AudioBean.this.session.setAnnotationValue(ownerId, "AudioLagAnnotation", (Object)2);
                } else if (status_low) {
                    AudioBean.this.session.setAnnotationValue(ownerId, "AudioLagAnnotation", (Object)1);
                } else {
                    AudioBean.this.session.setAnnotationValue(ownerId, "AudioLagAnnotation", (Object)0);
                }
            }
        }
    }

    class NoiseInfo {
        private int level;
        private int millis;

        public NoiseInfo(int level, int millis) {
            this.level = level;
            this.millis = millis;
        }

        public int getLevel() {
            return this.level;
        }

        public int getMillis() {
            return this.millis;
        }
    }
}

