/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.groupware.audio.ecelp.ECELPCodec;
import com.elluminate.groupware.audio.module.AudioBean;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.utils.AudioFileLoader;
import com.elluminate.groupware.imps.module.AudioAPI;
import com.elluminate.groupware.imps.module.AudioAlertAPI;
import com.elluminate.util.log.LogSupport;
import java.net.URL;

public class AudioAPIImpl
implements AudioAPI {
    private static final String ECELP_EXTENSION = ".ecelp20";
    private ECELPCodec codec;
    private Object lockObject = new Object();
    private AudioBean audioBean;

    public AudioAPIImpl(AudioBean theAudioBean) {
        this.audioBean = theAudioBean;
    }

    public void volumeInc(short clientId) {
        this.audioBean.volumeInc(clientId);
    }

    public void volumeDec(short clientId) {
        this.audioBean.volumeDec(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playCustomAlert(AudioAlertAPI audioAlert) {
        Object object = this.lockObject;
        synchronized (object) {
            short[] samples = audioAlert.getSamples();
            if (samples == null && audioAlert.hasCustomSound()) {
                try {
                    String fileName = audioAlert.getLoadedFileName();
                    if (fileName.endsWith(ECELP_EXTENSION)) {
                        if (this.codec == null) {
                            this.openDecoder();
                        } else {
                            this.codec.resetDecoder();
                        }
                        samples = this.codec.decode(audioAlert.getBytes());
                    } else {
                        samples = AudioFileLoader.loadAudioFile((URL)audioAlert.getURL(), (float)8000.0f);
                    }
                    if (samples != null) {
                        audioAlert.setSamples(samples);
                    } else {
                        LogSupport.message((Object)this, (String)"playCustomAlert", (String)("Failed to load custom sound: " + audioAlert));
                        audioAlert.clearCustomSound();
                    }
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"playCustomAlert", (Throwable)t, (boolean)true, (String)("playing: " + audioAlert));
                    audioAlert.clearCustomSound();
                }
            }
            if (samples != null) {
                AudioEngine.getInstance(this.audioBean.getAppFrame()).playCustomSound(samples);
            } else {
                AudioEngine.beep();
            }
        }
    }

    public String getProvider() {
        return "audio";
    }

    public byte getTier() {
        return 32;
    }

    private void openDecoder() {
        if (this.codec == null) {
            this.codec = new ECELPCodec();
            this.codec.openDecoder();
        }
    }
}

