/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.ecelp;

public abstract class Filter {
    protected float[] coeffs;
    protected float[] memory;
    protected int order;

    protected Filter(int order) {
        this.order = order;
        this.coeffs = new float[order + 1];
        this.memory = new float[order + 1];
    }

    public void filter(float[] data) {
        this.filter(data.length, data);
    }

    public abstract void filter(int var1, float[] var2);

    public float[] getCoeffs() {
        return this.coeffs;
    }

    public float[] getMemory() {
        return this.memory;
    }

    public int getOrder() {
        return this.order;
    }

    public void setCoeffs(float[] newCoeffs) {
        System.arraycopy(newCoeffs, 0, this.coeffs, 0, this.order + 1);
    }

    public void setMemory(float[] newMemory) {
        System.arraycopy(newMemory, 0, this.memory, 0, this.order + 1);
    }

    public void zeroCoeffs() {
        for (int i = 0; i <= this.order; ++i) {
            this.coeffs[i] = 0.0f;
        }
    }

    public void zeroMemory() {
        for (int i = 0; i <= this.order; ++i) {
            this.memory[i] = 0.0f;
        }
    }
}

