/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.Note;
import com.elluminate.util.log.LogSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;

class TextNote
extends Note {
    public static final String TEXT_PROPERTY = "text";
    private static HashMap cachedEditorKits = new HashMap();
    private EditorKit editorKit;
    private Document document;

    public TextNote() {
        this("text/rtf");
    }

    public TextNote(String contentType) {
        super(contentType);
        this.editorKit = TextNote.getEditorKit(contentType);
        this.document = this.editorKit.createDefaultDocument();
        this.document.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextNote.this.fireTextChange(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextNote.this.fireTextChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!TextNote.this.isEmpty()) {
                    TextNote.this.fireTextChange(e);
                }
            }
        });
    }

    private void fireTextChange(DocumentEvent e) {
        this.changeSupport.firePropertyChange(TEXT_PROPERTY, null, e);
    }

    @Override
    public byte[] getData() throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String charset = this.getCharacterSet();
            if (charset != null) {
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, charset);
                this.editorKit.write(w, this.document, 0, this.document.getLength());
            } else {
                this.editorKit.write(out, this.document, 0, this.document.getLength());
            }
            return out.toByteArray();
        }
        catch (BadLocationException ex) {
            LogSupport.error((Object)this, (String)"getData", (String)ex.toString());
            return new byte[0];
        }
    }

    @Override
    public void setData(byte[] data) throws IOException {
        try {
            int len;
            this.document.remove(0, this.document.getLength());
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            String charset = this.getCharacterSet();
            if (charset != null) {
                InputStreamReader r = new InputStreamReader((InputStream)in, charset);
                this.editorKit.read(r, this.document, 0);
            } else {
                this.editorKit.read(in, this.document, 0);
            }
            if (this.getContentType().toLowerCase(Locale.ENGLISH).startsWith("text/rtf") && (len = this.document.getLength()) > 0 && this.document.getText(len - 1, 1).equals("\n")) {
                this.document.remove(len - 1, 1);
            }
        }
        catch (BadLocationException ex) {
            LogSupport.error((Object)this, (String)"setData", (String)ex.toString());
        }
    }

    @Override
    public String getDataAsText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException ex) {
            LogSupport.error((Object)this, (String)"getDataAsText", (String)ex.toString());
            return "";
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getDataAsText().length() == 0;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getCharacterSet() {
        String ctype = this.getContentType();
        int pos = ctype.indexOf(59);
        if (pos == -1) {
            return null;
        }
        String parm = "charset=";
        String parms = ctype.substring(pos + 1);
        if ((pos = parms.indexOf("charset=")) == -1) {
            return null;
        }
        String charset = parms.substring(pos + "charset=".length());
        if ((pos = charset.indexOf(59)) != -1) {
            charset = charset.substring(0, pos);
        }
        return charset.trim();
    }

    private static EditorKit getEditorKit(String contentType) {
        EditorKit kit;
        String ctype = contentType.toLowerCase(Locale.ENGLISH);
        if (ctype.startsWith("text/rtf")) {
            kit = (EditorKit)cachedEditorKits.get("text/rtf");
            if (kit == null) {
                kit = new RTFEditorKit();
                cachedEditorKits.put("text/rtf", kit);
            }
        } else if (ctype.startsWith("text/html")) {
            kit = (EditorKit)cachedEditorKits.get("text/html");
            if (kit == null) {
                kit = new HTMLEditorKit();
                cachedEditorKits.put("text/html", kit);
            }
        } else {
            kit = (EditorKit)cachedEditorKits.get("text/plain");
            if (kit == null) {
                kit = new DefaultEditorKit();
                cachedEditorKits.put("text/plain", kit);
            }
        }
        return kit;
    }
}

