/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.NotesDocument;
import com.elluminate.groupware.notes.module.util.NotesUtilities;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

class NotesIndex {
    public static final String ENTRY_PROPERTY = "entry";
    public static final String ENTRY_COUNT_PROPERTY = "entryCount";
    public static final String MODIFIED_PROPERTY = "modified";
    private static final String ROOT_NAME = "notes_index";
    private static final String DOC_FILENAME_ATTR = "file";
    private static final String DOC_MODIFICATION_DATE_ATTR = "modification_date";
    private File file;
    private File notesDirectory;
    private String noteFileExtension;
    private HashMap files = new HashMap();
    private HashMap documents = new HashMap();
    private boolean loaded = false;
    private boolean modified = false;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public NotesIndex(File file, File notesDirectory, String noteFileExtension) {
        this.file = file;
        this.notesDirectory = notesDirectory;
        this.noteFileExtension = noteFileExtension.toLowerCase(Locale.ENGLISH);
    }

    public void load() throws IOException {
        if (this.file.exists()) {
            Document doc;
            SAXBuilder b = new SAXBuilder();
            try {
                doc = b.build(this.file);
            }
            catch (JDOMException ex) {
                throw new IOException("invalid data in index file");
            }
            Element root = doc.getRootElement();
            if (!root.getName().equals(ROOT_NAME)) {
                throw new IOException("invalid root element in index file: " + root.getName());
            }
            for (Element e : root.getChildren()) {
                if (!e.getName().equals("notes_document")) {
                    LogSupport.log((Object)this, (String)"load", (String)("unknown index element: " + e.getName()));
                    continue;
                }
                String filename = null;
                Attribute attr = e.getAttribute(DOC_FILENAME_ATTR);
                if (attr != null) {
                    filename = attr.getValue();
                }
                Date modDate = null;
                attr = e.getAttribute(DOC_MODIFICATION_DATE_ATTR);
                if (attr != null) {
                    try {
                        modDate = new Date(attr.getLongValue());
                    }
                    catch (DataConversionException ex) {
                        // empty catch block
                    }
                }
                String id = null;
                attr = e.getAttribute("session_id");
                if (attr != null) {
                    id = attr.getValue();
                }
                Date date = null;
                attr = e.getAttribute("session_date");
                if (attr != null) {
                    date = NotesUtilities.parseDate(attr.getValue());
                }
                String name = null;
                attr = e.getAttribute("session_name");
                if (attr != null) {
                    name = attr.getValue();
                }
                String auth = null;
                attr = e.getAttribute("author");
                if (attr != null) {
                    auth = attr.getValue();
                }
                if (filename == null || modDate == null || id == null || date == null || name == null || auth == null) {
                    LogSupport.error((Object)this, (String)"load", (String)("invalid entry in notes index: " + filename + "," + modDate + "," + id + "," + date + "," + name + "," + auth));
                    continue;
                }
                if (!this.notesDirectory.exists()) {
                    this.notesDirectory.mkdirs();
                }
                File f = new File(this.notesDirectory, filename);
                NotesDocument ndoc = new NotesDocument(f, modDate, id, date, name, auth);
                this.addDocument(ndoc, false);
            }
        }
        this.sync();
        this.loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        Element root = new Element(ROOT_NAME);
        Document doc = new Document(root);
        Iterator itr = this.documents.entrySet().iterator();
        while (itr.hasNext()) {
            List list = (List)itr.next().getValue();
            for (NotesDocument ndoc : list) {
                Element e = new Element("notes_document");
                e.setAttribute(DOC_FILENAME_ATTR, ndoc.getFile().getName());
                e.setAttribute(DOC_MODIFICATION_DATE_ATTR, String.valueOf(ndoc.getFile().lastModified()));
                e.setAttribute("session_id", ndoc.getSessionID());
                e.setAttribute("session_date", NotesUtilities.formatDate(ndoc.getSessionDate()));
                e.setAttribute("session_name", ndoc.getSessionName());
                e.setAttribute("author", ndoc.getAuthor());
                root.addContent((Content)e);
            }
        }
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            out.output(doc, (Writer)w);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException ex) {}
            }
        }
        this.setModified(false);
    }

    private synchronized void sync() {
        if (!this.notesDirectory.exists()) {
            this.removeAllDocuments();
            return;
        }
        ArrayList filenames = new ArrayList(this.files.keySet());
        File[] noteFiles = this.notesDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName().toLowerCase(Locale.ENGLISH);
                return name.endsWith(NotesIndex.this.noteFileExtension);
            }
        });
        for (int i = 0; i < noteFiles.length; ++i) {
            NotesDocument ndoc;
            File f = noteFiles[i];
            String filename = f.getName();
            if (!filenames.remove(filename)) {
                try {
                    ndoc = new NotesDocument(f);
                    ndoc.loadHeader();
                    this.addDocument(ndoc, true);
                }
                catch (IOException ex) {
                    LogSupport.error((Object)this, (String)"sync", (String)ex.toString());
                }
                continue;
            }
            ndoc = this.getDocument(filename);
            if (f.lastModified() <= ndoc.getModificationDate().getTime()) continue;
            try {
                ndoc.loadHeader();
                continue;
            }
            catch (IOException ex) {
                LogSupport.error((Object)this, (String)"sync", (String)ex.toString());
            }
        }
        for (String filename : filenames) {
            NotesDocument ndoc = this.getDocument(filename);
            this.removeDocument(ndoc, true);
        }
    }

    public synchronized void addDocument(NotesDocument document) {
        this.addDocument(document, true);
    }

    private void addDocument(NotesDocument document, boolean publicChange) {
        if (!document.isIdentified()) {
            throw new IllegalStateException("document is not identified: " + document.getFile().getPath());
        }
        String sessID = document.getSessionID();
        ArrayList<NotesDocument> list = (ArrayList<NotesDocument>)this.documents.get(sessID);
        if (list == null) {
            list = new ArrayList<NotesDocument>();
            this.documents.put(sessID, list);
        }
        int oldCount = this.files.size();
        list.add(document);
        this.files.put(document.getFile().getName(), sessID);
        if (publicChange) {
            int newCount = this.files.size();
            this.changeSupport.firePropertyChange(ENTRY_COUNT_PROPERTY, oldCount, newCount);
            this.changeSupport.firePropertyChange(ENTRY_PROPERTY, null, document);
            this.setModified(true);
        }
    }

    public synchronized void removeDocument(NotesDocument document) {
        this.removeDocument(document, true);
    }

    private synchronized void removeDocument(NotesDocument document, boolean publicChange) {
        int oldCount = this.files.size();
        String filename = document.getFile().getName();
        String sessID = (String)this.files.remove(filename);
        if (sessID != null) {
            List list = (List)this.documents.get(sessID);
            list.remove(document);
            if (publicChange) {
                int newCount = this.files.size();
                this.changeSupport.firePropertyChange(ENTRY_COUNT_PROPERTY, oldCount, newCount);
                this.changeSupport.firePropertyChange(ENTRY_PROPERTY, document, null);
                this.setModified(true);
            }
        }
    }

    private synchronized void removeAllDocuments() {
        ArrayList filenames = new ArrayList(this.files.keySet());
        for (String filename : filenames) {
            this.removeDocument(this.getDocument(filename));
        }
    }

    private NotesDocument getDocument(String filename) {
        String sessID = (String)this.files.get(filename);
        if (sessID == null) {
            return null;
        }
        List list = (List)this.documents.get(sessID);
        for (NotesDocument ndoc : list) {
            if (!filename.equals(ndoc.getFile().getName())) continue;
            return ndoc;
        }
        return null;
    }

    public List getDocuments(String sessionID) {
        return (List)this.documents.get(sessionID);
    }

    public List getDocuments() {
        ArrayList<NotesDocument> ndocs = new ArrayList<NotesDocument>();
        Iterator itr = this.documents.entrySet().iterator();
        while (itr.hasNext()) {
            List list = (List)itr.next().getValue();
            Iterator itr2 = list.iterator();
            while (itr2.hasNext()) {
                ndocs.add((NotesDocument)itr2.next());
            }
        }
        return ndocs;
    }

    public List findDocumentsByName(String searchString) {
        if (searchString.length() == 0) {
            return this.getDocuments();
        }
        ArrayList<NotesDocument> ndocs = new ArrayList<NotesDocument>();
        String srch = searchString.toLowerCase();
        Iterator itr = this.documents.entrySet().iterator();
        while (itr.hasNext()) {
            List list = (List)itr.next().getValue();
            for (NotesDocument ndoc : list) {
                String sessName = ndoc.getSessionName().toLowerCase();
                if (sessName.indexOf(srch) == -1) continue;
                ndocs.add(ndoc);
            }
        }
        return ndocs;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean modified) {
        if (modified == this.modified) {
            return;
        }
        boolean oldModified = this.modified;
        this.modified = modified;
        this.changeSupport.firePropertyChange(MODIFIED_PROPERTY, oldModified, modified);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }
}

