/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.Note;
import com.elluminate.groupware.notes.module.NoteComponent;
import com.elluminate.groupware.notes.module.NotesDocument;
import com.elluminate.groupware.notes.module.NotesEditor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class NotesEditorChangeListener
implements PropertyChangeListener {
    private NotesEditor editor;

    public NotesEditorChangeListener(NotesEditor editor) {
        this.editor = editor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String changedProperty = e.getPropertyName();
        if (changedProperty.equals("note")) {
            this.changeNoteProperty(e.getOldValue(), e.getNewValue(), (NotesDocument)e.getSource());
        }
    }

    private void changeNoteProperty(Object oldValue, Object newValue, NotesDocument notesDoc) {
        NoteComponent ncomp;
        if (oldValue != null && newValue != null) {
            if (oldValue.equals("time") || oldValue.equals("offset")) {
                this.editor.revalidate();
                this.editor.repaint();
            }
        } else if (newValue != null) {
            this.editor.addNewNoteComponent((Note)newValue, false);
            this.editor.setAuthorDisplayInDocument(notesDoc);
        } else if (oldValue != null && (ncomp = this.editor.getNoteComponent((Note)oldValue)) != null) {
            this.editor.remove(ncomp);
            this.editor.setAuthorDisplayInDocument(notesDoc);
        }
    }
}

