/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.NotesDebug;
import com.elluminate.groupware.notes.module.ImageNote;
import com.elluminate.groupware.notes.module.Note;
import com.elluminate.groupware.notes.module.TextNote;
import com.elluminate.groupware.notes.module.util.NotesUtilities;
import com.elluminate.util.Base64;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.text.BadLocationException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

class NotesDocument {
    public static final String NOTE_PROPERTY = "note";
    public static final String NOTE_COUNT_PROPERTY = "noteCount";
    public static final String MODIFIED_PROPERTY = "modified";
    static final String ROOT_NAME = "notes_document";
    static final String SESSION_ID_ATTR = "session_id";
    static final String SESSION_DATE_ATTR = "session_date";
    static final String SESSION_NAME_ATTR = "session_name";
    static final String AUTHOR_ATTR = "author";
    private static final String NOTE_ELEMENT = "note";
    private static final String NOTE_CONTENT_TYPE_ATTR = "content-type";
    private static final String NOTE_TIME_ATTR = "time";
    private static final String NOTE_OFFSET_ATTR = "offset";
    private static final String NOTE_AUTHOR_ATTR = "author";
    private File file;
    private Date modificationDate;
    private String sessionID;
    private Date sessionDate;
    private String sessionName;
    private String author;
    private ArrayList notes = new ArrayList();
    private boolean identified;
    private boolean loaded = false;
    private boolean modified = false;
    private volatile boolean killLoad = false;
    private final Object privateObjectForThreadExclusion = new Object();
    private PropertyChangeListener noteListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Note n = (Note)e.getSource();
            String prop = e.getPropertyName();
            if (prop == NotesDocument.NOTE_TIME_ATTR && NotesDocument.this.notes.remove(n)) {
                NotesDocument.this.insertNoteSorted(n);
            }
            NotesDocument.this.changeSupport.firePropertyChange("note", prop, n);
            NotesDocument.this.setModified(true);
        }
    };
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public NotesDocument(File file) {
        this.file = file;
        this.identified = false;
    }

    public NotesDocument(File file, Date modificationDate, String sessionID, Date sessionDate, String sessionName, String author) {
        this.file = file;
        this.modificationDate = modificationDate;
        this.sessionID = sessionID;
        this.sessionDate = sessionDate;
        this.sessionName = sessionName;
        this.author = author;
        this.identified = true;
    }

    public File getFile() {
        return this.file;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public String getSessionID() {
        this.checkIdentified();
        return this.sessionID;
    }

    public Date getSessionDate() {
        this.checkIdentified();
        return this.sessionDate;
    }

    public String getSessionName() {
        this.checkIdentified();
        return this.sessionName;
    }

    public String getAuthor() {
        this.checkIdentified();
        return this.author;
    }

    public void setAuthor(String author) {
        this.checkIdentified();
        this.author = author;
    }

    private void checkIdentified() {
        if (!this.identified) {
            throw new IllegalStateException("header not loaded");
        }
    }

    private void checkFiled() {
        if (!this.file.exists()) {
            throw new IllegalStateException("document does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadHeader() throws IOException {
        Document doc;
        this.checkFiled();
        StringBuffer xml = new StringBuffer();
        BufferedReader r = null;
        try {
            String line;
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
            String headerStart = "<notes_document";
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).startsWith("<notes_document") && line.endsWith(">")) {
                    int len = line.length();
                    if (line.charAt(len - 2) != '/') {
                        line = line.substring(0, len - 1) + "/>";
                    }
                    xml.append(line);
                    break;
                }
                xml.append(line);
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {}
            }
        }
        SAXBuilder b = new SAXBuilder();
        try {
            doc = b.build((Reader)new StringReader(xml.toString()));
        }
        catch (JDOMException ex) {
            throw new IOException("invalid data in notes file");
        }
        Element root = doc.getRootElement();
        if (!root.getName().equals(ROOT_NAME)) {
            throw new IOException("invalid root element in notes file: " + root.getName());
        }
        String id = null;
        Attribute attr = root.getAttribute(SESSION_ID_ATTR);
        if (attr != null) {
            id = attr.getValue();
        }
        Date date = null;
        attr = root.getAttribute(SESSION_DATE_ATTR);
        if (attr != null) {
            date = NotesUtilities.parseDate(attr.getValue());
        }
        String name = null;
        attr = root.getAttribute(SESSION_NAME_ATTR);
        if (attr != null) {
            name = attr.getValue();
        }
        String auth = null;
        attr = root.getAttribute("author");
        if (attr != null) {
            auth = attr.getValue();
        }
        if (id == null || date == null || name == null || auth == null) {
            throw new IOException("invalid header in notes document");
        }
        this.modificationDate = new Date(this.file.lastModified());
        this.sessionID = id;
        this.sessionDate = date;
        this.sessionName = name;
        this.author = auth;
        this.identified = true;
    }

    public synchronized void loadNotes() throws IOException {
        Document doc;
        if (!this.file.exists()) {
            this.loaded = true;
            return;
        }
        SAXBuilder b = new SAXBuilder();
        try {
            doc = b.build(this.file);
        }
        catch (JDOMException ex) {
            throw new IOException("invalid data in notes file");
        }
        Element root = doc.getRootElement();
        if (!root.getName().equals(ROOT_NAME)) {
            throw new IOException("invalid root element in notes file: " + root.getName());
        }
        for (Element e : root.getChildren()) {
            if (!e.getName().equals("note")) {
                LogSupport.log((Object)this, (String)"loadNotes", (String)("unknown notes element: " + e.getName()));
                continue;
            }
            String ctype = null;
            Attribute attr = e.getAttribute(NOTE_CONTENT_TYPE_ATTR);
            if (attr != null) {
                ctype = attr.getValue();
            }
            long time = -1L;
            attr = e.getAttribute(NOTE_TIME_ATTR);
            if (attr != null) {
                try {
                    time = attr.getLongValue();
                }
                catch (DataConversionException ex) {
                    // empty catch block
                }
            }
            int offset = -1;
            attr = e.getAttribute(NOTE_OFFSET_ATTR);
            if (attr != null) {
                try {
                    offset = attr.getIntValue();
                }
                catch (DataConversionException ex) {
                    // empty catch block
                }
            }
            String auth = null;
            attr = e.getAttribute("author");
            if (attr != null) {
                auth = attr.getValue();
            }
            String txt = e.getTextTrim();
            byte[] data = Base64.decode((String)txt);
            if (ctype == null || time == -1L || offset == -1 || auth == null) {
                LogSupport.error((Object)this, (String)"load", (String)("invalid note in document: " + ctype + "," + time + "," + offset + "," + auth));
                continue;
            }
            Note note = null;
            String ltype = ctype.toLowerCase();
            if (ltype.startsWith("text/")) {
                note = new TextNote(ctype);
            } else if (ltype.startsWith("image/")) {
                note = new ImageNote(ctype);
            } else {
                LogSupport.error((Object)this, (String)"load", (String)("unsupported note content type: " + ctype));
                continue;
            }
            note.setAuthor(auth);
            note.setTime(time);
            note.setOffset(offset);
            note.setData(data);
            note.addPropertyChangeListener(this.noteListener);
            this.insertNoteSorted(note);
            if (!this.killLoad) continue;
            this.notes.clear();
            if (NotesDebug.ONE_CLICK_DEBUG.show()) {
                LogSupport.message((Object)this, (String)"loadNotes", (String)"Second click in queue, cancelling the load.");
            }
            return;
        }
        this.loaded = true;
    }

    void setKillLoad(boolean value) {
        this.killLoad = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadNotes() {
        ArrayList arrayList = this.notes;
        synchronized (arrayList) {
            for (Note n : this.notes) {
                n.removePropertyChangeListener(this.noteListener);
            }
            this.notes.clear();
            this.modified = false;
            this.loaded = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        ArrayList arrayList = this.notes;
        synchronized (arrayList) {
            this.writeNotesFile(this.notes.toArray(new Note[0]), this.file);
            this.setModified(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCopy(File file) throws IOException {
        ArrayList arrayList = this.notes;
        synchronized (arrayList) {
            this.writeNotesFile(this.notes.toArray(new Note[0]), file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCopyAsText(File file) throws IOException {
        ArrayList arrayList = this.notes;
        synchronized (arrayList) {
            this.writeTextFile(this.notes.toArray(new Note[0]), file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeNotesFile(Note[] notes, File file) throws IOException {
        File fo;
        Element root = new Element(ROOT_NAME);
        root.setAttribute(SESSION_ID_ATTR, this.sessionID);
        root.setAttribute(SESSION_DATE_ATTR, NotesUtilities.formatDate(this.sessionDate));
        root.setAttribute(SESSION_NAME_ATTR, this.sessionName);
        root.setAttribute("author", this.author);
        Document doc = new Document(root);
        boolean childAdded = false;
        for (int i = 0; i < notes.length; ++i) {
            Note n = notes[i];
            if (n.isEmpty()) continue;
            Element e = new Element("note");
            e.setAttribute(NOTE_CONTENT_TYPE_ATTR, n.getContentType());
            e.setAttribute(NOTE_TIME_ATTR, String.valueOf(n.getTime()));
            e.setAttribute(NOTE_OFFSET_ATTR, String.valueOf(n.getOffset()));
            e.setAttribute("author", String.valueOf(n.getAuthor()));
            e.addContent(Base64.encode((byte[])n.getData(), (int)72));
            root.addContent((Content)e);
            childAdded = true;
        }
        if (!childAdded) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                w.close();
                LogSupport.log((String)("Saving empty Notes document " + sw.toString()));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!(fo = file.getParentFile()).exists()) {
            fo.mkdirs();
        }
        File f = File.createTempFile(file.getName(), null, fo);
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            out.output(doc, (Writer)w);
            w.close();
            w = null;
            if (file.exists() && !file.delete()) {
                throw new IOException("Could not delete original file for replacement");
            }
            if (!f.renameTo(file)) {
                throw new IOException("Could not rename temporary file to original file");
            }
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException ex) {}
            }
            if (f != null && f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTextFile(Note[] notes, File file) throws IOException {
        int pixelsPerLine = 12;
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(file));
            w.write("[");
            w.write(this.getSessionName());
            w.write("]");
            w.newLine();
            w.write("[");
            DateFormat fmt = DateFormat.getDateInstance(1);
            w.write(fmt.format(this.getSessionDate()));
            w.write("]");
            w.newLine();
            w.write("[");
            w.write(this.getAuthor());
            w.write("]");
            w.newLine();
            w.newLine();
            boolean first = true;
            for (int i = 0; i < notes.length; ++i) {
                Note n = notes[i];
                if (!first) {
                    w.newLine();
                }
                for (int lineCount = n.getOffset() / 12; lineCount > 0; --lineCount) {
                    w.newLine();
                }
                w.write("[");
                w.write(n.getAuthor());
                w.write("]");
                w.newLine();
                String txt = n.getDataAsText();
                if (txt == null) {
                    txt = "(" + n.getContentType() + ")";
                }
                w.write(txt);
                w.newLine();
                first = false;
            }
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public boolean delete() {
        return !this.file.exists() || this.file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ArrayList arrayList = this.notes;
        synchronized (arrayList) {
            if (this.notes.size() == 0) {
                return true;
            }
            for (Note n : this.notes) {
                if (n.isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    public boolean isNew() {
        return !this.file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNoteSorted(Note note) {
        ArrayList arrayList = this.notes;
        synchronized (arrayList) {
            int index = -1;
            long t = note.getTime();
            for (int i = 0; i < this.notes.size(); ++i) {
                Note n = (Note)this.notes.get(i);
                if (t >= n.getTime()) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.notes.add(index, note);
            } else {
                this.notes.add(note);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNote(Note note) {
        int newCount;
        int oldCount;
        ArrayList arrayList = this.notes;
        synchronized (arrayList) {
            oldCount = this.notes.size();
            this.insertNoteSorted(note);
            newCount = this.notes.size();
        }
        note.addPropertyChangeListener(this.noteListener);
        this.changeSupport.firePropertyChange("note", null, note);
        this.changeSupport.firePropertyChange(NOTE_COUNT_PROPERTY, oldCount, newCount);
        if (!note.isEmpty()) {
            this.setModified(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addUniqueNoteToDocument(String slideName, String note, String author, long sessionTimestamp, boolean allowDups) {
        if (note == null) {
            return false;
        }
        Object object = this.privateObjectForThreadExclusion;
        synchronized (object) {
            try {
                note = this.reformatNote(slideName, note);
                if (allowDups || this.checkForDups(note) == -1) {
                    TextNote noteToAdd = new TextNote();
                    noteToAdd.getDocument().insertString(0, note, null);
                    noteToAdd.setTime(sessionTimestamp);
                    if (author != null) {
                        noteToAdd.setAuthor(author);
                    } else {
                        noteToAdd.setAuthor(this.getAuthor());
                    }
                    this.addNote(noteToAdd);
                }
            }
            catch (BadLocationException ble) {
                if (NotesDebug.DOC_WRITER_DEBUG.show()) {
                    LogSupport.message((Object)this, (String)"purgeNotesCache", (String)("Unable to set note [" + note + "]"));
                }
                return false;
            }
        }
        return true;
    }

    protected String reformatNote(String slideName, String originalNote) {
        return "[" + slideName + "]\n" + originalNote;
    }

    protected int checkForDups(String note) {
        Note[] notes = this.getNotes();
        if (notes != null) {
            for (int i = 0; i < notes.length; ++i) {
                if (!notes[i].getDataAsText().equals(note)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(Note note) {
        int newCount;
        int oldCount;
        ArrayList arrayList = this.notes;
        synchronized (arrayList) {
            oldCount = this.notes.size();
            if (!this.notes.remove(note)) {
                return;
            }
            newCount = this.notes.size();
        }
        note.removePropertyChangeListener(this.noteListener);
        this.changeSupport.firePropertyChange("note", note, null);
        this.changeSupport.firePropertyChange(NOTE_COUNT_PROPERTY, oldCount, newCount);
        if (!note.isEmpty()) {
            this.setModified(true);
        }
    }

    public void removeAllNotes() {
        Note[] notes = this.getNotes();
        for (int i = notes.length - 1; i >= 0; --i) {
            Note n = notes[i];
            this.removeNote(n);
        }
    }

    public Note[] getNotes() {
        return this.notes.toArray(new Note[0]);
    }

    public int getNoteCount() {
        return this.notes.size();
    }

    public int getNoteIndex(Note note) {
        return this.notes.indexOf(note);
    }

    public Note getNote(int index) {
        return (Note)this.notes.get(index);
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean modified) {
        if (modified == this.modified) {
            return;
        }
        boolean oldModified = this.modified;
        this.modified = modified;
        this.changeSupport.firePropertyChange(MODIFIED_PROPERTY, oldModified, modified);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }
}

