/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.net;

import com.elluminate.util.log.LogSupport;
import java.net.MalformedURLException;
import java.util.Locale;

public class URLString {
    String proto = "http";
    String host = "localhost";
    int port = -1;
    String path = null;

    public URLString() {
    }

    public URLString(String str) throws MalformedURLException {
        String tmpPath;
        String tmpPort;
        String tmpHost;
        int separator = str.indexOf("://");
        if (separator < 0) {
            throw new MalformedURLException("No protocol specified in URL '" + str + "'");
        }
        String tmpProto = str.substring(0, separator).toLowerCase(Locale.ENGLISH);
        int colon = str.indexOf(58, separator += 3);
        int slash = str.indexOf(47, separator);
        int question = str.indexOf(63, separator);
        if (slash < 0 && question >= 0) {
            slash = question;
        }
        if (colon < 0 && slash < 0) {
            tmpHost = str.substring(separator).trim();
            tmpPort = null;
            tmpPath = null;
        } else if (colon < 0) {
            tmpHost = str.substring(separator, slash).trim();
            tmpPort = null;
            tmpPath = str.substring(slash).trim();
        } else if (slash < 0) {
            tmpHost = str.substring(separator, colon).trim();
            tmpPort = str.substring(colon + 1).trim();
            tmpPath = null;
        } else if (slash < colon) {
            tmpHost = str.substring(separator, slash).trim();
            tmpPath = str.substring(slash).trim();
            tmpPort = null;
        } else {
            tmpHost = str.substring(separator, colon).trim();
            tmpPort = str.substring(colon + 1, slash).trim();
            tmpPath = str.substring(slash).trim();
        }
        if (tmpHost.equals("") && !tmpProto.equals("file") && !tmpProto.equals("agenda")) {
            throw new MalformedURLException("Empty host name not allowed '" + str + "'");
        }
        if (tmpPort != null && tmpPort.equals("") && !tmpProto.equals("file")) {
            throw new MalformedURLException("Empty port specification not allowed '" + str + "'");
        }
        if (tmpPort != null) {
            try {
                this.port = Integer.parseInt(tmpPort);
            }
            catch (Throwable t) {
                LogSupport.message(this, "<init>", "Error parsing URL: '" + str + "'\n  " + t);
                throw new MalformedURLException("Invalid port specification: " + tmpPort);
            }
            if (this.port < 1 || this.port > 65535) {
                throw new MalformedURLException("Port '" + this.port + "' out of range 1-65535");
            }
        }
        this.host = tmpHost;
        this.proto = tmpProto;
        this.path = tmpPath;
    }

    public URLString(String proto, String host, int port, String path) {
        this.setProtocol(proto);
        this.setHost(host);
        this.setPort(port);
        this.setPath(path);
    }

    public void setProtocol(String proto) {
        this.proto = proto.toLowerCase(Locale.ENGLISH);
    }

    public String getProtocol() {
        return this.proto;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPath(String path) {
        this.path = path != null ? (path.length() == 0 ? "/" : (path.charAt(0) == '/' ? path : "/" + path)) : null;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        if (this.path == null) {
            return null;
        }
        if (this.path.length() < 2) {
            return null;
        }
        return this.path.substring(1);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.proto);
        buf.append("://");
        buf.append(this.host);
        if (this.port > 0) {
            buf.append(":");
            buf.append(this.port);
        }
        if (this.path != null) {
            buf.append(this.path);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        try {
            URLString other = (URLString)o;
            return this.toString().equals(other.toString());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

