/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.net;

import com.elluminate.net.EndpointCaller;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.URLString;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ProxyUtils {
    public static final String INHERIT = "inherit";
    public static final String DIRECT = "direct";
    public static final String SOCKS = "socks";
    public static final String HTTPS = "https";
    public static final String HTTP = "http";
    public static final String[] OVERRIDES = new String[]{"direct", "socks", "https", "http"};
    public static final String DEFAULT_HOST = "proxy";
    public static final int SOCKS_PORT = 1080;
    public static final int HTTPS_PORT = 8080;
    public static final int HTTP_PORT = 8080;
    private static Map<String, ProxyInfo> fromSelector = null;
    private static Map<String, ProxyInfo> fromProps = ProxyUtils.getDefaults();
    private static ProxyInfo current = null;

    private ProxyUtils() {
    }

    public static void setDestination(String host, int port) {
        ProxyUtils.selectProxy(host, port, SOCKS, "socket", Proxy.Type.SOCKS);
        ProxyUtils.selectProxy(host, 443, HTTPS, HTTPS, Proxy.Type.HTTP);
        ProxyUtils.selectProxy(host, 80, HTTP, HTTP, Proxy.Type.HTTP);
    }

    public static String getCurrentProxyType() {
        if (current != null) {
            return current.getProtocol();
        }
        return ProxyUtils.getDefaultProxyType();
    }

    public static String getCurrentProxyHost() {
        if (current != null) {
            return current.getHost();
        }
        return ProxyUtils.getDefaultProxyHost();
    }

    public static int getCurrentProxyPort() {
        if (current != null) {
            return current.getPort();
        }
        return ProxyUtils.getDefaultProxyPort();
    }

    public static String getCurrentProxyOpts() {
        if (current != null) {
            return current.getOptions();
        }
        return null;
    }

    public static String getDefaultProxyType() {
        if (ProxyUtils.hasDefault(SOCKS)) {
            return SOCKS;
        }
        if (ProxyUtils.hasDefault(HTTPS)) {
            return HTTPS;
        }
        if (ProxyUtils.hasDefault(HTTP)) {
            return HTTP;
        }
        return DIRECT;
    }

    public static String getDefaultProxyHost() {
        String proto = ProxyUtils.getDefaultProxyType();
        return ProxyUtils.getDefaultHostForProxyType(proto);
    }

    public static int getDefaultProxyPort() {
        String proto = ProxyUtils.getDefaultProxyType();
        return ProxyUtils.getDefaultPortForProxyType(proto);
    }

    public static String getHostForProxyType(String proto) {
        if (current != null && proto.equals(current.getProtocol())) {
            return current.getHost();
        }
        return ProxyUtils.getDefaultHostForProxyType(proto);
    }

    public static int getPortForProxyType(String proto) {
        if (current != null && proto.equals(current.getProtocol())) {
            return current.getPort();
        }
        return ProxyUtils.getDefaultPortForProxyType(proto);
    }

    public static String getOptionsForProxyType(String proto) {
        if (current != null && proto.equals(current.getProtocol())) {
            return current.getOptions();
        }
        return null;
    }

    public static String getDefaultHostForProxyType(String proto) {
        ProxyInfo info = ProxyUtils.getInfo(proto);
        if (info == null) {
            return null;
        }
        return info.getHost();
    }

    public static int getDefaultPortForProxyType(String proto) {
        ProxyInfo info = ProxyUtils.getInfo(proto);
        if (info == null) {
            return -1;
        }
        return info.getPort();
    }

    public static boolean isOverride() {
        return current != null;
    }

    public static void applyProxy(URLString proxy) {
        if (proxy == null) {
            current = null;
            return;
        }
        String proxyProto = proxy.getProtocol();
        String proxyHost = proxy.getHost();
        int proxyPort = proxy.getPort();
        String proxyOpts = proxy.getName();
        if (proxyPort < 0) {
            if (proxyProto.equalsIgnoreCase(SOCKS)) {
                proxyPort = 1080;
            } else if (proxyProto.equalsIgnoreCase(HTTPS)) {
                proxyPort = 8080;
            } else if (proxyProto.equalsIgnoreCase(HTTP)) {
                proxyPort = 8080;
            }
        }
        if (proxyOpts != null && proxyOpts.trim().length() == 0) {
            proxyOpts = null;
        }
        if (proxyProto.equals(DIRECT) || EndpointCaller.isTunnelMethodAvailable(proxyProto)) {
            current = new ProxyInfo(proxyProto, proxyHost, proxyPort, proxyOpts);
        }
    }

    private static boolean hasDefault(String type) {
        if (fromSelector != null) {
            return fromSelector.containsKey(type);
        }
        return fromProps.containsKey(type);
    }

    private static ProxyInfo getInfo(String type) {
        ProxyInfo info = null;
        if (fromSelector != null) {
            info = fromSelector.get(type);
        }
        if (info == null) {
            info = fromProps.get(type);
        }
        return info;
    }

    private static Map<String, ProxyInfo> getDefaults() {
        String proxies = System.getProperty("javaplugin.proxy.config.list");
        HashMap<String, ProxyInfo> map = new HashMap<String, ProxyInfo>();
        if (proxies == null) {
            return map;
        }
        StringTokenizer parser = new StringTokenizer(proxies, ",");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            try {
                ProxyInfo info = new ProxyInfo(token);
                String proto = info.getProtocol();
                if (EndpointCaller.isTunnelMethodAvailable(proto)) {
                    if (UtilDebug.PROXY_DETECT.show()) {
                        LogSupport.message(ProxyUtils.class, "getDefaults", "Found " + info + " using properties");
                    }
                    if (map.containsKey(proto)) continue;
                    map.put(proto, info);
                    continue;
                }
                if (!UtilDebug.PROXY_DETECT.show()) continue;
                LogSupport.message(ProxyUtils.class, "getDefaults", "Skipping " + info + " using properties (not supported)");
            }
            catch (Throwable t) {}
        }
        return map;
    }

    private static void selectProxy(String host, int port, String method, String prefix, Proxy.Type type) {
        List<Proxy> proxies;
        ProxySelector selector = ProxySelector.getDefault();
        if (!EndpointCaller.isTunnelMethodAvailable(method)) {
            if (UtilDebug.PROXY_DETECT.show()) {
                LogSupport.message(ProxyUtils.class, "selectProxy", "Skipping " + method + " in selector search - not supported");
            }
            return;
        }
        try {
            proxies = selector.select(new URI(prefix, null, host, port, null, null, null));
        }
        catch (URISyntaxException usx) {
            return;
        }
        if (UtilDebug.PROXY_DETECT.show()) {
            LogSupport.message(ProxyUtils.class, "selectProxy", "Found " + proxies.size() + " proxies of type " + prefix);
        }
        for (Proxy p : proxies) {
            if (p.type() == type) {
                try {
                    ProxyInfo info = new ProxyInfo(method, p);
                    if (fromSelector == null) {
                        fromSelector = new HashMap<String, ProxyInfo>();
                    }
                    if (UtilDebug.PROXY_DETECT.show()) {
                        LogSupport.message(ProxyUtils.class, "selectProxy", "Found " + info + " using selector");
                    }
                    fromSelector.put(method, info);
                    return;
                }
                catch (IllegalArgumentException iax) {
                    if (!UtilDebug.PROXY_DETECT.show()) continue;
                    LogSupport.message(ProxyUtils.class, "selectProxy", "Skipping " + p + " using selector (" + iax + ")");
                    continue;
                }
            }
            if (!UtilDebug.PROXY_DETECT.show()) continue;
            LogSupport.message(ProxyUtils.class, "selectProxy", "Skipping " + p + " using selector");
        }
        if (fromSelector != null) {
            fromSelector.remove(method);
        }
    }

    static class ProxyInfo {
        private String protocol;
        private String host;
        private int port;
        private String options;

        public ProxyInfo(String spec) throws ParseException {
            int equals = spec.indexOf(61);
            if (equals < 1) {
                throw new ParseException(spec, 0);
            }
            this.protocol = spec.substring(0, equals);
            String def = spec.substring(equals + 1).trim();
            if (def.length() == 0) {
                throw new ParseException(spec, equals);
            }
            int colon = def.indexOf(58);
            if (colon < 1) {
                throw new ParseException(spec, equals);
            }
            this.host = def.substring(0, colon);
            this.port = Integer.parseInt(def.substring(colon + 1));
            if (this.port < 1 || this.port > 65535) {
                throw new ParseException(spec, equals + colon + 1);
            }
            this.options = null;
        }

        public ProxyInfo(String method, Proxy p) throws IllegalArgumentException {
            int pPort;
            String pHost;
            try {
                InetSocketAddress addr = (InetSocketAddress)p.address();
                pHost = addr.getHostName();
                pPort = addr.getPort();
            }
            catch (ClassCastException ccx) {
                throw new IllegalArgumentException(ccx);
            }
            this.protocol = method;
            this.host = pHost;
            this.port = pPort;
            this.options = null;
        }

        public ProxyInfo(String aProto, String aHost, int aPort, String aOpts) {
            this.protocol = aProto;
            this.host = aHost;
            this.port = aPort;
            this.options = aOpts;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getOptions() {
            return this.options;
        }

        public String toString() {
            return this.protocol + " proxy " + this.host + ":" + this.port + (this.options == null ? "" : " (" + this.options + ")");
        }
    }
}

