/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.net;

import com.elluminate.util.net.URLString;
import java.net.MalformedURLException;
import java.net.URI;

public class LaunchLink {
    private URLString url;
    private String user;
    private String auth;

    public LaunchLink(String uriStr) throws LaunchLinkParseException {
        URI uri = null;
        try {
            uri = URI.create(uriStr);
        }
        catch (RuntimeException e) {
            throw new LaunchLinkParseException("Could not create URI from string", e);
        }
        this.init(uri);
    }

    public LaunchLink(URI uri) throws LaunchLinkParseException {
        this.init(uri);
    }

    private void init(URI uri) throws LaunchLinkParseException {
        String userInfo = uri.getUserInfo();
        if (userInfo == null) {
            throw new LaunchLinkParseException("Null user info for uri: " + uri.toString());
        }
        String[] parts = userInfo.split(":");
        if (parts.length < 2) {
            throw new LaunchLinkParseException("Could not split user and auth for uri: " + uri.toString());
        }
        this.user = parts[0].replace('+', ' ');
        this.auth = parts[1];
        String portNum = uri.getPort() > 0 ? Integer.toString(uri.getPort()) : "2187";
        String fragment = uri.getFragment() != null ? "#" + uri.getFragment() : "";
        String urlStr = uri.getScheme() + "://" + uri.getHost() + ":" + portNum + uri.getPath() + fragment;
        urlStr = urlStr.replace('+', ' ');
        try {
            this.url = new URLString(urlStr);
        }
        catch (MalformedURLException e) {
            throw new LaunchLinkParseException("Could not reassemble url", e);
        }
    }

    public URLString getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getAuth() {
        return this.auth;
    }

    public static class LaunchLinkParseException
    extends Exception {
        public LaunchLinkParseException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public LaunchLinkParseException(String arg0) {
            super(arg0);
        }

        public LaunchLinkParseException(Throwable arg0) {
            super(arg0);
        }
    }
}

