/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.log;

import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogConstants;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Singleton;
import java.text.SimpleDateFormat;
import java.util.Date;

@Singleton
public class LogEmitter
implements Runnable {
    private static final String WHITESPACE = "                                ";
    private final Thread processor;
    private boolean running = false;
    private final Object lock = new Object();
    private boolean terminal = false;
    private LogEntry head = null;
    private LogEntry tail = null;

    LogEmitter() {
        this.processor = new WorkerThread((Runnable)this, "Default LogEmitter");
        this.processor.setDaemon(true);
        this.processor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Object object = this.lock;
        synchronized (object) {
            this.terminal = true;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(String context, String message, long time, byte mode) {
        LogEntry e = new LogEntry(context, message, time, mode);
        Object object = this.lock;
        synchronized (object) {
            if (this.terminal) {
                return;
            }
            if (this.tail == null) {
                this.head = this.tail = e;
            } else {
                this.tail.next = e;
                this.tail = e;
            }
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry getNextEntry() {
        Object object = this.lock;
        synchronized (object) {
            while (this.head == null && !this.terminal && !Thread.currentThread().isInterrupted()) {
                try {
                    this.lock.wait(500L);
                }
                catch (InterruptedException intx) {
                    this.terminal = true;
                }
            }
            if (Thread.interrupted()) {
                this.terminal = true;
            }
            if (this.head == null) {
                if (this.terminal) {
                    this.running = false;
                }
                return null;
            }
            LogEntry e = this.head;
            this.head = e.next;
            e.next = null;
            if (this.head == null) {
                this.tail = null;
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder buf = new StringBuilder();
        try {
            this.running = true;
            while (this.running) {
                LogEntry cur = this.getNextEntry();
                try {
                    if (cur == null) continue;
                    cur.emit(buf);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            System.err.println("Logging terminated: " + Thread.currentThread());
        }
    }

    private static class LogEntry
    implements LogConstants {
        private LogEntry next = null;
        private long logTime = -1L;
        private byte timeMode = 0;
        private String context = null;
        private String message = null;

        LogEntry(String context, String message, long time, byte mode) {
            this.logTime = time;
            this.timeMode = mode;
            this.context = context;
            this.message = message;
        }

        void emit(StringBuilder buf) {
            buf.setLength(0);
            if (this.logTime > 0L) {
                switch (this.timeMode) {
                    case 1: {
                        Date date = new Date(this.logTime);
                        SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss SSS");
                        buf.append(fmt.format(date));
                        buf.append(" ");
                        break;
                    }
                    case 2: {
                        Date date = new Date(this.logTime);
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                        buf.append(fmt.format(date));
                        buf.append(" ");
                        break;
                    }
                    case 4: {
                        Date date = new Date(this.logTime);
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
                        buf.append(fmt.format(date));
                        buf.append(" ");
                        break;
                    }
                    case 3: {
                        buf.append(this.logTime);
                        buf.append(' ');
                        break;
                    }
                }
            }
            if (this.context != null) {
                buf.append(this.context);
                buf.append(": ");
            }
            int prefixLen = buf.length();
            int len = this.message.length();
            int prefixCount = 1;
            int last = this.message.indexOf(10);
            while (last >= 0) {
                ++prefixCount;
                last = this.message.indexOf("\n", last + 1);
            }
            LogSupport.checkAndRotate(len += prefixCount * (prefixLen + 1));
            int prev = 0;
            int nl = 0;
            while ((nl = this.message.indexOf(10, prev)) >= 0) {
                buf.append(this.message.substring(prev, nl));
                System.err.println(buf.toString());
                buf.setLength(0);
                int i = prefixLen;
                while (i > 0) {
                    if (i > LogEmitter.WHITESPACE.length()) {
                        buf.append(LogEmitter.WHITESPACE);
                        i -= LogEmitter.WHITESPACE.length();
                        continue;
                    }
                    buf.append(LogEmitter.WHITESPACE.substring(0, i));
                    i = 0;
                }
                prev = nl + 1;
            }
            buf.append(this.message.substring(prev));
            System.err.println(buf.toString());
        }

        public String toString() {
            return "LogEntry: [" + this.context + "] @" + this.logTime + " '" + this.message + "'";
        }
    }
}

