/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.log;

import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Map;
import java.util.TreeMap;

public abstract class ExTRASupport {
    public static final String DEBUG_EXTRA = "ExTRA.test";
    private static Class<?> extraCls = null;
    private static Method extraPost = null;
    private static Method extraInit = null;
    private static ListenerRegistry<ExceptionFilter> filterList = new ListenerRegistry(new FiringThrowableHandler("applyFilters"));
    private static final ListenerRegistry<ExceptionListener> exceptionListenerList = new ListenerRegistry(new FiringThrowableHandler("fireExceptionListeners"));

    private static void initialize() {
        try {
            Method m;
            Method reg;
            extraCls = Class.forName("com.elluminate.extra.ExTRA");
            extraPost = extraCls.getMethod("postException", String.class, Throwable.class, String.class, Map.class);
            extraInit = extraCls.getMethod("isInitialized", new Class[0]);
            try {
                reg = extraCls.getMethod("setMessageHandler", Method.class);
                m = LogSupport.class.getMethod("message", Object.class, String.class, String.class);
                reg.invoke(null, m);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            try {
                reg = extraCls.getMethod("setErrorHandler", Method.class);
                m = LogSupport.class.getMethod("error", Object.class, String.class, String.class);
                reg.invoke(null, m);
            }
            catch (Throwable ignored) {}
        }
        catch (Throwable t) {
            extraPost = null;
            extraInit = null;
        }
        final DebugFlag testExTRA = DebugFlag.get(DEBUG_EXTRA);
        PropertyChangeListener pclExTRA = new PropertyChangeListener(){
            private int counter = 0;

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DebugFlag flag = (DebugFlag)e.getSource();
                if (!flag.isEnabled()) {
                    return;
                }
                final RuntimeException t = new RuntimeException("Test Exception #" + ++this.counter);
                Thread reporter = new Thread("ExTRA Test Thread"){

                    @Override
                    public void run() {
                        LogSupport.exception(this, "propertyChange", t, false);
                        testExTRA.setEnabled(false);
                    }
                };
                reporter.start();
            }
        };
        testExTRA.addPropertyChangeListener("debugEnabled", pclExTRA);
    }

    public static boolean isExtraConfigured() {
        if (extraInit == null) {
            return false;
        }
        try {
            return (Boolean)extraInit.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void addExceptionFilter(ExceptionFilter f) {
        filterList.add(f);
    }

    public static void removeExceptionFilter(ExceptionFilter f) {
        filterList.remove(f);
    }

    public static void reportException(String where, Throwable ex, String msg) {
        if (ExTRASupport.applyFilters(where, ex, msg)) {
            return;
        }
        ExTRASupport.postExTRA(where, ex, msg);
    }

    private static boolean applyFilters(final String where, final Throwable ex, final String msg) {
        FiringFunctor<ExceptionFilter> ff = new FiringFunctor<ExceptionFilter>(){

            @Override
            public void fire(ExceptionFilter f) {
                for (Throwable chkEx = ex; chkEx != null; chkEx = chkEx.getCause()) {
                    try {
                        if (!f.checkException(chkEx)) continue;
                        f.processException(where, ex, msg);
                        throw new FilterHandledError();
                    }
                    catch (Throwable t) {
                        LogSupport.message(ExTRASupport.class, "applyFilters", Debug.getStackTrace(t));
                        LogSupport.message(ExTRASupport.class, "applyFilters", "While processing: " + Debug.getStackTrace(ex));
                    }
                }
            }
        };
        try {
            filterList.fire(ff);
        }
        catch (FilterHandledError fhe) {
            return true;
        }
        return false;
    }

    private static void postExTRA(String where, Throwable ex, String msg) {
        if (!ExTRASupport.isExtraConfigured()) {
            return;
        }
        String history = LogSupport.getHistory();
        Map<String, Object> extraFlds = ExTRASupport.fireExceptionListeners(where, ex);
        if (extraFlds == null) {
            extraFlds = new TreeMap<String, Object>();
        }
        if (history.length() > 0) {
            extraFlds.put("console", history);
        }
        extraFlds.put("details", Platform.getDetailedInfo());
        extraFlds.put("memory", Platform.getExtendedMemoryStatus());
        String flagInfo = DebugFlag.getList(false);
        if (flagInfo != null && flagInfo.length() > 0) {
            extraFlds.put("flags", flagInfo);
        }
        if (extraPost != null) {
            try {
                extraPost.invoke(null, where, ex, msg, extraFlds);
            }
            catch (Throwable t) {
                LogSupport.message(ExTRASupport.class, "postExTRA", t.toString());
            }
        }
    }

    public static void addExceptionListener(ExceptionListener l) {
        exceptionListenerList.add(l);
    }

    public static void removeExceptionListener(ExceptionListener l) {
        exceptionListenerList.remove(l);
    }

    private static Map<String, Object> fireExceptionListeners(final String where, final Throwable t) {
        final TreeMap<String, Object> props = new TreeMap<String, Object>();
        FiringFunctor<ExceptionListener> ff = new FiringFunctor<ExceptionListener>(){
            ExceptionEvent ev = null;

            @Override
            public void fire(ExceptionListener l) {
                if (this.ev == null) {
                    this.ev = new ExceptionEvent(where, t, props);
                }
                l.exceptionReported(this.ev);
            }
        };
        exceptionListenerList.fire(ff);
        if (props.isEmpty()) {
            return null;
        }
        return props;
    }

    static {
        ExTRASupport.initialize();
    }

    public static class ExceptionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private String catcher;
        private Throwable exception;
        private Map<String, Object> extraFields;
        private StackTraceElement[] stackTrace;

        public ExceptionEvent(String where, Throwable exc, Map<String, Object> flds) {
            super(exc);
            this.catcher = where;
            this.exception = exc;
            this.extraFields = flds;
            this.stackTrace = null;
        }

        public String getCatcher() {
            return this.catcher;
        }

        public Throwable getException() {
            return this.exception;
        }

        public boolean traceContains(String className, String methodName) {
            if (this.stackTrace == null) {
                this.stackTrace = this.exception.getStackTrace();
            }
            for (StackTraceElement sFrame : this.stackTrace) {
                if (sFrame == null || !className.equals(sFrame.getClassName())) continue;
                if (methodName == null) {
                    return true;
                }
                if (!methodName.equals(sFrame.getMethodName())) continue;
                return true;
            }
            return false;
        }

        public Map<String, Object> getExtraFields() {
            return this.extraFields;
        }

        @Override
        public String toString() {
            return this.catcher + " caught " + this.exception.getClass().getName() + ": " + this.exception.getMessage();
        }
    }

    public static abstract class ExceptionFilter {
        public abstract boolean checkException(Throwable var1);

        public abstract void processException(String var1, Throwable var2, String var3);

        protected void reportException(String where, Throwable t, String msg) {
            ExTRASupport.postExTRA(where, t, msg);
        }
    }

    public static interface ExceptionListener
    extends EventListener {
        public void exceptionReported(ExceptionEvent var1);
    }

    private static class FilterHandledError
    extends Error {
        private static final long serialVersionUID = 1L;

        private FilterHandledError() {
            super("Exception handled by filter");
        }
    }

    private static class FiringThrowableHandler
    implements ThrowableListener {
        private String firingMethod;

        private FiringThrowableHandler(String methodName) {
            this.firingMethod = methodName;
        }

        @Override
        public void exceptionThrown(Exception ex) {
            this.report(ex);
        }

        @Override
        public void errorThrown(Error err) {
            if (err instanceof FilterHandledError) {
                throw err;
            }
            this.report(err);
        }

        private void report(Throwable t) {
            LogSupport.error(ExTRASupport.class, this.firingMethod, "Exception while processing listener: " + Debug.getStackTrace(t));
        }
    }
}

