/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class IOUtilities {
    public static OutputStreamWriter generateUTF8WriterFromFile(File f) throws IOException {
        return IOUtilities.generateEncodedWriterFromFile(f, ENCODING.UTF8);
    }

    public static OutputStreamWriter generateEncodedWriterFromFile(File f, ENCODING encoding) throws IOException {
        Object osw = null;
        FileOutputStream fos = null;
        fos = new FileOutputStream(f);
        return new OutputStreamWriter((OutputStream)fos, encoding.getEncoding());
    }

    public static int copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[4096];
        int totalBytesCopied = 0;
        try {
            int nRead;
            while ((nRead = is.read(buf)) >= 0) {
                os.write(buf, 0, nRead);
                totalBytesCopied += nRead;
            }
        }
        catch (EOFException ignored) {
            // empty catch block
        }
        return totalBytesCopied;
    }

    public static byte[] readStream(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtilities.copyStream(is, bos);
        return bos.toByteArray();
    }

    public static enum ENCODING {
        ASCII("US-ASCII"),
        ISO88591("ISO-8859-1"),
        UTF8("UTF-8"),
        UTF16("UTF-16");

        private String encodingName = null;

        private ENCODING(String name) {
            this.encodingName = name;
        }

        public String getEncoding() {
            return Charset.forName(this.encodingName).name();
        }
    }
}

