/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.io;

import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class FileSysUtils {
    public static final FileFilter DIR_FILTER = new DirectoryFilter();
    public static final char extensionSeparator = '.';
    private static final boolean IS_MAC = Platform.getPlatform() == 2;
    private static final boolean IS_WIN = Platform.getPlatform() == 1;
    private static final boolean USE_CHOOSER_TRAVERSE = IS_MAC;
    private static final boolean HAS_IS_DIRECTORY_BUG = IS_WIN && Platform.checkJavaVersion("1.6.0_02+") && !Platform.checkJavaVersion("1.6.0_06+");
    private static volatile FileSystemView fileSystemView = null;
    private static volatile boolean fileSystemViewFailed = false;
    private static volatile FileView fileView = null;
    private static volatile boolean fileViewFailed = false;
    private static TreeDeleteHook treeDeleteHook = null;

    public static boolean isTraversableDirectory(File f) {
        block11: {
            Object localFileView;
            if (f == null) {
                return false;
            }
            if (USE_CHOOSER_TRAVERSE) {
                FileSysUtils.loadFileView();
                localFileView = fileView;
                if (localFileView != null) {
                    try {
                        return ((FileView)localFileView).isTraversable(f);
                    }
                    catch (Throwable t) {
                        LogSupport.exception(FileSysUtils.class, "isTraversableDirectory", t, true, "Checking FileView.isTraversable for " + f);
                    }
                }
            }
            FileSysUtils.loadFileSystemView();
            localFileView = fileSystemView;
            if (localFileView != null) {
                try {
                    return ((FileSystemView)localFileView).isTraversable(f);
                }
                catch (Throwable t) {
                    if (HAS_IS_DIRECTORY_BUG && FileSysUtils.isInterruptedException(t)) break block11;
                    LogSupport.exception(FileSysUtils.class, "isTraversableDirectory", t, true, "Checking FileSystemView.isTraversable for " + f);
                }
            }
        }
        try {
            return f.isDirectory();
        }
        catch (Throwable t) {
            if (!HAS_IS_DIRECTORY_BUG || !FileSysUtils.isInterruptedException(t)) {
                LogSupport.exception(FileSysUtils.class, "isTraversableDirectory", t, true, "Checking isDirectory for " + f);
            }
            LogSupport.message(FileSysUtils.class, "isTraversableDirectory", "Cannot determine traversability of " + f);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFileView() {
        if (fileView != null || fileViewFailed) return;
        Class<FileSysUtils> clazz = FileSysUtils.class;
        synchronized (FileSysUtils.class) {
            if (fileView != null || fileViewFailed) return;
            try {
                JFileChooser fChooser = new JFileChooser();
                fileView = fChooser.getUI().getFileView(fChooser);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            fileViewFailed = fileView == null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFileSystemView() {
        if (fileSystemView != null || fileSystemViewFailed) return;
        Class<FileSysUtils> clazz = FileSysUtils.class;
        synchronized (FileSysUtils.class) {
            if (fileSystemView != null || fileSystemViewFailed) return;
            try {
                fileSystemView = FileSystemView.getFileSystemView();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            fileSystemViewFailed = fileSystemView == null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static boolean isInterruptedException(Throwable t) {
        Throwable cause = t;
        while (cause != null) {
            if (cause instanceof InterruptedException) {
                return true;
            }
            cause = t.getCause();
        }
        return false;
    }

    public static File[] getVolumes() {
        ArrayList<File> volumes = new ArrayList<File>();
        for (File f : File.listRoots()) {
            volumes.add(f);
        }
        if (IS_MAC) {
            try {
                File mountPoint = new File("/Volumes");
                for (File f : mountPoint.listFiles()) {
                    try {
                        File f2;
                        f = f2 = f.getCanonicalFile();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    if (volumes.contains(f) || f.isFile()) continue;
                    volumes.add(f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return volumes.toArray(new File[volumes.size()]);
    }

    public static File findFileInPath(String file) {
        return FileSysUtils.findFileInPath(file, System.getProperty("java.library.path"), System.getProperty("path.separator"));
    }

    public static File findFileInPath(String file, String path) {
        return FileSysUtils.findFileInPath(file, path, System.getProperty("path.separator"));
    }

    public static File findFileInPath(String file, String path, String sep) {
        String[] pathEntry = path.split(sep);
        for (int index = 0; index < pathEntry.length; ++index) {
            File f;
            if (pathEntry[index].equals("") || !(f = new File(pathEntry[index], file)).exists()) continue;
            return f;
        }
        return null;
    }

    public static String getExtension(File f) {
        if (f == null) {
            return null;
        }
        return FileSysUtils.getExtensionString(f.getName());
    }

    public static String getExtensionString(String s) {
        if (s == null) {
            return null;
        }
        String ext = null;
        int pos = s.lastIndexOf(46);
        if (pos > 0 && pos < s.length() - 1) {
            ext = s.substring(pos + 1).toLowerCase(Locale.ENGLISH);
        }
        return ext;
    }

    public static String stripExtension(String name) {
        int idx = name.lastIndexOf(46);
        if (idx <= 0) {
            return name;
        }
        return name.substring(0, idx);
    }

    public static File setExtensionDefault(File file, String ext) {
        String name = file.getName();
        return new File(file.getParent(), FileSysUtils.setExtensionDefault(name, ext));
    }

    public static String setExtensionDefault(String file, String ext) {
        String extension = FileSysUtils.getExtensionString(file);
        if (extension == null || !extension.equalsIgnoreCase(ext)) {
            file = file + '.' + ext;
        }
        return file;
    }

    public static String replaceExtension(String name, String ext) {
        int idx = name.lastIndexOf(46);
        if (idx <= 0) {
            return name + '.' + ext;
        }
        if (name.substring(idx + 1).toLowerCase(Locale.ENGLISH).equals(ext)) {
            return name;
        }
        return name.substring(0, idx) + '.' + ext;
    }

    public static String getCanonicalPath(File f) {
        String result = null;
        try {
            result = f.getCanonicalPath();
        }
        catch (Throwable t) {
            result = f.getAbsolutePath();
        }
        return result;
    }

    public static void pruneTree(File tree, FileFilter filter, boolean recursive) {
        int ix;
        File[] dirs;
        if (!tree.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + tree);
        }
        if (recursive && (dirs = tree.listFiles(DIR_FILTER)) != null) {
            for (ix = 0; ix < dirs.length; ++ix) {
                FileSysUtils.pruneTree(dirs[ix], filter, recursive);
            }
        }
        File[] toDo = null;
        File[] fileArray = toDo = filter == null ? tree.listFiles() : tree.listFiles(filter);
        if (toDo != null) {
            for (ix = 0; ix < toDo.length; ++ix) {
                if (toDo[ix].delete()) continue;
                LogSupport.message(FileSysUtils.class, "pruneTree", "Failed to delete: " + toDo[ix]);
            }
        }
    }

    public static boolean deleteTree(File tree) {
        if (!tree.exists()) {
            return true;
        }
        if (tree.isDirectory()) {
            FileSysUtils.pruneTree(tree, null, true);
        }
        return tree.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteTreeOnExit(File tree) {
        Class<TreeDeleteHook> clazz = TreeDeleteHook.class;
        synchronized (TreeDeleteHook.class) {
            if (treeDeleteHook == null) {
                try {
                    TreeDeleteHook h = new TreeDeleteHook();
                    Runtime.getRuntime().addShutdownHook(h);
                    treeDeleteHook = h;
                }
                catch (Throwable t) {
                    LogSupport.message(FileSysUtils.class, "deleteTreeOnExit", "Failed to create shutdown hook: " + Debug.getStackTrace(t));
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            FileSysUtils.treeDeleteHook.addTree(tree);
            return true;
        }
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    }

    private static class TreeDeleteHook
    extends Thread {
        private volatile boolean accepting = true;
        private final ArrayList<File> toDelete = new ArrayList();

        private TreeDeleteHook() {
        }

        private void addTree(File tree) {
            if (this.accepting) {
                File f = new File(tree.getAbsolutePath());
                if (this.toDelete.contains(f)) {
                    return;
                }
                this.toDelete.add(f);
            }
        }

        @Override
        public void run() {
            this.accepting = false;
            while (!this.toDelete.isEmpty()) {
                File f = this.toDelete.get(0);
                this.toDelete.remove(f);
                try {
                    if (FileSysUtils.deleteTree(f)) continue;
                    LogSupport.message(this, "run", "Failed to delete: " + f);
                }
                catch (Throwable t) {
                    LogSupport.message(this, "run", "Error processing " + f + ": " + Debug.getStackTrace(t));
                }
            }
        }
    }
}

