/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image.gif;

import com.elluminate.util.Debug;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.image.gif.GifFile;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GifImage {
    private static final String MIME = "image/gif";
    private long delay;
    private byte[] imageData;
    private int[] raster = null;
    private String mimeType;
    private int left;
    private int top;
    private int width;
    private int height;
    private int logicalWidth;
    private int logicalHeight;
    private Image image = null;
    private boolean partFrame = false;
    private int disposalMethod = 0;
    private int pixelCount = 0;

    public GifImage(int[] previousRaster, String mimeType, byte[] imageData, int top, int left, int width, int height, long delay, int disposalMethod) {
        this.mimeType = mimeType;
        this.imageData = imageData;
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.delay = delay;
        this.disposalMethod = disposalMethod;
        this.logicalWidth = width;
        this.logicalHeight = height;
        this.pixelCount = this.logicalWidth * this.logicalHeight;
        this.makeRaster(previousRaster);
    }

    public GifImage(int[] previousRaster, String mimeType, byte[] header, byte[] bytes, int startOffset, int offset, int left, int top, int width, int height, int logicalWidth, int logicalHeight, long delay, int disposalMethod) {
        this.mimeType = mimeType;
        this.imageData = new byte[header.length + offset - startOffset + 1];
        System.arraycopy(header, 0, this.imageData, 0, header.length);
        System.arraycopy(bytes, startOffset, this.imageData, header.length, offset - startOffset);
        this.imageData[this.imageData.length - 1] = 59;
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.logicalWidth = logicalWidth;
        this.logicalHeight = logicalHeight;
        this.delay = delay;
        this.disposalMethod = disposalMethod;
        this.pixelCount = logicalWidth * logicalHeight;
        this.makeRaster(previousRaster);
    }

    void disposeRaster() {
        this.raster = null;
    }

    public int getTopOffset() {
        return this.top;
    }

    public int getLeftOffset() {
        return this.left;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    int[] getRaster() {
        return this.raster;
    }

    private void makeRaster(int[] previousRaster) {
        BufferedImage im = null;
        try {
            ByteArrayInputStream inStrm = new ByteArrayInputStream(this.imageData);
            im = ImageIO.read(inStrm);
        }
        catch (IOException iox) {
            LogSupport.message(this, "loadImage", "Error loading image from stream:" + Debug.getStackTrace(iox));
        }
        int[] imageRaster = new int[this.width * this.height];
        ImageSupport.getImageArray(im, this.width, this.height, imageRaster);
        im.flush();
        im = null;
        int heightLimit = Math.min(this.height + this.top, this.logicalHeight);
        int widthLimit = Math.min(this.width + this.left, this.logicalWidth);
        if (previousRaster == null) {
            this.raster = GifFile.fillRaster(null, this.logicalWidth, this.logicalHeight, 0);
        } else {
            this.raster = new int[previousRaster.length];
            System.arraycopy(previousRaster, 0, this.raster, 0, previousRaster.length);
        }
        for (int y = this.top; y < heightLimit; ++y) {
            for (int x = this.left; x < widthLimit; ++x) {
                int sourceIndex = (y - this.top) * this.width + x - this.left;
                int sourcePixel = imageRaster[sourceIndex];
                int destinationIndex = y * this.logicalWidth + x;
                if ((sourcePixel & 0xFF000000) == 0) continue;
                this.raster[destinationIndex] = sourcePixel;
            }
        }
        imageRaster = null;
    }

    public Image getImage() throws InterruptedException {
        if (this.image != null) {
            return this.image;
        }
        BufferedImage bimg = new BufferedImage(this.logicalWidth, this.logicalHeight, 2);
        bimg.setRGB(0, 0, this.logicalWidth, this.logicalHeight, this.raster, 0, this.logicalWidth);
        this.image = bimg;
        this.raster = null;
        return this.image;
    }

    public int getDisposalMethod() {
        return this.disposalMethod;
    }

    public int getPixelCount() {
        return this.pixelCount;
    }

    public long getDelay() {
        return this.delay;
    }
}

