/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.util.image.ImageSupport;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ScaleUtil {
    private Runtime runtime;

    public ScaleUtil(Runtime rt) {
        this.runtime = rt;
    }

    public ScaleUtil() {
    }

    public boolean canScale(int size, Dimension targetSize) {
        boolean canScale = false;
        for (int i = 0; i < 3; ++i) {
            double requestedMem = this.calcRequestedMemory(size, targetSize);
            boolean bl = canScale = (double)this.runtime.freeMemory() >= requestedMem;
            if (canScale) {
                return true;
            }
            this.runtime.gc();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        return canScale;
    }

    private double calcRequestedMemory(int size, Dimension targetSize) {
        double requestedMem = ((double)size + targetSize.getHeight() * targetSize.getWidth()) * 4.0;
        requestedMem += requestedMem * 0.2;
        return requestedMem;
    }

    public Dimension calcScaleToLimit(int w, int h, Dimension limitSize) {
        Dimension scaled = new Dimension(w, h);
        if (w > limitSize.width) {
            scaled.width = limitSize.width;
            scaled.height = Math.round((float)h * ((float)limitSize.width / (float)w));
            w = scaled.width;
            h = scaled.height;
        }
        if (h > limitSize.height) {
            scaled.height = limitSize.height;
            scaled.width = Math.round((float)w * ((float)limitSize.height / (float)h));
        }
        return scaled;
    }

    public Image scaleToLimit(BufferedImage img, Dimension limitSize) {
        Dimension d = this.calcScaleToLimit(img.getWidth(), img.getHeight(), limitSize);
        if (d.width == img.getWidth()) {
            return img;
        }
        return ImageSupport.getScaledInstance(img, d.width, d.height, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public Dimension calcSizeReductionRequiredToLoad(int w, int h, Dimension auotScaleSize) {
        int size = w * h;
        int areaReductionPercent = (int)((double)this.runtime.freeMemory() / this.calcRequestedMemory(size, auotScaleSize) * 100.0 - 15.0);
        double aspectRatio = (double)w / (double)h;
        int reducedSize = (int)((double)size * ((double)areaReductionPercent / 100.0));
        Dimension targetDimension = new Dimension();
        targetDimension.width = (int)(Math.sqrt(reducedSize) * Math.sqrt(aspectRatio));
        targetDimension.height = (int)(Math.sqrt(reducedSize) / Math.sqrt(aspectRatio));
        return targetDimension;
    }
}

