/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.util.image.ImageInfo;
import com.elluminate.util.image.ImageProviderAPI;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.image.PICTImporter;
import com.elluminate.util.image.ScaleUtil;
import com.elluminate.util.image.SizeProvider;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class PICTImageProvider
implements ImageProviderAPI {
    private static final String[] PICT_TYPES = new String[]{"image/pict", "image/x-pict"};
    private SizeProvider autoScaleSizeProvider = new SizeProvider(){

        @Override
        public Dimension getSize() {
            return PICTImageProvider.this.maxSize;
        }
    };
    private Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private ScaleUtil scaleUtil = new ScaleUtil(Runtime.getRuntime());

    PICTImageProvider() {
        if (!PICTImporter.isSupported()) {
            throw new RuntimeException("PICT import not supported.");
        }
    }

    @Override
    public String[] getInputTypes() {
        return PICTImporter.getMIMETypes();
    }

    @Override
    public String[] getOutputTypes() {
        return new String[0];
    }

    @Override
    public boolean isSupportedInputType(String mime) {
        if (mime == null) {
            return false;
        }
        return PICTImporter.isPICT(mime);
    }

    @Override
    public boolean isSupportedOutputType(String mime) {
        return false;
    }

    @Override
    public void setMaxSize(Dimension d) {
        this.maxSize = d;
    }

    @Override
    public Image loadImage(byte[] imageData, String mime) throws IOException {
        if (!PICTImporter.isPICT(mime)) {
            return null;
        }
        return this.checkImageSize(PICTImporter.convertPICT(imageData));
    }

    @Override
    public ImageInfo loadImage(byte[] imageData, String mime, boolean autoScale) throws IOException {
        return this.checkImageSize(PICTImporter.convertPICT(imageData), autoScale);
    }

    @Override
    public Image loadImage(URL url) throws IOException {
        Object img = null;
        URLConnection con = url.openConnection();
        if (!PICTImporter.isPICT(con.getContentType())) {
            return null;
        }
        InputStream is = con.getInputStream();
        return this.checkImageSize(PICTImporter.convertPICT(is, false));
    }

    @Override
    public Image loadImage(File f) throws IOException {
        if (!PICTImporter.isPICT(f)) {
            return null;
        }
        return this.checkImageSize(PICTImporter.loadPICT(f));
    }

    @Override
    public Image loadImage(File f, boolean autoScale) throws IOException {
        if (!PICTImporter.isPICT(f)) {
            return null;
        }
        return this.checkImageSize(PICTImporter.loadPICT(f), autoScale).getImage();
    }

    @Override
    public boolean storeImage(Image img, OutputStream outStrm, String mime, int param) {
        return false;
    }

    private Image checkImageSize(BufferedImage img) {
        return this.checkImageSize(img, false).getImage();
    }

    private ImageInfo checkImageSize(BufferedImage img, boolean autoScale) {
        ImageInfo result = new ImageInfo();
        result.setImage(img);
        if (img != null) {
            int w = img.getWidth(null);
            int h = img.getHeight(null);
            if (!autoScale && this.isBigger(w, h, this.maxSize)) {
                img.flush();
                throw new ImageSupport.OversizeImageException(this.maxSize.width * this.maxSize.height);
            }
            Dimension autoScaleSize = this.autoScaleSizeProvider.getSize();
            if (autoScale && this.isBigger(w, h, autoScaleSize) && this.scaleUtil.canScale(w * h, autoScaleSize)) {
                Image scaledImg = this.scaleUtil.scaleToLimit(img, autoScaleSize);
                result.setImage(scaledImg);
                result.setScaled(img != scaledImg);
            } else {
                throw new ImageSupport.InsufficientMemoryExcetpion(this.scaleUtil.calcSizeReductionRequiredToLoad(w, h, autoScaleSize));
            }
        }
        return result;
    }

    private boolean isBigger(int w, int h, Dimension s) {
        return w > s.width || h > s.height;
    }

    @Override
    public void setAutoScaleSizeProvider(SizeProvider sp) {
        this.autoScaleSizeProvider = sp;
    }
}

