/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.platform.Platform;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;

public class ImageInformation {
    private static final String[] mimeTypes = new String[]{"image/apf", "image/bmp", "image/cur", "image/gif", "image/ico", "image/jpeg", "image/pcx", "image/png", "image/psd", "image/targa", "image/tiff"};
    public static final int APF_IMAGE = 0;
    public static final int BMP_IMAGE = 1;
    public static final int CUR_IMAGE = 2;
    public static final int GIF_IMAGE = 3;
    public static final int ICO_IMAGE = 4;
    public static final int JPEG_IMAGE = 5;
    public static final int PCX_IMAGE = 6;
    public static final int PNG_IMAGE = 7;
    public static final int PSD_IMAGE = 8;
    public static final int TARGA_IMAGE = 9;
    public static final int TIFF_IMAGE = 10;
    public static final byte[][] APF_FORMAT_SIGNATURES = new byte[][]{{65, 80, 70}};
    static final short BMP_FILETYPE = 19778;
    static final short BMP_VERSION_2X = 12;
    static final short BMP_VERSION_3X = 40;
    static final short BMP_VERSION_4X = 108;
    short bmpFileType = (short)19778;
    private String mimeType;
    private File file;
    private int width = -1;
    private int height = -1;
    private int depth = -1;
    private int delay = -1;
    private int imageCount = 0;
    int dataByte;

    public ImageInformation(File file) {
        this.mimeType = Platform.getMimeType(file);
        this.file = file;
        if (file.isFile()) {
            long fileLength = file.length();
            DataInputStream data = this.getDataStream(file);
            try {
                switch (this.decodeMimeType(this.mimeType)) {
                    case 0: {
                        this.getAPFImageInfo(data, fileLength);
                        break;
                    }
                    case 1: {
                        this.getBMPImageInfo(data, fileLength);
                        break;
                    }
                    case 2: {
                        this.getCURImageInfo(data, fileLength);
                        break;
                    }
                    case 3: {
                        this.getGIFImageInfo(data, fileLength);
                        break;
                    }
                    case 4: {
                        this.getICOImageInfo(data, fileLength);
                        break;
                    }
                    case 5: {
                        this.getJPEGImageInfo(data, fileLength);
                        break;
                    }
                    case 6: {
                        this.getPCXImageInfo(data, fileLength);
                        break;
                    }
                    case 7: {
                        this.getPNGImageInfo(data, fileLength);
                        break;
                    }
                    case 8: {
                        this.getPSDImageInfo(data, fileLength);
                        break;
                    }
                    case 9: {
                        this.getTARGAImageInfo(data, fileLength);
                        break;
                    }
                    case 10: {
                        this.getTIFFImageInfo(data, fileLength);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                data.close();
            }
            catch (IOException ex1) {
                // empty catch block
            }
        }
    }

    public ImageInformation(String file) {
        this(new File(file));
    }

    private int decodeMimeType(String mimeType) {
        String localMimeType = mimeType.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < mimeTypes.length; ++i) {
            if (!localMimeType.equals(mimeTypes[i])) continue;
            return i;
        }
        return -1;
    }

    private DataInputStream getDataStream(File file) {
        DataInputStream data = null;
        try {
            data = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        return data;
    }

    private void getAPFImageInfo(DataInputStream data, long fileLength) throws IOException {
        byte[] formatSignature = APF_FORMAT_SIGNATURES[0];
        for (int i = 0; i < formatSignature.length; ++i) {
            if (formatSignature[i] == data.readByte()) continue;
            return;
        }
        this.width = data.readInt();
        this.height = data.readInt();
        this.imageCount = 1;
    }

    private void getBMPImageInfo(DataInputStream data, long fileLength) throws IOException {
        boolean topDown;
        boolean colorsUsed = false;
        int bitsPerPixel = 0;
        boolean sizeOfBitmap = false;
        this.imageCount = 1;
        this.depth = 0;
        this.delay = -1;
        short fileType = data.readShort();
        if (fileType != 19778) {
            return;
        }
        int fileSize = data.readInt();
        short reserved1 = data.readShort();
        short reserved2 = data.readShort();
        int bitmapOffset = data.readInt();
        int size = data.readInt();
        if (size == 12) {
            topDown = this.readVersion2x(data);
        } else if (size == 40) {
            topDown = this.readVersion3x(data);
        } else if (size == 108) {
            topDown = this.readVersion4x(data);
        } else {
            return;
        }
        if (topDown) {
            return;
        }
        int noOfPixels = this.width * this.height;
        int scanLineSize = (this.width * bitsPerPixel + 31) / 32 * 4;
        if (sizeOfBitmap) {
            boolean actualSizeOfBitmap = sizeOfBitmap;
        } else {
            int actualSizeOfBitmap = scanLineSize * this.height;
        }
        if (colorsUsed) {
            boolean actualColorsUsed = colorsUsed;
        } else if (bitsPerPixel < 16) {
            int actualColorsUsed = 1 << bitsPerPixel;
        } else {
            boolean actualColorsUsed = false;
        }
    }

    private void getCURImageInfo(DataInputStream data, long fileLength) throws IOException {
        this.depth = 0;
        this.delay = -1;
        this.imageCount = 1;
    }

    private void getGIFImageInfo(DataInputStream data, long fileLength) throws IOException {
    }

    private void getICOImageInfo(DataInputStream data, long fileLength) throws IOException {
        this.depth = 0;
        this.delay = -1;
        this.imageCount = 1;
    }

    private void getJPEGImageInfo(DataInputStream data, long fileLength) throws IOException {
        int index = 0;
        while ((long)index < fileLength - 10L) {
            if (this.nextByte(data) == 255 && this.nextByte(data) == 192) {
                short length = data.readShort();
                this.depth = this.nextByte(data);
                this.height = data.readShort();
                this.width = data.readShort();
                int components = this.nextByte(data);
                break;
            }
            ++index;
        }
        this.imageCount = 1;
    }

    private void getPCXImageInfo(DataInputStream data, long fileLength) throws IOException {
        this.depth = 0;
        this.delay = -1;
        this.imageCount = 1;
    }

    private void getPNGImageInfo(DataInputStream data, long fileLength) throws IOException {
        this.depth = 0;
        this.delay = -1;
        this.imageCount = 1;
    }

    private void getPSDImageInfo(DataInputStream data, long fileLength) throws IOException {
        this.depth = 0;
        this.delay = -1;
        this.imageCount = 1;
    }

    private void getTARGAImageInfo(DataInputStream data, long fileLength) throws IOException {
        this.depth = 0;
        this.delay = -1;
        this.imageCount = 1;
    }

    private void getTIFFImageInfo(DataInputStream data, long fileLength) throws IOException {
        this.depth = 0;
        this.delay = -1;
        this.imageCount = 1;
    }

    private int nextByte(DataInputStream data) throws IOException {
        this.dataByte = data.readByte() & 0xFF;
        return this.dataByte;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    boolean readVersion2x(DataInputStream data) throws IOException {
        this.width = data.readShort();
        this.height = data.readShort();
        int planes = data.readUnsignedShort();
        int bitsPerPixel = data.readUnsignedShort();
        boolean compression = false;
        int bmpVersion = 2;
        return this.height < 0;
    }

    boolean readVersion3x(DataInputStream data) throws IOException {
        this.width = data.readInt();
        this.height = data.readInt();
        int planes = data.readUnsignedShort();
        int bitsPerPixel = data.readUnsignedShort();
        int compression = data.readInt();
        int sizeOfBitmap = data.readInt();
        int horzResolution = data.readInt();
        int vertResolution = data.readInt();
        int colorsUsed = data.readInt();
        int colorsImportant = data.readInt();
        if (compression == 3) {
            int redMask = data.readInt();
            int greenMask = data.readInt();
            int blueMask = data.readInt();
        } else if (bitsPerPixel == 16) {
            int redMask = 31744;
            int greenMask = 992;
            int blueMask = 31;
            boolean bl = false;
        }
        int bmpVersion = 3;
        return this.height < 0;
    }

    boolean readVersion4x(DataInputStream data) throws IOException {
        this.width = data.readInt();
        this.height = data.readInt();
        int planes = data.readUnsignedShort();
        this.depth = data.readUnsignedShort();
        int compression = data.readInt();
        int sizeOfBitmap = data.readInt();
        int horzResolution = data.readInt();
        int vertResolution = data.readInt();
        int colorsUsed = data.readInt();
        int colorsImportant = data.readInt();
        int redMask = data.readInt();
        int greenMask = data.readInt();
        int blueMask = data.readInt();
        int alphaMask = data.readInt();
        int csType = data.readInt();
        int redX = data.readInt();
        int redY = data.readInt();
        int redZ = data.readInt();
        int greenX = data.readInt();
        int greenY = data.readInt();
        int greenZ = data.readInt();
        int blueX = data.readInt();
        int blueY = data.readInt();
        int blueZ = data.readInt();
        int gammaRed = data.readInt();
        int gammaGreen = data.readInt();
        int gammaBlue = data.readInt();
        int bmpVersion = 4;
        return this.height < 0;
    }
}

