/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.util.image.ImageInfo;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.ImageProviderAPI;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.image.ScaleUtil;
import com.elluminate.util.image.SizeProvider;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class IIOImageProvider
implements ImageProviderAPI {
    private static final boolean AUTO_SCALE_OFF = false;
    private Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private ScaleUtil scaleUtil = new ScaleUtil(Runtime.getRuntime());
    private SizeProvider autoScaleSizeProvider = new AutoScaleSizeProvider();

    @Override
    public String[] getInputTypes() {
        return ImageIO.getReaderMIMETypes();
    }

    @Override
    public String[] getOutputTypes() {
        return ImageIO.getWriterMIMETypes();
    }

    @Override
    public boolean isSupportedInputType(String mime) {
        if (mime == null) {
            return false;
        }
        mime = ImageMimeUtilities.getRawImageMimeType(mime);
        for (String t : this.getInputTypes()) {
            String raw = ImageMimeUtilities.getRawImageMimeType(t);
            if (!mime.equalsIgnoreCase(raw)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSupportedOutputType(String mime) {
        if (mime == null) {
            return false;
        }
        mime = ImageMimeUtilities.getRawImageMimeType(mime);
        for (String t : this.getOutputTypes()) {
            if (!mime.equalsIgnoreCase(ImageMimeUtilities.getRawImageMimeType(t))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMaxSize(Dimension max) {
        this.maxSize = max;
    }

    @Override
    public Image loadImage(byte[] imageData, String mime) throws IOException {
        ImageInfo info = this.loadImage(imageData, mime, false);
        return info == null ? null : info.getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageInfo loadImage(byte[] imageData, String mime, boolean autoScale) throws IOException {
        Iterator<ImageReader> itr = ImageIO.getImageReadersByMIMEType(mime);
        if (!itr.hasNext()) {
            return null;
        }
        ImageSourceInfo sourceInfo = null;
        try {
            sourceInfo = new ImageSourceInfo(imageData);
            ImageInfo info = this.loadImage(sourceInfo.getImageInputStream(), itr.next(), autoScale);
            info.setMimeType(mime);
            ImageInfo imageInfo = info;
            return imageInfo;
        }
        finally {
            if (sourceInfo != null) {
                sourceInfo.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image loadImage(URL url) throws IOException {
        ImageSourceInfo sourceInfo = null;
        try {
            sourceInfo = new ImageSourceInfo(url);
            Image image = this.loadImage(sourceInfo.getImageInputStream(), false);
            return image;
        }
        finally {
            if (sourceInfo != null) {
                sourceInfo.close();
            }
        }
    }

    @Override
    public Image loadImage(File f) throws IOException {
        return this.loadImage(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image loadImage(File f, boolean autoScale) throws IOException {
        ImageSourceInfo sourceInfo = null;
        try {
            sourceInfo = new ImageSourceInfo(f);
            Image image = this.loadImage(sourceInfo.getImageInputStream(), autoScale);
            return image;
        }
        finally {
            if (sourceInfo != null) {
                sourceInfo.close();
            }
        }
    }

    private Image loadImage(ImageInputStream strm, boolean autoScale) throws IOException {
        if (strm == null) {
            return null;
        }
        Iterator<ImageReader> itr = ImageIO.getImageReaders(strm);
        if (!itr.hasNext()) {
            return null;
        }
        return this.loadImage(strm, itr.next(), autoScale).getImage();
    }

    private ImageInfo loadImage(ImageInputStream strm, ImageReader reader, boolean autoScale) throws IOException {
        if (strm == null || reader == null) {
            return null;
        }
        try {
            reader.setInput(strm, false, true);
            int w = reader.getWidth(0);
            int h = reader.getHeight(0);
            if (!(autoScale || w <= this.maxSize.width && h <= this.maxSize.height)) {
                throw new ImageSupport.OversizeImageException(this.maxSize.height * this.maxSize.width);
            }
            Dimension autoScaleSize = this.autoScaleSizeProvider.getSize();
            if (!this.isSmallerThanMaxSize(autoScaleSize)) {
                autoScaleSize = this.maxSize;
            }
            if (!autoScale || w < autoScaleSize.width && h < autoScaleSize.height) {
                ImageInfo imageInfo = new ImageInfo(reader.read(0), false);
                return imageInfo;
            }
            if (this.scaleUtil.canScale(w * h, autoScaleSize)) {
                Image scaledImg;
                boolean scaled;
                BufferedImage img = reader.read(0);
                boolean bl = scaled = img != (scaledImg = this.scaleUtil.scaleToLimit(img, autoScaleSize));
                if (scaled) {
                    img.flush();
                }
                ImageInfo imageInfo = new ImageInfo(scaledImg, scaled);
                return imageInfo;
            }
            throw new ImageSupport.InsufficientMemoryExcetpion(this.scaleUtil.calcSizeReductionRequiredToLoad(w, h, autoScaleSize));
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    private boolean isSmallerThanMaxSize(Dimension autoScaleSize) {
        return autoScaleSize.width < this.maxSize.width && autoScaleSize.height < this.maxSize.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeImage(Image img, OutputStream outStrm, String mime, int param) throws IOException {
        Iterator<ImageWriter> itr = ImageIO.getImageWritersByMIMEType(mime);
        if (itr.hasNext()) {
            ImageWriter writer = null;
            try {
                writer = itr.next();
                BufferedImage bImage = ImageSupport.toBufferedImage(img);
                ImageOutputStream imgStrm = ImageIO.createImageOutputStream(outStrm);
                if (imgStrm != null) {
                    writer.setOutput(imgStrm);
                    IIOImage iioImage = new IIOImage(bImage, null, null);
                    ImageWriteParam iwParam = this.prepareParam(writer, mime, param);
                    writer.write(null, iioImage, iwParam);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (writer != null) {
                    writer.dispose();
                }
            }
        }
        return false;
    }

    private ImageWriteParam prepareParam(ImageWriter writer, String mime, int param) {
        ImageWriteParam result = null;
        if ("image/jpeg".equalsIgnoreCase(mime)) {
            if (param > 100) {
                param = 100;
            }
            if (param < 1) {
                param = 1;
            }
            try {
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                if (iwp.canWriteCompressed()) {
                    iwp.setCompressionMode(2);
                    iwp.setCompressionQuality((float)param / 100.0f);
                    result = iwp;
                }
            }
            catch (Throwable ignored) {}
        } else if ("image/png".equalsIgnoreCase(mime)) {
            if (param > 9) {
                param = 9;
            }
            if (param < 1) {
                param = 1;
            }
            try {
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                if (iwp.canWriteCompressed()) {
                    iwp.setCompressionMode(2);
                    iwp.setCompressionQuality(1.0f - (float)param / 9.0f);
                    result = iwp;
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void setAutoScaleSizeProvider(SizeProvider sp) {
        this.autoScaleSizeProvider = sp;
    }

    private class AutoScaleSizeProvider
    implements SizeProvider {
        private AutoScaleSizeProvider() {
        }

        @Override
        public Dimension getSize() {
            return IIOImageProvider.this.maxSize;
        }
    }

    public static class ImageSourceInfo {
        private long length;
        private InputStream source;
        private ImageInputStream stream;

        public ImageSourceInfo(File f) throws IOException {
            this.length = f.length();
            this.source = new FileInputStream(f);
            this.open();
        }

        public ImageSourceInfo(URL url) throws IOException {
            URLConnection connect = url.openConnection();
            this.length = connect.getContentLength();
            this.source = connect.getInputStream();
            this.open();
        }

        public ImageSourceInfo(byte[] imageData) throws IOException {
            this.length = imageData.length;
            this.source = new ByteArrayInputStream(imageData);
            this.open();
        }

        public ImageInputStream getImageInputStream() {
            return this.stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open() throws IOException {
            boolean succeeded = false;
            try {
                this.stream = this.length > 0L || this.length <= 131072L ? new MemoryCacheImageInputStream(this.source) : ImageIO.createImageInputStream(this.source);
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.close();
                }
            }
        }

        public void close() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.stream = null;
            }
            if (this.source != null) {
                try {
                    this.source.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.source = null;
            }
        }
    }
}

