/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.event;

import com.elluminate.util.WorkerThread;
import com.elluminate.util.event.OperationCanceledException;
import com.elluminate.util.event.OperationEvent;
import com.elluminate.util.event.OperationListener;
import com.elluminate.util.event.OperationProgressException;
import javax.swing.event.EventListenerList;

public abstract class Operation
implements Runnable {
    private Object object;
    private String name;
    private long size;
    private String progressStatus;
    private long progressSize;
    private boolean running = false;
    private boolean finished = false;
    private boolean canceled = false;
    private EventListenerList listenerList = new EventListenerList();
    private Thread thread;
    private long nextThreadIndex = 1L;

    public Operation(Object object, String name) {
        this(object, name, -1L);
    }

    public Operation(Object object, String name, long size) {
        this.object = object;
        this.name = name;
        this.size = size;
    }

    public Object getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    protected void setSize(long size) {
        this.size = size;
    }

    public String getProgressStatus() {
        return this.progressStatus;
    }

    protected void setProgressStatus(String progressStatus) {
        this.progressStatus = progressStatus;
        this.fireProgressEvent(2);
    }

    public long getProgressSize() {
        return this.progressSize;
    }

    protected void setProgressSize(long progressSize) {
        this.progressSize = progressSize;
        this.fireProgressEvent(2);
    }

    protected void setProgress(String progressStatus, long progressSize) {
        this.progressStatus = progressStatus;
        this.progressSize = progressSize;
        this.fireProgressEvent(2);
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("Operation is already in progress");
        }
        this.canceled = false;
        this.finished = false;
        this.running = true;
        this.thread = new WorkerThread((Runnable)this, "Operation-" + this.nextThreadIndex);
        this.thread.start();
        ++this.nextThreadIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.fireProgressEvent(1);
            this.perform();
            this.finished = true;
            this.fireProgressEvent(3);
        }
        catch (OperationCanceledException ex) {
            this.fireProgressEvent(4);
        }
        catch (OperationProgressException ex) {
            this.fireProgressEvent(5);
        }
        finally {
            this.running = false;
            this.thread = null;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected abstract void perform() throws OperationProgressException;

    public synchronized void cancel() {
        if (this.running) {
            this.canceled = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void checkCanceled() throws OperationCanceledException {
        if (this.canceled) {
            throw new OperationCanceledException();
        }
    }

    public void addOperationListener(OperationListener l) {
        this.listenerList.add(OperationListener.class, l);
    }

    public void removeOperationListener(OperationListener l) {
        this.listenerList.remove(OperationListener.class, l);
    }

    protected void fireProgressEvent(int eventID) {
        OperationEvent e = new OperationEvent(this, eventID);
        Object[] ls = this.listenerList.getListenerList();
        block7: for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != OperationListener.class) continue;
            OperationListener l = (OperationListener)ls[i + 1];
            switch (eventID) {
                case 1: {
                    l.progressStarted(e);
                    continue block7;
                }
                case 2: {
                    l.progressChanged(e);
                    continue block7;
                }
                case 3: {
                    l.progressFinished(e);
                    continue block7;
                }
                case 4: {
                    l.progressCanceled(e);
                    continue block7;
                }
                case 5: {
                    l.progressError(e);
                }
            }
        }
    }
}

