/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.event;

import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ThrowableListener;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListenerRegistry<T>
implements Iterable<T> {
    private final CopyOnWriteArrayList<T> listeners = new CopyOnWriteArrayList();
    private ThrowableListener exceptionListener;

    @Inject
    public ListenerRegistry(ThrowableListener el) {
        this.setThrowableListener(el);
    }

    public void setThrowableListener(ThrowableListener el) {
        if (el == null) {
            throw new IllegalArgumentException("ThrowableListener can not be null");
        }
        this.exceptionListener = el;
    }

    public ThrowableListener getThrowableListener() {
        return this.exceptionListener;
    }

    public void add(T listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.addIfAbsent(listener)) {
            // empty if block
        }
    }

    public void remove(T listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.remove(listener)) {
            // empty if block
        }
    }

    public void fire(FiringFunctor<T> fc) {
        for (T listener : this.listeners) {
            try {
                fc.fire(listener);
            }
            catch (Exception e) {
                this.exceptionListener.exceptionThrown(e);
            }
            catch (Error e) {
                this.exceptionListener.errorThrown(e);
            }
        }
    }

    public int size() {
        return this.listeners.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.listeners.iterator();
    }
}

