/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto.net;

import com.elluminate.util.StringComparator;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.crypto.AES;
import com.elluminate.util.crypto.BlkCipher;
import com.elluminate.util.crypto.CBCMode;
import com.elluminate.util.crypto.SHA256;
import com.elluminate.util.crypto.net.AuthenticationException;
import com.elluminate.util.crypto.net.SequenceManager;
import com.elluminate.util.crypto.net.URLVerifier;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.URLString;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class URLSigner {
    private static StringComparator comparator = new StringComparator();
    private static HashMap targets = new HashMap();
    private BigInteger id;
    private BigInteger key;
    private String idStr;
    private String encoding = System.getProperty("file.encoding");
    private BlkCipher cipher = new AES(128);
    private SequenceManager seq = null;

    private URLSigner(SequenceManager seq, BigInteger id, BigInteger key) {
        this.id = id;
        this.key = key;
        this.seq = seq;
        this.idStr = id.toString(36);
        this.cipher.init(key.toByteArray(), true);
    }

    public static URLSigner getInstance(URL url, BigInteger id, BigInteger key) {
        return URLSigner.getInstance(url.toString(), id, key);
    }

    public static URLSigner getInstance(URLString url, BigInteger id, BigInteger key) {
        return URLSigner.getInstance(url.toString(), id, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLSigner getInstance(String url, BigInteger id, BigInteger key) {
        SequenceManager mgr = null;
        HashMap hashMap = targets;
        synchronized (hashMap) {
            mgr = (SequenceManager)targets.get(url);
            if (mgr == null) {
                mgr = new SequenceManager();
                targets.put(url, mgr);
            }
        }
        return new URLSigner(mgr, id, key);
    }

    public void setEncoding(String coding) throws UnsupportedEncodingException {
        URLEncoder.encode("this is a test", coding);
        this.encoding = coding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public URL sign(URL base, Map args, String enc) throws MalformedURLException, UnsupportedEncodingException {
        return new URL(this.sign(base.toString(), args, enc));
    }

    public URL sign(URL base, Map args) throws MalformedURLException {
        return new URL(this.sign(base.toString(), args));
    }

    public URLString sign(URLString base, Map args, String enc) throws MalformedURLException, UnsupportedEncodingException {
        return new URLString(this.sign(base.toString(), args, enc));
    }

    public URLString sign(URLString base, Map args) throws MalformedURLException {
        return new URLString(this.sign(base.toString(), args));
    }

    public String sign(String base, Map args) {
        try {
            return this.sign(base, args, this.encoding);
        }
        catch (UnsupportedEncodingException uex) {
            throw new RuntimeException(uex);
        }
    }

    public Map sign(Map args) {
        TreeMap<String, String> map = new TreeMap<String, String>(comparator);
        SHA256 sha = new SHA256();
        BigInteger seqInt = BigInteger.valueOf(this.seq.getNext());
        map.putAll(args);
        map.put("sigID", this.idStr);
        map.put("sigSeq", seqInt.toString(36));
        map.put("sigAlg", "SHA256.AES-128");
        map.put("sigVer", "2");
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            try {
                sha.process(key.getBytes("UTF-8"));
                sha.process(value.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uex) {
                LogSupport.exception(this, "sign", uex, true);
                throw new RuntimeException("UTF-8 not supported.");
            }
        }
        int hashlen = sha.hashByteLength();
        int blklen = this.cipher.getBlockByteLength();
        byte[] hash = sha.hash();
        if (hashlen % blklen != 0) {
            int pad = blklen - hashlen % blklen;
            byte[] padded = new byte[hash.length + pad];
            System.arraycopy(hash, 0, padded, pad, hash.length);
            hash = padded;
        }
        CBCMode cbc = new CBCMode(this.cipher, this.key.toByteArray());
        byte[] iv = cbc.createIV();
        byte[] auth = new byte[hash.length];
        cbc.encrypt(iv, 0, hash, 0, auth, 0, hash.length);
        BigInteger ivInt = new BigInteger(iv);
        BigInteger authInt = new BigInteger(auth);
        map.put("sigAuth", ivInt.toString(36) + "." + authInt.toString(36));
        return map;
    }

    public String sign(String base, Map args, String enc) throws UnsupportedEncodingException {
        Map map = this.sign(args);
        StringBuffer buf = new StringBuffer(base);
        int separator = base.indexOf("?") > 0 ? 38 : 63;
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            buf.append((char)separator);
            buf.append(URLEncoder.encode(key, enc));
            buf.append('=');
            buf.append(URLEncoder.encode(value, enc));
            separator = 38;
        }
        String signed = buf.toString();
        if (UtilDebug.SIGNED_URL.show()) {
            LogSupport.message(this, "sign", "--> " + signed);
        }
        return signed;
    }

    public static void main(String[] unused) {
        String base = "http://www.elluminate.com/servlet/auth";
        HashMap<String, String> args = new HashMap<String, String>();
        SecureRandom rnd = new SecureRandom();
        BigInteger key = new BigInteger(192, rnd);
        BigInteger id = new BigInteger(64, rnd);
        URLSigner signer = new URLSigner(new SequenceManager(), id, key);
        URLVerifier verifier = new URLVerifier();
        HashSet<String> names = new HashSet<String>();
        args.put("conf", "dev|eLive-TNG1");
        args.put("name", "Bob");
        args.put("req", "join");
        names.add("conf");
        names.add("name");
        names.add("req");
        String url = signer.sign(base, args);
        verifier.addSource(id, key);
        URLSigner.test(verifier, url, names);
        URLSigner.test(verifier, url, names);
        url = signer.sign(base, args);
        url = url + "&extra=stuff";
        URLSigner.test(verifier, url, names);
        url = signer.sign(base, args);
        int idx = url.indexOf("Bob");
        url = url.substring(0, idx) + "Joe" + url.substring(idx + 3);
        URLSigner.test(verifier, url, names);
    }

    private static void test(URLVerifier verifier, String url, Set names) {
        System.out.println(url);
        try {
            verifier.verify(url, names);
            System.out.println("verified");
        }
        catch (AuthenticationException ex) {
            System.out.println("not verified - " + ex);
        }
    }
}

