/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.command;

import com.elluminate.util.DebugFlag;
import com.elluminate.util.QuotedStringTokenizer;
import com.elluminate.util.command.CommandAdapter;
import com.elluminate.util.command.CommandProcessor;
import com.elluminate.util.log.LogSupport;
import java.io.File;

public class TraceCmd
extends CommandAdapter {
    public TraceCmd() {
        this.setDescription("Select debugging output and redirection.");
        this.setUsage("usage: @ on|off <traceFlagName>\n           @ log console|<log file name");
    }

    @Override
    public void execute(CommandProcessor cp, String cmd, QuotedStringTokenizer args) {
        String state = null;
        String flag = null;
        if (args.hasMoreTokens()) {
            state = args.nextToken();
        }
        if (args.hasMoreTokens()) {
            flag = args.nextToken();
        }
        if (state == null || flag == null || args.hasMoreTokens()) {
            this.sendResponse(401, this.getUsage(cmd));
            return;
        }
        if (state.equalsIgnoreCase("on")) {
            DebugFlag f = DebugFlag.get(flag);
            f.setEnabled(true);
        } else if (state.equalsIgnoreCase("off")) {
            DebugFlag f = DebugFlag.get(flag);
            f.setEnabled(false);
        } else if (state.equalsIgnoreCase("log")) {
            if (flag.equalsIgnoreCase("console")) {
                LogSupport.setLoggingToConsole(true);
                LogSupport.setLoggingToFile(false);
            } else {
                try {
                    File f = new File(flag);
                    LogSupport.setLogFile(f);
                    LogSupport.setLoggingToConsole(false);
                }
                catch (Exception ex) {
                    LogSupport.setLoggingToConsole(true);
                    this.sendResponse(400, "Unable to set log file " + flag + " - " + ex);
                    return;
                }
            }
        } else {
            this.sendResponse(401, this.getUsage(cmd));
            return;
        }
        this.sendResponse(200, "OK");
    }
}

