/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.command;

import com.elluminate.util.QuotedStringTokenizer;
import com.elluminate.util.ThreadUtils;
import com.elluminate.util.command.CommandAdapter;
import com.elluminate.util.command.CommandProcessor;

public class DeadlocksCmd
extends CommandAdapter {
    public DeadlocksCmd() {
        this.setDescription("Check for deadlocked threads.");
    }

    @Override
    public void execute(CommandProcessor cp, String cmd, QuotedStringTokenizer args) {
        if (args.hasMoreTokens()) {
            this.sendResponse(401, this.getUsage(cmd));
            return;
        }
        if (!ThreadUtils.isTrackingDeadlocksSupported()) {
            this.sendResponse(400, "Deadlock detection not supported.");
            return;
        }
        String report = ThreadUtils.reportDeadlocks(null);
        if (report == null) {
            this.sendResponse(200, "No deadlocks detected.");
            return;
        }
        this.sendResponse(200, report);
    }
}

