/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.browser;

import com.elluminate.platform.Platform;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.browser.BrowserLauncher;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public class BrowserUtil {
    private static Object basicService = null;
    private static Method showDocMethod = null;
    private static final boolean isWindows;

    private BrowserUtil() {
    }

    public static final void gotoURL(String str) throws IOException {
        if (showDocMethod != null && !UtilDebug.BROWSER_EXTERN.show()) {
            URL url = null;
            try {
                url = new URL(str);
            }
            catch (MalformedURLException mue) {
                LogSupport.exception(BrowserUtil.class, "gotoURL", mue, true, "Processing URI: '" + str + "'");
            }
            BrowserUtil.gotoURL(url);
            return;
        }
        LogSupport.message(BrowserUtil.class, "gotoURL", "Launching URI '" + str + "' using BrowserLauncher");
        BrowserLauncher.openURL(str);
    }

    public static final void gotoURL(URL url) throws IOException {
        if (url == null) {
            return;
        }
        if (!(showDocMethod == null || UtilDebug.BROWSER_EXTERN.show() || isWindows && "mailto".equalsIgnoreCase(url.getProtocol()) && !UtilDebug.BROWSER_SERVICE.show())) {
            try {
                if (UtilDebug.BROWSER_URL.show()) {
                    LogSupport.message(BrowserUtil.class, "gotoURL", "Opening URL: " + url);
                    LogSupport.message(BrowserUtil.class, "gotoURL", "   show doc: " + showDocMethod);
                }
                showDocMethod.invoke(basicService, url);
                if (UtilDebug.BROWSER_URL.show()) {
                    LogSupport.message(BrowserUtil.class, "gotoURL", "   returned: " + showDocMethod);
                }
                return;
            }
            catch (Throwable ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                Throwable cause = null;
                if (ex instanceof InvocationTargetException) {
                    cause = ex.getCause();
                }
                LogSupport.exception(BrowserUtil.class, "gotoURL", cause != null ? cause : ex, true, "Processing URL: " + url);
            }
        }
        LogSupport.message(BrowserUtil.class, "gotoURL", "Launching URL '" + url + "' using BrowserLauncher");
        BrowserLauncher.openURL(url.toString());
    }

    static {
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            basicService = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            Method check = basicService.getClass().getMethod("isWebBrowserSupported", new Class[0]);
            if (((Boolean)check.invoke(basicService, new Object[0])).booleanValue()) {
                showDocMethod = basicService.getClass().getMethod("showDocument", URL.class);
            }
        }
        catch (Throwable ex) {
            showDocMethod = null;
        }
        isWindows = Platform.getPlatform() == 1;
    }
}

