/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.Resource;
import com.elluminate.util.StringComparator;
import com.elluminate.util.StringsProperties;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;

@Singleton
public class VersionManager
implements ComponentRegistrar {
    private static final int PRODUCT_MAJOR = 0;
    private static final int PRODUCT_MINOR = 1;
    private static final int PRODUCT_PATCH = 2;
    private static final String WHITESPACE = "                                ";
    private Version productVer = null;
    private String productBuild = null;
    private Copyright productCopyright = null;
    private Map<String, Version> componentVer = new TreeMap<String, Version>(new StringComparator());
    private List<Copyright> componentCopyright = new LinkedList<Copyright>();
    private Map<String, Library> libByPkg = new HashMap<String, Library>();
    private Map<String, Library> libByName = new TreeMap<String, Library>(new StringComparator());
    private I18n i18n = I18n.create(this);

    public static int[] parse(String string) {
        int buildx = string.indexOf(95);
        if (buildx > 0) {
            string = string.substring(0, buildx);
        }
        ArrayList<Integer> version = new ArrayList<Integer>();
        StringTokenizer parser = new StringTokenizer(string, ".", false);
        while (parser.hasMoreTokens()) {
            String part = parser.nextToken();
            int value = Integer.parseInt(part, 10);
            if (value < 0) {
                throw new NumberFormatException("Version numbers may not have negative parts.");
            }
            version.add(value);
        }
        int size = version.size();
        if (size == 4 || size == 2) {
            version.add(2, 0);
        }
        int[] parts = new int[version.size()];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = (Integer)version.get(i);
        }
        return parts;
    }

    public boolean hasVersions() {
        return this.productVer != null;
    }

    public boolean hasCopyrights() {
        return this.productCopyright != null || !this.componentCopyright.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProduct(Object obj) {
        ResourceBundle rsrc;
        if (UtilDebug.VERSION.show()) {
            LogSupport.message(this, "registerProduct", "Register product using " + obj);
        }
        if ((rsrc = this.getResourceFor(obj, "Product.name")) == null) {
            if (UtilDebug.VERSION.show()) {
                LogSupport.message(this, "registerProduct", "No version resources found for product " + obj);
            }
            return;
        }
        ResourceBundle buildrsrc = this.getResourceFor(obj, "Product.build");
        if (buildrsrc == null) {
            buildrsrc = rsrc;
        }
        String pName = this.getBundleString(rsrc, "Product.name");
        String pVer = this.getBundleString(buildrsrc, "Product.version");
        String pBuild = this.getBundleString(buildrsrc, "Product.build");
        if (this.isEmpty(pBuild)) {
            pBuild = this.getBundleString(rsrc, "Product.build");
        }
        if (pName == null || pVer == null) {
            if (UtilDebug.VERSION.show()) {
                LogSupport.message(this, "registerProduct", "Required values missing for product " + obj);
            }
            return;
        }
        VersionManager versionManager = this;
        synchronized (versionManager) {
            if (this.productVer != null) {
                throw new IllegalStateException("Only one product can be registered with the version manager.\n " + pName + " " + pVer);
            }
            this.productVer = new Version(pName, pVer);
            this.productCopyright = this.getCopyright(rsrc, "Product", null);
            this.productBuild = pBuild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerComponent(Object obj) {
        ResourceBundle rsrc;
        if (UtilDebug.VERSION.show()) {
            LogSupport.message(this, "registerComponent", "Register component using " + obj);
        }
        if ((rsrc = this.getResourceFor(obj, "Component.name")) == null) {
            if (UtilDebug.VERSION.show()) {
                LogSupport.message(this, "registerComponent", "No resouorces found for component " + obj);
            }
            return;
        }
        String cName = this.getBundleString(rsrc, "Component.name");
        String cVer = this.getBundleString(rsrc, "Component.version");
        if (cName == null || cVer == null) {
            if (UtilDebug.VERSION.show()) {
                LogSupport.message(this, "registerComponent", "Required values missing for component " + obj);
            }
            return;
        }
        VersionManager versionManager = this;
        synchronized (versionManager) {
            String dependencies;
            if (this.productVer == null) {
                throw new IllegalStateException("A component may not be registered without a product.\n    " + cName + " " + cVer);
            }
            Version version = new Version(cName, cVer);
            if (version.version[0] != this.productVer.version[0]) {
                throw new IllegalArgumentException("Component " + version + " has an incompatible major number with " + this.productVer);
            }
            if (version.version[1] > this.productVer.version[1]) {
                this.productVer.version[1] = version.version[1];
                this.productVer.version[2] = version.version[2];
            } else if (version.version[1] == this.productVer.version[1] && version.version[2] > this.productVer.version[2]) {
                this.productVer.version[2] = version.version[2];
            }
            this.componentVer.put(cName, version);
            Copyright copyright = this.getCopyright(rsrc, "Component", cName);
            if (copyright != null && this.productCopyright != null && this.productCopyright.isCompatibleWith(copyright)) {
                this.productCopyright.addYears(copyright.years);
                copyright = null;
            }
            if (copyright != null) {
                this.componentCopyright.add(copyright);
            }
            if ((dependencies = this.getBundleString(rsrc, "Component.dependencies")) != null) {
                this.parseDependencies(dependencies);
            }
        }
    }

    private Copyright getCopyright(ResourceBundle rsrc, String prefix, String part) {
        String holder = this.getBundleString(rsrc, prefix + ".copyrightBy");
        String dates = this.getBundleString(rsrc, prefix + ".copyrightDate");
        String terms = this.getBundleString(rsrc, prefix + ".copyrightTerms");
        if (dates == null && holder == null) {
            return null;
        }
        if (dates == null || holder == null) {
            throw new IllegalArgumentException("Both " + prefix + ".copyrightBy and " + prefix + ".copyrightDate are required.");
        }
        return new Copyright(part, holder, dates, terms);
    }

    public String getVersions() {
        if (!this.hasVersions()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int nameLen = 0;
        buf.append(this.productVer);
        if (this.productBuild != null) {
            buf.append('.');
            buf.append(this.productBuild);
        }
        buf.append('\n');
        for (String nm : this.componentVer.keySet()) {
            if (nm.length() <= nameLen) continue;
            nameLen = nm.length();
        }
        for (String nm : this.libByName.keySet()) {
            if (nm.length() <= nameLen) continue;
            nameLen = nm.length();
        }
        for (String nm : this.componentVer.keySet()) {
            Version ver = this.componentVer.get(nm);
            buf.append("\n    ");
            buf.append(ver.toString(nameLen));
        }
        for (String nm : this.libByName.keySet()) {
            Library lib = this.libByName.get(nm);
            buf.append("\n    ");
            buf.append(lib.toString(nameLen));
        }
        return buf.toString();
    }

    public String getHtmlCopyrights() {
        if (!this.hasCopyrights()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (this.productCopyright != null) {
            buf.append(this.productCopyright);
        }
        return buf.toString();
    }

    public String getCopyrights() {
        if (!this.hasCopyrights()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (this.productCopyright != null) {
            buf.append(this.productCopyright);
        }
        for (Copyright c : this.componentCopyright) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public boolean hasCopyright(String name) {
        try {
            return this.getCopyright(name) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public String getCopyright(String name) {
        if (name == null) {
            if (this.productCopyright == null) {
                throw new IllegalArgumentException("No product copyright defined");
            }
            return this.productCopyright.toString();
        }
        for (Copyright cp : this.componentCopyright) {
            if (!name.equals(cp.work)) continue;
            return cp.toString();
        }
        Library lib = this.libByName.get(name);
        if (lib != null) {
            return lib.copyright;
        }
        throw new IllegalArgumentException("Unknown component '" + name + "'");
    }

    public boolean hasInfoURL(String name) {
        try {
            return this.getInfoURL(name) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public String getInfoURL(String name) {
        Library lib = this.libByName.get(name);
        if (lib == null) {
            throw new IllegalArgumentException("Unknown library '" + name + "'");
        }
        return lib.URL;
    }

    public String toString() {
        if (this.hasVersions() && this.hasCopyrights()) {
            return this.getVersions() + "\n\n" + this.getCopyrights();
        }
        if (this.hasVersions()) {
            return this.getVersions();
        }
        return "";
    }

    public boolean isNewerThan(String version) {
        if (this.productVer == null) {
            return false;
        }
        return this.productVer.isNewerThan(version);
    }

    public String getProductName() {
        return this.productVer.name;
    }

    public String getProductVer() {
        if (this.productBuild != null) {
            return this.productVer.getVersionString() + "." + this.productBuild;
        }
        return this.productVer.getVersionString();
    }

    public String getProductBuild() {
        return this.productBuild;
    }

    public int getProductMajorVersion() {
        return this.productVer.version[0];
    }

    public int getProductMinorVersion() {
        return this.productVer.version[1];
    }

    public int getProductPatchVersion() {
        return this.productVer.version[2];
    }

    public Iterator componentIterator() {
        return this.componentVer.keySet().iterator();
    }

    public Iterator libraryIterator() {
        return this.libByName.keySet().iterator();
    }

    public String getVersionString(String name) {
        if (name == null) {
            if (this.productVer == null) {
                throw new IllegalArgumentException("No product version defined");
            }
            return this.productVer.getVersionString();
        }
        Version ver = this.componentVer.get(name);
        if (ver != null) {
            return ver.getVersionString();
        }
        Library lib = this.libByName.get(name);
        if (lib != null) {
            return lib.version;
        }
        if (this.productVer != null && name.equals(this.productVer.name)) {
            return this.productVer.getVersionString();
        }
        throw new IllegalArgumentException("Unknown component '" + name + "'");
    }

    private ResourceBundle getResourceFor(Object obj, String key) {
        String nm = null;
        Class cls = obj.getClass();
        if (obj instanceof ResourceBundle) {
            return (ResourceBundle)obj;
        }
        if (obj instanceof String) {
            nm = (String)obj;
        } else if (obj instanceof Class) {
            cls = (Class)obj;
        }
        if (nm == null) {
            nm = cls.getName();
            int dot = nm.lastIndexOf(46);
            if (dot < 0) {
                return null;
            }
            nm = nm.substring(0, dot);
        }
        while (nm.indexOf(46) > 0) {
            ResourceBundle rsrc = Resource.getResourceFor(nm, "Version", cls);
            if (rsrc != null) {
                if (key != null) {
                    if (this.getBundleString(rsrc, key) != null) {
                        return rsrc;
                    }
                } else {
                    return rsrc;
                }
            }
            int idx = nm.lastIndexOf(46);
            nm = nm.substring(0, idx);
        }
        return null;
    }

    private void parseDependencies(String deps) {
        if (UtilDebug.VERSION.show()) {
            LogSupport.message(this, "parseDependencies", "Got dependencies: " + deps);
        }
        StringTokenizer parser = new StringTokenizer(deps, ",");
        while (parser.hasMoreTokens()) {
            String libClass = parser.nextToken();
            int dot = libClass.lastIndexOf(46);
            Class<?> cls = null;
            if (UtilDebug.VERSION.show()) {
                LogSupport.message(this, "parseDependencies", "  parsing " + libClass);
            }
            if (dot < 0) continue;
            String lib = libClass.substring(0, dot);
            if (UtilDebug.VERSION.show()) {
                LogSupport.message(this, "parseDependencies", "    lib=" + lib);
            }
            if (this.libByPkg.containsKey(lib)) continue;
            try {
                cls = Class.forName(libClass);
            }
            catch (Throwable t) {
                if (!UtilDebug.VERSION.show()) continue;
                LogSupport.message(this, "parseDependencies", Debug.getStackTrace(t));
                continue;
            }
            ResourceBundle rsrc = this.getResourceFor(cls, "Library.name");
            String prefix = "";
            if (rsrc == null) {
                rsrc = this.getResourceFor(this.getClass(), libClass + ".Library.name");
                if (rsrc == null) {
                    String packagePath = this.getClass().getPackage().getName();
                    if (!UtilDebug.VERSION.show()) continue;
                    LogSupport.message(this, "Library Search - no library info: ", packagePath + libClass + ".Library.name");
                    continue;
                }
                prefix = libClass + ".";
            }
            String name = this.getBundleString(rsrc, prefix + "Library.name");
            String ver = this.getBundleString(rsrc, prefix + "Library.version");
            String rights = this.getBundleString(rsrc, prefix + "Library.copyright");
            String url = this.getBundleString(rsrc, prefix + "Library.url");
            String dep2 = this.getBundleString(rsrc, prefix + "Library.dependencies");
            Library library = new Library(name, ver, rights, url);
            if (UtilDebug.VERSION.show()) {
                LogSupport.message(this, "parseDependencies", "    info=" + library + " " + rights);
            }
            this.libByPkg.put(lib, library);
            this.libByName.put(name, library);
            if (dep2 == null) continue;
            this.parseDependencies(dep2);
        }
    }

    private String getBundleString(ResourceBundle rsrc, String key) {
        try {
            return rsrc.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    class Copyright {
        public String work = null;
        public String holder = null;
        public int[] years = null;
        public String terms = null;

        public Copyright(String on, String who, String when, String what) {
            this.work = on;
            this.holder = who;
            this.years = new int[0];
            this.terms = what;
            this.addYears(when);
        }

        public void addYears(String desc) {
            StringTokenizer parser = new StringTokenizer(desc, ",-", true);
            int prev = -1;
            int start = -1;
            if (desc.trim().equals("")) {
                return;
            }
            while (parser.hasMoreTokens()) {
                String token = parser.nextToken();
                if ((token = token.trim()).equals(",")) {
                    if (prev < 0) {
                        throw new IllegalArgumentException("Comma without preceeding year.  '" + desc + "'");
                    }
                    this.addYear(prev);
                    prev = -1;
                    continue;
                }
                if (token.equals("-")) {
                    if (start > 0) {
                        throw new IllegalArgumentException("Invalid construct '--'.  '" + desc + "'");
                    }
                    if (prev < 0) {
                        throw new IllegalArgumentException("Dash without preceeding year.  '" + desc + "'");
                    }
                    start = prev;
                    continue;
                }
                int curr = Integer.parseInt(token, 10);
                if (start > 0) {
                    if (start > curr) {
                        throw new IllegalArgumentException("Year range reversed '" + start + "-" + curr + "'");
                    }
                    for (int i = start; i <= curr; ++i) {
                        this.addYear(i);
                    }
                    start = -1;
                    continue;
                }
                if (prev > 0) {
                    throw new IllegalArgumentException("Years must be separated by commas or dashes.  '" + desc + "'");
                }
                prev = Integer.parseInt(token, 10);
            }
            if (start > 0) {
                throw new IllegalArgumentException("Copyright year spec ends with '-'.  '" + desc + "'");
            }
            if (prev < 0) {
                throw new IllegalArgumentException("Copyright year spec ends with ','.  '" + desc + "'");
            }
            this.addYear(prev);
        }

        public void addYears(int[] when) {
            for (int i = 0; i < when.length; ++i) {
                this.addYear(when[i]);
            }
        }

        public void addYear(int when) {
            for (int i = 0; i < this.years.length; ++i) {
                if (when == this.years[i]) {
                    return;
                }
                if (when >= this.years[i]) continue;
                int[] newYears = new int[this.years.length + 1];
                System.arraycopy(this.years, 0, newYears, 0, i);
                newYears[i] = when;
                System.arraycopy(this.years, i, newYears, i + 1, this.years.length - i);
                this.years = newYears;
                return;
            }
            int[] newYears = new int[this.years.length + 1];
            System.arraycopy(this.years, 0, newYears, 0, this.years.length);
            newYears[this.years.length] = when;
            this.years = newYears;
        }

        public boolean isCompatibleWith(Copyright other) {
            if (!this.holder.equals(other.holder)) {
                return false;
            }
            if (this.terms != null && other.terms != null ? !this.terms.equals(other.terms) : this.terms == null && other.terms != null) {
                return false;
            }
            return this.work == null || other.work == null || this.work.equals(other.work);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int first = -1;
            int last = -1;
            for (int i = 0; i < this.years.length; ++i) {
                if (last < 0) {
                    buf.append(this.years[i]);
                    first = last = this.years[i];
                    continue;
                }
                if (last + 1 == this.years[i]) {
                    last = this.years[i];
                    continue;
                }
                if (last > first) {
                    buf.append('-');
                    buf.append(last);
                }
                buf.append(',');
                buf.append(this.years[i]);
                first = last = this.years[i];
            }
            if (last > first) {
                buf.append('-');
                buf.append(last);
            }
            String dates = buf.toString();
            buf.setLength(0);
            if (this.work != null) {
                buf.append(VersionManager.this.i18n.getString(StringsProperties.VERSIONMANAGER_PARTCOPYRIGHT, this.work, dates, this.holder));
            } else {
                buf.append(VersionManager.this.i18n.getString(StringsProperties.VERSIONMANAGER_COPYRIGHT, dates, this.holder));
            }
            if (this.terms != null) {
                buf.append(", ");
                buf.append(this.terms);
                buf.append(".");
            }
            return buf.toString();
        }
    }

    class Library {
        String name;
        String version;
        String copyright;
        String URL;

        public Library(String nm, String ver, String rights, String url) {
            this.name = nm;
            this.version = ver;
            this.copyright = rights;
            this.URL = url;
        }

        public String toString() {
            return this.toString(0);
        }

        public String toString(int pad) {
            StringBuffer buf = new StringBuffer(this.name);
            int ws = pad - this.name.length() + 1;
            if (ws < 0) {
                ws = 1;
            }
            while (ws > 0) {
                if (ws > VersionManager.WHITESPACE.length()) {
                    buf.append(VersionManager.WHITESPACE);
                    ws -= VersionManager.WHITESPACE.length();
                    continue;
                }
                buf.append(VersionManager.WHITESPACE.substring(0, ws));
                ws = 0;
            }
            buf.append(this.version);
            return buf.toString();
        }
    }

    class Version {
        public String name = null;
        public int[] version = null;

        public Version(String nm, int[] ver) {
            this.name = nm;
            this.version = ver;
        }

        public Version(String nm, String ver) {
            this.name = nm;
            this.version = VersionManager.parse(ver);
        }

        public String getVersionString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.version.length; ++i) {
                if (i > 0) {
                    buf.append('.');
                }
                buf.append(this.version[i]);
            }
            return buf.toString();
        }

        public String toString(int pad) {
            StringBuffer buf = new StringBuffer(this.name);
            int ws = pad - this.name.length() + 1;
            if (ws < 0) {
                ws = 1;
            }
            while (ws > 0) {
                if (ws > VersionManager.WHITESPACE.length()) {
                    buf.append(VersionManager.WHITESPACE);
                    ws -= VersionManager.WHITESPACE.length();
                    continue;
                }
                buf.append(VersionManager.WHITESPACE.substring(0, ws));
                ws = 0;
            }
            buf.append(this.getVersionString());
            return buf.toString();
        }

        public String toString() {
            return this.toString(0);
        }

        public boolean isNewerThan(String vStr) {
            int[] ver = VersionManager.parse(vStr);
            for (int i = 0; i < this.version.length; ++i) {
                if (i >= ver.length) {
                    return true;
                }
                if (this.version[i] > ver[i]) {
                    return true;
                }
                if (this.version[i] >= ver[i]) continue;
                return false;
            }
            return false;
        }
    }
}

