/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.Debug;
import com.elluminate.util.TimerQueue;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;

public class TimedExecution
implements Runnable {
    private TimerQueue timerQueue = new TimerQueue();
    private Thread timerThread = null;

    public void removeRunnable(Object UID) {
        this.timerQueue.remove(UID);
    }

    public void addRunnable(long scheduleTime, Object UID, Runnable run) {
        this.threadCheck();
        try {
            this.timerQueue.addRunnable(scheduleTime, UID, run);
        }
        catch (Exception ex) {
            LogSupport.exception(this, "addRunnable", ex, true);
        }
    }

    @Override
    public void run() {
        TimerQueue myQueue = this.timerQueue;
        while (myQueue.run()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadCheck() {
        Thread thread = this.timerThread;
        if (thread != null) {
            return;
        }
        Debug.lockEnter(this, "threadCheck", null, this);
        TimedExecution timedExecution = this;
        synchronized (timedExecution) {
            if (this.timerThread == null) {
                this.timerThread = new WorkerThread((Runnable)this, "TimedExecution");
                this.timerThread.setDaemon(true);
                this.timerThread.start();
            }
        }
        Debug.lockLeave(this, "threadCheck", null, this);
    }

    public void shutdown() {
        this.timerQueue.shutdown();
    }
}

