/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.ChainHead;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.ObjectPool;
import com.elluminate.util.PooledObject;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.UtilTuning;
import com.elluminate.util.log.LogSupport;
import java.util.Iterator;

public class SimpleObjectPool
extends ObjectPool {
    private ChainHead head = null;
    private Class type = null;
    private long interval;
    private long lastAllocateTime = 0L;
    public int collisions = 0;
    private volatile boolean active = false;
    private volatile boolean scavengeScheduled = false;
    private LightweightTimer scavenger = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            if (SimpleObjectPool.this.scavenge()) {
                SimpleObjectPool.this.scavenger.scheduleIn(SimpleObjectPool.this.interval);
            } else {
                SimpleObjectPool.this.scavengeScheduled = false;
            }
        }
    });

    public SimpleObjectPool(Class cls) {
        this(cls, UtilTuning.ObjectPoolScavengeInterval.getIntValue());
    }

    public SimpleObjectPool(Class cls, long scavenge) {
        if (!PooledObject.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Class " + cls.getName() + " does not implement PooledObject.");
        }
        this.head = ChainHead.getInstance();
        this.interval = scavenge;
        this.type = this.checkClass(cls);
    }

    public SimpleObjectPool(Class cls, long scavenge, int size) {
        this.head = ChainHead.getInstance(size);
        this.interval = scavenge;
        this.type = this.checkClass(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledObject alloc() {
        PooledObject obj = null;
        this.active = true;
        obj = (PooledObject)this.head.remove();
        if (obj == null) {
            try {
                obj = (PooledObject)this.type.newInstance();
                obj.poPool = this;
                this.lastAllocateTime = System.currentTimeMillis();
            }
            catch (Throwable t) {
                LogSupport.exception(this, "alloc", t, true, " while allocating " + this.type.getName());
                return null;
            }
        }
        if (!this.scavengeScheduled) {
            this.scavengeScheduled = true;
            this.scavenger.scheduleIn(this.interval);
        }
        PooledObject pooledObject = obj;
        synchronized (pooledObject) {
            if (!obj.poDisposed) {
                throw new RuntimeException("Allocate of undisposed object!!!");
            }
            obj.poNext = null;
            obj.poDisposed = false;
            ++obj.poGeneration;
            obj.poStale = false;
            obj.poInit();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(PooledObject obj) {
        this.active = true;
        PooledObject pooledObject = obj;
        synchronized (pooledObject) {
            if (obj.poDisposed) {
                throw new RuntimeException("Dispose of already disposed object!!!");
            }
            obj.poDisposed = true;
        }
        this.head.insert(obj);
        if (!this.scavengeScheduled) {
            this.scavengeScheduled = true;
            this.scavenger.scheduleIn(this.interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean scavenge() {
        boolean reschedule = this.active;
        int nScavenged = 0;
        if (System.currentTimeMillis() - this.interval < this.lastAllocateTime) {
            return true;
        }
        if (UtilDebug.OBJECT_POOL.show()) {
            LogSupport.message(this, "scavenge", "Scavenging " + this.type.getName() + " in pool " + this + "...");
        }
        ChainHead chainHead = this.head;
        synchronized (chainHead) {
            Iterator i = this.head.beginScavenge();
            while (i.hasNext()) {
                PooledObject po = (PooledObject)i.next();
                if (po.poStale) {
                    i.remove();
                    ++nScavenged;
                    while (i.hasNext()) {
                        i.next();
                        i.remove();
                        ++nScavenged;
                    }
                    continue;
                }
                po.poStale = true;
                reschedule = true;
            }
            this.head.endScavenge();
        }
        this.active = false;
        if (UtilDebug.OBJECT_POOL.show()) {
            LogSupport.message(this, "scavenge", "Scavenge complete - " + nScavenged + " items removed, " + (reschedule ? "rescheduling" : "idle"));
        }
        return reschedule;
    }
}

