/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.UtilDebug;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ProcessUtils {
    public static final long NO_TIMEOUT = -1L;
    public static final int STATUS_TIMEOUT = Integer.MIN_VALUE;
    public static final int STATUS_INTERRUPTED = -2147483647;

    public static int exec(String[] cmd, StringBuffer out, StringBuffer err, long timeout, boolean kill) throws IOException {
        Process p = Runtime.getRuntime().exec(cmd);
        return ProcessUtils.getProcessOutput(p, out, err, timeout, kill);
    }

    public static int exec(String[] cmd) throws IOException {
        return ProcessUtils.exec(cmd, null, null, -1L, false);
    }

    public static int getProcessOutput(Process proc, StringBuffer out, StringBuffer err, long timeout, boolean kill) {
        ProcessTracker t = new ProcessTracker(proc, out, err);
        t.start();
        return t.waitFor(timeout, kill, true);
    }

    public static int getProcessOutput(Process proc, StringBuffer out, StringBuffer err, long timeout) {
        return ProcessUtils.getProcessOutput(proc, out, err, timeout, true);
    }

    public static int waitFor(Process proc, long timeout, boolean kill) {
        ProcessTracker t = new ProcessTracker(proc, (OutputHandler)null, null);
        t.start();
        return t.waitFor(timeout, kill, false);
    }

    public static void trackProcessOutput(Process proc, OutputHandler outHandler, OutputHandler errHandler) {
        new ProcessTracker(proc, outHandler, errHandler).start();
    }

    public static int trackProcessOutput(Process proc, OutputHandler outHandler, OutputHandler errHandler, long timeout, boolean kill) {
        ProcessTracker t = new ProcessTracker(proc, outHandler, errHandler);
        t.start();
        return t.waitFor(timeout, kill, true);
    }

    public static void ignoreProcessOutput(Process proc) {
        if (UtilDebug.PROCESS_OUTPUT.show()) {
            ProcessUtils.debugProcessOutput(proc);
        } else {
            ProcessUtils.trackProcessOutput(proc, null, null);
        }
    }

    public static void debugProcessOutput(Process proc) {
        OutputHandler debugOutput = new OutputHandler(){

            @Override
            public void start() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void outputReceived(byte[] data, int pos, int nBytes) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    LogSupport.message(new String(data, pos, nBytes));
                }
            }

            @Override
            public void stop() {
            }
        };
        ProcessUtils.trackProcessOutput(proc, debugOutput, debugOutput);
    }

    public static boolean isProcessRunning(Process proc) {
        boolean result;
        try {
            int status = proc.exitValue();
            result = false;
        }
        catch (IllegalThreadStateException ex) {
            result = true;
        }
        return result;
    }

    public static interface OutputHandler {
        public void start();

        public void outputReceived(byte[] var1, int var2, int var3);

        public void stop();
    }

    public static class ProcessTracker {
        private StreamDrainer outDrainer;
        private StreamDrainer errDrainer;
        private Process proc;
        private volatile boolean timedOut = false;

        public ProcessTracker(Process proc, OutputHandler outHandler, OutputHandler errHandler) {
            this.proc = proc;
            this.init(outHandler, errHandler);
        }

        public ProcessTracker(Process proc, StringBuffer out, StringBuffer err) {
            this.proc = proc;
            StringOutputHandler outHandler = null;
            StringOutputHandler errHandler = null;
            if (out != null) {
                outHandler = new StringOutputHandler(out);
            }
            if (err != null) {
                errHandler = new StringOutputHandler(err);
            }
            this.init(outHandler, errHandler);
        }

        private void init(OutputHandler outHandler, OutputHandler errHandler) {
            this.outDrainer = new StreamDrainer(this.proc.getInputStream(), outHandler);
            this.errDrainer = new StreamDrainer(this.proc.getErrorStream(), errHandler);
        }

        public void start() {
            this.outDrainer.start();
            this.errDrainer.start();
        }

        public synchronized void kill() {
            if (ProcessUtils.isProcessRunning(this.proc)) {
                this.proc.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitFor(long timeout, boolean kill, boolean waitForOutput) {
            Object instigator;
            int status = Integer.MAX_VALUE;
            WorkerThread timer = null;
            if (timeout > 0L) {
                instigator = Thread.currentThread();
                timer = new WorkerThread("Process Utils Watchdog Thread", (Thread)instigator, timeout, kill){
                    final /* synthetic */ Thread val$instigator;
                    final /* synthetic */ long val$timeout;
                    final /* synthetic */ boolean val$kill;
                    {
                        this.val$instigator = thread;
                        this.val$timeout = l;
                        this.val$kill = bl;
                        super(x0);
                    }

                    @Override
                    public void run() {
                        ProcessTracker.this.watchdog(this.val$instigator, this.val$timeout, this.val$kill);
                    }
                };
                timer.setDaemon(true);
                timer.start();
            }
            try {
                status = this.proc.waitFor();
                instigator = this;
                synchronized (instigator) {
                    if (timer != null && !Thread.interrupted() && timer.isAlive()) {
                        timer.interrupt();
                    }
                }
                if (waitForOutput) {
                    long waitEndTime = System.currentTimeMillis() + 2000L;
                    this.outDrainer.join(waitEndTime - System.currentTimeMillis());
                    this.errDrainer.join(Math.max(1L, waitEndTime - System.currentTimeMillis()));
                    if (this.outDrainer.isAlive()) {
                        this.outDrainer.interrupt();
                    }
                    if (this.errDrainer.isAlive()) {
                        this.errDrainer.interrupt();
                    }
                }
            }
            catch (InterruptedException iex) {
                status = -2147483647;
            }
            if (this.timedOut) {
                return Integer.MIN_VALUE;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void watchdog(Thread instigator, long timeout, boolean kill) {
            try {
                Thread.sleep(timeout);
                ProcessTracker processTracker = this;
                synchronized (processTracker) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    this.timedOut = true;
                    if (instigator.isAlive()) {
                        instigator.interrupt();
                    }
                    if (kill) {
                        this.kill();
                    }
                }
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
        }
    }

    public static class StreamDrainer
    extends WorkerThread {
        InputStream istrm = null;
        OutputHandler handler = null;

        public StreamDrainer(InputStream is, OutputHandler h) {
            super("Process Output Stream Drainer", 6);
            this.setDaemon(true);
            this.istrm = is;
            this.handler = h;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.istrm == null) {
                return;
            }
            byte[] buf = new byte[1024];
            try {
                if (this.handler != null) {
                    this.handler.start();
                }
                do {
                    int nRead;
                    if ((nRead = this.istrm.read(buf)) < 0) {
                        break;
                    }
                    if (this.handler == null || nRead <= 0) continue;
                    this.handler.outputReceived(buf, 0, nRead);
                } while (!Thread.currentThread().isInterrupted());
            }
            catch (EOFException eofx) {
            }
            catch (IOException io) {
            }
            catch (Throwable t) {
                LogSupport.exception(this, "run", t, true);
            }
            finally {
                try {
                    this.istrm.close();
                }
                catch (IOException iox) {}
                if (this.handler != null) {
                    this.handler.stop();
                }
            }
        }
    }

    public static class StringOutputHandler
    implements OutputHandler {
        private StringBuffer result = null;

        public StringOutputHandler(StringBuffer buf) {
            this.result = buf;
        }

        @Override
        public void start() {
        }

        @Override
        public void outputReceived(byte[] data, int pos, int nBytes) {
            if (this.result != null && nBytes > 0) {
                this.result.append(new String(data, pos, nBytes));
            }
        }

        @Override
        public void stop() {
        }

        public String toString() {
            return this.result == null ? "" : this.result.toString();
        }
    }
}

