/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.CPropertyChangeSupport;
import com.elluminate.util.TuningParamReader;
import com.elluminate.util.UnknownTuningParamException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Preferences {
    private File file;
    private List<File> alternateFiles = new ArrayList<File>();
    private String comments;
    private Properties settings = new Properties();
    private CPropertyChangeSupport propertySupport = new CPropertyChangeSupport(this);

    public Preferences() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences(Preferences preferences) {
        Preferences preferences2 = preferences;
        synchronized (preferences2) {
            Enumeration<Object> enm = preferences.settings.keys();
            while (enm.hasMoreElements()) {
                Object key = enm.nextElement();
                this.settings.put(key, preferences.settings.get(key));
            }
        }
    }

    public Properties getStore() {
        return this.settings;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void addAlternateFile(File alternateFile) {
        this.alternateFiles.add(alternateFile);
    }

    public void removeAlternateFile(File alternateFile) {
        this.alternateFiles.remove(alternateFile);
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getComments() {
        return this.comments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        File f = this.file;
        List<File> list = this.alternateFiles;
        synchronized (list) {
            int index = 0;
            while (!(f != null && f.exists() || index >= this.alternateFiles.size())) {
                f = this.alternateFiles.get(++index);
            }
        }
        if (f == null || !f.exists()) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            this.settings.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.file == null) {
            return;
        }
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            try {
                this.settings.store(out, this.comments);
            }
            catch (IOException iox) {
                // empty catch block
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void updateTuningParameters() throws IllegalArgumentException, UnknownTuningParamException {
        TuningParamReader.read(this.settings, "tuning");
    }

    public void clearSetting(String name) {
        this.setSetting(name, (String)null);
    }

    public void clearSettings(String nameStart) {
        Enumeration<Object> enm = this.settings.keys();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!key.startsWith(nameStart)) continue;
            this.clearSetting(key);
        }
    }

    public boolean hasSetting(String name) {
        return this.settings.containsKey(name);
    }

    public String getSetting(String name) {
        return this.getSetting(name, null);
    }

    public String getSetting(String name, String dfault) {
        return this.settings.getProperty(name, dfault);
    }

    public void setSetting(String name, String value) {
        String oldValue = this.settings.getProperty(name);
        if (oldValue == null && oldValue == value || oldValue != null && oldValue.equals(value)) {
            return;
        }
        if (value == null) {
            this.settings.remove(name);
        } else {
            this.settings.setProperty(name, value);
        }
        this.propertySupport.firePropertyChange(name, oldValue, value);
    }

    public boolean getBooleanSetting(String name, boolean dfault) {
        return Preferences.booleanValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, boolean value) {
        this.setSetting(name, value ? "true" : "false");
    }

    public double getDoubleSetting(String name, double dfault) {
        return Preferences.doubleValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, double value) {
        this.setSetting(name, String.valueOf(value));
    }

    public int getIntegerSetting(String name, int dfault) {
        return Preferences.integerValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, int value) {
        this.setSetting(name, String.valueOf(value));
    }

    public Point getPointSetting(String name, Point dfault) {
        return Preferences.pointValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, Point point) {
        String val = null;
        if (point != null) {
            StringBuffer b = new StringBuffer();
            b.append(point.x);
            b.append(",");
            b.append(point.y);
            val = b.toString();
        }
        this.setSetting(name, val);
    }

    public Dimension getDimensionSetting(String name, Dimension dfault) {
        return Preferences.dimensionValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, Dimension dimension) {
        String val = null;
        if (dimension != null) {
            StringBuffer b = new StringBuffer();
            b.append(dimension.width);
            b.append("x");
            b.append(dimension.height);
            val = b.toString();
        }
        this.setSetting(name, val);
    }

    public Rectangle getRectangleSetting(String name, Rectangle dfault) {
        return Preferences.rectangleValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, Rectangle bounds) {
        String val = null;
        if (bounds != null) {
            StringBuffer b = new StringBuffer();
            b.append(bounds.x);
            b.append(",");
            b.append(bounds.y);
            b.append(",");
            b.append(bounds.width);
            b.append(",");
            b.append(bounds.height);
            val = b.toString();
        }
        this.setSetting(name, val);
    }

    public Color getColorSetting(String name, Color dfault) {
        return Preferences.colorValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, Color color) {
        String val = null;
        if (color != null) {
            StringBuffer b = new StringBuffer();
            b.append(color.getRed());
            b.append(",");
            b.append(color.getGreen());
            b.append(",");
            b.append(color.getBlue());
            val = b.toString();
        }
        this.setSetting(name, val);
    }

    public File getFileSetting(String name, File dfault) {
        return Preferences.fileValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, File file) {
        String val = null;
        if (file != null) {
            val = file.getAbsolutePath();
        }
        this.setSetting(name, val);
    }

    public File[] getFileListSetting(String name, File[] dfault) {
        return Preferences.fileListValue(this.getSetting(name), dfault);
    }

    public void setSetting(String name, File[] files) {
        String val = null;
        if (files != null) {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < files.length; ++i) {
                if (b.length() != 0) {
                    b.append(File.pathSeparator);
                }
                b.append(files[i].getAbsolutePath());
            }
            val = b.toString();
        }
        this.setSetting(name, val);
    }

    public Map<String, String> getSettings(String nameStart) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<Object> enm = this.settings.keys();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!key.startsWith(nameStart)) continue;
            String value = (String)this.settings.get(key);
            map.put(key, value);
        }
        return map;
    }

    public void setSettings(Preferences preferences) {
        this.setSettings(preferences.getSettings(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(Map<String, String> map) {
        Map<String, String> map2 = map;
        synchronized (map2) {
            Enumeration<Object> enm = this.settings.keys();
            while (enm.hasMoreElements()) {
                String key = (String)enm.nextElement();
                String oldValue = (String)this.settings.get(key);
                String newValue = null;
                if (map.containsKey(key)) {
                    newValue = map.get(key);
                }
                if (newValue == null) {
                    this.clearSetting(key);
                    continue;
                }
                if (newValue.equals(oldValue)) continue;
                this.setSetting(key, newValue);
            }
            for (String key : map.keySet()) {
                if (this.settings.containsKey(key)) continue;
                this.setSetting(key, map.get(key));
            }
        }
    }

    public void addSettingChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void addSettingChangeListener(String setting, PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(setting, l);
    }

    public void removeSettingChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public void removeSettingChangeListener(String setting, PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(setting, l);
    }

    public static String stringValue(Object value, String dfault) {
        if (value == null) {
            return dfault;
        }
        return String.valueOf(value);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        return this.toString(this, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Preferences preferences, String prefix) {
        Properties settings;
        StringBuffer buf = new StringBuffer();
        LinkedList<String> list = new LinkedList<String>();
        Properties properties = settings = preferences.getStore();
        synchronized (properties) {
            for (String string : settings.keySet()) {
                if (!string.startsWith(prefix)) continue;
                list.add(string + ": " + settings.getProperty(string) + '\n');
            }
        }
        Collections.sort(list);
        Iterator strIter = list.iterator();
        while (strIter.hasNext()) {
            buf.append((String)strIter.next());
        }
        return buf.toString();
    }

    public static boolean booleanValue(Object value, boolean dfault) {
        if (value == null) {
            return dfault;
        }
        String val = String.valueOf(value);
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes")) {
            return true;
        }
        if (val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no")) {
            return false;
        }
        return dfault;
    }

    public static double doubleValue(Object value, double dfault) {
        if (value == null) {
            return dfault;
        }
        String val = String.valueOf(value);
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException ex) {
            return dfault;
        }
    }

    public static int integerValue(Object value, int dfault) {
        if (value == null) {
            return dfault;
        }
        String val = String.valueOf(value);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException ex) {
            return dfault;
        }
    }

    public static Point pointValue(Object value, Point dfault) {
        if (value == null) {
            return dfault;
        }
        String val = String.valueOf(value);
        StringTokenizer st = new StringTokenizer(val, ",");
        if (st.countTokens() != 2) {
            return dfault;
        }
        try {
            int x = Integer.parseInt(st.nextToken());
            int y = Integer.parseInt(st.nextToken());
            return new Point(x, y);
        }
        catch (Exception ex) {
            return dfault;
        }
    }

    public static Dimension dimensionValue(Object value, Dimension dfault) {
        if (value == null) {
            return dfault;
        }
        String val = String.valueOf(value);
        StringTokenizer st = new StringTokenizer(val, "x");
        if (st.countTokens() != 2) {
            return dfault;
        }
        try {
            int w = Integer.parseInt(st.nextToken());
            int h = Integer.parseInt(st.nextToken());
            return new Dimension(w, h);
        }
        catch (Exception ex) {
            return dfault;
        }
    }

    public static Rectangle rectangleValue(Object value, Rectangle dfault) {
        if (value == null) {
            return dfault;
        }
        String val = String.valueOf(value);
        StringTokenizer st = new StringTokenizer(val, ",");
        if (st.countTokens() != 4) {
            return dfault;
        }
        try {
            int x = Integer.parseInt(st.nextToken());
            int y = Integer.parseInt(st.nextToken());
            int w = Integer.parseInt(st.nextToken());
            int h = Integer.parseInt(st.nextToken());
            return new Rectangle(x, y, w, h);
        }
        catch (Exception ex) {
            return dfault;
        }
    }

    public static Color colorValue(Object value, Color dfault) {
        if (value == null) {
            return dfault;
        }
        String val = String.valueOf(value);
        StringTokenizer st = new StringTokenizer(val, ",");
        if (st.countTokens() != 3) {
            return dfault;
        }
        try {
            int r = Integer.parseInt(st.nextToken());
            int g = Integer.parseInt(st.nextToken());
            int b = Integer.parseInt(st.nextToken());
            return new Color(r, g, b);
        }
        catch (Exception ex) {
            return dfault;
        }
    }

    public static File fileValue(Object value, File dfault) {
        if (value == null) {
            return dfault;
        }
        return new File(String.valueOf(value));
    }

    public static File[] fileListValue(Object value, File[] dfault) {
        if (value == null) {
            return dfault;
        }
        ArrayList<File> list = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(String.valueOf(value), File.pathSeparator);
        while (st.hasMoreTokens()) {
            list.add(new File(st.nextToken()));
        }
        return list.toArray(new File[0]);
    }
}

