/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.Chained;
import com.elluminate.util.UnlockedChainHead;
import com.elluminate.util.UtilTuning;
import java.util.Iterator;

public abstract class ChainHead {
    protected static final Chained SCAVENGE_MARKER = new Chained();

    public abstract Iterator beginScavenge();

    public abstract void endScavenge();

    public abstract void insert(Chained var1);

    public abstract Chained remove();

    protected ChainedIterator getIter() {
        return new ChainedIterator();
    }

    protected Chained iterHead(ChainedIterator iter) {
        return iter.getHead();
    }

    protected void resetIter(ChainedIterator iter, Chained list) {
        iter.reset(list);
    }

    protected void setNext(Chained c, Chained n) {
        c.poNext = n;
    }

    protected Chained getNext(Chained c) {
        return c.poNext;
    }

    public static ChainHead getInstance(int sz) {
        return UnlockedChainHead.getInstance(sz);
    }

    public static ChainHead getInstance() {
        if (UtilTuning.ObjectPoolMode.getIntValue() == 1) {
            return ChainHead.getInstance(-1);
        }
        return ChainHead.getInstance(UtilTuning.ObjectPoolSize.getIntValue());
    }

    protected class ChainedIterator
    implements Iterator {
        private Chained head = null;
        private Chained prev = null;
        private Chained curr = null;
        private Chained next = null;

        ChainedIterator() {
        }

        void reset(Chained list) {
            this.head = list;
            this.prev = null;
            this.curr = null;
            this.next = list;
        }

        Chained getHead() {
            return this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            this.prev = this.curr;
            this.curr = this.next;
            this.next = this.curr != null ? this.curr.poNext : null;
            return this.curr;
        }

        @Override
        public void remove() {
            if (this.prev == null) {
                this.head = this.curr.poNext;
            } else {
                this.prev.poNext = this.curr.poNext;
            }
            this.curr = this.prev;
            this.next = this.curr != null ? this.prev.poNext : this.head;
        }
    }
}

