/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform.windows;

import com.elluminate.util.Base64;
import com.elluminate.util.EncodingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class WinNetNtlmAuth {
    private static final String LIB_NAME = "WinPlatform";
    private static boolean initialized = false;
    private static String charset;
    private long credentials = 0L;
    private long context = 0L;

    public void setCredentials(String username, String password, String ntdomain) throws IOException {
        if (!initialized) {
            throw new IOException("Native NTLM support is not available.");
        }
        this.nativeGetCredentials(WinNetNtlmAuth.getCString(username), WinNetNtlmAuth.getCString(password), WinNetNtlmAuth.getCString(ntdomain));
        if (this.credentials == 0L) {
            throw new IOException("Could not get credentials handle");
        }
    }

    public String getType1() throws IOException {
        if (this.credentials == 0L) {
            throw new IllegalStateException("getType1 called without setCredentials.");
        }
        if (this.context != 0L) {
            throw new IllegalStateException("getType1 called more than once from a single context.");
        }
        String type1 = null;
        try {
            type1 = Base64.encode(this.nativeGetType1());
        }
        catch (Throwable t) {
            this.credentials = 0L;
            this.context = 0L;
        }
        return type1;
    }

    public String getType3(String type2) throws IOException {
        if (this.credentials == 0L) {
            throw new IllegalStateException("getType3 called without setCredentials.");
        }
        if (this.context == 0L) {
            throw new IllegalStateException("getType3 called without getType1.");
        }
        String type3 = null;
        try {
            byte[] t2 = Base64.decode(type2);
            type3 = Base64.encode(this.nativeGetType3(t2));
        }
        catch (EncodingException ex) {
            throw new IOException("Invalid type2 response received from server.");
        }
        finally {
            this.credentials = 0L;
            this.context = 0L;
        }
        return type3;
    }

    private static native void nativeInitialize();

    private native void nativeGetCredentials(byte[] var1, byte[] var2, byte[] var3);

    private native byte[] nativeGetType1();

    private native byte[] nativeGetType3(byte[] var1);

    private static byte[] getCString(String str) {
        if (str == null) {
            return null;
        }
        try {
            byte[] bytes = str.getBytes(charset);
            byte[] cstring = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, cstring, 0, bytes.length);
            cstring[bytes.length] = 0;
            return cstring;
        }
        catch (UnsupportedEncodingException uex) {
            return null;
        }
    }

    static {
        System.loadLibrary(LIB_NAME);
        WinNetNtlmAuth.nativeInitialize();
        charset = System.getProperty("sun.jnu.encoding");
        if (charset == null) {
            charset = System.getProperty("file.encoding");
        }
        initialized = true;
    }
}

