/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform.macos;

import com.elluminate.platform.AppLookupAPI;
import com.elluminate.platform.MacOSXPlatform;
import com.elluminate.util.log.LogSupport;
import java.io.File;

public class LaunchServicesJNI
implements AppLookupAPI {
    public static final int kLSApplicationNotFoundErr = -10814;
    private static MacOSXPlatform.CarbonLock carbonLock = null;

    private static native int getVersionNative();

    private static native int appForMimeNative(String var0, StringBuffer var1);

    private static native int appForExtensionNative(String var0, StringBuffer var1);

    private static native int appForCreatorNative(int var0, StringBuffer var1);

    private static native int appForBundleNative(String var0, StringBuffer var1);

    private static native int getBundleIDNative(String var0, StringBuffer var1);

    private static native String getNativePathNative(String var0, boolean var1);

    @Override
    public File findAppByMIME(final String mime) {
        int err;
        final StringBuffer path = new StringBuffer(4096);
        if (mime == null || mime.length() < 1) {
            throw new IllegalArgumentException("Invalid MIME type: " + mime);
        }
        if (carbonLock == null) {
            carbonLock = MacOSXPlatform.getCarbonLock();
        }
        if ((err = carbonLock.runCarbonInt(new MacOSXPlatform.RunnableResult(){
            int result = -1;

            @Override
            public void run() {
                this.result = LaunchServicesJNI.appForMimeNative(mime, path);
            }

            @Override
            public int intResult() {
                return this.result;
            }
        })) != 0) {
            throw new RuntimeException("Mac OS Error finding app for MIME type " + mime + ": " + err);
        }
        if (path.length() < 1) {
            return null;
        }
        return new File(path.toString());
    }

    @Override
    public File findAppByExtension(final String ext) {
        int err;
        final StringBuffer path = new StringBuffer(4096);
        if (ext == null || ext.length() < 1) {
            throw new IllegalArgumentException("Invalid extension binding: " + ext);
        }
        if (carbonLock == null) {
            carbonLock = MacOSXPlatform.getCarbonLock();
        }
        if ((err = carbonLock.runCarbonInt(new MacOSXPlatform.RunnableResult(){
            int result = -1;

            @Override
            public void run() {
                this.result = LaunchServicesJNI.appForExtensionNative(ext, path);
            }

            @Override
            public int intResult() {
                return this.result;
            }
        })) == -10814) {
            return null;
        }
        if (err != 0) {
            throw new RuntimeException("Mac OS Error finding app for extension " + ext + ": " + err);
        }
        if (path.length() < 1) {
            return null;
        }
        return new File(path.toString());
    }

    public File findAppByCreator(final int creatorCode) {
        int err;
        final StringBuffer path = new StringBuffer(4096);
        if (carbonLock == null) {
            carbonLock = MacOSXPlatform.getCarbonLock();
        }
        if ((err = carbonLock.runCarbonInt(new MacOSXPlatform.RunnableResult(){
            int result = -1;

            @Override
            public void run() {
                this.result = LaunchServicesJNI.appForCreatorNative(creatorCode, path);
            }

            @Override
            public int intResult() {
                return this.result;
            }
        })) == -10814) {
            return null;
        }
        if (err != 0) {
            throw new RuntimeException("Mac OS Error finding app for Creator code 0x" + Integer.toHexString(creatorCode) + ": " + err);
        }
        if (path.length() < 1) {
            return null;
        }
        return new File(path.toString());
    }

    public File findAppByBundle(String bundleID) {
        StringBuffer path = new StringBuffer(4096);
        int err = LaunchServicesJNI.appForBundleNative(bundleID, path);
        return new File(path.toString());
    }

    public String getBundleID(final File path) {
        int err;
        final StringBuffer bundleID = new StringBuffer(256);
        if (carbonLock == null) {
            carbonLock = MacOSXPlatform.getCarbonLock();
        }
        if ((err = carbonLock.runCarbonInt(new MacOSXPlatform.RunnableResult(){
            int result = -1;

            @Override
            public void run() {
                this.result = LaunchServicesJNI.getBundleIDNative(path.getAbsolutePath(), bundleID);
            }

            @Override
            public int intResult() {
                return this.result;
            }
        })) != 0) {
            throw new RuntimeException("Mac OS Error getting Bundle ID for " + path + ": " + err);
        }
        if (bundleID.length() < 1) {
            return null;
        }
        return bundleID.toString();
    }

    public String getNativePath(final File posixPath) {
        String result;
        if (carbonLock == null) {
            carbonLock = MacOSXPlatform.getCarbonLock();
        }
        if ((result = carbonLock.runCarbonStr(new MacOSXPlatform.RunnableResult(){
            String result = null;

            @Override
            public void run() {
                boolean isDir = posixPath.isDirectory();
                String path = posixPath.getPath();
                this.result = LaunchServicesJNI.getNativePathNative(path, isDir);
                if (isDir && !this.result.endsWith(":")) {
                    this.result = this.result + ":";
                }
            }

            @Override
            public String strResult() {
                return this.result;
            }
        })) == null) {
            throw new RuntimeException("Failed to get native path for: " + posixPath);
        }
        return result;
    }

    public static void main(String[] args) {
        LaunchServicesJNI ls = new LaunchServicesJNI();
        for (int ix = 0; ix < args.length; ++ix) {
            String bndlID;
            if (args[ix].equals("-ext") || args[ix].equals("-extension")) {
                ++ix;
                try {
                    File app = ls.findAppByExtension(args[ix]);
                    String bndlID2 = null;
                    if (app != null) {
                        try {
                            bndlID2 = ls.getBundleID(app);
                        }
                        catch (Throwable t) {
                            System.err.println("Error getting bundle " + app + ":");
                            t.printStackTrace();
                        }
                    }
                    System.err.println("'" + args[ix] + "' mapped to " + app + " " + (app == null ? "" : (app.isFile() ? "F" : (app.isDirectory() ? "D" : (app.exists() ? "X" : "")))) + " ID=" + bndlID2);
                }
                catch (Exception ex) {
                    System.err.println("Error processing extension " + args[ix]);
                    ex.printStackTrace();
                }
                continue;
            }
            if (args[ix].equals("-crt") || args[ix].equals("-creator")) {
                ++ix;
                try {
                    int creatorType = MacOSXPlatform.convertFileType(args[ix]);
                    File app = ls.findAppByCreator(creatorType);
                    bndlID = null;
                    if (app != null) {
                        try {
                            bndlID = ls.getBundleID(app);
                        }
                        catch (Throwable t) {
                            System.err.println("Error getting bundle " + app + ":");
                            t.printStackTrace();
                        }
                    }
                    System.err.println("'" + args[ix] + "' 0x" + Integer.toHexString(creatorType) + " mapped to " + app + " " + (app == null ? "" : (app.isFile() ? "F" : (app.isDirectory() ? "D" : (app.exists() ? "X" : "")))) + " ID=" + bndlID);
                }
                catch (Exception ex) {
                    System.err.println("Error processing creator '" + args[ix] + "'");
                    ex.printStackTrace();
                }
                continue;
            }
            if (args[ix].equals("-bndl") || args[ix].equals("-bundle")) {
                ++ix;
                try {
                    File app = ls.findAppByBundle(args[ix]);
                    System.err.println(args[ix] + " mapped to " + app);
                }
                catch (Exception ex) {
                    System.err.println("Error processing bundle ID: " + args[ix]);
                    ex.printStackTrace();
                }
                continue;
            }
            if (!args[ix].equals("-f") && !args[ix].equals("-path")) continue;
            File f = new File(args[++ix]);
            try {
                String hfs = ls.getNativePath(f);
                bndlID = null;
                try {
                    bndlID = ls.getBundleID(f);
                }
                catch (Throwable t) {
                    System.err.println("Error processing path for bundle: " + f);
                    t.printStackTrace();
                    bndlID = null;
                }
                System.err.println(f + " " + hfs + " " + (f.isFile() ? "F" : (f.isDirectory() ? "D" : (f.exists() ? "O" : "-"))) + " ID=" + bndlID);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Error processing path " + args[ix]);
                ex.printStackTrace();
            }
        }
        System.exit(0);
    }

    static {
        System.loadLibrary("LaunchServices");
        int version = LaunchServicesJNI.getVersionNative();
        StringBuffer versionStr = new StringBuffer();
        versionStr.append(version >> 16 & 0xFFFF);
        versionStr.append('.');
        versionStr.append(version >> 8 & 0xFF);
        versionStr.append('.');
        versionStr.append(version & 0xFF);
        LogSupport.message("Loaded native library LaunchServices, version " + versionStr.toString());
    }
}

