/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform;

import com.elluminate.platform.AppLookupAPI;
import com.elluminate.platform.GenericPlatform;
import com.elluminate.platform.Platform;
import com.elluminate.platform.PlatformDebug;
import com.elluminate.platform.StringsProperties;
import com.elluminate.util.Debug;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class WindowsPlatform
extends GenericPlatform {
    private static final int NANOS_PER_MILLI = 1000000;
    private static final String LOOKUP_API = "com.elluminate.platform.windows.WinAppLookup";
    private static final String SYSTEM_API = "java.lang.System";
    private static final String WINTIME_API = "com.elluminate.platform.windows.WinTime";
    private static final String PLATFORM_API = "com.elluminate.platform.windows.WinPlatform";
    private static final String CPUINFO_API = "com.elluminate.platform.windows.WinCPUInfo";
    private static final String SCREEN_READER_INFO_API = "com.elluminate.platform.windows.WinScreenReaderInfo";
    private static final String EXECUTABLE_EXTENSION = ".exe";
    private static final String ILLEGAL_FILENAME_CHARACTERS = "/\\:*?\"<>|";
    private static AppLookupAPI lookup;
    private static CPUInfoAPI cpuInfo;
    private static Class<?> milliTimeCls;
    private static Method milliTimeMth;
    private static long milliTimeOff;
    private static Class<?> nanoTimeCls;
    private static Method nanoTimeMth;
    private static long nanoTimeOff;
    private static ScreenReaderInfoAPI screenReaderInfo;
    private static boolean avoidNanoTimer;
    private int winOS = 0;

    public WindowsPlatform() {
        String name = System.getProperty("os.name");
        this.winOS = name.startsWith(this.i18n.getString(StringsProperties.WINPLATFORM_WINNTPREFIX)) ? 403 : (name.indexOf(this.i18n.getString(StringsProperties.WINPLATFORM_WIN95KEY)) != -1 ? 400 : (name.indexOf(this.i18n.getString(StringsProperties.WINPLATFORM_WIN98KEY)) != -1 ? 401 : (name.indexOf(this.i18n.getString(StringsProperties.WINPLATFORM_WINMEKEY)) != -1 ? 402 : (name.indexOf(this.i18n.getString(StringsProperties.WINPLATFORM_WIN2KKEY)) != -1 ? 404 : (name.indexOf(this.i18n.getString(StringsProperties.WINPLATFORM_WINXPKEY)) != -1 ? 405 : (name.indexOf(this.i18n.getString(StringsProperties.WINPLATFORM_WIN2003KEY)) != -1 ? 405 : (name.indexOf(this.i18n.getString(StringsProperties.WINPLATFORM_WINVISTAKEY)) != -1 ? 406 : (name.startsWith(this.i18n.getString(StringsProperties.WINPLATFORM_WIN7KEY)) ? 407 : 0))))))));
        if (this.winOS == 403 && this.version == 5) {
            this.winOS = 404;
        }
        if (this.winOS == 403 && this.version == 6) {
            this.winOS = 405;
        }
        this.evaluateTimers();
        WorkerThread t = new WorkerThread("System Info Gatherer"){

            @Override
            public void run() {
                block5: {
                    String[] cmd = new String[]{"systeminfo"};
                    try {
                        StringBuffer result = new StringBuffer(256);
                        StringBuffer error = PlatformDebug.GENERAL.show() ? new StringBuffer() : null;
                        int status = ProcessUtils.exec(cmd, result, error, -1L, false);
                        if (PlatformDebug.GENERAL.show() && status != 0) {
                            LogSupport.message(this, "run", "Error invoking " + cmd[0] + ": " + status + (error != null ? " " + error.toString() : ""));
                        }
                        if (result.length() > 0) {
                            WindowsPlatform.this.details = this.filterOutput(result.toString());
                            if (PlatformDebug.GENERAL.show()) {
                                LogSupport.message(this, "run", WindowsPlatform.this.details);
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (!PlatformDebug.GENERAL.show()) break block5;
                        LogSupport.message(this, "run", "Exception invoking " + cmd[0] + ": " + Debug.getStackTrace(t));
                    }
                }
            }

            private String filterOutput(String in) {
                String[] lines = in.split(System.getProperty("line.separator", "\r\n"));
                if (lines == null || lines.length == 0) {
                    return "";
                }
                boolean suppress = false;
                StringBuilder out = new StringBuilder(in.length());
                for (int ix = 0; ix < lines.length; ++ix) {
                    String trimmed = lines[ix].trim();
                    if (trimmed.length() < 1 || suppress && trimmed.startsWith("[")) continue;
                    suppress = false;
                    if (trimmed.startsWith("Host Name:") || trimmed.startsWith("Registered Owner:") || trimmed.startsWith("Registered Organization:") || trimmed.startsWith("Product ID:") || trimmed.startsWith("Windows Directory:") || trimmed.startsWith("System Directory:") || trimmed.startsWith("Boot Device:") || trimmed.startsWith("Page File Location") || trimmed.startsWith("Domain:") || trimmed.startsWith("Logon Server:") || trimmed.startsWith("Connection Name:") || trimmed.startsWith("DHCP Enabled:") || trimmed.startsWith("DHCP Server:")) continue;
                    if (trimmed.startsWith("IP address")) {
                        suppress = true;
                        continue;
                    }
                    out.append(trimmed + "\n");
                    if (!trimmed.startsWith("Hotfix")) continue;
                    suppress = true;
                }
                return out.toString();
            }
        };
        t.start();
    }

    private void evaluateTimers() {
        if (milliTimeCls != null && nanoTimeCls != null && this.winOS >= 400 && this.winOS <= 405) {
            try {
                long startN = ((Long)nanoTimeMth.invoke(null, new Object[0]) + nanoTimeOff) / 1000000L;
                long startM = (Long)milliTimeMth.invoke(null, new Object[0]) + milliTimeOff;
                Thread.sleep(1500L);
                long endN = ((Long)nanoTimeMth.invoke(null, new Object[0]) + nanoTimeOff) / 1000000L;
                long endM = (Long)milliTimeMth.invoke(null, new Object[0]) + milliTimeOff;
                double diffN = endN - startN;
                double diffM = endM - startM;
                if (diffN / diffM < 0.996) {
                    LogSupport.message("Nanotimer appears unreliable. Using millitimer.");
                    LogSupport.message("  diffN: " + diffN + "   diffM: " + (endM - startM));
                    avoidNanoTimer = true;
                } else {
                    LogSupport.message("Using nanotimer. It scored " + diffN / diffM);
                }
            }
            catch (Exception t) {
                LogSupport.message("mxyzptlk!");
            }
        }
    }

    @Override
    public int getPlatform() {
        return 1;
    }

    @Override
    public int getOS() {
        return this.winOS;
    }

    @Override
    public int getCPUCount() {
        if (cpuInfo != null) {
            return cpuInfo.getCPUCount();
        }
        return super.getCPUCount();
    }

    @Override
    public long getCPUFrequency(int index) {
        if (cpuInfo != null) {
            return cpuInfo.getCPUFrequency(index);
        }
        return super.getCPUFrequency(index);
    }

    private String getEnvironmentVariable(String variableName) {
        try {
            String cmdProc;
            if (Platform.checkJavaVersion("1.5+")) {
                return System.getenv(variableName);
            }
            switch (this.getOS()) {
                case 400: 
                case 401: 
                case 402: {
                    cmdProc = "command.com";
                    break;
                }
                default: {
                    cmdProc = "cmd.exe";
                }
            }
            Process proc = Runtime.getRuntime().exec(new String[]{cmdProc, "/c", "echo", "%" + variableName + "%"});
            StringBuffer b = new StringBuffer();
            int result = ProcessUtils.getProcessOutput(proc, b, null, -1L);
            if (result == 0) {
                return b.toString().trim();
            }
        }
        catch (Throwable t) {
            LogSupport.message(this, "getEnvironmentVariable", Debug.getStackTrace(t));
        }
        return null;
    }

    @Override
    public File getPreferencesDir() {
        File dir;
        File dir2;
        String path = this.getEnvironmentVariable("APPDATA");
        if (path != null && path.length() > 0 && (dir2 = new File(path)).exists() && dir2.isDirectory()) {
            return dir2;
        }
        String userhome = System.getProperty("user.home");
        if (userhome != null && (dir = new File(userhome, "Application Data")).exists()) {
            return dir;
        }
        if (userhome != null) {
            return new File(userhome);
        }
        return null;
    }

    public File nativeLibDir() {
        return null;
    }

    @Override
    public File getLogRelPathRoot() {
        return new File(new File("").getAbsolutePath());
    }

    @Override
    public String filterFilename(String filename) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (ILLEGAL_FILENAME_CHARACTERS.indexOf(ch) != -1) continue;
            b.append(ch);
        }
        return b.toString();
    }

    @Override
    public File findAppByMIME(String mimeType) {
        return this.findAppByExtension(this.getExtensionFromMimeInternal(mimeType));
    }

    @Override
    public File findAppByExtension(String extension) {
        if (lookup != null) {
            return lookup.findAppByExtension(extension);
        }
        return null;
    }

    @Override
    public File findAppByReference(String appRef) {
        File app = new File(appRef);
        if (app.exists() && app.isFile()) {
            return app;
        }
        if (!appRef.endsWith(EXECUTABLE_EXTENSION) && (app = new File(appRef + EXECUTABLE_EXTENSION)).exists() && app.isFile()) {
            return app;
        }
        if (appRef.indexOf(File.separator) == -1) {
            String paths;
            String path = this.getEnvironmentVariable("PROGRAMFILES");
            if (path != null) {
                File programFilesDir = new File(path);
                String appName = appRef;
                if (!appRef.endsWith(EXECUTABLE_EXTENSION)) {
                    appName = appRef + EXECUTABLE_EXTENSION;
                }
                if ((app = this.findFile(programFilesDir, appName, 2)) != null) {
                    return app;
                }
            }
            if ((paths = this.getEnvironmentVariable("PATH")) != null) {
                StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    File dir = new File(st.nextToken());
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    app = new File(dir, appRef);
                    if (app.exists() && app.isFile()) {
                        return app;
                    }
                    if (appRef.endsWith(EXECUTABLE_EXTENSION) || !(app = new File(dir, appRef + EXECUTABLE_EXTENSION)).exists() || !app.isFile()) continue;
                    return app;
                }
            }
        }
        return null;
    }

    private File findFile(File directory, String name, int recursionDepth) {
        if (directory.isDirectory()) {
            File f = new File(directory, name);
            if (f.exists() && f.isFile()) {
                return f;
            }
            if (recursionDepth != 0) {
                File[] fs = directory.listFiles();
                for (int i = 0; i < fs.length; ++i) {
                    if (!fs[i].isDirectory() || (f = this.findFile(fs[i], name, recursionDepth - 1)) == null) continue;
                    return f;
                }
            }
        }
        return null;
    }

    @Override
    public boolean launchApp(File app) {
        return this.launchApp(app, null);
    }

    @Override
    public boolean launchApp(File app, File document) {
        String cmdProc;
        switch (this.getOS()) {
            case 400: 
            case 401: 
            case 402: {
                cmdProc = "command.com";
                break;
            }
            default: {
                cmdProc = "cmd.exe";
            }
        }
        String[] cmd = new String[3];
        if (document != null) {
            cmd = new String[4];
        }
        cmd[0] = cmdProc;
        cmd[1] = "/c";
        cmd[2] = app.getAbsolutePath();
        if (document != null) {
            cmd[3] = document.getAbsolutePath();
        }
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ProcessUtils.ignoreProcessOutput(p);
            return ProcessUtils.isProcessRunning(p);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean openFile(File file) {
        String cmdProc;
        switch (this.getOS()) {
            case 400: 
            case 401: 
            case 402: {
                cmdProc = "command.com";
                break;
            }
            default: {
                cmdProc = "cmd.exe";
            }
        }
        String[] cmd = new String[]{cmdProc, "/c", "start", "\"\"", "\"" + file.getAbsolutePath() + "\""};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ProcessUtils.ignoreProcessOutput(p);
            return ProcessUtils.isProcessRunning(p);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public long currentTimeMillis() {
        if (nanoTimeCls != null && !avoidNanoTimer) {
            try {
                return ((Long)nanoTimeMth.invoke(null, new Object[0]) + nanoTimeOff) / 1000000L;
            }
            catch (Throwable t) {
                LogSupport.message(this, "currentTimeMillis", "nanoTime failed: " + t);
                nanoTimeCls = null;
            }
        }
        if (milliTimeCls != null) {
            try {
                return (Long)milliTimeMth.invoke(null, new Object[0]) + milliTimeOff;
            }
            catch (Throwable t) {
                LogSupport.message(this, "currentTimeMillis", "milliTime failed: " + t);
                milliTimeCls = null;
            }
        }
        return System.currentTimeMillis();
    }

    @Override
    public int usingScreenReader() {
        int result = PlatformDebug.PRETEND_USING_SCREEN_READER.isEnabled() ? 1 : (screenReaderInfo != null ? screenReaderInfo.usingScreenReader() : -1);
        if (PlatformDebug.GENERAL.show()) {
            String resultStr = result == 1 ? "TRUE" : (result == 0 ? "FALSE" : (result == -1 ? "UNKNOWN" : "#" + result));
            LogSupport.message(this, "usingScreenReader", "Returned " + resultStr);
        }
        return result;
    }

    static {
        Class<?> cls;
        block18: {
            lookup = null;
            cpuInfo = null;
            milliTimeCls = null;
            milliTimeMth = null;
            milliTimeOff = 0L;
            nanoTimeCls = null;
            nanoTimeMth = null;
            nanoTimeOff = 0L;
            screenReaderInfo = null;
            avoidNanoTimer = false;
            try {
                Class<?> platformCls = Class.forName(PLATFORM_API);
                Method getVersionMth = platformCls.getMethod("getVersion", new Class[0]);
                String version = (String)getVersionMth.invoke(null, new Object[0]);
                LogSupport.message("Loaded native library WinPlatform, version " + version);
            }
            catch (Throwable t) {
                if (!PlatformDebug.GENERAL.show()) break block18;
                LogSupport.message(WindowsPlatform.class, "<clinit>", Debug.getStackTrace(t));
            }
        }
        try {
            cls = Class.forName(LOOKUP_API);
            lookup = (AppLookupAPI)cls.newInstance();
        }
        catch (Throwable t) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message(WindowsPlatform.class, "<clinit>", Debug.getStackTrace(t));
            }
            lookup = null;
        }
        try {
            cls = Class.forName(CPUINFO_API);
            cpuInfo = (CPUInfoAPI)cls.newInstance();
        }
        catch (Throwable t) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message(WindowsPlatform.class, "<clinit>", Debug.getStackTrace(t));
            }
            cpuInfo = null;
        }
        try {
            cls = Class.forName(SCREEN_READER_INFO_API);
            screenReaderInfo = (ScreenReaderInfoAPI)cls.newInstance();
        }
        catch (Throwable t) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message(WindowsPlatform.class, "<clinit>", Debug.getStackTrace(t));
            }
            screenReaderInfo = null;
        }
        try {
            milliTimeCls = Class.forName(WINTIME_API);
            milliTimeMth = milliTimeCls.getMethod("milliTime", new Class[0]);
            milliTimeOff = System.currentTimeMillis() - (Long)milliTimeMth.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message(WindowsPlatform.class, "<clinit>", Debug.getStackTrace(t));
            }
            milliTimeCls = null;
        }
        try {
            nanoTimeCls = Class.forName(SYSTEM_API);
            nanoTimeMth = nanoTimeCls.getMethod("nanoTime", new Class[0]);
            nanoTimeOff = 1000000L * System.currentTimeMillis() - (Long)nanoTimeMth.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message(WindowsPlatform.class, "<clinit>", Debug.getStackTrace(t));
            }
            nanoTimeCls = null;
        }
        if (milliTimeCls == null && nanoTimeCls == null) {
            LogSupport.message(WindowsPlatform.class, "<clinit>", "currentTimeMillis() degraded by no milliTime() or nanoTime()");
        }
    }

    public static interface CPUInfoAPI {
        public int getCPUCount();

        public long getCPUFrequency(int var1);
    }

    public static interface ScreenReaderInfoAPI {
        public int usingScreenReader();
    }
}

