/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform;

import com.elluminate.platform.GenericPlatform;
import com.elluminate.platform.Platform;
import com.elluminate.platform.PlatformDebug;
import com.elluminate.util.Debug;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

class UnixPlatform
extends GenericPlatform {
    private static final String ILLEGAL_FILENAME_CHARACTERS = "/";

    public UnixPlatform() {
        this.platform = 3;
        WorkerThread initializer = new WorkerThread("Platform Details Harvester"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<File> infoFiles = new ArrayList<File>();
                ArrayList<String[]> commands = new ArrayList<String[]>();
                File etc = new File("/etc");
                if (etc.isDirectory()) {
                    String[] names = etc.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith("release");
                        }
                    });
                    if (names.length < 1) {
                        return;
                    }
                    for (int ix = 0; ix < names.length; ++ix) {
                        File f = new File(etc, names[ix]);
                        if (!f.isFile() || f.length() == 0L) continue;
                        infoFiles.add(f);
                    }
                }
                if (UnixPlatform.this.opSystem == 250) {
                    commands.add(new String[]{"/usr/sbin/psrinfo", "-pv"});
                    commands.add(new String[]{"/usr/sbin/prtconf"});
                }
                infoFiles.add(new File("/proc/cpuinfo"));
                infoFiles.add(new File("/proc/meminfo"));
                infoFiles.add(new File("/proc/version"));
                StringBuffer result = new StringBuffer(256);
                for (File f : infoFiles) {
                    StringBuffer fbuf = new StringBuffer(1024);
                    FileReader fr = null;
                    BufferedReader br = null;
                    try {
                        fr = new FileReader(f);
                        br = new BufferedReader(fr);
                        while (fbuf.length() < 4096) {
                            String text = br.readLine();
                            if (text == null) {
                                break;
                            }
                            if ((text = text.trim()).length() == 0) continue;
                            if (text.length() + fbuf.length() > fbuf.capacity()) {
                                break;
                            }
                            fbuf.append(text + "\n");
                        }
                    }
                    catch (Throwable t) {
                        if (PlatformDebug.GENERAL.show()) {
                            LogSupport.message(this, "run", "Exception processing " + f + ": " + Debug.getStackTrace(t));
                        }
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (Throwable t) {}
                        try {
                            fr.close();
                        }
                        catch (Throwable t) {}
                    }
                    if (fbuf.length() <= 0) continue;
                    if (result.length() > 0) {
                        result.append("\n");
                    }
                    result.append("===== " + f.getName() + " =====\n");
                    result.append(fbuf.toString());
                }
                for (String[] cmd : commands) {
                    int status;
                    StringBuffer output;
                    block36: {
                        output = new StringBuffer(4096);
                        try {
                            status = ProcessUtils.exec(cmd, output, output, 20000L, true);
                        }
                        catch (Throwable t) {
                            status = -65536;
                            if (!PlatformDebug.GENERAL.show()) break block36;
                            LogSupport.message(this, "run", "Exception processing " + cmd[0] + ": " + Debug.getStackTrace(t));
                        }
                    }
                    if (result.length() > 0) {
                        result.append("\n");
                    }
                    result.append("===== Command status=" + status + " =====\n");
                    for (int ix = 0; ix < cmd.length; ++ix) {
                        if (ix > 0) {
                            result.append(" ");
                        }
                        result.append(cmd[ix]);
                    }
                    result.append("\n" + output);
                }
                if (result.length() > 0) {
                    UnixPlatform.this.details = result.toString();
                    if (PlatformDebug.GENERAL.show()) {
                        LogSupport.message(this, "run", UnixPlatform.this.details);
                    }
                }
            }
        };
        initializer.setDaemon(true);
        initializer.start();
    }

    @Override
    public String cleanFilename(String filename, boolean visible) {
        String nme = filename.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        if (!visible && !filename.startsWith(".")) {
            nme = "." + nme;
        }
        return nme;
    }

    @Override
    public String filterFilename(String filename) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (ILLEGAL_FILENAME_CHARACTERS.indexOf(ch) != -1) continue;
            b.append(ch);
        }
        return b.toString();
    }

    private String getEnvironmentVariable(String variableName) {
        try {
            String var;
            StringBuffer b;
            if (Platform.checkJavaVersion("1.5+")) {
                return System.getenv(variableName);
            }
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "echo $" + variableName});
            int result = ProcessUtils.getProcessOutput(proc, b = new StringBuffer(), null, -1L);
            if (result == 0 && (var = b.toString().trim()).length() != 0) {
                return var;
            }
        }
        catch (Throwable t) {
            LogSupport.message(this, "getEnvironmentVariable", Debug.getStackTrace(t));
        }
        return null;
    }

    @Override
    public File findAppByReference(String appRef) {
        String paths;
        File app = new File(appRef);
        if (app.exists() && app.isFile()) {
            return app;
        }
        if (appRef.indexOf(File.separator) == -1 && (paths = this.getEnvironmentVariable("PATH")) != null) {
            StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                if (!dir.exists() || !dir.isDirectory() || !(app = new File(dir, appRef)).exists() || !app.isFile()) continue;
                return app;
            }
        }
        return null;
    }

    @Override
    public boolean launchApp(File app) {
        return this.launchApp(app, null);
    }

    @Override
    public boolean launchApp(File app, File document) {
        String[] cmd = document != null ? new String[]{app.getAbsolutePath(), document.getAbsolutePath()} : new String[]{app.getAbsolutePath()};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ProcessUtils.ignoreProcessOutput(p);
            return ProcessUtils.isProcessRunning(p);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean openFile(File file) {
        String[] cmd;
        if (this.getEnvironmentVariable("GNOME_DESKTOP_SESSION_ID") != null) {
            cmd = new String[]{"gnome-open", file.getAbsolutePath()};
        } else if ("true".equalsIgnoreCase(System.getenv("KDE_FULL_SESSION"))) {
            cmd = new String[]{"kfmclient", "exec", file.getAbsolutePath()};
        } else {
            return false;
        }
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ProcessUtils.ignoreProcessOutput(p);
            return ProcessUtils.isProcessRunning(p);
        }
        catch (IOException ex) {
            return false;
        }
    }
}

