/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform;

import com.elluminate.platform.GenericPlatform;
import com.elluminate.platform.PlatformAPI;
import com.elluminate.platform.PlatformApp;
import com.elluminate.platform.PlatformDebug;
import com.elluminate.platform.VersionSupport;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Platform {
    public static final String JAVAFX_JRE = "1.7.0_06+";
    public static final int GENERIC = 0;
    public static final int PLATFORM_WINDOWS = 1;
    public static final int PLATFORM_MACINTOSH = 2;
    public static final int PLATFORM_UNIX = 3;
    public static final int ARCH_INTELx86 = 101;
    public static final int ARCH_POWERPC = 102;
    public static final int ARCH_SPARC = 103;
    private static final int OS_MAC_CLASSIC = 201;
    public static final int OS_MAC_OS_X = 202;
    public static final int OS_SOLARIS = 250;
    public static final int OS_LINUX = 300;
    public static final int OS_WINDOWS_95 = 400;
    public static final int OS_WINDOWS_98 = 401;
    public static final int OS_WINDOWS_ME = 402;
    public static final int OS_WINDOWS_NT = 403;
    public static final int OS_WINDOWS_2K = 404;
    public static final int OS_WINDOWS_XP = 405;
    public static final int OS_WINDOWS_VISTA = 406;
    public static final int OS_WINDOWS_7 = 407;
    public static final int LAF_OTHER = 0;
    public static final int LAF_NONE = 500;
    public static final int LAF_METAL = 501;
    public static final int LAF_AQUA = 502;
    public static final int LAF_WINDOWS = 503;
    public static final int LAF_MACINTOSH = 504;
    public static final int BIG_ENDIAN = 601;
    public static final int LITTLE_ENDIAN = 602;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int UNKNOWN = -1;
    private static volatile PlatformAPI instance = null;
    private static boolean getLAFIDinit = false;
    private static Method getLAFIDmethod = null;

    public static int getPlatform() {
        return Platform.getInstance().getPlatform();
    }

    public static String getPlatformName() {
        return Platform.getInstance().getPlatformName();
    }

    public static String getDeviceCode() {
        if (PlatformDebug.DEVICE_OVERRIDE.show()) {
            if (PlatformDebug.IPHONE_DEVICE.show()) {
                return "Mi";
            }
            if (PlatformDebug.ANDROID_PHONE_DEVICE.show()) {
                return "Ma";
            }
            if (PlatformDebug.IPAD_DEVICE.show()) {
                return "MI";
            }
            if (PlatformDebug.ANDROID_TABLET_DEVICE.show()) {
                return "MA";
            }
        }
        return Platform.getInstance().getDeviceCode();
    }

    public static int getArch() {
        return Platform.getInstance().getArch();
    }

    public static int getByteOrder() {
        return Platform.getInstance().getByteOrder();
    }

    public static boolean is64BitAddressable() {
        return Platform.getInstance().is64BitAddressable();
    }

    public static String getArchName() {
        return Platform.getInstance().getArchName();
    }

    public static int getOS() {
        return Platform.getInstance().getOS();
    }

    public static String getOSName() {
        return Platform.getInstance().getOSName();
    }

    public static int getVersion() {
        return Platform.getInstance().getVersion();
    }

    public static int getRelease() {
        return Platform.getInstance().getRelease();
    }

    public static int getBugfix() {
        return Platform.getInstance().getBugfix();
    }

    public static boolean checkOSVersion(int os, String vs) {
        PlatformAPI api = Platform.getInstance();
        if (api.getOS() != os) {
            return false;
        }
        String str = api.getVersion() + "." + api.getRelease() + "." + api.getBugfix();
        return VersionSupport.matchVersion(str, vs);
    }

    public static String getPatch() {
        return Platform.getInstance().getPatch();
    }

    public static String getVersionString() {
        return Platform.getInstance().getVersionString();
    }

    public static String getInfo() {
        return Platform.getInstance().getInfo();
    }

    public static String getDetailedInfo() {
        return Platform.getInstance().getDetailedInfo();
    }

    public static String getJavaInfo() {
        return Platform.getInstance().getJavaInfo();
    }

    public static boolean isJavaFXEnabled() {
        try {
            return Platform.getOS() == 202 && Platform.checkJREVersion(JAVAFX_JRE);
        }
        catch (RuntimeException e) {
            System.out.println("Unable to identify the JRE: " + e.getMessage());
            return false;
        }
    }

    public static int getCPUCount() {
        return Platform.getInstance().getCPUCount();
    }

    public static long getCPUFrequency(int index) {
        return Platform.getInstance().getCPUFrequency(index);
    }

    public static boolean checkJavaVersion(String vs) {
        return VersionSupport.matchVersion(System.getProperty("java.version"), vs);
    }

    public static boolean checkJVMVersion(String vs) {
        return VersionSupport.matchVersion(System.getProperty("java.vm.version", "1.1.8"), vs);
    }

    public static boolean checkJREVersion(String vs) {
        return VersionSupport.matchVersion(System.getProperty("java.runtime.version", "1.1.8"), vs);
    }

    public static int getLAF() {
        String lafID;
        try {
            lafID = Platform.getLAFID();
        }
        catch (Throwable t) {
            return 500;
        }
        if (lafID.equals("Aqua") || lafID.equals("MacOSX")) {
            return 502;
        }
        if (lafID.equals("Windows")) {
            return 503;
        }
        if (lafID.equals("Metal")) {
            return 501;
        }
        if (lafID.equals("Mac")) {
            return 504;
        }
        return 0;
    }

    private static String getLAFID() throws IllegalAccessException {
        if (!getLAFIDinit) {
            getLAFIDinit = true;
            try {
                Class<?> cls = Class.forName("com.elluminate.gui.GuiUtils");
                getLAFIDmethod = cls.getMethod("getLAFID", new Class[0]);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if (getLAFIDmethod != null) {
            try {
                return (String)getLAFIDmethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException();
    }

    public static void setApplication(PlatformApp app) {
        Platform.getInstance().setApplication(app);
    }

    public static void applicationInit() {
        Platform.getInstance().applicationInit();
    }

    public static String getMimeType(File f) {
        return Platform.getInstance().getMimeType(f);
    }

    public static String getMimeType(String name) {
        return Platform.getInstance().getMimeType(name);
    }

    public static String getSuffix(String mime) {
        return Platform.getInstance().getSuffix(mime);
    }

    public static File getDefaultDir() {
        return Platform.getInstance().getDefaultDir();
    }

    public static File getTempDir() {
        return Platform.getInstance().getTempDir();
    }

    public static File getPreferencesDir() {
        return Platform.getInstance().getPreferencesDir();
    }

    public static File getLogRelPathRoot() {
        return Platform.getInstance().getLogRelPathRoot();
    }

    public static String getNativePath(File path) {
        return Platform.getInstance().getNativePath(path);
    }

    public static String getNativePath(String path) {
        return Platform.getInstance().getNativePath(path);
    }

    public static String cleanFilename(String filename, boolean visible) {
        return Platform.getInstance().cleanFilename(filename, visible);
    }

    public static String filterFilename(String filename) {
        return Platform.getInstance().filterFilename(filename);
    }

    public static String getMemoryStatus() {
        return Platform.getInstance().getMemoryStatus();
    }

    public static String getExtendedMemoryStatus() {
        return Platform.getInstance().getExtendedMemoryStatus();
    }

    public static File findAppByMIME(String mimeType) {
        return Platform.getInstance().findAppByMIME(mimeType);
    }

    public static File findAppByExtension(String extension) {
        return Platform.getInstance().findAppByExtension(extension);
    }

    public static File findAppByReference(String appRef) {
        return Platform.getInstance().findAppByReference(appRef);
    }

    public static boolean launchApp(File app) {
        return Platform.getInstance().launchApp(app);
    }

    public static boolean launchApp(File app, File document) {
        return Platform.getInstance().launchApp(app, document);
    }

    public static boolean openFile(File file) {
        return Platform.getInstance().openFile(file);
    }

    public static long currentTimeMillis() {
        return Platform.getInstance().currentTimeMillis();
    }

    public static int usingScreenReader() {
        return Platform.getInstance().usingScreenReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlatformAPI getInstance() {
        if (instance != null) return instance;
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (instance != null) return instance;
            instance = Platform.manufacture();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static PlatformAPI manufacture() {
        PlatformAPI result = null;
        if (instance != null) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message("Platform: singleton already exists.");
            }
            throw new RuntimeException("Attempt to instantiate second Platform instance.");
        }
        try {
            String className = Platform.encodeName();
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message("Platform: Manufacturing Platform specialization: " + className + " for os.name: '" + System.getProperty("os.name", "*UNDEFINED*") + "'");
            }
            Class<?> cls = Class.forName(className);
            result = (PlatformAPI)cls.newInstance();
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message(result.getInfo());
                LogSupport.message(result.getJavaInfo());
            }
        }
        catch (Exception ex) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message("Platform: exception during manufacture().");
                LogSupport.exception(Platform.class, "manufacture", ex, true);
            }
            result = new GenericPlatform();
        }
        return result;
    }

    private static String encodeName() {
        String base = System.getProperty("os.name");
        StringBuffer encoded = new StringBuffer(64);
        String myPackage = Platform.class.getName();
        int pos = myPackage.lastIndexOf(".");
        myPackage = pos < 0 ? "" : myPackage.substring(0, pos) + ".";
        if (base == null) {
            return myPackage + "GenericPlatform";
        }
        if (base.startsWith("Windows")) {
            return myPackage + "WindowsPlatform";
        }
        if (base.startsWith("Mac")) {
            return myPackage + "MacOSXPlatform";
        }
        if (base.startsWith("SunOS") || base.startsWith("Linux")) {
            return myPackage + "UnixPlatform";
        }
        for (int ix = 0; ix < base.length(); ++ix) {
            char ch = base.charAt(ix);
            if (encoded.length() == 0) {
                if (!Character.isJavaIdentifierStart(ch)) continue;
                if (Character.isLowerCase(ch)) {
                    ch = Character.toUpperCase(ch);
                }
                encoded.append(ch);
                continue;
            }
            if (!Character.isJavaIdentifierPart(ch)) continue;
            encoded.append(ch);
        }
        if (encoded.length() == 0) {
            return myPackage + "GenericPlatform";
        }
        return myPackage + encoded.toString() + "Platform";
    }
}

