/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.nio.ssl;

import com.elluminate.net.AbstractAsyncEndpoint;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOAdapter;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.AsyncIORequestImpl;
import com.elluminate.net.AsyncSecureRequest;
import com.elluminate.net.AsyncSecurityListener;
import com.elluminate.net.EndpointSecurityException;
import com.elluminate.net.NetDebug;
import com.elluminate.net.RequestQueue;
import com.elluminate.net.nio.SelectorAsyncEndpoint;
import com.elluminate.util.PooledObject;
import com.elluminate.util.SimpleObjectPool;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class AsyncSSLEndpoint
extends AbstractAsyncEndpoint {
    private static final byte RST_IDLE = 0;
    private static final byte RST_BUFFERED = 1;
    private static final byte RST_PENDING = 2;
    private static final byte RST_READING = 3;
    private static final byte R_ACT_NONE = 0;
    private static final byte R_ACT_PROCESS = 1;
    private static final byte R_ACT_READ = 2;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(1);
    private static int bufferSize = 0;
    private static SimpleObjectPool bufferPool = null;
    private static Object poolLock = new Object();
    private AtomicReference<AsyncIORequestImpl> readReq = new AtomicReference<Object>(null);
    private AtomicReference<AsyncIORequestImpl> writeReq = new AtomicReference<Object>(null);
    private AtomicReference<AsyncSecureRequest> secureReq = new AtomicReference<Object>(null);
    private AsyncEndpoint real;
    private SSLEngine engine;
    private AsyncSecurityListener listener;
    private RequestQueue xmitQueue = new RequestQueue();
    private RequestQueue recvQueue = new RequestQueue();
    private IOException writeX = null;
    private IOException readX = null;
    private Closer closer = null;
    private Object writeLock = new Object();
    private Object readLock = new Object();
    private Buf readBuffer = null;
    private byte readState = 0;
    private boolean debug = false;
    private boolean debug_hs = false;

    public AsyncSSLEndpoint(AsyncEndpoint real, SSLEngine engine, AsyncSecurityListener asl) throws EndpointSecurityException {
        this.real = real;
        this.engine = engine;
        this.listener = asl;
        engine.setUseClientMode(true);
        this.init();
    }

    public AsyncSSLEndpoint(AsyncEndpoint real, SSLEngine engine, boolean authClient, AsyncSecurityListener asl) throws EndpointSecurityException {
        this.real = real;
        this.engine = engine;
        this.listener = asl;
        engine.setUseClientMode(false);
        engine.setNeedClientAuth(authClient);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws EndpointSecurityException {
        this.debug = NetDebug.SSL.isEnabled();
        this.debug_hs = NetDebug.SSL_HANDSHAKE.isEnabled();
        Object object = poolLock;
        synchronized (object) {
            if (bufferPool == null) {
                SSLSession session = this.engine.getSession();
                int appSz = session.getApplicationBufferSize();
                int sslSz = session.getPacketBufferSize();
                bufferSize = Math.max(appSz, sslSz);
                if (this.debug) {
                    LogSupport.message(this + ": Using " + bufferSize + " byte buffers.");
                }
                bufferPool = new SimpleObjectPool(Buf.class);
            }
        }
        this.secureReq.set(new AsyncSecureRequest(this, this.listener));
        if (!this.real.isConnected()) {
            throw new EndpointSecurityException("Cannot secure an endpoint that is not connected.");
        }
        try {
            this.engine.beginHandshake();
            this.processStatus(this.engine.getHandshakeStatus());
        }
        catch (SSLException sslx) {
            throw new EndpointSecurityException("Unable to begin SSL handshake: " + sslx);
        }
    }

    @Override
    public boolean isConnected() {
        return this.real.isConnected();
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public void setLinger(int secs) throws SocketException {
        this.real.setLinger(secs);
    }

    @Override
    public int getLinger() throws SocketException {
        return this.real.getLinger();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.real.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.real.getTcpNoDelay();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.real.getInetAddress();
    }

    @Override
    public int getPort() {
        return this.real.getPort();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.real.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.real.getLocalPort();
    }

    @Override
    public void beginConnect(InetAddress addr, int port, AsyncIOListener lst) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean actualConnect(AsyncIORequestImpl req, InetAddress addr, int port) {
        throw new RuntimeException("Connect operation not supported by AsyncSSLEndpoint");
    }

    @Override
    protected int beginReadImpl(byte[] buf, int off, int len, AsyncIOListener lst) throws IOException {
        int nRead = 0;
        AsyncIORequestImpl req = AsyncIORequestImpl.getReadReq(this, buf, off, len, this.handler, lst);
        if (this.debug) {
            LogSupport.message(this, "beginReadImpl", this + ": Starting beginRead...");
        }
        if ((nRead = this.actualRead(req, buf, off, len)) == 0) {
            if (this.debug) {
                LogSupport.message(this, "beginReadImpl", this + ": Queueing read...");
            }
            if (!this.readReq.compareAndSet(null, req)) {
                throw new IllegalStateException("Multiple concurrent asynchronous reads.");
            }
            this.receive(req);
        } else if (this.debug) {
            LogSupport.message(this, "beginReadImpl", this + ": Completed read - " + nRead + " bytes");
        }
        return nRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int actualRead(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
        int nRead = 0;
        if (this.recvQueue.isEmpty()) {
            if (this.engine.isOutboundDone()) {
                throw new IOException("Async endpoint closed.");
            }
            if (this.debug) {
                LogSupport.message(this, "actualRead", this + ": Queue empty - reading");
            }
            if (this.readX != null) {
                throw this.readX;
            }
            this.receive(req);
        }
        Object object = this.readLock;
        synchronized (object) {
            while (len > 0 && !this.recvQueue.isEmpty()) {
                Buf b = (Buf)this.recvQueue.getHead();
                int n = b.getBytes(buf, off, len);
                nRead += n;
                off += n;
                len -= n;
                if (!b.isEmpty()) continue;
                this.recvQueue.remove();
            }
        }
        return nRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int beginWrite(byte[] buf, int off, int len, AsyncIOListener lst) throws IOException {
        int n = 0;
        if (this.engine.isOutboundDone()) {
            throw new IOException("Async endpoint closed.");
        }
        AsyncIORequestImpl req = AsyncIORequestImpl.getWriteReq(this, buf, off, len, this.handler, lst);
        Object object = this.writeLock;
        synchronized (object) {
            n = this.actualWrite(req, buf, off, len);
            if (n == 0) {
                if (!this.writeReq.compareAndSet(null, req)) {
                    throw new IllegalStateException("Multiple simultaneous async writes.");
                }
            } else {
                req.dispose();
            }
        }
        return n;
    }

    @Override
    protected int actualWrite(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
        if (this.writeX != null) {
            throw this.writeX;
        }
        Buf plain = (Buf)bufferPool.alloc();
        Buf cipher = (Buf)bufferPool.alloc();
        int ret = 0;
        plain.putBytes(buf, off, len);
        SSLEngineResult result = this.engine.wrap(plain.getReadBuffer(), cipher.getWriteBuffer());
        int nC = result.bytesConsumed();
        int nP = result.bytesProduced();
        plain.dispose();
        if (nC > 0) {
            cipher.setRequest(req);
            req.setBytesTransferred(nC);
        }
        if (nP > 0 && this.transmit(cipher)) {
            cipher.debug = this.debug;
            ret = nC;
        }
        this.processStatus(result.getHandshakeStatus());
        return ret;
    }

    @Override
    public void beginClose(AsyncIOListener lst) {
        AsyncIORequestImpl r = AsyncIORequestImpl.getCloseReq(this, this.handler, lst);
        if (this.debug) {
            LogSupport.message(this, "beginClose", this + ": starting close.");
        }
        this.closer = new Closer(r);
        if (this.readX == null && this.writeX == null) {
            if (this.xmitQueue.isEmpty()) {
                if (this.debug_hs) {
                    LogSupport.message(this, "beginClose", this + ": shutting down SSL engine");
                }
                this.engine.closeOutbound();
                this.processStatus(this.engine.getHandshakeStatus());
            }
        } else {
            if (this.debug_hs) {
                LogSupport.message(this, "beginClose", this + ": closing connection after error");
            }
            this.closer.handshakeDone();
        }
    }

    @Override
    protected boolean actualClose(AsyncIORequestImpl req) {
        return true;
    }

    public X509Certificate[] getPeerCertificates() {
        try {
            return (X509Certificate[])this.engine.getSession().getPeerCertificates();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private boolean processResult(AsyncIORequestImpl req, SSLEngineResult result) throws IOException {
        if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            if (this.debug) {
                LogSupport.message(this, "processResult", this + ": Reading on underflow...");
            }
            return this.receive(req);
        }
        this.processStatus(result.getHandshakeStatus());
        return !this.recvQueue.isEmpty();
    }

    private void processStatus(SSLEngineResult.HandshakeStatus hs) {
        SSLEngineResult result = null;
        block12: while (hs != null) {
            SSLEngineResult.HandshakeStatus status = hs;
            hs = null;
            switch (status) {
                case NEED_TASK: {
                    Runnable r;
                    if (this.debug) {
                        LogSupport.message(this, "processStatus", this + ": handshake status = NEED_TASK");
                    }
                    SelectorAsyncEndpoint sae = (SelectorAsyncEndpoint)this.real;
                    while ((r = this.engine.getDelegatedTask()) != null) {
                        sae.run(new SSLTask(this, r));
                    }
                    return;
                }
                case NEED_WRAP: {
                    if (this.debug) {
                        LogSupport.message(this, "processStatus", this + ": handshake status = NEED_WRAP");
                    }
                    Buf buf = (Buf)bufferPool.alloc();
                    buf.setRequest(null);
                    buf.debug = this.debug;
                    try {
                        EMPTY_BUFFER.clear();
                        result = this.engine.wrap(EMPTY_BUFFER, buf.getWriteBuffer());
                        if (this.debug) {
                            LogSupport.message(this, "processStatus", this + ": Wrap - " + result.bytesConsumed() + " bytes -> " + result.bytesProduced() + " bytes");
                        }
                        hs = result.getHandshakeStatus();
                    }
                    catch (SSLException sslx) {
                        this.writeException(sslx);
                        return;
                    }
                    try {
                        this.transmit(buf);
                    }
                    catch (IOException iox) {
                        this.writeException(iox);
                    }
                    break;
                }
                case NEED_UNWRAP: {
                    if (this.debug) {
                        LogSupport.message(this, "processStatus", this + ": handshake status = NEED_UNWRAP");
                    }
                    try {
                        if (!this.receive(null)) continue block12;
                        hs = this.engine.getHandshakeStatus();
                    }
                    catch (IOException iox) {
                        this.readException(iox);
                    }
                    break;
                }
                case FINISHED: {
                    this.processFinished();
                }
            }
        }
    }

    private void processFinished() {
        AsyncSecureRequest sReq;
        if (this.debug) {
            LogSupport.message(this, "processFinished", this + ": handshake status = FINISHED");
        }
        if (this.closer != null) {
            this.closer.handshakeDone();
        }
        if (this.secureReq.compareAndSet(sReq = this.secureReq.get(), null) && sReq != null) {
            String cipher = this.engine.getSession().getCipherSuite();
            sReq.dispatch(cipher);
        }
    }

    private void onReadComplete(Buf buf) {
        if (this.debug) {
            LogSupport.message(this, "onReadComplete", this + ": Read complete...");
        }
        try {
            AsyncIORequestImpl r;
            if (!this.processReceived(buf) && (r = this.readReq.get()) != null) {
                if (this.debug) {
                    LogSupport.message(this, "onReadComplete", this + ": Restarting recieve because request not satisfied...");
                }
                this.receive(r);
            }
        }
        catch (IOException iox) {
            this.readException(iox);
            return;
        }
        if (!this.recvQueue.isEmpty()) {
            AsyncIORequestImpl req = this.readReq.get();
            while (req != null && !this.readReq.compareAndSet(req, null)) {
                req = this.readReq.get();
            }
            if (req != null) {
                req.execute();
            }
        }
    }

    private boolean receive(AsyncIORequestImpl req) throws IOException {
        boolean more = true;
        while (more) {
            switch (this.getReadBuffer(req)) {
                case 0: {
                    return !this.recvQueue.isEmpty();
                }
                case 1: {
                    more = !this.processReceived(this.readBuffer);
                    break;
                }
                case 2: {
                    more = this.readBuffer.read(this);
                    if (more) {
                        boolean bl = more = !this.processReceived(this.readBuffer);
                    }
                    if (more) break;
                    return !this.recvQueue.isEmpty();
                }
            }
        }
        return !this.recvQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte getReadBuffer(AsyncIORequestImpl req) {
        Object object = this.readLock;
        synchronized (object) {
            switch (this.readState) {
                case 0: {
                    if (this.debug) {
                        LogSupport.message(this, "receive", this + ": Start receive (was IDLE)");
                    }
                    this.readBuffer = (Buf)bufferPool.alloc();
                    this.readBuffer.debug = this.debug;
                    if (req != null) {
                        this.readBuffer.setRequest(req);
                    }
                    this.readState = (byte)3;
                    return 2;
                }
                case 1: {
                    if (this.debug) {
                        LogSupport.message(this, "receive", this + ": Start receive (was BUFFERED)");
                    }
                    if (req != null) {
                        this.readBuffer.setRequest(req);
                    }
                    this.readState = (byte)3;
                    return 2;
                }
                case 2: {
                    if (this.debug) {
                        LogSupport.message(this, "receive", this + ": Start receive (was BUFFERED)");
                    }
                    if (req != null) {
                        this.readBuffer.setRequest(req);
                    }
                    this.readState = (byte)3;
                    return 1;
                }
                case 3: {
                    if (!this.debug) break;
                    LogSupport.message(this, "receive", this + ": Ignored receive (was READING)");
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReceiveState(SSLEngineResult result) {
        Object object = this.readLock;
        synchronized (object) {
            if (this.readBuffer.isEmpty()) {
                if (this.debug) {
                    LogSupport.message(this, "updateReceiveState", this + ": Receive state changed to IDLE");
                }
                this.readBuffer.dispose();
                this.readBuffer = null;
                this.readState = 0;
            } else if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                if (this.debug) {
                    LogSupport.message(this, "updateReceiveState", this + ": Receive state changed to BUFFERED");
                }
                this.readState = 1;
            } else {
                if (this.debug) {
                    LogSupport.message(this, "updateReceiveState", this + ": Receive state changed to PENDING");
                }
                this.readState = (byte)2;
            }
        }
    }

    private boolean processReceived(Buf buffer) throws IOException {
        if (this.debug) {
            LogSupport.message(this, "processReceived", this + ": Read " + buffer.size() + " bytes");
        }
        boolean more = true;
        SSLEngineResult result = null;
        while (more) {
            Buf out = (Buf)bufferPool.alloc();
            result = this.engine.unwrap(buffer.getReadBuffer(), out.getWriteBuffer());
            if (this.debug) {
                LogSupport.message(this, "processReceived", this + ": SSL Engine: " + result.bytesConsumed() + " in -> " + result.bytesProduced() + " out");
            }
            if (result.bytesProduced() > 0) {
                this.recvQueue.add(out);
            } else {
                out.dispose();
            }
            boolean bl = more = !buffer.isEmpty() && result.bytesConsumed() > 0;
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue;
            this.processFinished();
        }
        this.updateReceiveState(result);
        this.processResult(buffer.getRequest(), result);
        return !this.recvQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWriteComplete(Buf buf) {
        if (this.debug) {
            LogSupport.message(this, "onWriteComplete", this + ": Wrote " + buf.position() + " bytes");
        }
        boolean more = this.xmitQueue.remove();
        while (more) {
            Buf next = (Buf)this.xmitQueue.getHead();
            try {
                if (this.debug) {
                    LogSupport.message(this, "onWriteComplete", this + ": Writing " + next.size() + " bytes");
                }
                if (!next.write(this)) continue;
                if (this.debug) {
                    LogSupport.message(this, "onWriteComplete", this + ": Wrote " + next.position() + " bytes");
                }
                more = this.xmitQueue.remove();
                next.dispose();
            }
            catch (IOException iox) {
                this.writeException(iox);
            }
        }
        boolean dispatch = false;
        AsyncIORequestImpl req = buf.getRequest();
        Object object = this.writeLock;
        synchronized (object) {
            if (req != null) {
                if (!this.writeReq.compareAndSet(req, null)) {
                    LogSupport.error(this, "onWriteComplete", "Write request conflict - head=" + this.writeReq.get() + ", completed=" + req);
                    throw new IllegalStateException("Write request conflict!");
                }
                dispatch = true;
            }
        }
        if (dispatch) {
            req.dispatch();
        }
        if (this.closer != null && !this.engine.isOutboundDone()) {
            this.engine.closeOutbound();
            this.processStatus(this.engine.getHandshakeStatus());
        }
    }

    private boolean transmit(Buf buf) throws IOException {
        IOException x = this.writeX;
        if (x != null) {
            throw x;
        }
        if (this.debug) {
            LogSupport.message(this, "transmit", this + ": Transmitting " + buf.size() + " bytes");
        }
        if (this.xmitQueue.add(buf) && buf.write(this)) {
            if (this.debug) {
                LogSupport.message(this, "transmit", this + ": Transmit complete.");
            }
            while (this.xmitQueue.remove()) {
                buf.dispose();
                buf = (Buf)this.xmitQueue.getHead();
                try {
                    if (buf.write(this)) {
                        AsyncIORequestImpl req = buf.getRequest();
                        if (req == null) continue;
                        req.dispatch();
                        continue;
                    }
                    return true;
                }
                catch (IOException iox) {
                    this.writeException(iox);
                }
            }
            return true;
        }
        return false;
    }

    private void readException(IOException iox) {
        this.readX = iox;
        AsyncSecureRequest sreq = this.secureReq.get();
        while (sreq != null && !this.secureReq.compareAndSet(sreq, null)) {
            sreq = this.secureReq.get();
        }
        if (sreq != null) {
            sreq.dispatch(iox);
        }
        AsyncIORequestImpl req = this.readReq.get();
        while (req != null && !this.readReq.compareAndSet(req, null)) {
            req = this.readReq.get();
        }
        if (req != null) {
            req.fail(iox);
            req.dispose();
        }
    }

    private void writeException(IOException iox) {
        this.writeX = iox;
        AsyncSecureRequest sreq = this.secureReq.get();
        while (sreq != null && !this.secureReq.compareAndSet(sreq, null)) {
            sreq = this.secureReq.get();
        }
        if (sreq != null) {
            sreq.dispatch(iox);
        }
        AsyncIORequestImpl req = this.writeReq.get();
        while (req != null && !this.writeReq.compareAndSet(req, null)) {
            req = this.writeReq.get();
        }
        if (req != null) {
            req.fail(iox);
            req.dispose();
        }
    }

    static /* synthetic */ int access$000() {
        return bufferSize;
    }

    public static class Buf
    extends PooledObject
    implements AsyncIOListener,
    RequestQueue.Queueable {
        AsyncSSLEndpoint owner = null;
        ByteBuffer buffer = ByteBuffer.allocate(AsyncSSLEndpoint.access$000());
        AsyncIORequestImpl request = null;
        int nBytes = 0;
        boolean draining = false;
        boolean debug = false;

        @Override
        public RequestQueue.Queueable getNext() {
            return (Buf)this.poNext;
        }

        @Override
        public void setNext(RequestQueue.Queueable next) {
            this.poNext = (Buf)next;
        }

        @Override
        public void poInit() {
            this.draining = false;
        }

        @Override
        public void poCleanup() {
            this.owner = null;
            this.request = null;
            this.nBytes = 0;
            this.buffer.clear();
        }

        public void setRequest(AsyncIORequestImpl req) {
            this.request = req;
        }

        public AsyncIORequestImpl getRequest() {
            return this.request;
        }

        public void setNBytes(int n) {
            this.nBytes = n;
        }

        public int getNBytes() {
            return this.nBytes;
        }

        public int remaining() {
            return this.buffer.remaining();
        }

        public int position() {
            return this.buffer.position();
        }

        public int size() {
            if (!this.draining) {
                this.buffer.flip();
                this.draining = true;
            }
            return this.buffer.remaining();
        }

        public boolean isEmpty() {
            return !this.buffer.hasRemaining();
        }

        public ByteBuffer getReadBuffer() {
            if (!this.draining) {
                this.buffer.flip();
                this.draining = true;
            }
            return this.buffer;
        }

        public ByteBuffer getWriteBuffer() {
            if (this.draining) {
                this.buffer.compact();
                this.draining = false;
            }
            return this.buffer;
        }

        public int getBytes(byte[] buf, int off, int len) {
            if (!this.draining) {
                this.buffer.flip();
                this.draining = true;
            }
            int n = Math.min(len, this.buffer.remaining());
            this.buffer.get(buf, off, n);
            return n;
        }

        public int putBytes(byte[] buf, int off, int len) {
            if (this.draining) {
                this.buffer.compact();
                this.draining = false;
            }
            int n = Math.min(len, this.buffer.remaining());
            this.buffer.put(buf, off, n);
            return n;
        }

        public boolean read(AsyncSSLEndpoint owner) throws IOException {
            if (this.draining) {
                this.buffer.compact();
                this.draining = false;
            }
            byte[] array = this.buffer.array();
            int off = this.buffer.position();
            int len = this.buffer.remaining();
            this.owner = owner;
            int n = owner.real.beginRead(array, off, len, this);
            if (n > 0) {
                if (this.debug) {
                    LogSupport.message(this, "read", owner + ": Read " + n + " bytes");
                }
                len -= n;
                this.buffer.position(off += n);
                return true;
            }
            if (this.debug) {
                LogSupport.message(this, "read", owner + ": Read started...");
            }
            return false;
        }

        public boolean write(AsyncSSLEndpoint owner) throws IOException {
            int nWritten;
            this.owner = owner;
            if (!this.draining) {
                this.buffer.flip();
                this.draining = true;
            }
            byte[] array = this.buffer.array();
            int off = 0;
            int len = this.buffer.limit();
            while ((nWritten = owner.real.beginWrite(array, off, len, this)) > 0) {
                if (this.debug) {
                    LogSupport.message(this, "write", owner + ": Wrote " + nWritten + " bytes");
                }
                this.buffer.position(off += nWritten);
                if ((len -= nWritten) != 0) continue;
                return true;
            }
            if (this.debug) {
                LogSupport.message(this, "write", owner + ": Write started...");
            }
            return false;
        }

        @Override
        public void writeComplete(AsyncIORequest req) {
            int nWritten = 0;
            int off = this.buffer.position();
            int len = this.buffer.remaining();
            byte[] array = this.buffer.array();
            boolean first = true;
            try {
                nWritten = req.finishRequest();
                do {
                    if (this.debug) {
                        if (first) {
                            LogSupport.message(this, "writeComplete", this.owner + ": ... write of " + nWritten + " bytes completed.");
                        } else {
                            LogSupport.message(this, "writeComplete", this.owner + ": Wrote " + nWritten + " bytes");
                        }
                        first = false;
                    }
                    this.buffer.position(off += nWritten);
                    if ((len -= nWritten) != 0) continue;
                    this.owner.onWriteComplete(this);
                    return;
                } while ((nWritten = this.owner.real.beginWrite(array, off, len, this)) > 0);
                if (this.debug) {
                    LogSupport.message(this, "writeComplete", this.owner + ": Write started...");
                }
            }
            catch (IOException iox) {
                this.owner.writeException(iox);
            }
        }

        @Override
        public void readComplete(AsyncIORequest req) {
            int nRead = 0;
            try {
                nRead = req.finishRequest();
                if (this.debug) {
                    LogSupport.message(this, "readComplete", this.owner + ": ... read of " + nRead + " bytes completed.");
                }
                this.buffer.position(this.buffer.position() + nRead);
                this.owner.onReadComplete(this);
            }
            catch (IOException iox) {
                this.owner.readException(iox);
            }
        }

        @Override
        public void connectComplete(AsyncIORequest req) {
            throw new RuntimeException("connectComplete called for AsyncSSLEndpoint!");
        }

        @Override
        public void closeComplete(AsyncIORequest req) {
            throw new RuntimeException("connectComplete called for AsyncSSLEndpoint!");
        }
    }

    class Closer
    extends AsyncIOAdapter {
        AsyncIORequestImpl req = null;

        public Closer(AsyncIORequestImpl r) {
            this.req = r;
        }

        @Override
        public void closeComplete(AsyncIORequest r) {
            try {
                r.finishRequest();
                this.req.dispatch();
            }
            catch (IOException iox) {
                this.req.fail(iox);
            }
        }

        public void handshakeDone() {
            if (AsyncSSLEndpoint.this.debug) {
                LogSupport.message(this, "handshakeDone", AsyncSSLEndpoint.this + ": Closing real endpoint");
            }
            AsyncSSLEndpoint.this.real.beginClose(this);
        }
    }

    private class SSLTask
    implements Runnable {
        private AsyncEndpoint aep;
        private Runnable sub;

        public SSLTask(AsyncEndpoint ep, Runnable r) {
            this.aep = ep;
            this.sub = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.sub.run();
            }
            finally {
                if (AsyncSSLEndpoint.this.debug) {
                    LogSupport.message(this, "run", this.aep + ": SSL Task complete.");
                }
                AsyncSSLEndpoint.this.processStatus(AsyncSSLEndpoint.this.engine.getHandshakeStatus());
            }
        }
    }
}

