/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.nio;

import com.elluminate.net.nio.IOStateAction;
import com.elluminate.util.ObjectPool;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;

public class IOChangeOpAction
extends IOStateAction {
    static ObjectPool pool = ObjectPool.getInstance(IOChangeOpAction.class);
    volatile SelectionKey key = null;
    int and = 0;
    int or = 0;

    @Override
    public void poCleanup() {
        super.poCleanup();
        this.key = null;
    }

    public void initAdd(SelectionKey k, int mask) {
        this.key = k;
        this.and = -1;
        this.or = mask;
    }

    public void initRemove(SelectionKey k, int mask) {
        this.key = k;
        this.and = ~mask;
        this.or = 0;
    }

    @Override
    public void execute() {
        try {
            int ops = this.key.interestOps();
            ops = ops & this.and | this.or;
            this.key.interestOps(ops);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
        this.dispose();
    }

    public void change() {
        try {
            this.start(this.key.selector());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static IOChangeOpAction addOpInstance(SelectionKey key, int mask) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        IOChangeOpAction action = (IOChangeOpAction)pool.alloc();
        action.initAdd(key, mask);
        return action;
    }

    public static IOChangeOpAction removeOpInstance(SelectionKey key, int mask) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        IOChangeOpAction action = (IOChangeOpAction)pool.alloc();
        action.initRemove(key, mask);
        return action;
    }
}

